/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.snwodp;

import com.cognos.xqe.data.providers.olap.DefaultConnectionSelector;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPConnection;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPLog;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.pool.connection.ISelectorContext;
import com.cognos.xqe.trace.LogLevel;

class SNWODPConnectionSelector
extends DefaultConnectionSelector {
    SNWODPConnectionSelector() {
    }

    public IConnectionSelector.ReturnCode selectConnection(ConnectionParameters connectionParameters, ISelectorContext context, IPooledConnection pooledConnection) {
        SNWODPConnection connection = (SNWODPConnection)((Object)pooledConnection.getConnection());
        if (connection.getActiveDataQuery()) {
            if (SNWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
                SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SNWODPConnectionSelector skipping connection already in use for data query");
            }
            return IConnectionSelector.ReturnCode.NOT_MATCH;
        }
        if (connection.getConnect().isValid(false)) {
            return super.selectConnection(connectionParameters, context, pooledConnection);
        }
        if (SNWODPLog.isOn("Connection", LogLevel.WARN).booleanValue()) {
            SNWODPLog.getLogger("Connection").log(LogLevel.WARN, "SNWODPConnectionSelector removing connection that SAP BW says is invalid");
        }
        pooledConnection.setNotReusable();
        connection.disconnect();
        return IConnectionSelector.ReturnCode.NOT_MATCH;
    }
}

