/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.snwodp;

import com.cognos.xqe.bibushandler.CancelRequestSourceEnum;
import com.cognos.xqe.bibushandler.CancelUnsuccessfulException;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.conn.bapi.JBapiCancelException;
import com.cognos.xqe.conn.bapi.JBapiConnect;
import com.cognos.xqe.conn.bapi.JBapiException;
import com.cognos.xqe.conn.bapi.JBapiFunction;
import com.cognos.xqe.conn.bapi.JBapiStructure;
import com.cognos.xqe.conn.bapi.JBapiTable;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPConfig;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPConnection;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPException;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPLog;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPMessageKeys;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.pool.XQEIntegerPool;

public abstract class SNWODPFunctionHandler
implements ICancelable,
IReleasable {
    private static final String STR_TIMING_START_MSG = "Start Execution of ";
    private static final String STR_TIMING_END_MSG = "End Execution of ";
    private static final String STR_EXECUTE_MSG = "Executing: ";
    private static final String STR_SET_KEYDATE_MSG = ": setting Keydate: ";
    private static final String STR_SET_PARAM_MSG = ": setting Input Parameter \"";
    private static final String STR_ENDQUOTE = "\"";
    private static final String STR_CORRUPTED_SID_TAG = "CL_RSDM_READ_MASTER_DATA";
    private static final String CONSTRUCTOR_MSG = "Initializing SNWODPFunctionHandler on existing connection for: ";
    private static final String RFC_ABAP_INSTALL_AND_RUN = "RFC_ABAP_INSTALL_AND_RUN";
    protected SNWODPConnection connection;
    protected JBapiFunction mFunction = null;
    protected JBapiConnect mConnect;
    protected boolean mIsExtFunc = false;
    protected boolean cancelReceived = false;

    protected SNWODPFunctionHandler(SNWODPConnection snwodpConnection, String functionName) throws LogonFailureException, SNWODPException {
        this.connection = snwodpConnection;
        try {
            this.mConnect = this.connection.getConnect();
            this.mFunction = new JBapiFunction(functionName, this.mConnect);
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_FNC_HANDLE_ERROR, e, functionName);
        }
        if (SNWODPLog.isOn("Function", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("Function").log(LogLevel.TRACE, CONSTRUCTOR_MSG + functionName);
        }
    }

    protected SNWODPFunctionHandler(SNWODPConnection snwodpConnection, JBapiConnect clnt, String functionName) throws SNWODPException {
        this.connection = snwodpConnection;
        this.mConnect = clnt;
        try {
            this.mFunction = new JBapiFunction(functionName, this.mConnect);
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_FNC_HANDLE_ERROR, e, functionName);
        }
        if (SNWODPLog.isOn("Function", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("Function").log(LogLevel.TRACE, CONSTRUCTOR_MSG + functionName);
        }
    }

    protected SNWODPFunctionHandler(SNWODPConnection snwodpConnection, JBapiFunction function) {
        this.connection = snwodpConnection;
        this.mFunction = function;
        this.mConnect = function.getConnection();
        this.mIsExtFunc = true;
        if (SNWODPLog.isOn("Function", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("Function").log(LogLevel.TRACE, CONSTRUCTOR_MSG + this.mFunction.getFunctionName());
        }
    }

    protected void initializeFunction(SNWODPConnection snwodpConnection, String functionName) throws LogonFailureException, SNWODPException {
        this.connection = snwodpConnection;
        try {
            this.mConnect = this.connection.getConnect();
            this.mFunction = new JBapiFunction(functionName, this.mConnect);
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_FNC_HANDLE_ERROR, e, functionName);
        }
        if (SNWODPLog.isOn("Function", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("Function").log(LogLevel.TRACE, CONSTRUCTOR_MSG + functionName);
        }
    }

    public void cancel() throws CancelUnsuccessfulException {
        if (!this.cancelReceived) {
            try {
                this.cancelReceived = true;
                if (this.mFunction != null && SNWODPLog.isOn("Function", LogLevel.TRACE).booleanValue()) {
                    SNWODPLog.getLogger("Function").log(LogLevel.TRACE, "Cancel received: " + this.mFunction.getFunctionName());
                }
            }
            catch (JBapiException e) {
                throw new CancelUnsuccessfulException();
            }
        }
    }

    public synchronized void cancel(CancelRequestSourceEnum cancelSource) throws CancelUnsuccessfulException {
        throw new CancelUnsuccessfulException();
    }

    protected void checkForCancel() throws OperationCanceledException {
        if (this.cancelReceived) {
            if (SNWODPLog.isOn("Function", LogLevel.TRACE).booleanValue()) {
                SNWODPLog.getLogger("Function").log(LogLevel.TRACE, "Cancelled: " + this.mFunction.getFunctionName());
            }
            throw new OperationCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(boolean retry, boolean checkRtn) throws SNWODPException, OperationCanceledException {
        block16: {
            XQELogger logger = null;
            try {
                if (SNWODPLog.isOn("Function", LogLevel.TRACE).booleanValue()) {
                    SNWODPLog.getLogger("Function").log(LogLevel.TRACE, STR_EXECUTE_MSG + this.mFunction.getFunctionName());
                }
                if (SNWODPLog.isOn("Timing", LogLevel.INFO).booleanValue()) {
                    logger = SNWODPLog.getLogger("Timing");
                    logger.log(LogLevel.INFO, OperationEnum.START, STR_TIMING_START_MSG + this.mFunction.getFunctionName());
                }
                if (SNWODPLog.isOn("Connection", LogLevel.INFO).booleanValue()) {
                    SNWODPLog.getLogger("Connection").log(LogLevel.INFO, "Executing BAPI: " + this.mFunction.getFunctionName() + " on connection: " + this.mConnect.getHandle());
                }
                this.mFunction.execute(0, checkRtn);
                this.checkForCancel();
            }
            catch (JBapiCancelException ce) {
                throw new OperationCanceledException();
            }
            catch (JBapiException se) {
                if (se.getErrorKey().equals("012") || se.getErrorKey().equals("887") || se.getErrorKey().equals("201")) {
                    throw se;
                }
                if (se.getErrorKey().equals("520") || se.getErrorKey().equals("037")) {
                    throw se;
                }
                if (se.getErrorKey().equals("RFC_ERROR_SYSTEM_FAILURE")) {
                    SNWODPLog.getLogger("Exception").log(LogLevel.ERROR, this.mFunction.getFunctionName() + " failed with error " + "RFC_ERROR_SYSTEM_FAILURE");
                    throw se;
                }
                if (se.getErrorKey().equals("299")) {
                    if (se.getRFCMessage().contains(STR_CORRUPTED_SID_TAG)) {
                        if (retry) {
                            this.clearSAPMetadataCache();
                            this.clearSAPUserCache();
                            SNWODPLog.getLogger("Connection").log(LogLevel.WARN, "Flushing SAP server caches and re-trying BAPI in response to SIDS Table corruption");
                            this.execute(false, checkRtn);
                            break block16;
                        }
                        this.mConnect.invalidateConnection();
                        SNWODPLog.getLogger("Connection").log(LogLevel.WARN, "Invalidating connection in response to SIDS Table corruption");
                        throw new SNWODPException(SNWODPMessageKeys.ERR_EXECUTE_ERROR, se, this.mFunction.getFunctionName());
                    }
                    this.mConnect.invalidateConnection();
                    SNWODPLog.getLogger("Connection").log(LogLevel.WARN, "Invalidating connection in response to ABAP error on server");
                    throw new SNWODPException(SNWODPMessageKeys.ERR_EXECUTE_ERROR, se, this.mFunction.getFunctionName());
                }
                this.mConnect.invalidateConnection();
                throw new SNWODPException(SNWODPMessageKeys.ERR_EXECUTE_ERROR, se, this.mFunction.getFunctionName());
            }
            finally {
                if (logger != null) {
                    logger.log(LogLevel.INFO, OperationEnum.END, STR_TIMING_END_MSG + this.mFunction.getFunctionName());
                }
            }
        }
    }

    protected void executeFunction() throws SNWODPException, OperationCanceledException {
        this.execute(true, SNWODPConfig.instance().getCheckReturnCode());
    }

    protected void executeFunctionNoCheck() throws SNWODPException, OperationCanceledException {
        this.execute(true, false);
    }

    protected void clearSAPMetadataCache() {
        JBapiFunction clearCache = new JBapiFunction("BAPI_MDPROVIDER_REFRESH", this.mConnect);
        try {
            if (SNWODPLog.isOn("Function", LogLevel.TRACE).booleanValue()) {
                SNWODPLog.getLogger("Function").log(LogLevel.TRACE, "Clearing SAP Metadata Cache");
            }
            clearCache.execute(0, true);
        }
        catch (JBapiCancelException ce) {
            throw new OperationCanceledException();
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_EXECUTE_ERROR, e, clearCache.getFunctionName());
        }
        finally {
            clearCache.releaseFunction();
        }
    }

    protected void clearSAPUserCache() {
        JBapiFunction clearCache = new JBapiFunction("RSCR_API_USER_CACHE_CLEAR", this.mConnect);
        try {
            if (SNWODPLog.isOn("Function", LogLevel.TRACE).booleanValue()) {
                SNWODPLog.getLogger("Function").log(LogLevel.TRACE, "Clearing SAP User Cache");
            }
            clearCache.execute(0, true);
        }
        catch (JBapiCancelException ce) {
            throw new OperationCanceledException();
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_EXECUTE_ERROR, e, clearCache.getFunctionName());
        }
        finally {
            clearCache.releaseFunction();
        }
    }

    protected JBapiFunction installAndRunABAP(String mode, String progName, String code) throws SNWODPException {
        if (!this.mFunction.getFunctionName().equals(RFC_ABAP_INSTALL_AND_RUN)) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_WRONG_FUNCTION, RFC_ABAP_INSTALL_AND_RUN, this.mFunction.getFunctionName());
        }
        try {
            if (SNWODPLog.isOn("Function", LogLevel.TRACE).booleanValue()) {
                SNWODPLog.getLogger("Function").log(LogLevel.TRACE, "Install and Run ABAP");
            }
            if (SNWODPLog.isOn("Function", LogLevel.INFO).booleanValue()) {
                SNWODPLog.getLogger("Function").log(LogLevel.INFO, "Dynamic ABAP Trace: " + code);
            }
            if (mode != null && mode.length() > 0) {
                this.setImportParameter("MODE", mode);
            }
            if (progName != null && progName.length() > 0) {
                this.setImportParameter("PROGRAMNAME", progName);
            }
            JBapiTable program = this.getTable("PROGRAM");
            program.clearContent();
            int lineSz = program.getStructLength(false);
            int start = 0;
            int count = 0;
            int progSize = code.length();
            while (start < progSize) {
                this.checkForCancel();
                if (count >= start + lineSz || count >= progSize || code.charAt(count) == '\n' || code.charAt(count) == '\r') {
                    if (count > start) {
                        program.appendRow();
                        String progPart = code.substring(start, count);
                        if (progPart.length() > 0) {
                            program.setFieldByIndex(0, progPart);
                        }
                    } else if (count == start) {
                        // empty if block
                    }
                    start = ++count;
                    continue;
                }
                ++count;
            }
            JBapiTable writes = this.getTable("WRITES");
            writes.clearContent();
            writes.release();
            program.release();
            this.executeFunctionNoCheck();
        }
        catch (JBapiCancelException ce) {
            throw new OperationCanceledException();
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_EXECUTE_ERROR, e, this.mFunction.getFunctionName());
        }
        return this.mFunction;
    }

    protected JBapiTable getTable(String tableName) throws SNWODPException {
        try {
            return this.mFunction.getTable(tableName);
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_TABLE_FAILED, e, tableName);
        }
    }

    protected Object getExportParameter(String name) throws SNWODPException {
        try {
            return this.mFunction.getParam(name);
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_EXPORT_PARAM_FAILED, e, name);
        }
    }

    protected JBapiStructure getExportStructure(String name) throws SNWODPException {
        try {
            return this.mFunction.getStructure(name);
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_EXPORT_STRUCT_FAILED, e, name);
        }
    }

    protected void setKeyDateParam(String keyDate) throws SNWODPException {
        if (keyDate != null) {
            if (SNWODPLog.isOn("Function", LogLevel.INFO).booleanValue()) {
                SNWODPLog.getLogger("Function").log(LogLevel.INFO, this.mFunction.getFunctionName() + STR_SET_KEYDATE_MSG + keyDate);
            }
            this.setImportParameter("KEY_DATE", keyDate);
        } else {
            if (SNWODPLog.isOn("Function", LogLevel.INFO).booleanValue()) {
                SNWODPLog.getLogger("Function").log(LogLevel.INFO, this.mFunction.getFunctionName() + STR_SET_KEYDATE_MSG + "00000000");
            }
            this.setImportParameter("KEY_DATE", "00000000");
        }
    }

    protected void setImportParameter(String name, Object value) throws SNWODPException {
        try {
            if (SNWODPLog.isOn("Function", LogLevel.INFO).booleanValue()) {
                SNWODPLog.getLogger("Function").log(LogLevel.INFO, this.mFunction.getFunctionName() + STR_SET_PARAM_MSG + name + "\" to \"" + value.toString() + STR_ENDQUOTE);
            }
            this.mFunction.setParam(name, value.toString());
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_SET_IMPORT_PARAM_FAILED, e, name);
        }
    }

    protected void setImportParameter(String name, int value) throws SNWODPException {
        try {
            if (SNWODPLog.isOn("Function", LogLevel.INFO).booleanValue()) {
                SNWODPLog.getLogger("Function").log(LogLevel.INFO, this.mFunction.getFunctionName() + STR_SET_PARAM_MSG + name + "\" to (integer) \"" + value + STR_ENDQUOTE);
            }
            this.mFunction.setParam(name, XQEIntegerPool.getInteger((int)value).toString());
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_SET_IMPORT_PARAM_FAILED, e, name);
        }
    }

    protected JBapiStructure getImportStructure(String name) throws SNWODPException {
        try {
            return this.mFunction.getStructure(name);
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_EXPORT_STRUCT_FAILED, e, name);
        }
    }

    protected void clearTable(String tableName) throws SNWODPException {
        try {
            if (SNWODPLog.isOn("Function", LogLevel.TRACE).booleanValue()) {
                SNWODPLog.getLogger("Function").log(LogLevel.TRACE, "Clearing Table: " + tableName);
            }
            this.getTable(tableName).clearContent();
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_CLEAR_TABLE, e);
        }
    }

    public void release() {
        if (this.mFunction != null && !this.mIsExtFunc) {
            JBapiFunction localFunc = this.mFunction;
            this.mFunction = null;
            localFunc.releaseFunction();
        }
    }

    public String getFunctionName() {
        return this.mFunction.getFunctionName();
    }
}

