/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.snwodp;

import com.cognos.xqe.conn.bapi.JBapiException;
import com.cognos.xqe.data.providers.connection.parameters.JAASSubjectParameter;
import com.cognos.xqe.data.providers.connection.parameters.PasswordParameter;
import com.cognos.xqe.data.providers.connection.parameters.UserIDParameter;
import com.cognos.xqe.data.providers.olap.snwodp.ClientParameter;
import com.cognos.xqe.data.providers.olap.snwodp.CodePageParameter;
import com.cognos.xqe.data.providers.olap.snwodp.LogonGroupParameter;
import com.cognos.xqe.data.providers.olap.snwodp.RouteParameter;
import com.cognos.xqe.data.providers.olap.snwodp.RunLocaleParameter;
import com.cognos.xqe.data.providers.olap.snwodp.SAPServerParameter;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPConfig;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPException;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPLog;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPMessageKeys;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPSSOCache;
import com.cognos.xqe.data.providers.olap.snwodp.SSOTicketParameter;
import com.cognos.xqe.data.providers.olap.snwodp.ServerTypeParameter;
import com.cognos.xqe.data.providers.olap.snwodp.SystemIDParameter;
import com.cognos.xqe.data.providers.olap.snwodp.SystemNumberParameter;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.trace.LogLevel;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.security.auth.Subject;

class SNWODPLogonInfo
extends Properties {
    private static final String STARS = "*****";
    public static final String STR_SERVER = "server";
    public static final String STR_SERVER_TYPE = "serverType";
    public static final String STR_DATA_SOURCE = "Data Source";
    public static final String STR_SYSNR = "sysnr";
    public static final String STR_LOGONGROUP = "logonGroup";
    public static final String STR_SYSID = "sysid";
    public static final String STR_CLIENT = "client";
    public static final String STR_CODEPAGE = "codePage";
    public static final String STR_ROUTERSTRING = "routerString";
    public static final String STR_UID = "username";
    public static final String STR_PWD = "password";
    public static final String STR_CUBE = "cube";
    public static final String STR_CATALOG = "catalog";
    public static final String STR_SSO = "sapSSO";
    public static final String STR_KEYDATE = "keyDate";
    public static final String STR_SIGNON = "signon";
    public static final String STR_APP_SERVER = "applicationServer";
    public static final String STR_MSG_SERVER = "messageServer";
    public static final String STR_DEST_SERVER = "destination";
    public static final String STR_PLACEHOLDER = "%s";
    public static final String STR_COGNOS_SAP_HOST = "cognos.sap.host";
    public static final String STR_COGNOS_SAP_SERVER_TYPE = "cognos.sap.serverType";
    public static final String STR_SAP_USER = "USER";
    public static final String STR_SAP_ASHOST = "ASHOST";
    public static final String STR_SAP_MSHOST = "MSHOST";
    public static final String STR_SAP_DEST = "DEST";
    public static final String STR_SAP_PASSWD = "PASSWD";
    public static final String STR_SAP_SSO = "MYSAPSSO2";
    public static final String STR_SAP_SYSNR = "SYSNR";
    public static final String STR_SAP_R3NAME = "R3NAME";
    public static final String STR_SAP_LANG = "LANG";
    public static final String STR_SAP_CODEPAGE = "CODEPAGE";
    public static final String CONTROL_CHARS = "[\"\\;=]";
    private static final long serialVersionUID = 1L;
    private Map<String, String> localeToLanguageMap;

    public SNWODPLogonInfo() {
        this.setupLanguageMap();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseConnectionParams(ConnectionParameters connectionParameters) throws SNWODPException {
        String value;
        if (!connectionParameters.contains(ServerTypeParameter.class)) throw new SNWODPException(SNWODPMessageKeys.ERR_MISSING_SERVER_TYPE);
        String route = "";
        String type = (String)connectionParameters.valueOf(ServerTypeParameter.class);
        this.setProperty(STR_COGNOS_SAP_SERVER_TYPE, type);
        if (connectionParameters.contains(RouteParameter.class)) {
            route = (String)connectionParameters.valueOf(RouteParameter.class);
        }
        if (type.equals(STR_DEST_SERVER)) {
            if (!connectionParameters.contains(SAPServerParameter.class)) throw new SNWODPException(SNWODPMessageKeys.ERR_MISSING_DEST_HOST);
            value = (String)connectionParameters.valueOf(SAPServerParameter.class);
            this.setProperty(STR_SAP_DEST, value);
            this.setProperty(STR_COGNOS_SAP_HOST, value);
        } else if (type.equals(STR_APP_SERVER)) {
            if (!connectionParameters.contains(SAPServerParameter.class)) {
                throw new SNWODPException(SNWODPMessageKeys.ERR_MISSING_APP_HOST);
            }
            String host = (String)connectionParameters.valueOf(SAPServerParameter.class);
            this.setProperty(STR_COGNOS_SAP_HOST, host);
            this.setProperty(STR_SAP_ASHOST, route + host);
            if (!connectionParameters.contains(SystemNumberParameter.class)) throw new SNWODPException(SNWODPMessageKeys.ERR_MISSING_SYS_NUMBER);
            this.setProperty(STR_SAP_SYSNR, (String)connectionParameters.valueOf(SystemNumberParameter.class));
        } else {
            if (!type.equals(STR_MSG_SERVER)) throw new SNWODPException(SNWODPMessageKeys.ERR_UNKNOWN_SRVR_TYPE, type);
            if (!connectionParameters.contains(SAPServerParameter.class)) {
                throw new SNWODPException(SNWODPMessageKeys.ERR_MISSING_MSG_HOST);
            }
            value = (String)connectionParameters.valueOf(SAPServerParameter.class);
            this.setProperty(STR_SAP_MSHOST, value);
            this.setProperty(STR_COGNOS_SAP_HOST, value);
            if (!connectionParameters.contains(SystemIDParameter.class)) {
                throw new SNWODPException(SNWODPMessageKeys.ERR_MISSING_SYS_ID);
            }
            this.setProperty(STR_SAP_R3NAME, route + (String)connectionParameters.valueOf(SystemIDParameter.class));
            if (!connectionParameters.contains(LogonGroupParameter.class)) throw new SNWODPException(SNWODPMessageKeys.ERR_MISSING_LOGON_GRP);
            this.setProperty("GROUP", (String)connectionParameters.valueOf(LogonGroupParameter.class));
        }
        if (!connectionParameters.contains(ClientParameter.class)) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_MISSING_CLIENT_NUMBER);
        }
        this.setProperty("CLIENT", (String)connectionParameters.valueOf(ClientParameter.class));
        if (!connectionParameters.contains(CodePageParameter.class)) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_MISSING_CODEPAGE);
        }
        this.setProperty(STR_SAP_CODEPAGE, (String)connectionParameters.valueOf(CodePageParameter.class));
        String pwd = null;
        if (connectionParameters.contains(UserIDParameter.class)) {
            String uid = (String)connectionParameters.valueOf(UserIDParameter.class);
            if ("".equals(uid) || uid.equals(STR_PLACEHOLDER)) {
                throw new SNWODPException(SNWODPMessageKeys.ERR_NO_USERID);
            }
            this.setProperty(STR_SAP_USER, uid);
            if (connectionParameters.contains(PasswordParameter.class)) {
                pwd = (String)connectionParameters.valueOf(PasswordParameter.class);
                if (pwd != null) {
                    String[] controlChars;
                    if (SNWODPConfig.instance().getUppercasePwd()) {
                        pwd = pwd.toUpperCase();
                    }
                    if ((controlChars = pwd.split(CONTROL_CHARS)).length > 1) {
                        throw new JBapiException("Unsupported character(s) \"\\;= found in the password for user " + uid);
                    }
                    this.setProperty(STR_SAP_PASSWD, pwd);
                } else if (this.isHTTPSSOEnabled()) {
                    this.getSSOTicket(false);
                }
            }
            if (pwd == null && !connectionParameters.contains(SSOTicketParameter.class) && null == this.getProperty(STR_SAP_SSO)) {
                throw new SNWODPException(SNWODPMessageKeys.ERR_NO_PASSWD);
            }
        }
        if (connectionParameters.contains(JAASSubjectParameter.class)) {
            ByteArrayOutputStream os = null;
            if (SNWODPLog.isOn(LogLevel.TRACE).booleanValue()) {
                os = new ByteArrayOutputStream();
            }
            if (this.isHTTPSSOEnabled()) {
                SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "JAASSubject Kerberos signon");
                Subject subject = (Subject)connectionParameters.valueOf(JAASSubjectParameter.class, Subject.class);
                this.setProperty(STR_SAP_USER, subject.getPrincipals().toString());
                class KerberosTask
                implements PrivilegedAction<Exception> {
                    ByteArrayOutputStream os;
                    Exception ex = null;

                    KerberosTask(ByteArrayOutputStream theOs) {
                        this.os = theOs;
                    }

                    @Override
                    public Exception run() {
                        PrintStream old = System.out;
                        if (this.os != null) {
                            PrintStream ps = new PrintStream(this.os);
                            System.setOut(ps);
                        }
                        try {
                            SNWODPLogonInfo.this.getSSOTicket(true);
                        }
                        catch (Exception e) {
                            this.ex = e;
                        }
                        finally {
                            System.setOut(old);
                        }
                        return this.ex;
                    }

                    public Exception getException() {
                        return this.ex;
                    }
                }
                KerberosTask kerberosTask = new KerberosTask(os);
                Subject.doAs(subject, kerberosTask);
                if (this.getProperty(STR_SAP_SSO) == null) {
                    Exception e = kerberosTask.getException();
                    String message = "";
                    if (e != null) {
                        message = e.getMessage();
                    }
                    if (SNWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
                        SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "JAASSubject Kerberos Signon failed. " + message);
                    }
                }
            }
        }
        if (connectionParameters.contains(SSOTicketParameter.class) && null == this.getProperty(STR_SAP_SSO) && (null == pwd || "".equals(pwd))) {
            this.setProperty(STR_SAP_SSO, (String)connectionParameters.valueOf(SSOTicketParameter.class));
        }
        if (null == this.getProperty(STR_SAP_SSO)) {
            if (!connectionParameters.contains(UserIDParameter.class)) {
                throw new SNWODPException(SNWODPMessageKeys.ERR_NO_USERID);
            }
            if (!connectionParameters.contains(PasswordParameter.class)) {
                throw new SNWODPException(SNWODPMessageKeys.ERR_NO_PASSWD);
            }
        }
        if (connectionParameters.contains(RunLocaleParameter.class)) {
            String language = (String)connectionParameters.valueOf(RunLocaleParameter.class);
            List<String> extendedLanguages = SNWODPConfig.instance().getExtendedLanguages();
            for (String sapLanguage : extendedLanguages) {
                if (!this.localeToLanguageMap.containsKey(sapLanguage) || !this.localeToLanguageMap.get(sapLanguage).equalsIgnoreCase(language)) continue;
                language = sapLanguage;
                this.setProperty(STR_SAP_CODEPAGE, "4103");
                break;
            }
            this.setProperty(STR_SAP_LANG, language);
        }
        this.setProperty("TYPE", "3");
        if (!SNWODPConfig.instance().getTraceRFC()) return;
        this.setProperty("TRACE", "1");
    }

    private boolean isHTTPSSOEnabled() {
        if (this.getProperty(STR_COGNOS_SAP_SERVER_TYPE).equals(STR_DEST_SERVER)) {
            return false;
        }
        SNWODPSSOCache ssoCache = SNWODPSSOCache.getInstance();
        return ssoCache.isHTTPSSOEnabled();
    }

    private void getSSOTicket(boolean isKerberos) {
        SNWODPSSOCache ssoCache;
        String ticket;
        String user = this.getProperty(STR_SAP_USER);
        if (user == null || user.isEmpty()) {
            return;
        }
        String server = this.getProperty(STR_COGNOS_SAP_HOST);
        if (server == null || server.isEmpty()) {
            return;
        }
        if (SNWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "GetSSOTicket: " + server + " / " + user);
        }
        if ((ticket = (ssoCache = SNWODPSSOCache.getInstance()).getSSOTicket(server, user, isKerberos)) != null && !ticket.isEmpty()) {
            this.setProperty(STR_SAP_SSO, ticket);
            if (SNWODPLog.isOn("Connection", LogLevel.INFO).booleanValue()) {
                if (isKerberos) {
                    SNWODPLog.getLogger("Connection").log(LogLevel.INFO, "Kerberos SSO successful");
                } else {
                    SNWODPLog.getLogger("Connection").log(LogLevel.INFO, "HTTP SSO successful");
                }
            }
        } else if (SNWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SSO Ticket was empty!");
        }
    }

    void obfuscatePassword() {
        if (null != this.getProperty(STR_SAP_PASSWD)) {
            this.setProperty(STR_SAP_PASSWD, STARS);
        }
    }

    void obfuscateSSO() {
        if (null != this.getProperty(STR_SAP_SSO)) {
            this.setProperty(STR_SAP_SSO, STARS);
        }
    }

    private void setupLanguageMap() {
        this.localeToLanguageMap = new TreeMap<String, String>();
        this.localeToLanguageMap.put("0A", "ar_om");
        this.localeToLanguageMap.put("0S", "es_co");
        this.localeToLanguageMap.put("1A", "ar_dz");
        this.localeToLanguageMap.put("1B", "ar_qa");
        this.localeToLanguageMap.put("1C", "zh_hans_hk");
        this.localeToLanguageMap.put("1D", "nl_be");
        this.localeToLanguageMap.put("1E", "en_au");
        this.localeToLanguageMap.put("1F", "fr_be");
        this.localeToLanguageMap.put("1G", "de_at");
        this.localeToLanguageMap.put("1I", "it_ch");
        this.localeToLanguageMap.put("1M", "ms_bn");
        this.localeToLanguageMap.put("1N", "en_nz");
        this.localeToLanguageMap.put("1P", "pt_pt");
        this.localeToLanguageMap.put("1S", "es_ar");
        this.localeToLanguageMap.put("1U", "ur_in");
        this.localeToLanguageMap.put("1X", "es_mx");
        this.localeToLanguageMap.put("2A", "ar_bh");
        this.localeToLanguageMap.put("2B", "ar_sy");
        this.localeToLanguageMap.put("2C", "zh_hans_mo");
        this.localeToLanguageMap.put("2E", "en_bz");
        this.localeToLanguageMap.put("2F", "fr_cm");
        this.localeToLanguageMap.put("2G", "de_li");
        this.localeToLanguageMap.put("2H", "fr_re");
        this.localeToLanguageMap.put("2N", "en_ph");
        this.localeToLanguageMap.put("2S", "es_bo");
        this.localeToLanguageMap.put("2X", "es_ni");
        this.localeToLanguageMap.put("3A", "ar_eg");
        this.localeToLanguageMap.put("3B", "ar_tn");
        this.localeToLanguageMap.put("3C", "zh_hans_sg");
        this.localeToLanguageMap.put("3E", "en_ca");
        this.localeToLanguageMap.put("3F", "fr_ca");
        this.localeToLanguageMap.put("3G", "de_lu");
        this.localeToLanguageMap.put("3H", "fr_sn");
        this.localeToLanguageMap.put("3N", "en_sg");
        this.localeToLanguageMap.put("3P", "pa_arab_pk");
        this.localeToLanguageMap.put("3S", "es_cl");
        this.localeToLanguageMap.put("3X", "es_pa");
        this.localeToLanguageMap.put("4A", "ar_iq");
        this.localeToLanguageMap.put("4B", "ar_ae");
        this.localeToLanguageMap.put("4C", "zh_hant_tw");
        this.localeToLanguageMap.put("4G", "de_ch");
        this.localeToLanguageMap.put("4H", "fr_ch");
        this.localeToLanguageMap.put("4N", "en_za");
        this.localeToLanguageMap.put("4S", "es_cr");
        this.localeToLanguageMap.put("4X", "es_py");
        this.localeToLanguageMap.put("5A", "ar_jo");
        this.localeToLanguageMap.put("5B", "ar_ye");
        this.localeToLanguageMap.put("5E", "en_hk");
        this.localeToLanguageMap.put("5F", "fr_ci");
        this.localeToLanguageMap.put("5N", "en_tt");
        this.localeToLanguageMap.put("5R", "az_cyrl");
        this.localeToLanguageMap.put("5S", "es_do");
        this.localeToLanguageMap.put("5X", "es_pe");
        this.localeToLanguageMap.put("6A", "ar_kw");
        this.localeToLanguageMap.put("6B", "bn_in");
        this.localeToLanguageMap.put("6E", "en_in");
        this.localeToLanguageMap.put("6F", "fr_in");
        this.localeToLanguageMap.put("6N", "en_gb");
        this.localeToLanguageMap.put("6S", "es_ec");
        this.localeToLanguageMap.put("6X", "es_pr");
        this.localeToLanguageMap.put("7A", "ar_lb");
        this.localeToLanguageMap.put("7F", "fr_lu");
        this.localeToLanguageMap.put("7N", "en_zw");
        this.localeToLanguageMap.put("7R", "ro_md");
        this.localeToLanguageMap.put("7S", "es_sv");
        this.localeToLanguageMap.put("7X", "es_uy");
        this.localeToLanguageMap.put("8A", "ar_ly");
        this.localeToLanguageMap.put("8E", "en_ie");
        this.localeToLanguageMap.put("8F", "fr_ml");
        this.localeToLanguageMap.put("8R", "ru_md");
        this.localeToLanguageMap.put("8S", "es_gt");
        this.localeToLanguageMap.put("8X", "es_ve");
        this.localeToLanguageMap.put("9A", "ar_ma");
        this.localeToLanguageMap.put("9E", "en_jm");
        this.localeToLanguageMap.put("9F", "fr_mc");
        this.localeToLanguageMap.put("9N", "ne_in");
        this.localeToLanguageMap.put("9S", "es_hn");
    }
}

