/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.snwodp;

import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPLog;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.TimeValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.trace.LogLevel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class SNWODPUtility {
    private static final int THREE = 3;
    private static final String INFOCUBE = "$INFOCUBE";

    public static String getSAPMemberUniqueNameKey(String memberUniqueName) {
        int iPartTwoEndInx;
        String memberUniqueNameKey = null;
        int iPartTwoStartInx = memberUniqueName.lastIndexOf("].[");
        if (iPartTwoStartInx != -1 && (iPartTwoEndInx = memberUniqueName.indexOf("]", iPartTwoStartInx += 3)) != -1 && ((memberUniqueNameKey = memberUniqueName.substring(iPartTwoStartInx, iPartTwoEndInx)) == null || memberUniqueNameKey.length() == 0)) {
            memberUniqueNameKey = "#";
        }
        return memberUniqueNameKey;
    }

    public static String makeEffectiveKeyDateRange(String date1, String date2) {
        StringBuilder sb = new StringBuilder(StringUtils.replace((String)date1, (String)"-", (String)""));
        sb.append("-");
        sb.append(StringUtils.replace((String)date2, (String)"-", (String)""));
        return sb.toString();
    }

    public static int convertTreeOperatorEnumSetToInt(EnumSet<TreeOperatorEnum> treeOpSet) {
        int answer = 0;
        block8: for (TreeOperatorEnum treeOp : treeOpSet) {
            switch (treeOp) {
                case CHILDREN: {
                    answer |= 1;
                    continue block8;
                }
                case SIBLINGS: {
                    answer |= 2;
                    continue block8;
                }
                case PARENT: {
                    answer |= 4;
                    continue block8;
                }
                case SELF: {
                    answer |= 8;
                    continue block8;
                }
                case DESCENDANTS: {
                    answer |= 0x10;
                    continue block8;
                }
                case ANCESTORS: {
                    answer |= 0x20;
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unsupported tree operator value: " + treeOp);
        }
        return answer;
    }

    public static boolean isTreeOpcontainsSelf(EnumSet<TreeOperatorEnum> treeOpSet) {
        if (null != treeOpSet) {
            for (TreeOperatorEnum treeOp : treeOpSet) {
                switch (treeOp) {
                    case SELF: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static class SAPNWTypeUtils {
        public static final String STR_TO = " to: ";

        public static IDataType sapMeasureDataTypeToXQEDataType(String sapDataType) {
            Object xqeDataType = sapDataType.equals("INT1") || sapDataType.equals("INT2") || sapDataType.equals("INT4") || sapDataType.equals("PREC") || sapDataType.equals("QUAN") || sapDataType.equals("CURR") || sapDataType.equals("DEC") || sapDataType.equals("FLTP") ? DataTypeFactory.getDoubleType() : (sapDataType.equals("STRG") || sapDataType.equals("UNIT") || sapDataType.equals("ACCP") || sapDataType.equals("CHAR") || sapDataType.equals("CLNT") || sapDataType.equals("CUKY") || sapDataType.equals("RAW") || sapDataType.equals("RSTR") || sapDataType.equals("LANG") || sapDataType.equals("LCHR") || sapDataType.equals("LRAW") || sapDataType.equals("NUMC") ? DataTypeFactory.getStringType() : (sapDataType.equals("DATS") ? DataTypeFactory.getDateType() : (sapDataType.equals("TIMS") ? DataTypeFactory.getTimeType() : DataTypeFactory.getVariantType())));
            if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
                SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Converting SAP Measure DataType: " + sapDataType + STR_TO + xqeDataType.getTypeName());
            }
            return xqeDataType;
        }

        public static IDataType sapPropertyDataTypeToXQEDataType(String sapDataType, int precision, int scale) {
            Object xqeDataType = sapDataType.equals("INT1") || sapDataType.equals("INT2") || sapDataType.equals("PREC") ? DataTypeFactory.getIntegerType((int)precision, (int)scale) : (sapDataType.equals("INT4") || sapDataType.equals("QUAN") ? DataTypeFactory.getLongType((int)precision, (int)scale) : (sapDataType.equals("CURR") || sapDataType.equals("DEC") || sapDataType.equals("FLTP") ? DataTypeFactory.getDoubleType() : (sapDataType.equals("STRG") || sapDataType.equals("UNIT") || sapDataType.equals("ACCP") || sapDataType.equals("CHAR") || sapDataType.equals("CLNT") || sapDataType.equals("CUKY") || sapDataType.equals("LANG") || sapDataType.equals("LCHR") || sapDataType.equals("LRAW") || sapDataType.equals("NUMC") || sapDataType.equals("RAW") || sapDataType.equals("RSTR") ? DataTypeFactory.getStringType() : (sapDataType.equals("DATS") || sapDataType.equals("TIMS") ? DataTypeFactory.getTimestampType() : DataTypeFactory.getVariantType()))));
            if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
                SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Converting SAP Property DataType: " + sapDataType + STR_TO + xqeDataType.getTypeName());
            }
            return xqeDataType;
        }

        public static IDataType sapVariableDataTypeToXQEDataType(String sapDataType, boolean isDateType) {
            Object xqeDataType = sapDataType.equals("INT1") || sapDataType.equals("INT2") || sapDataType.equals("PREC") ? DataTypeFactory.getIntegerType() : (sapDataType.equals("INT4") || sapDataType.equals("QUAN") ? DataTypeFactory.getLongType() : (sapDataType.equals("CURR") || sapDataType.equals("DEC") || sapDataType.equals("FLTP") ? DataTypeFactory.getDoubleType() : (sapDataType.equals("STRG") || sapDataType.equals("UNIT") || sapDataType.equals("ACCP") || sapDataType.equals("CLNT") || sapDataType.equals("CUKY") || sapDataType.equals("LANG") || sapDataType.equals("LCHR") || sapDataType.equals("LRAW") || sapDataType.equals("NUMC") || sapDataType.equals("RAW") || sapDataType.equals("RSTR") ? DataTypeFactory.getStringType() : (sapDataType.equals("CHAR") ? (isDateType ? DataTypeFactory.getDateType() : DataTypeFactory.getStringType()) : (sapDataType.equals("DATS") || sapDataType.equals("TIMS") ? DataTypeFactory.getTimestampType() : DataTypeFactory.getVariantType())))));
            if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
                SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Converting SAP Variable DataType: " + sapDataType + STR_TO + xqeDataType.getTypeName());
            }
            return xqeDataType;
        }

        public static AggregateTypeEnum convertSAPAggregateType(int sapAggregateType) {
            switch (sapAggregateType) {
                case 1: {
                    return AggregateTypeEnum.SUM;
                }
                case 2: {
                    return AggregateTypeEnum.COUNT;
                }
                case 3: {
                    return AggregateTypeEnum.MIN;
                }
                case 4: {
                    return AggregateTypeEnum.MAX;
                }
                case 5: {
                    return AggregateTypeEnum.AVG;
                }
                case 6: {
                    return AggregateTypeEnum.VAR;
                }
                case 7: {
                    return AggregateTypeEnum.STDDEV;
                }
                case 8: {
                    return AggregateTypeEnum.AVG_NON_ZERO;
                }
                case 9: {
                    return AggregateTypeEnum.AVG_CALENDAR_DAYS;
                }
                case 11: {
                    return AggregateTypeEnum.COUNT_NON_ZERO;
                }
                case 12: {
                    return AggregateTypeEnum.FIRST;
                }
                case 13: {
                    return AggregateTypeEnum.LAST;
                }
                case 127: {
                    return AggregateTypeEnum.CALC;
                }
                case 10: {
                    return AggregateTypeEnum.AVG_PERIOD;
                }
            }
            return AggregateTypeEnum.UNKNOWN;
        }
    }

    public static enum DisplayPropertiesForCaption {
        NAME("NAME", "1"),
        KEY("KEY", "2"),
        LONGNAME("LONG NAME", "4"),
        MEDIUMNAME("MEDIUM NAME", "5"),
        DESCRIPTION("DESCRIPTION", "6"),
        CAPTION("CAPTION", "7");

        private final String dimPrefix;
        private final String propertyName;

        private DisplayPropertiesForCaption(String thePropertyName, String theDimPrefix) {
            this.propertyName = thePropertyName;
            this.dimPrefix = theDimPrefix;
        }

        public String getDimensionPrefix() {
            return this.dimPrefix;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public static String getPrefixPropertyName(String propertyName) {
            for (DisplayPropertiesForCaption e : DisplayPropertiesForCaption.values()) {
                if (!e.getPropertyName().equals(propertyName)) continue;
                return e.getDimensionPrefix();
            }
            return CAPTION.getDimensionPrefix();
        }

        public static DisplayPropertiesForCaption getDisplayProperty(String propertyName) {
            for (DisplayPropertiesForCaption e : DisplayPropertiesForCaption.values()) {
                if (!e.getPropertyName().equals(propertyName)) continue;
                return e;
            }
            return CAPTION;
        }
    }

    public static class SNWODPNameUtils {
        public static final String DOUBLE_UNDERBAR = "__";

        public static String removeBrackets(String name) {
            if (name == null) {
                return null;
            }
            String nm = name;
            if (name.startsWith("[")) {
                nm = name.endsWith("]") ? name.substring(1, name.length() - 1) : name.substring(1);
            }
            return nm;
        }

        public static String extractInfoObjectName(String name) {
            String nm = name;
            int end = name.lastIndexOf("/");
            if (name.startsWith("[")) {
                nm = end == -1 ? name.substring(1) : name.substring(1, end);
            } else if (end != -1) {
                nm = name.substring(0, end);
            }
            return nm;
        }

        public static String extractIObjFromNavAttrName(String name) {
            String nm = name;
            int idx = name.lastIndexOf(DOUBLE_UNDERBAR);
            if (-1 != idx) {
                nm = nm.substring(idx + 2);
            }
            return nm;
        }

        public static String extractCubeName(String name) {
            String nm = name;
            int end = name.lastIndexOf("/");
            if (name.startsWith("$")) {
                nm = end == -1 ? name.substring(1) : name.substring(1, end);
            } else if (end != -1) {
                nm = name.substring(0, end);
            }
            return nm;
        }

        public static String makeCubeDimensionName(String cubeName, String dimUniqueName) {
            String nm = SNWODPNameUtils.makeCubeName(cubeName);
            StringBuilder sb = new StringBuilder(nm);
            sb.append(".");
            sb.append(dimUniqueName);
            return sb.toString();
        }

        public static String makeCubeName(String cubeName) {
            String nm = cubeName;
            if (!nm.startsWith("[")) {
                StringBuffer sb = new StringBuffer("[");
                sb.append(nm);
                sb.append("]");
                nm = sb.toString();
            }
            return nm;
        }

        public static String makeDimPropertyName(String prefix, String dimName) {
            StringBuilder sb = new StringBuilder(dimName);
            sb.append(".");
            sb.append("[");
            sb.append(prefix);
            sb.append(dimName.substring(1));
            return sb.toString();
        }

        public static String getPropertyKeyName(String dimUniqueName) {
            StringBuffer sb = new StringBuffer(dimUniqueName);
            sb.append(".[");
            sb.append("2");
            sb.append(SNWODPNameUtils.removeBrackets(dimUniqueName));
            sb.append("]");
            return sb.toString();
        }

        public static void checkCatalogName(IRestrictions restrictions) {
            String cubeRestriction = (String)restrictions.getValueOf(RestrictionType.CUBE);
            if (cubeRestriction != null) {
                String catalogRestriction;
                if (cubeRestriction.startsWith("$")) {
                    restrictions.replace(RestrictionType.CATALOG, (Object)SNWODPUtility.INFOCUBE);
                }
                if (cubeRestriction.contains("/") && !cubeRestriction.startsWith("$") && (catalogRestriction = (String)restrictions.getValueOf(RestrictionType.CATALOG)).startsWith("$")) {
                    restrictions.replace(RestrictionType.CATALOG, (Object)catalogRestriction.substring(1));
                }
            }
        }
    }

    public static class DateUtils {
        public static final int DATE_LENGTH = 10;
        public static final String SAP_DATE_TIME_FORMAT = "yyyyMMddhhmmss";
        public static final String SAP_DATE_FORMAT = "yyyyMMdd";
        public static final String SAP_TIME_FORMAT = "hhmmss";
        public static final String STR_COLON = ":";
        public static final String STR_MINUS = "-";
        public static final String ZERO_TIME = "000000";
        public static final int CONST_ENDYEAR = 4;
        public static final int CONST_ENDMONTH = 6;
        public static final int CONST_ENDDAY = 8;
        public static final int CONST_ENDHOURS = 10;
        public static final int CONST_ENDMINUTES = 12;
        public static final int CONST_DATEMIN = 8;
        public static final int CONST_STAMPMIN = 14;
        public static final int CONST_TIMEMIN = 6;
        public static final int CONST_TIME_ENDHOURS = 2;
        public static final int CONST_TIME_ENDMINUTES = 4;
        public static final int CONST_TIME_ENDSECONDS = 6;
        private static GregorianCalendar calendar = new GregorianCalendar();
        private static final String SAP_RX_DATE_FORMAT = "[0-9]{8}";

        public static DateValue getLocalDate() {
            DateValue value = DataValueFactory.createDateValue();
            value.set(DateUtils.getLocalDateTime("yyyy-MM-dd"));
            return value;
        }

        public static TimeValue getLocalTime() {
            TimeValue value = DataValueFactory.createTimeValue();
            value.set(DateUtils.getLocalDateTime("HH:mm:ss"));
            return value;
        }

        private static String getLocalDateTime(String dateFormat) {
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            return sdf.format(calendar.getTime());
        }

        public static String getLocalDateInSAPFormat() {
            return DateUtils.getLocalDateTime(SAP_DATE_FORMAT);
        }

        public static String getLocalTimeInSAPFormat() {
            return DateUtils.getLocalDateTime(SAP_TIME_FORMAT);
        }

        public static String convertDateToSAPDateFormat(DateValue value) {
            SimpleDateFormat sdf = new SimpleDateFormat(SAP_DATE_FORMAT);
            return sdf.format(value.getDate());
        }

        public static DateValue convertSAPDateToDateValue(String date) {
            String rxDate = SAP_RX_DATE_FORMAT;
            Pattern pattern = Pattern.compile(rxDate);
            DateValue value = DataValueFactory.createDateValue();
            value.setNull();
            Matcher m = pattern.matcher(date);
            if (!m.matches()) {
                return value;
            }
            int year = Integer.valueOf(date.substring(0, 4));
            int month = Integer.valueOf(date.substring(4, 6));
            int day = Integer.valueOf(date.substring(6, 8));
            Calendar cal = value.getCalendar();
            cal.setLenient(false);
            cal.set(year, month - 1, day);
            value.set(cal.getTime());
            return value;
        }

        public static TimeValue convertSAPTSToTimestampValue(String time) {
            String rxTime = "[0-9]{6}";
            Pattern pattern = Pattern.compile(rxTime);
            TimeValue value = DataValueFactory.createTimeValue();
            value.setNull();
            Matcher m = pattern.matcher(time);
            if (!m.matches()) {
                return value;
            }
            int hours = Integer.valueOf(time.substring(0, 2));
            int min = Integer.valueOf(time.substring(2, 4));
            int second = Integer.valueOf(time.substring(4, 6));
            Calendar cal = value.getCalendar();
            cal.set(0, 0, 0, hours, min, second);
            value.set(cal.getTime());
            return value;
        }

        public static TimestampValue convertSAPTimestampToTimestampValue(String time) {
            String rxDate = "[0-9]{14}";
            Pattern pattern = Pattern.compile(rxDate);
            TimestampValue value = DataValueFactory.createTimestampValue();
            Matcher m = pattern.matcher(time);
            if (!m.matches()) {
                return value;
            }
            int year = Integer.valueOf(time.substring(0, 4));
            int month = Integer.valueOf(time.substring(4, 6));
            int day = Integer.valueOf(time.substring(6, 8));
            int hours = Integer.valueOf(time.substring(8, 10));
            int min = Integer.valueOf(time.substring(10, 12));
            int second = Integer.valueOf(time.substring(12));
            Calendar cal = value.getCalendar();
            cal.set(year, month - 1, day, hours, min, second);
            value.set(cal.getTime());
            return value;
        }

        public static String convertDateToSAPDateFormat(String value) {
            DateValue date = DataValueFactory.createDateValue();
            date.set(value);
            return DateUtils.convertDateToSAPDateFormat(date);
        }

        public static String convertDateToXSDTimestamp(String value) {
            StringBuilder sb = new StringBuilder();
            if (value.contains(STR_MINUS)) {
                sb.append(DateUtils.convertDateToSAPDateFormat(value));
            } else {
                sb.append(value);
            }
            sb.append(ZERO_TIME);
            return DateUtils.convertSAPTimestampToTimestampValue(sb.toString()).getString().replace(" ", "T");
        }

        public static String convertDateFormatToString(DateValue value) {
            String format = "MMM dd, yyyy";
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.format(value.getDate());
        }

        public static boolean isDateType(String date) {
            String rxDate = SAP_RX_DATE_FORMAT;
            Pattern pattern = Pattern.compile(rxDate);
            Matcher m = pattern.matcher(date);
            return m.matches();
        }

        public static int compareDates(String date1, String date2, String format) throws ParseException {
            Date sapdate2;
            SimpleDateFormat df = new SimpleDateFormat(format);
            Date sapdate1 = df.parse(date1);
            if (sapdate1.equals(sapdate2 = df.parse(date2))) {
                return 0;
            }
            if (sapdate1.after(sapdate2)) {
                return 1;
            }
            return -1;
        }

        public static int compareDates(String firstDate, String secondDate) {
            int date2;
            if (firstDate.length() != 10 && secondDate.length() != 10) {
                return 0;
            }
            if (firstDate.length() != 10) {
                return -1;
            }
            if (secondDate.length() != 10) {
                return 1;
            }
            firstDate = StringUtils.replace((String)firstDate, (String)STR_MINUS, (String)"");
            secondDate = StringUtils.replace((String)secondDate, (String)STR_MINUS, (String)"");
            int date1 = Integer.parseInt(firstDate);
            if (date1 > (date2 = Integer.parseInt(secondDate))) {
                return 1;
            }
            if (date1 < date2) {
                return -1;
            }
            return 0;
        }
    }
}

