/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast;

import com.cognos.xqe.ast.INodeCondition;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTENodeIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class XQENodeIndex
extends QTENodeIndex<IXQEQueryNode> {
    public static final int QUERYTREE_UNLIMITED_DEPTH = 0;
    private static final String NODE_ID = "id";
    private static final int NODE_LIMIT_FOR_DISTANCE_SEARCH = 50;

    public XQENodeIndex() {
        super(0);
    }

    public List<IXQEQueryNode> getDescendantsOfTypeByDistance(int nodeType, IXQEQueryNode ancestor, int maxSearchDistance) {
        if (ancestor == null) {
            return null;
        }
        boolean keepNulls = true;
        Collection<IXQEQueryNode> nodesForType = this.getNodesCollectionByType(keepNulls, nodeType);
        if (maxSearchDistance == 0 && nodesForType.size() >= 50) {
            return ancestor.getDescendantsOfTypeOrdered(nodeType, false);
        }
        return this.filterOutByAncestorAndDistance(ancestor, nodesForType, maxSearchDistance);
    }

    private List<IXQEQueryNode> filterOutByAncestorAndDistance(IXQEQueryNode ancestor, Collection<IXQEQueryNode> inputNodes, int maxSearchDistance) {
        ArrayList<IXQEQueryNode> filteredList = new ArrayList<IXQEQueryNode>();
        block0: for (IXQEQueryNode node : inputNodes) {
            if (node == null) continue;
            IXQEQueryNode parent = node.getParent();
            int j = 1;
            while (parent != null) {
                if (parent == ancestor) {
                    filteredList.add(node);
                    continue block0;
                }
                parent = parent.getParent();
                if (maxSearchDistance > 0 && j == maxSearchDistance) continue block0;
                ++j;
            }
        }
        return filteredList;
    }

    public void getDescendantsForConditionByDistance(Collection<IXQEQueryNode> nodeCollection, INodeCondition condition, IXQEQueryNode ancestor, int maxSearchDistance) {
        if (ancestor == null) {
            return;
        }
        int[] nodeTypes = condition.getNodeTypes();
        if (nodeTypes.length == 0) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "nodeTypes.length == 0");
        }
        if (ancestor.isOfCategory(1001) && condition.isAncestorNode((AbstractMDXNode)ancestor)) {
            ArrayList<IXQEQueryNode> nodeList = new ArrayList<IXQEQueryNode>();
            for (int i = 0; i < nodeTypes.length; ++i) {
                nodeList.addAll(this.getNonNullNodesCollectionByType(nodeTypes[i]));
            }
            nodeList.remove(ancestor);
            condition.applies(nodeList, nodeCollection);
        } else {
            for (int i = 0; i < nodeTypes.length; ++i) {
                boolean keepNulls = true;
                Collection nodes = this.getNodesCollectionByType(keepNulls, nodeTypes[i]);
                block2: for (IXQEQueryNode node : nodes) {
                    if (node == null) continue;
                    IXQEQueryNode parent = node.getParent();
                    int j = 1;
                    while (parent != null) {
                        if (parent == ancestor) {
                            if (!condition.applies(node)) continue block2;
                            nodeCollection.add(node);
                            continue block2;
                        }
                        parent = parent.getParent();
                        if (maxSearchDistance > 0 && j == maxSearchDistance) continue block2;
                        ++j;
                    }
                }
            }
        }
    }

    public List<IXQEQueryNode> getDescendantsOfType(int nodeType, IXQEQueryNode ancestor) {
        return this.getDescendantsOfTypeByDistance(nodeType, ancestor, 0);
    }

    public void getDescendantsForCondition(Collection<IXQEQueryNode> nodeCollection, INodeCondition condition, IXQEQueryNode ancestor) {
        this.getDescendantsForConditionByDistance(nodeCollection, condition, ancestor, 0);
    }

    public XQEQueryNode[] getChildrenOfType(int nodeType, XQEQueryNode parent) {
        List<IXQEQueryNode> childrenOfType = this.getDescendantsOfTypeByDistance(nodeType, parent, 1);
        return childrenOfType.toArray(new XQEQueryNode[childrenOfType.size()]);
    }

    public boolean nodeTypeIsDescendantOfOtherNode(int childNodeType, XQEQueryNode ancestor) {
        if (ancestor == null) {
            return false;
        }
        boolean exists = false;
        boolean keepNulls = true;
        for (IXQEQueryNode child : this.getNodesCollectionByType(keepNulls, childNodeType)) {
            if (child == null || !child.isAncestor(ancestor)) continue;
            exists = true;
            break;
        }
        return exists;
    }

    public int[] getNumberOfChildrenOfNodesOfTypeInSubtree(int nodeType, XQEQueryNode subtreeRoot) {
        if (subtreeRoot == null) {
            return null;
        }
        boolean keepNulls = true;
        Collection nodeArray = this.getNodesCollectionByType(keepNulls, nodeType);
        int[] numChildren = new int[nodeArray.size()];
        int i = 0;
        for (IXQEQueryNode node : nodeArray) {
            if (node == null) {
                numChildren[i++] = 0;
                continue;
            }
            if (node.isAncestor(subtreeRoot)) {
                numChildren[i++] = node.getNumberChildren();
                continue;
            }
            numChildren[i++] = 0;
        }
        return numChildren;
    }

    public int[] getNumberOfNodesOfTypeInSubtreesOfType(int nodeType, int subtreeRootType) {
        return this.getNumberOfNodesOfTypeInSubtrees(nodeType, this.getNodesByType(subtreeRootType));
    }

    private int[] getNumberOfNodesOfTypeInSubtrees(int nodeType, Collection<IXQEQueryNode> roots) {
        if (roots == null) {
            return null;
        }
        int[] numberOfNodes = new int[roots.size()];
        boolean keepNulls = true;
        Collection nodes = this.getNodesCollectionByType(keepNulls, nodeType);
        int j = 0;
        for (IXQEQueryNode node : nodes) {
            if (node == null) continue;
            for (IXQEQueryNode root : roots) {
                if (root == null || !node.isAncestor(root)) continue;
                int n = j;
                numberOfNodes[n] = numberOfNodes[n] + 1;
                break;
            }
            ++j;
        }
        return numberOfNodes;
    }

    public IXQEQueryNode validateIndex(IXQEQueryNode node, XQETrace trace) {
        IXQEQueryNode invalidNode1 = this.validateNodesAreInIndex(node, trace);
        IXQEQueryNode invalidNode2 = this.validateNodesAreInTree(node, trace);
        if (invalidNode1 == null) {
            invalidNode1 = invalidNode2;
        }
        return invalidNode1;
    }

    private IXQEQueryNode validateNodesAreInIndex(IXQEQueryNode node, XQETrace trace) {
        IXQEQueryNode invalidNode = null;
        IXQEQueryNode[] children = node.getChildren();
        if (children != null) {
            for (IXQEQueryNode child : children) {
                invalidNode = this.validateNodesAreInIndex(child, trace);
            }
        }
        boolean hasKey = this.containsNodeById(node.getId());
        if (node.getParent() != null && !hasKey) {
            trace.beginElement("nodeInTreeNotInIndex", -1);
            trace.attribute(NODE_ID, node.getId());
            trace.endElement();
            invalidNode = node;
        }
        return invalidNode;
    }

    private IXQEQueryNode validateNodesAreInTree(IXQEQueryNode root, XQETrace trace) {
        IXQEQueryNode invalidNode = null;
        for (IXQEQueryNode node : this.getNodesById()) {
            if (node.isAncestor(root)) continue;
            trace.beginElement("nodeInIndexNotInTree", -1);
            trace.attribute(NODE_ID, node.getId());
            trace.endElement();
            invalidNode = node;
        }
        return invalidNode;
    }

    public boolean hasDescendantOfType(IXQEQueryNode node, int type, boolean includeSelf) {
        if (node == null) {
            return false;
        }
        if (includeSelf && node.getType() == type) {
            return true;
        }
        boolean keepNulls = true;
        Collection nodesForType = this.getNodesCollectionByType(keepNulls, type);
        if (nodesForType == null || nodesForType.size() == 0) {
            return false;
        }
        if (nodesForType.size() >= 50) {
            return node.getFirstDescendantOfTypeOrdered(type, includeSelf) != null;
        }
        for (IXQEQueryNode n : nodesForType) {
            if (n == null) continue;
            for (IXQEQueryNode parent = n.getParent(); parent != null; parent = parent.getParent()) {
                if (parent != node) continue;
                return true;
            }
        }
        return false;
    }
}

