/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEProperty;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTEQueryNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class XQEQueryNode
extends XQEBaseQueryNode {
    private static final String STRING_PROPERTY_KEY = "key";
    private static final String STRING_LINEAGE = "lineage";
    public static final String STRING_NULL = "null";
    protected Map<String, Object> mProperties = new HashMap<String, Object>();
    private Collection<IXQEQueryNode> mLineage = null;
    protected boolean mRootOfSubtree;

    protected XQEQueryNode() {
    }

    public void copyPropertiesTo(XQEQueryNode target) {
        for (Map.Entry<String, Object> entry : this.mProperties.entrySet()) {
            target.setPropertyValue(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public final Map<String, Object> getProperties() {
        return new HashMap<String, Object>(this.mProperties);
    }

    @Override
    public Object getPropertyValue(String key) {
        return this.mProperties.get(key);
    }

    @Override
    public final void removeProperty(String key) {
        boolean trace;
        XQETrace traceObj = this.getPlanningEnvironment().getTrace();
        if (traceObj != null && (trace = traceObj.isEnable(256))) {
            traceObj.beginElement("removeProperty", this.getId());
            traceObj.attribute(STRING_PROPERTY_KEY, key);
            traceObj.endElement();
        }
        this.mProperties.remove(key);
        this.setTreeHasBeenModified();
    }

    @Override
    public final Boolean getBooleanPropertyValue(String key) {
        Object value = this.mProperties.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return null;
    }

    public final Boolean getBooleanPropertyValue(String key, Boolean defaultValue) {
        Object value = this.mProperties.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    @Override
    public final Integer getIntegerPropertyValue(String key) {
        Object value = this.mProperties.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return null;
    }

    @Override
    public final Float getFloatPropertyValue(String key) {
        Object value = this.mProperties.get(key);
        if (value instanceof Float) {
            return (Float)value;
        }
        return null;
    }

    @Override
    public final Double getDoublePropertyValue(String key) {
        Object value = this.mProperties.get(key);
        if (value instanceof Double) {
            return (Double)value;
        }
        return null;
    }

    @Override
    public String getPropertyValueAsXML(String propertyName) {
        return null;
    }

    public final void setProperties(HashMap<String, Object> map) {
        this.mProperties.putAll(map);
    }

    @Override
    public void setPropertyValue(String key, Object value) {
        boolean trace;
        XQETrace traceObj;
        if (this.getPlanningEnvironment() != null && (traceObj = this.getPlanningEnvironment().getTrace()) != null && (trace = traceObj.isEnable(256))) {
            traceObj.beginElement("setPropertyValue", this.getId());
            traceObj.attribute(STRING_PROPERTY_KEY, key);
            if (value != null) {
                traceObj.attribute("value", value);
            }
            traceObj.endElement();
        }
        this.mProperties.put(key, value);
        this.setTreeHasBeenModified();
    }

    @Override
    public void dumpProperties(XQETrace trace) {
        Object value;
        Set<String> keySet = this.getProperties().keySet();
        ArrayList<String> keysSortedList = new ArrayList<String>(keySet);
        Collections.sort(keysSortedList);
        for (String key : keysSortedList) {
            value = this.getPropertyValue(key);
            if (value instanceof IXQEProperty) continue;
            if (value instanceof String[] && ((String[])value).length != 0) {
                List<String> arrayValues = Arrays.asList((String[])value);
                trace.attribute(key, arrayValues.toString());
                continue;
            }
            if (value instanceof Set && ((Set)value).size() != 0 && ((Set)value).iterator().next() instanceof Comparable) {
                Object[] array = ((Set)value).toArray();
                List<Object> arrayValues = Arrays.asList(array);
                Collections.sort(arrayValues);
                trace.attribute(key, value.toString());
                continue;
            }
            if (value != null) {
                trace.attribute(key, value.toString());
                continue;
            }
            trace.attribute(key, STRING_NULL);
        }
        for (String key : keysSortedList) {
            value = this.getPropertyValue(key);
            if (!(value instanceof IXQEProperty) || (trace.getTraceLevel() & 0x40) == 0) continue;
            ((IXQEProperty)value).toXMLString(trace);
        }
    }

    private void createLineage() {
        this.mLineage = new LinkedHashSet<IXQEQueryNode>();
    }

    private void setLineage(IXQEQueryNode node) {
        if (!this.getPlanningEnvironment().getQueryLineageTrackingEnabled()) {
            return;
        }
        if (node == null) {
            String message = "Cannot set null lineage.";
            throw new RuntimeException(message);
        }
        if (this.mLineage == null) {
            this.createLineage();
        }
        this.mLineage.add(node);
    }

    @Override
    public void addLineage(Collection<IXQEQueryNode> lineage) {
        if (lineage == null) {
            return;
        }
        if (!this.getPlanningEnvironment().getQueryLineageTrackingEnabled()) {
            return;
        }
        if (this.mLineage == null) {
            this.createLineage();
        }
        this.mLineage.addAll(lineage);
    }

    @Override
    protected void copyLineageToNode(IXQEQueryNode target) {
        Collection<IXQEQueryNode> lineage = this.getLineage();
        if (lineage != null && target != null) {
            target.addLineage(lineage);
        }
    }

    @Override
    protected void setSubTreeLineage(Collection<IXQEQueryNode> lineage) {
        if (lineage != null && this.getLineage() == null) {
            this.addLineage(lineage);
            for (IXQEQueryNode child : this.getChildren()) {
                ((XQEBaseQueryNode)child).setSubTreeLineage(lineage);
            }
        }
    }

    @Override
    public void deleteLineage(boolean deleteChildLineage) {
        if (!this.getPlanningEnvironment().getQueryLineageTrackingEnabled()) {
            return;
        }
        if (this.mLineage != null) {
            this.mLineage.clear();
            if (deleteChildLineage) {
                this.mLineage = null;
            }
        }
        if (deleteChildLineage) {
            int numberChildren = this.getNumberChildren();
            for (int i = 0; i < numberChildren; ++i) {
                ((XQEBaseQueryNode)this.getChild(i)).deleteLineage(deleteChildLineage);
            }
        }
    }

    @Override
    public Collection<IXQEQueryNode> getLineage() {
        return this.mLineage;
    }

    @Override
    public void initializeLineage(QTEQueryNode target) {
        this.initializeLineage((IXQEQueryNode)target);
    }

    @Override
    public void initializeLineage(IXQEQueryNode source) {
        if (!this.getPlanningEnvironment().getQueryLineageTrackingEnabled()) {
            return;
        }
        source.setNodeId(this.getId());
        this.setLineage(source);
        IXQEQueryNode[] sourceChildren = this.getChildren();
        IXQEQueryNode[] targetChildren = source.getChildren();
        for (int i = 0; i < sourceChildren.length; ++i) {
            sourceChildren[i].initializeLineage(targetChildren[i]);
        }
    }

    protected void dumpNodeLineage(XQETrace trace) {
        if (this.getPlanningEnvironment() == null || !this.getPlanningEnvironment().getQueryLineageTrackingEnabled()) {
            return;
        }
        Collection<IXQEQueryNode> lineage = this.getLineage();
        if (lineage == null || lineage.size() == 0) {
            return;
        }
        Iterator<IXQEQueryNode> it = this.getLineage().iterator();
        StringBuilder buffer = new StringBuilder();
        while (it.hasNext()) {
            XQEBaseQueryNode node = (XQEBaseQueryNode)it.next();
            buffer.append(node.getId().toString());
            if (!it.hasNext()) continue;
            buffer.append(",");
        }
        trace.attribute(STRING_LINEAGE, buffer.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dumpLineage(XQETrace trace) {
        void var4_7;
        if (!this.getPlanningEnvironment().getQueryLineageTrackingEnabled()) {
            return;
        }
        Collection<IXQEQueryNode> lineage = this.getLineage();
        if (lineage != null && lineage.size() > 0) {
            trace.beginElement("node", -1);
            trace.attribute("id", this.getId());
            for (XQEBaseQueryNode xQEBaseQueryNode : this.getLineage()) {
                trace.beginElement(STRING_LINEAGE, -1);
                trace.attribute("id", xQEBaseQueryNode.getId());
                trace.endElement();
            }
            trace.endElement();
        }
        int numberChildren = this.getNumberChildren();
        boolean bl = false;
        while (var4_7 < numberChildren) {
            ((XQEBaseQueryNode)this.getChild((int)var4_7)).dumpLineage(trace);
            ++var4_7;
        }
    }

    @Override
    public void setAsRootOfSubtree(String name, String subTreeType) {
        this.setAsRootOfSubtree(name, subTreeType, 0);
    }

    @Override
    public void setAsRootOfSubtree(String name, String subTreeType, int leafNodeDelimiter) {
        if (this.mRootOfSubtree) {
            return;
        }
        XQETrace traceObj = this.getPlanningEnvironment().getTrace();
        traceObj.beginElement(256, "markSubTree", this.getId());
        if (name != null) {
            traceObj.attribute(256, "name", name);
        }
        if (subTreeType != null) {
            traceObj.attribute(256, "subTreeType", subTreeType);
        }
        if (leafNodeDelimiter != 0) {
            traceObj.attribute(256, "leafNodeType", leafNodeDelimiter);
        }
        traceObj.endElement(256);
        this.mRootOfSubtree = true;
    }

    @Override
    public void removeSubtreeDefinition() {
        if (!this.mRootOfSubtree) {
            return;
        }
        XQETrace traceObj = this.getPlanningEnvironment().getTrace();
        boolean trace = traceObj.isEnable(256);
        if (trace) {
            traceObj.beginElement("removeSubTree", this.getId());
            traceObj.endElement();
        }
        this.mRootOfSubtree = false;
    }

    @Override
    public boolean getIsRootOfSubtree() {
        return this.mRootOfSubtree;
    }

    @Override
    public void copyContentTo(IXQENodeFactory nodeFactory, IXQEQueryNode target) {
        super.copyContentTo(nodeFactory, target);
        if (!this.mProperties.isEmpty()) {
            ((XQEQueryNode)target).mProperties.putAll(this.mProperties);
            ((XQEQueryNode)target).setTreeHasBeenModified();
        }
    }

    @Override
    public void resolveValueOfQueryNodeProperties(Map<IXQEQueryNode, IXQEQueryNode> map) {
        super.resolveValueOfQueryNodeProperties(map);
        for (Map.Entry<String, Object> entry : this.mProperties.entrySet()) {
            IXQEQueryNode newNode;
            if (!(entry.getValue() instanceof IXQEQueryNode) || (newNode = map.get(entry.getValue())) == null) continue;
            entry.setValue(newNode);
        }
    }

    @Override
    public void dump(XQETrace trace, boolean includeRuntimeSpecifics) {
        Integer nodeID = -1;
        if (includeRuntimeSpecifics) {
            nodeID = this.getId();
        }
        trace.beginElement(this.getNodeTypeName(), nodeID);
        this.dumpNodeLineage(trace);
        this.dumpProperties(trace);
        this.dumpExtraInfo(trace, includeRuntimeSpecifics);
        int numberChildren = this.getNumberChildren();
        for (int i = 0; i < numberChildren; ++i) {
            this.getChild(i).dump(trace, includeRuntimeSpecifics);
        }
        trace.endElement();
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        if (this.getProperties().size() > 0) {
            TreeMap<String, Object> omap = new TreeMap<String, Object>();
            omap.putAll(this.getProperties());
            for (Map.Entry entry : omap.entrySet()) {
                if (!this.isSimpleType(ctx, entry.getValue())) continue;
                this.persistAttributeProperty(ctx, (String)entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        if (this.getProperties().size() > 0) {
            for (Map.Entry<String, Object> entry : this.getProperties().entrySet()) {
                if (entry.getValue() == null || this.isSimpleType(ctx, entry.getValue())) continue;
                this.persistElementProperty(ctx, entry.getKey(), entry.getValue());
            }
        }
    }

    protected boolean isSimpleType(XQEPersistContext ctx, Object value) {
        return ctx.isSimpleType(value);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        Object value = ctx.attributeValue(att);
        this.setPropertyValue(att.getName(), value);
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname != null) {
            Object value = ctx.elementValue(node);
            this.setPropertyValue(pname, value);
        }
    }
}

