/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.checksum.AbstractCheckSum;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.olap.decoration.INestable;
import com.cognos.xqe.runtree.olap.decoration.OLAPDecorationRuleCheckSum;
import com.cognos.xqe.runtree.olap.decoration.XOLAPEdgeDecoration;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class XQEQueryNodeCheckSum
extends AbstractCheckSum {
    private List<ResponseMessage> responseMessages = new ArrayList<ResponseMessage>();

    public void compute(IXQEQueryNode queryNode) {
        int index;
        QueryNodeCheckSumElement checkSumNode = new QueryNodeCheckSumElement(queryNode);
        if (!queryNode.isQueryNode() && ((XNode)queryNode).isDecorationNode()) {
            List<INestable> nestables = ((XOLAPEdgeDecoration)queryNode).getNestablesForCheckSum();
            for (INestable nestable : nestables) {
                if (nestable == null) continue;
                OLAPDecorationRuleCheckSum ruleCheckSum = (OLAPDecorationRuleCheckSum)nestable.getCheckSum();
                checkSumNode.setRuleCheckSum(ruleCheckSum);
            }
        }
        if ((index = this.checkSumElements.indexOf(checkSumNode)) != -1) {
            checkSumNode = (QueryNodeCheckSumElement)this.checkSumElements.get(index);
        } else {
            this.checkSumElements.add(checkSumNode);
        }
        checkSumNode.incrementOccurs();
        queryNode.computeCheckSum(this);
    }

    public void addResponseMessage(ResponseMessage responseMessage) {
        this.responseMessages.add(responseMessage);
    }

    @Override
    public String toString() {
        StringBuilder strBuffer = new StringBuilder();
        Collections.sort(this.checkSumElements);
        for (AbstractCheckSum.CheckSumElement element : this.checkSumElements) {
            strBuffer.append(element.toString());
        }
        Collections.sort(this.responseMessages);
        for (ResponseMessage message : this.responseMessages) {
            strBuffer.append(ResponseMessage.severityLevelToString(message.getSeverity()));
            strBuffer.append(message.getLocalizedMessage(Locale.US));
        }
        return strBuffer.toString();
    }

    @Override
    public void toXMLString(XMLWriter writer) {
        if (writer == null) {
            return;
        }
        writer.beginElement(this.checkSumName, -1);
        Collections.sort(this.checkSumElements);
        for (AbstractCheckSum.CheckSumElement element : this.checkSumElements) {
            element.toXMLString(writer);
        }
        Collections.sort(this.responseMessages);
        for (ResponseMessage message : this.responseMessages) {
            writer.beginElement(ResponseMessage.severityLevelToString(message.getSeverity()), 1);
            writer.data(message.getLocalizedMessage(Locale.US));
            writer.endElement();
        }
        writer.endElement();
    }

    private class QueryNodeCheckSumElement
    extends AbstractCheckSum.CheckSumElement {
        OLAPDecorationRuleCheckSum ruleCheckSum;

        QueryNodeCheckSumElement(IXQEQueryNode aQueryNode) {
            super(aQueryNode);
            this.ruleCheckSum = null;
        }

        @Override
        public void toXMLString(XMLWriter writer) {
            if (writer == null) {
                return;
            }
            writer.beginElement("nodeType", -1);
            writer.attribute("id", this.getTypeId().toString());
            writer.attribute("name", this.getCheckSummable().getClass().getSimpleName());
            for (Map.Entry entry : this.mPropertiesMap.entrySet()) {
                writer.attribute((String)entry.getKey(), (String)entry.getValue());
            }
            writer.attribute("occurs", this.getOccurs());
            if (this.getRuleCheckSum() != null) {
                this.getRuleCheckSum().toXMLString(writer);
            }
            writer.endElement();
        }

        @Override
        public String toString() {
            StringBuilder strBuffer = new StringBuilder();
            strBuffer.append(this.getTypeId());
            if (this.getRuleCheckSum() != null) {
                strBuffer.append(this.getRuleCheckSum().toString());
            }
            for (Map.Entry entry : this.mPropertiesMap.entrySet()) {
                strBuffer.append((String)entry.getKey());
                strBuffer.append((String)entry.getValue());
            }
            return strBuffer.toString();
        }

        public OLAPDecorationRuleCheckSum getRuleCheckSum() {
            return this.ruleCheckSum;
        }

        public void setRuleCheckSum(OLAPDecorationRuleCheckSum aRuleCheckSum) {
            this.ruleCheckSum = aRuleCheckSum;
        }
    }
}

