/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MFAbstractBTFunction;
import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TimestampWithTZValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.function.ArgumentList;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.date.AddHours;
import com.cognos.xqe.runtree.XDataContext;

public class MFAddHours
extends MFAbstractBTFunction {
    @Override
    IValue executeImpl(XDataContext theContext, MXFunction theFunctionNode) {
        int numArgs = theFunctionNode.getNumberChildren();
        if (numArgs != 2) {
            this.throwErrorNumberOfArguments(numArgs, 2);
        }
        String inputTimestamp = null;
        IValue firstArg = theFunctionNode.getParameter(theContext, 0);
        if (firstArg instanceof StringValue) {
            inputTimestamp = firstArg.toString();
        } else {
            this.throwErrorInvalidArgumentType(1, firstArg, "string");
        }
        int numOfHoursToAdd = 0;
        IValue secondArg = theFunctionNode.getParameter(theContext, 1);
        if (secondArg instanceof StringValue) {
            numOfHoursToAdd = theFunctionNode.getInteger((StringValue)secondArg);
        } else {
            this.throwErrorInvalidArgumentType(2, secondArg, "string");
        }
        AddHours func = new AddHours();
        TimestampWithTZValue inputDateTimeTZ = MFAddHours.createTimestampWithTZValueFromString(inputTimestamp);
        IntegerValue numOfHoursValue = DataValueFactory.createIntegerValue();
        numOfHoursValue.set(numOfHoursToAdd);
        TimestampWithTZValue outputDateTime = DataValueFactory.createTimestampWithTZValue();
        Value[] args = new Value[2];
        ArgumentList arguments = new ArgumentList();
        arguments.set(args);
        args[0] = inputDateTimeTZ;
        args[1] = numOfHoursValue;
        func.execute(theContext, (IParameterEvaluator)arguments, outputDateTime);
        StringValue resultValue = DataValueFactory.createStringValue();
        resultValue.set(outputDateTime.getStringWithNanoseconds());
        return resultValue;
    }

    @Override
    public String getFunctionName() {
        return "_add_hours";
    }
}

