/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MFAbstractFunction;
import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.bibushandler.content.ICMSessionIdentity;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.runtree.XDataContext;
import java.util.List;

public class MFCAMIDList
extends MFAbstractFunction {
    @Override
    IValue executeImpl(XDataContext theContext, MXFunction theFunctionNode) {
        int numArgs = theFunctionNode.getNumberChildren();
        String separator = ", ";
        if (numArgs >= 1) {
            IValue firstArg = theFunctionNode.getParameter(theContext, 0);
            if (firstArg instanceof StringValue) {
                separator = firstArg.toString();
            } else {
                this.throwErrorInvalidArgumentType(1, firstArg, "string");
            }
        }
        RequestEnvironment reqEnv = (RequestEnvironment)theContext.getEnvironment().getRequestEnvironment();
        List<ICMSessionIdentity> identities = ContentManager.getUserIdentitiesList(reqEnv);
        StringBuilder strBuf = new StringBuilder();
        for (ICMSessionIdentity cmIdentity : identities) {
            if (strBuf.length() > 0) {
                strBuf.append(separator);
            }
            strBuf.append(cmIdentity.getIdentity());
        }
        StringValue outputVal = DataValueFactory.createStringValue();
        outputVal.set(strBuf.toString());
        return outputVal;
    }

    @Override
    public String getFunctionName() {
        return "CAMIDList";
    }
}

