/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MFAbstractFunction;
import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.bibushandler.content.ICMSessionIdentity;
import com.cognos.xqe.data.types.ArrayType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.ArrayValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.runtree.XDataContext;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public class MFCAMIDListForType
extends MFAbstractFunction {
    @Override
    IValue executeImpl(XDataContext theContext, MXFunction theFunctionNode) {
        boolean numArgsRequired = true;
        int numArgs = theFunctionNode.getNumberChildren();
        String idType = null;
        if (numArgs == 1) {
            IValue firstArg = theFunctionNode.getParameter(theContext, 0);
            if (firstArg instanceof StringValue) {
                idType = firstArg.toString();
            } else {
                this.throwErrorInvalidArgumentType(1, firstArg, "string");
            }
        } else {
            this.throwErrorNumberOfArguments(numArgs, 1);
        }
        RequestEnvironment reqEnv = (RequestEnvironment)theContext.getEnvironment().getRequestEnvironment();
        TreeSet<String> idNames = new TreeSet<String>();
        List<ICMSessionIdentity> identities = ContentManager.getUserIdentitiesList(reqEnv);
        ArrayList<StringValue> resultArray = new ArrayList<StringValue>();
        for (ICMSessionIdentity cmIdentity : identities) {
            String typeName = cmIdentity.getType();
            if (!typeName.equals(idType) || idNames.contains(cmIdentity.getIdentity())) continue;
            idNames.add(cmIdentity.getIdentity());
            StringValue val = DataValueFactory.createStringValue();
            val.set(cmIdentity.getIdentity());
            resultArray.add(val);
        }
        ArrayType dType = DataTypeFactory.getArrayType(DataTypeFactory.getStringType(), resultArray.size());
        ArrayValue outputVal = DataValueFactory.createArrayValue(dType);
        StringValue[] x = new StringValue[]{};
        outputVal.set(resultArray.toArray(x));
        return outputVal;
    }

    @Override
    public String getFunctionName() {
        return "CAMIDListForType";
    }
}

