/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MFAbstractFunction;
import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.bibushandler.content.ICMSessionIdentity;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.runtree.XDataContext;
import java.util.List;
import java.util.TreeSet;

public class MFCSVIdentityNameList
extends MFAbstractFunction {
    @Override
    IValue executeImpl(XDataContext theContext, MXFunction theFunctionNode) {
        int numArgs = theFunctionNode.getNumberChildren();
        String separator = ", ";
        if (numArgs == 1) {
            IValue firstArg = theFunctionNode.getParameter(theContext, 0);
            if (firstArg instanceof StringValue) {
                separator = firstArg.toString();
            } else {
                this.throwErrorInvalidArgumentType(1, firstArg, "string");
            }
        }
        RequestEnvironment reqEnv = (RequestEnvironment)theContext.getEnvironment().getRequestEnvironment();
        TreeSet<Object> uniqueMappings = new TreeSet<Object>();
        List<ICMSessionIdentity> identities = ContentManager.getUserDefaultIdentityNames(reqEnv);
        for (ICMSessionIdentity cmIdentity : identities) {
            String defaultName = cmIdentity.getDefaultName();
            if (defaultName == null || defaultName.length() <= 0) continue;
            uniqueMappings.add(defaultName);
        }
        StringBuilder answerBuf = new StringBuilder();
        String singleQuote = "'";
        for (String string : uniqueMappings) {
            String escapedValue = string.replaceAll("'", "''");
            if (answerBuf.length() > 0) {
                answerBuf.append(separator);
            }
            answerBuf.append("'");
            answerBuf.append(escapedValue);
            answerBuf.append("'");
        }
        StringValue outputVal = DataValueFactory.createStringValue();
        outputVal.set(answerBuf.toString());
        return outputVal;
    }

    @Override
    public String getFunctionName() {
        return "CSVIdentityNameList";
    }
}

