/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MFAbstractFunction;
import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.data.types.ArrayType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.ArrayValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.XDataContext;
import java.util.ArrayList;

public class MFIndex
extends MFAbstractFunction {
    @Override
    IValue executeImpl(XDataContext theContext, MXFunction theFunctionNode) {
        IValue firstArg;
        IValue secondArg;
        int three = 3;
        int numArgs = theFunctionNode.getNumberChildren();
        if (numArgs != 2 && numArgs != 3) {
            this.throwErrorNumberOfArguments(numArgs, 2, 3);
        }
        if (!((secondArg = theFunctionNode.getParameter(theContext, 1)) instanceof StringValue)) {
            this.throwErrorInvalidArgumentType(2, secondArg, "string");
        }
        String substr = secondArg.toString();
        Integer position = null;
        if (numArgs == 3) {
            IValue thirdArg = theFunctionNode.getParameter(theContext, 2);
            if (!(thirdArg instanceof StringValue)) {
                this.throwErrorInvalidArgumentType(3, thirdArg, "string");
            }
            int pos = theFunctionNode.getInteger((StringValue)thirdArg);
            position = pos;
        }
        if ((firstArg = theFunctionNode.getParameter(theContext, 0)) instanceof ArrayValue) {
            ArrayValue inputArray = (ArrayValue)firstArg;
            Value[] inputValues = inputArray.getValues();
            ArrayList<StringValue> outValues = new ArrayList<StringValue>();
            for (Value v : inputValues) {
                StringValue outV = this.doIndex(v, substr, position);
                outValues.add(outV);
            }
            int outLen = outValues.size();
            ArrayType dType = DataTypeFactory.getArrayType(DataTypeFactory.getStringType(), outLen);
            ArrayValue outputArray = DataValueFactory.createArrayValue(dType);
            outputArray.set(outValues.toArray(new StringValue[outLen]));
            return outputArray;
        }
        return this.doIndex(firstArg, substr, position);
    }

    protected StringValue doIndex(IValue v, String substr, Integer position) {
        if (!(v instanceof StringValue)) {
            this.throwErrorInvalidArgumentType(1, v, "string");
        }
        String text = v.toString();
        StringValue outputVal = DataValueFactory.createStringValue();
        if (position == null) {
            int idx = text.indexOf(substr);
            outputVal.set(String.valueOf(idx));
        } else {
            int pos = position;
            int idx = text.indexOf(substr, pos);
            outputVal.set(String.valueOf(idx));
        }
        return outputVal;
    }

    @Override
    public String getFunctionName() {
        return "index";
    }
}

