/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MFAbstractFunction;
import com.cognos.xqe.ast.macro.MFPatternMatch;
import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.data.types.ArrayType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.ArrayValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.XDataContext;
import java.util.ArrayList;

public class MFSubstitute
extends MFAbstractFunction {
    @Override
    IValue executeImpl(XDataContext theContext, MXFunction theFunctionNode) {
        int numArgs = theFunctionNode.getNumberChildren();
        int requiredNumArgs = 3;
        if (numArgs == 3) {
            MFPatternMatch patternMatcher = new MFPatternMatch();
            String pattern = null;
            String replacement = null;
            IValue firstArg = theFunctionNode.getParameter(theContext, 0);
            if (firstArg instanceof StringValue) {
                pattern = firstArg.toString();
                patternMatcher.parsePattern(pattern);
            } else {
                this.throwErrorInvalidArgumentType(1, firstArg, "string");
            }
            IValue secondArg = theFunctionNode.getParameter(theContext, 1);
            if (secondArg instanceof StringValue) {
                replacement = secondArg.toString();
            } else {
                this.throwErrorInvalidArgumentType(2, secondArg, "string");
            }
            IValue thirdArg = theFunctionNode.getParameter(theContext, 2);
            if (thirdArg instanceof StringValue) {
                StringBuilder result = new StringBuilder();
                int[] offsets = new int[2];
                String targetStr = thirdArg.toString();
                boolean found = patternMatcher.getPatternOffsets(targetStr, offsets);
                if (found) {
                    int start = offsets[0];
                    int end = offsets[1];
                    if (start > 0) {
                        result.append(targetStr.substring(0, start));
                    }
                    result.append(replacement);
                    result.append(targetStr.substring(end));
                } else {
                    result.append(targetStr);
                }
                StringValue outputVal = DataValueFactory.createStringValue();
                outputVal.set(result.toString());
                return outputVal;
            }
            if (thirdArg instanceof ArrayValue) {
                Value[] arrayValue = ((ArrayValue)thirdArg).getValues();
                ArrayList<StringValue> resultArray = new ArrayList<StringValue>();
                int[] offsets = new int[2];
                for (Value value : arrayValue) {
                    String targetStr = value.toString();
                    StringBuilder resultStr = new StringBuilder();
                    boolean found = patternMatcher.getPatternOffsets(targetStr, offsets);
                    if (found) {
                        int start = offsets[0];
                        int end = offsets[1];
                        if (start > 0) {
                            resultStr.append(targetStr.substring(0, start));
                        }
                        resultStr.append(replacement);
                        resultStr.append(targetStr.substring(end));
                    } else {
                        resultStr.append(targetStr);
                    }
                    StringValue strVal = DataValueFactory.createStringValue();
                    strVal.set(resultStr.toString());
                    resultArray.add(strVal);
                }
                ArrayType dType = DataTypeFactory.getArrayType(DataTypeFactory.getStringType(), resultArray.size());
                ArrayValue outputArrayVal = DataValueFactory.createArrayValue(dType);
                StringValue[] x = new StringValue[]{};
                outputArrayVal.set(resultArray.toArray(x));
                return outputArrayVal;
            }
            this.throwErrorInvalidArgumentType(3, thirdArg, "array");
        } else {
            this.throwErrorNumberOfArguments(numArgs, 3);
        }
        return null;
    }

    @Override
    public String getFunctionName() {
        return "substitute";
    }
}

