/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MFAbstractFunction;
import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.ast.macro.MacroException;
import com.cognos.xqe.data.types.ArrayType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.ArrayValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.XDataContext;
import java.util.ArrayList;

public class MFSubstr
extends MFAbstractFunction {
    @Override
    IValue executeImpl(XDataContext theContext, MXFunction theFunctionNode) {
        IValue firstArg;
        int offset;
        IValue secondArg;
        int three = 3;
        int numArgs = theFunctionNode.getNumberChildren();
        if (numArgs != 2 && numArgs != 3) {
            this.throwErrorNumberOfArguments(numArgs, 2, 3);
        }
        if (!((secondArg = theFunctionNode.getParameter(theContext, 1)) instanceof StringValue)) {
            this.throwErrorInvalidArgumentType(2, secondArg, "string");
        }
        if ((offset = theFunctionNode.getInteger((StringValue)secondArg)) < 0 && offset != -1) {
            throw new MacroException("The second argument of function 'substr' must be larger or equal to -1.");
        }
        Integer len = null;
        if (numArgs == 3) {
            int length;
            IValue thirdArg = theFunctionNode.getParameter(theContext, 2);
            if (!(thirdArg instanceof StringValue)) {
                this.throwErrorInvalidArgumentType(3, thirdArg, "string");
            }
            if ((length = theFunctionNode.getInteger((StringValue)thirdArg)) < 0) {
                throw new MacroException("The third argument of function 'substr' must be a non-negative integer.");
            }
            len = length;
        }
        if ((firstArg = theFunctionNode.getParameter(theContext, 0)) instanceof ArrayValue) {
            ArrayValue inputArray = (ArrayValue)firstArg;
            Value[] inputValues = inputArray.getValues();
            ArrayList<StringValue> outValues = new ArrayList<StringValue>();
            for (Value v : inputValues) {
                StringValue outV = this.doSubstr(v, offset, len);
                outValues.add(outV);
            }
            int outLen = outValues.size();
            ArrayType dType = DataTypeFactory.getArrayType(DataTypeFactory.getStringType(), outLen);
            ArrayValue outputArray = DataValueFactory.createArrayValue(dType);
            outputArray.set(outValues.toArray(new StringValue[outLen]));
            return outputArray;
        }
        return this.doSubstr(firstArg, offset, len);
    }

    protected StringValue doSubstr(IValue v, int offset, Integer len) {
        if (!(v instanceof StringValue)) {
            this.throwErrorInvalidArgumentType(1, v, "string");
        }
        String text = v.toString();
        StringValue outputVal = DataValueFactory.createStringValue();
        if (offset == -1) {
            outputVal.set(text);
            return outputVal;
        }
        int beginIdx = offset;
        int endIdx = 0;
        endIdx = len == null ? text.length() : Math.min(beginIdx + len, text.length());
        if (beginIdx >= endIdx) {
            outputVal.set("");
            return outputVal;
        }
        String rt = text.substring(beginIdx, endIdx);
        outputVal.set(rt);
        return outputVal;
    }

    @Override
    public String getFunctionName() {
        return "substr";
    }
}

