/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro.uniqueName;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import java.util.ArrayList;
import java.util.List;

public class ItemReference {
    List<String> metadata = new ArrayList<String>();
    List<String> logical = new ArrayList<String>();
    List<String> physical = new ArrayList<String>();
    IN_PIECE currentPiece = IN_PIECE.in_metadata;
    boolean isSuspect = false;

    public boolean isSuspect() {
        return this.isSuspect;
    }

    public void setIsSuspect(boolean v) {
        this.isSuspect = v;
    }

    public void addPart(String p) {
        if (p.equals("->")) {
            if (this.currentPiece != IN_PIECE.in_metadata) {
                this.isSuspect = true;
            }
            this.currentPiece = IN_PIECE.in_logical;
        } else if (p.equals(":")) {
            if (this.currentPiece != IN_PIECE.in_logical) {
                this.isSuspect = true;
            }
            this.currentPiece = IN_PIECE.in_physical;
        } else {
            switch (this.currentPiece) {
                case in_metadata: {
                    this.metadata.add(p);
                    break;
                }
                case in_logical: {
                    this.logical.add(p);
                    break;
                }
                case in_physical: {
                    this.physical.add(p);
                    break;
                }
                default: {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid name part");
                }
            }
        }
    }

    public String toString(List<String> pieces) {
        String result = new String();
        for (int i = 0; i < pieces.size(); ++i) {
            if (i > 0) {
                result = result + ".";
            }
            result = result + pieces.get(i);
        }
        return result;
    }

    public String toString() {
        String result = this.toString(this.metadata);
        if (this.logical.size() > 0 || this.physical.size() > 0) {
            result = result + "->";
            result = result + this.toString(this.logical);
            if (this.physical.size() > 0) {
                result = result + ":";
                result = result + this.toString(this.physical);
            }
        }
        result = this.isSuspect ? result + "(bad)" : result + "(valid)";
        return result;
    }

    private static enum IN_PIECE {
        in_metadata(0),
        in_logical(1),
        in_physical(2);


        private IN_PIECE(int i) {
        }
    }
}

