/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro.uniqueName;

import com.cognos.xqe.ast.macro.MXIdentifierVisitor;
import com.cognos.xqe.ast.macro.MacroException;
import com.cognos.xqe.ast.macro.RebuildExpressionVisitor;
import com.cognos.xqe.ast.macro.parser.MACCopyAsIsChunk;
import com.cognos.xqe.ast.macro.parser.MACCopyAsIsPieces;
import com.cognos.xqe.ast.macro.parser.MACNamePart;
import com.cognos.xqe.ast.macro.parser.MACNameParts;
import com.cognos.xqe.ast.macro.parser.MACStart;
import com.cognos.xqe.ast.macro.parser.MacroParser;
import com.cognos.xqe.ast.macro.parser.MacroParserNodeSerializer;
import com.cognos.xqe.ast.macro.parser.Node;
import com.cognos.xqe.ast.macro.parser.ParseException;
import com.cognos.xqe.ast.macro.parser.SimpleNode;
import com.cognos.xqe.ast.macro.parser.Token;
import com.cognos.xqe.ast.macro.uniqueName.ItemReference;
import com.cognos.xqe.ast.util.BoundedStringReader;
import java.util.LinkedHashMap;
import java.util.List;

public class ItemScanner {
    public static final String PARSING_ERROR_MSG = "ItemScanner - a parsing error was encountered in the expression text.";

    public List<ItemReference> extract(String str) {
        MACStart n = this.parse(str);
        MXIdentifierVisitor identifierVisitor = new MXIdentifierVisitor(this);
        ((SimpleNode)n).jjtAccept(identifierVisitor, null);
        return identifierVisitor.getItems();
    }

    public List<ItemReference> extract(String str, MXIdentifierVisitor identifierVisitor) {
        MACStart n = this.parse(str);
        ((SimpleNode)n).jjtAccept(identifierVisitor, null);
        return identifierVisitor.getItems();
    }

    public String rebuild(String str) {
        MACStart n = this.parse(str);
        RebuildExpressionVisitor rebuilder = new RebuildExpressionVisitor(this);
        return rebuilder.getText(n);
    }

    public MACStart parse(String expression) {
        MACStart cleaned;
        MacroParser np = new MacroParser(new BoundedStringReader(""));
        np.ReInit(new BoundedStringReader(expression));
        np.token_source.SwitchTo(2);
        np.saveLexerState();
        MACStart n = null;
        try {
            n = (MACStart)np.Start();
        }
        catch (ParseException e) {
            throw new MacroException(PARSING_ERROR_MSG, (Throwable)e);
        }
        if (null != n && null != (cleaned = this.cleanBogusMACNameParts(n))) {
            n = cleaned;
        }
        return n;
    }

    private MACStart cleanBogusMACNameParts(MACStart rootNode) {
        LinkedHashMap<Integer, MACCopyAsIsPieces> bogusNamePartsReplacementMap = new LinkedHashMap<Integer, MACCopyAsIsPieces>();
        for (int childNodeIdx = 0; childNodeIdx < rootNode.jjtGetNumChildren(); ++childNodeIdx) {
            Node child = rootNode.jjtGetChild(childNodeIdx);
            if (!(child instanceof MACNameParts)) continue;
            MACNameParts namePartsNode = (MACNameParts)child;
            boolean namePartFound = false;
            for (int namePartsChildIdx = 0; !namePartFound && namePartsChildIdx < namePartsNode.jjtGetNumChildren(); ++namePartsChildIdx) {
                Node macNamePartsChild = namePartsNode.jjtGetChild(namePartsChildIdx);
                if (!(macNamePartsChild instanceof MACNamePart)) continue;
                namePartFound = true;
            }
            if (namePartFound) continue;
            MACCopyAsIsPieces replacementNode = new MACCopyAsIsPieces(8);
            MacroParserNodeSerializer macroParserNodeSerializer = new MacroParserNodeSerializer();
            String serializedValue = macroParserNodeSerializer.serializeNode(namePartsNode);
            replacementNode.setValue(serializedValue);
            MACCopyAsIsChunk convertedChunk = new MACCopyAsIsChunk(9);
            convertedChunk.myToken = new Token();
            convertedChunk.myToken.image = serializedValue;
            String leadingTokenText = namePartsNode.getLeadingTokenText();
            if (null != leadingTokenText && 0 < leadingTokenText.length()) {
                convertedChunk.myToken.specialToken = new Token();
                convertedChunk.myToken.specialToken.image = leadingTokenText;
            }
            replacementNode.jjtAddChild(convertedChunk, 0);
            bogusNamePartsReplacementMap.put(childNodeIdx, replacementNode);
        }
        MACStart cleanedRootNode = null;
        if (bogusNamePartsReplacementMap.size() > 0) {
            cleanedRootNode = new MACStart(16);
            for (int childNodeIdx = 0; childNodeIdx < rootNode.jjtGetNumChildren(); ++childNodeIdx) {
                Node childNode = (Node)bogusNamePartsReplacementMap.get(childNodeIdx);
                if (null == childNode) {
                    childNode = rootNode.jjtGetChild(childNodeIdx);
                }
                cleanedRootNode.jjtAddChild(childNode, cleanedRootNode.jjtGetNumChildren());
            }
        }
        return cleanedRootNode;
    }
}

