/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.olap.util.MDXOOMContext;
import com.cognos.xqe.ast.olap.util.MDXOOMInfo;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class BaseMember
extends AbstractMDXMember {
    private static final String PROP_IMEMBER = "member";
    private static final String PROP_ILEVEL = "level";
    public static final String PROP_V5_MEMBER_UNIQUE_NAME = "v5MemberUniqueName";

    public String getUniqueName() {
        String result = (String)this.getPropertyValue(PROP_V5_MEMBER_UNIQUE_NAME);
        if (result == null) {
            result = this.getExternalName();
        }
        return result;
    }

    public String getExternalName() {
        String externalName = (String)this.getPropertyValue("externalName");
        if (externalName == null && this.getMember() != null) {
            externalName = this.getMember().getUniqueName();
        }
        return externalName;
    }

    public void bindExternalName(String memberExternalName) {
        this.setPropertyValue("externalName", memberExternalName);
    }

    public void bindLogicalName(String logicalName) {
        this.setPropertyValue("logical", logicalName);
    }

    public IMember getMember() {
        return (IMember)this.getPropertyValue(PROP_IMEMBER);
    }

    public ILevel getLevel() {
        return (ILevel)this.getPropertyValue(PROP_ILEVEL);
    }

    public void bindLevel(ILevel level) {
        this.setPropertyValue(PROP_ILEVEL, level);
    }

    public void bind(IMember member) {
        this.setPropertyValue(PROP_IMEMBER, member);
        this.bindLevel(member.getLevel());
        this.bindExternalName(member.getUniqueName());
    }

    @Override
    public int getType() {
        return 1067;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("type", "qs:member");
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1067) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public IHierarchy getHierarchy() {
        IHierarchy hierarchy = null;
        ILevel level = this.getLevel();
        if (level != null) {
            hierarchy = level.getHierarchy();
        }
        return hierarchy;
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        buffer.append(this.getExternalName());
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("ci", -1);
        trace.attribute("type", "qs:member");
        trace.data(this.getExternalName());
        trace.endElement();
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        boolean status = false;
        if (this.getType() == node.getType() && this.getExternalName() != null && this.getExternalName().compareTo(((BaseMember)node).getExternalName()) == 0) {
            status = true;
        }
        return status;
    }

    @Override
    public int isValidPlannedQuery() {
        int status = this.getId();
        if (this.getNumberChildren() == 0) {
            if (this.getLevel() != null) {
                status = -1;
            } else if (this.getMember() != null && this.getMember().isMeasure()) {
                status = -1;
            }
        }
        return status;
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        MDXHierInfo hierInfo = new MDXHierInfo();
        hierInfo.appendProjectedHierarchy(this.getHierarchy());
        return hierInfo;
    }

    @Override
    protected MDXLevelInfo getLevelInfo(IHierarchy hierarchy) {
        MDXLevelInfo exprInfo = new MDXLevelInfo();
        if (hierarchy == null || this.getLevel().getHierarchy().equals(hierarchy)) {
            exprInfo.addProjectedHierarchy(this.getLevel());
        }
        return exprInfo;
    }

    @Override
    public void getReferencedHierarchies(Set<IHierarchy> hierarchies, Set<AbstractMDXNode> visited) {
        hierarchies.add(this.getHierarchy());
    }

    @Override
    public ILevel getLowestReferencedLevel(IHierarchy hierarchy) {
        if (this.getHierarchy().equals(hierarchy)) {
            return this.getLevel();
        }
        return null;
    }

    @Override
    public ILevel getHighestReferencedLevel(IHierarchy hierarchy) {
        if (this.getHierarchy() == hierarchy) {
            return this.getLevel();
        }
        return null;
    }

    @Override
    public String[] getSyntaxProperties() {
        return new String[]{"externalName"};
    }

    @Override
    public boolean couldResolveToEmptyMember() {
        return false;
    }

    public boolean isMeasure() {
        return this.getHierarchy() != null && this.getHierarchy().getDimension() != null && this.getHierarchy().getDimension().isMeasuresDimension();
    }

    public boolean isRootMember() {
        IMember rootMun = this.getHierarchy().getRootMember();
        return rootMun != null && rootMun.getUniqueName().equals(this.getUniqueName());
    }

    public AggregateTypeEnum getMeasureAggregateRuleForGivenSet(MDXHierInfo hierInfo) {
        if (this.getMember() == null) {
            this.throwInternalError("Cannot get the aggrgate type, non-measure members are not usually bound to the actual member");
        }
        AggregateTypeEnum regularAggregate = this.getMember().getRegularAggregate();
        AggregateTypeEnum semiAggregate = this.getMember().getSemiAggregate();
        boolean isSemiAggregateRequired = hierInfo.projectsTimeDimension();
        if (!isSemiAggregateRequired && DataSourceTypeEnum.isSAPBW(this.getHierarchy().getDimension().getCube().getModelDataSource().getInterface())) {
            IAggregateRule[] aggRules;
            List<IHierarchy> projectedHierarchies = hierInfo.getProjectedHierarchies();
            block0: for (IAggregateRule aggRule : aggRules = this.getMember().getAggregateRules()) {
                String dimRef = aggRule.getDimensionRef();
                for (IHierarchy hierarchy : projectedHierarchies) {
                    if (!hierarchy.getDimension().getV5UniqueName().equals(dimRef)) continue;
                    isSemiAggregateRequired = true;
                    semiAggregate = aggRule.getAggregate();
                    continue block0;
                }
            }
            if (!isSemiAggregateRequired) {
                isSemiAggregateRequired = true;
            }
        }
        if (isSemiAggregateRequired && semiAggregate != AggregateTypeEnum.NONE && semiAggregate != AggregateTypeEnum.UNSUPPORTED) {
            return semiAggregate;
        }
        return regularAggregate;
    }

    public MDXSummaryFunctionTypeEnum getSummaryFunctionType(MDXHierInfo hierInfo) {
        AggregateTypeEnum aggregate = this.getMeasureAggregateRuleForGivenSet(hierInfo);
        return MDXSummaryFunctionTypeEnum.getSummaryFunctionType(aggregate);
    }

    @Override
    public void copyContentTo(IXQENodeFactory nodeFactory, IXQEQueryNode node) {
        super.copyContentTo(nodeFactory, node);
        BaseMember newMember = (BaseMember)node;
        for (String key : this.getProperties().keySet()) {
            if (key.startsWith("replacementsFor")) {
                newMember.removeProperty(key);
                continue;
            }
            if (!key.startsWith("recordReplacementsFor")) continue;
            newMember.removeProperty(key);
        }
        this.addReplacementMemberForTransf(newMember);
    }

    @Override
    public MDXOOMInfo computeOOM(MDXOOMContext context) {
        return MDXOOMInfo.oneMemberFromLevel(this.getLevel());
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(PROP_IMEMBER)) {
            Object value = ctx.attributeValue(att);
            this.bind((IMember)value);
        } else if (!attname.equals(PROP_ILEVEL)) {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }
}

