/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSetOperator;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import java.util.List;
import java.util.Set;

public final class BaseSet
extends AbstractMDXSetOperator {
    private static final String PROP_IHIERARCHY = "hierarchy";
    private static final String PROP_LEVEL_INFO = "levelInfo";

    @Override
    public int getType() {
        return 1148;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1148) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public IHierarchy getHierarchy() {
        return (IHierarchy)this.getPropertyValue(PROP_IHIERARCHY);
    }

    public void bindHierarchy(IHierarchy hierarchy) {
        this.setPropertyValue(PROP_IHIERARCHY, hierarchy);
    }

    public String getExternalName() {
        return (String)this.getPropertyValue("externalName");
    }

    public void bindExternalName(String memberExternalName) {
        this.setPropertyValue("externalName", memberExternalName);
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        IDataSourceCapabilities capabilities;
        MDXQuery mdxQuery = (MDXQuery)this.getAncestorOfType(1002);
        String dataSourceType = mdxQuery.getDataSourceType();
        if (dataSourceType.equals("TMR") && (capabilities = mdxQuery.getCapabilities()) != null && !capabilities.getBooleanValue("v5.useLocalOLAP", Boolean.FALSE)) {
            buffer.append("TM1SubsetToSet(");
            buffer.append(this.getHierarchy().getUniqueName());
            buffer.append(", '");
            try {
                buffer.append(UniqueNameParser.parseLastIdentifier(this.getExternalName()));
            }
            catch (UniqueNameParserException e) {
                throw new XQERuntimeException(e);
            }
            buffer.append("')");
            return;
        }
        buffer.append(this.getExternalName());
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("apply", -1);
        trace.beginElement("namedSet", -1);
        trace.endElement();
        trace.beginElement("cn", -1);
        trace.attribute("type", "xsd:string");
        trace.data(this.getExternalName());
        trace.endElement();
        trace.endElement();
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        MDXHierInfo hierInfo = new MDXHierInfo();
        hierInfo.appendProjectedHierarchy(this.getHierarchy());
        return hierInfo;
    }

    @Override
    protected MDXLevelInfo getLevelInfo(IHierarchy hierarchy) {
        MDXLevelInfo levelInfo = (MDXLevelInfo)this.getPropertyValue(PROP_LEVEL_INFO);
        if (levelInfo == null) {
            this.throwInternalError("");
        }
        if (hierarchy == null || levelInfo.getHierarchyInfo().projectsHierarchy(hierarchy)) {
            MDXLevelInfo newLevelInfo = new MDXLevelInfo();
            newLevelInfo.appendProjectedHierarchies(levelInfo);
            return newLevelInfo;
        }
        return new MDXLevelInfo();
    }

    public void setLevelInfo(List<ILevel> levels) {
        if (this.getHierarchy() == null) {
            this.throwInternalError("");
        }
        MDXLevelInfo levelInfo = new MDXLevelInfo();
        if (levels != null && !levels.isEmpty()) {
            levelInfo.addProjectedLevels(levels);
        } else {
            levelInfo.addProjectedHierarchyNoLevels(this.getHierarchy());
        }
        this.setPropertyValue(PROP_LEVEL_INFO, levelInfo);
    }

    @Override
    public void getReferencedHierarchies(Set<IHierarchy> hierarchies, Set<AbstractMDXNode> visited) {
        hierarchies.add(this.getHierarchy());
    }

    @Override
    public boolean projectsNonCalculatedMember() {
        return true;
    }

    @Override
    public boolean projectsDuplicates() {
        return false;
    }

    @Override
    public boolean isHierarchized() {
        return true;
    }

    @Override
    public ILevel getLowestReferencedLevel(IHierarchy hierarchy) {
        return this.getLevelInfo(hierarchy).getLowestProjectedLevel(hierarchy);
    }

    @Override
    public ILevel getHighestReferencedLevel(IHierarchy hierarchy) {
        return this.getLevelInfo(hierarchy).getHighestProjectedLevel(hierarchy);
    }

    @Override
    public boolean couldResolveToEmptySet(boolean ignoreTags, boolean ignoreRaggedUnbalanced, boolean ignoreNonEmpty) {
        return this.couldResolveToEmptySetForProvider(ignoreNonEmpty);
    }

    @Override
    public boolean projectsOnlyAscendantsOrDescendantsOfCurrentMember(boolean ignoreCalculatedMembers) {
        return false;
    }

    @Override
    public boolean projectsOnlyExplicitMembers(IHierarchy hierarchy) {
        return true;
    }

    @Override
    public boolean projectsOnlyCalculatedMembers(IHierarchy hierarchy) {
        return false;
    }

    @Override
    public int isValidPlannedQuery() {
        int status = this.getId();
        if (this.getHierarchy() != null && this.getExternalName() != null && this.getNumberChildren() == 0) {
            status = -1;
        }
        return status;
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        if (this.getType() != node.getType()) {
            return false;
        }
        return this.getExternalName() != null && this.getExternalName().equals(((BaseSet)node).getExternalName());
    }
}

