/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXValueExpression;
import com.cognos.xqe.ast.olap.BaseProperty;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQueryItemOfHierarchy;
import com.cognos.xqe.metadata.IQueryItemOfLevel;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.Iterator;
import java.util.Set;

public class CogMDXProperties
extends AbstractMDXValueExpression {
    public static final String PROP_BOOLEAN_ESSBASE_PROPERTY_FORMAT = "essbasePropertyFormat";
    public static final String PROP_BOOLEAN_WRITE_YK_PROPERTY_KEYWORD = "writeYKPropertyKeyword";
    public static final String CAPABILITIES_USE_LOLAP = "v5.useLocalOLAP";
    private static final String PROP_BOOLEAN_CONTEXT_DONE = "contextDone";

    public CogMDXProperties() {
        this.setPropertyValue(PROP_BOOLEAN_ESSBASE_PROPERTY_FORMAT, Boolean.FALSE);
        this.setPropertyValue(PROP_BOOLEAN_WRITE_YK_PROPERTY_KEYWORD, Boolean.FALSE);
    }

    @Override
    public boolean isUseEssbasePropertyFormat() {
        return Boolean.TRUE.equals(this.getPropertyValue(PROP_BOOLEAN_ESSBASE_PROPERTY_FORMAT));
    }

    public boolean isWriteYKTypedKeyWord() {
        return Boolean.TRUE.equals(this.getPropertyValue(PROP_BOOLEAN_WRITE_YK_PROPERTY_KEYWORD));
    }

    @Override
    public void setUseEssbasePropertyFormat(boolean essbasePropertyFormat) {
        this.setPropertyValue(PROP_BOOLEAN_ESSBASE_PROPERTY_FORMAT, essbasePropertyFormat);
    }

    public void setWriteYKTypedKeyWord(boolean beYKDTPropertyFormat) {
        this.setPropertyValue(PROP_BOOLEAN_WRITE_YK_PROPERTY_KEYWORD, beYKDTPropertyFormat);
    }

    @Override
    public int getType() {
        return 1016;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1016) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        if (this.isUseEssbasePropertyFormat() && this.isBooleanProperty()) {
            this.writeFormattedBooleanPropertyText(buffer);
        } else {
            this.getChild(1).writeFormattedText(buffer);
            buffer.append(".");
            if (this.isUseEssbasePropertyFormat()) {
                MDXQuery mdxQuery = (MDXQuery)this.getAncestorOfType(1002);
                boolean isLOLAP = mdxQuery.getUseLocalQueryProcessing();
                String name = ((BaseProperty)this.getChild(0)).getMDXName();
                if (name.equalsIgnoreCase("LEVEL_NUMBER") || name.equalsIgnoreCase("GEN_NUMBER")) {
                    if (isLOLAP && !mdxQuery.getForceRemoteQueryProcessing()) {
                        this.writeFormattedCommonPropertyText(buffer);
                    } else {
                        buffer.append(name);
                    }
                } else if (name.equalsIgnoreCase("MEMBER_NAME")) {
                    if (isLOLAP && !mdxQuery.getForceRemoteQueryProcessing()) {
                        buffer.append("PROPERTIES");
                        buffer.append("(");
                        buffer.append("\"");
                        buffer.append(name);
                        buffer.append("\"");
                        buffer.append(")");
                    } else {
                        buffer.append("[");
                        buffer.append(name);
                        buffer.append("]");
                    }
                } else if (name.equalsIgnoreCase("DESCRIPTION")) {
                    name = "COMMENTS";
                    buffer.append("[");
                    buffer.append(name);
                    buffer.append("]");
                } else if (name.equalsIgnoreCase("MEMBER_CAPTION")) {
                    name = "MEMBER_NAME";
                    if (isLOLAP && !mdxQuery.getForceRemoteQueryProcessing()) {
                        name = "MEMBER_CAPTION";
                        buffer.append("PROPERTIES");
                        buffer.append("(");
                        buffer.append("\"");
                        buffer.append(name);
                        buffer.append("\"");
                        buffer.append(")");
                    } else {
                        buffer.append(name);
                    }
                } else {
                    buffer.append("[");
                    buffer.append(name);
                    buffer.append("]");
                }
            } else if (this.isWriteYKTypedKeyWord()) {
                buffer.append("PROPERTIES");
                buffer.append("(");
                buffer.append("\"");
                buffer.append(((BaseProperty)this.getChild(0)).getMDXName());
                buffer.append("\"");
                buffer.append(",TYPED");
                buffer.append(")");
            } else {
                this.writeFormattedCommonPropertyText(buffer);
            }
        }
    }

    public void writeFormattedBooleanPropertyText(StringBuilder buffer) {
        if (this.isUseEssbasePropertyFormat() && this.isBooleanProperty()) {
            buffer.append("IIF");
            buffer.append("(");
            this.getChild(1).writeFormattedText(buffer);
            buffer.append(".");
            buffer.append("[");
            buffer.append(((BaseProperty)this.getChild(0)).getMDXName());
            buffer.append("]");
            buffer.append(", ");
            buffer.append(XQEIntegerPool.getInteger(1));
            buffer.append(", ");
            buffer.append(XQEIntegerPool.getInteger(0));
            buffer.append(")");
        }
    }

    public void writeFormattedCommonPropertyText(StringBuilder buffer) {
        buffer.append("PROPERTIES");
        buffer.append("(");
        buffer.append("\"");
        buffer.append(((BaseProperty)this.getChild(0)).getMDXName());
        buffer.append("\"");
        buffer.append(")");
    }

    @Override
    public int getMinimumNumberChildren() {
        return 2;
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        int[] categories = null;
        switch (index) {
            case 0: {
                categories = new int[]{1025};
                break;
            }
            case 1: {
                categories = new int[]{1022, 1021};
                break;
            }
            default: {
                categories = new int[]{};
            }
        }
        return categories;
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("apply", -1);
        trace.beginElement("propertyValue", -1);
        trace.endElement();
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            childIterator.next().dumpFormattedXMLQuery(trace);
        }
        trace.endElement();
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXNode)this.getChild(1)).getHierarchyInfo();
    }

    @Override
    protected MDXLevelInfo getLevelInfo(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXNode)this.getChild(1)).getLevelInfo(hierarchy);
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    public IHierarchy getHierarchy() {
        return ((AbstractMDXNode)this.getChild(1)).getHierarchyInfo().getProjectedHierarchy(0);
    }

    @Override
    public Set<MDXHierInfo> getContextDependentValueExpressionHierarchyInfo(AbstractMDXNode contextBoundary) {
        this.throwOnInvalidChildCategories();
        Set<MDXHierInfo> result = super.getContextDependentValueExpressionHierarchyInfo(contextBoundary);
        MDXHierInfo childHierInfo = ((AbstractMDXNode)this.getChild(1)).getHierarchyInfo();
        result.add(childHierInfo);
        return result;
    }

    @Override
    public boolean isBoolean() {
        return this.isBooleanProperty();
    }

    @Override
    public boolean isDateTime() {
        return this.isDateProperty() || this.isDateTimeProperty();
    }

    @Override
    public boolean isNumeric() {
        return this.isNumericProperty();
    }

    @Override
    public boolean isString() {
        return this.isStringProperty();
    }

    public boolean isStringProperty() {
        boolean bString = false;
        IDataType dType = this.getPropertyDataType();
        if (dType != null && dType.isTextType()) {
            bString = true;
        } else if (dType == null) {
            bString = true;
        }
        return bString;
    }

    public boolean isBooleanProperty() {
        IQueryItemOfHierarchy property;
        boolean bBoolean = false;
        BaseProperty prop = (BaseProperty)this.getChild(0);
        IQueryItem metaData = prop.getPropertyMetadata();
        if (metaData instanceof IQueryItemOfLevel) {
            IQueryItemOfLevel property2 = (IQueryItemOfLevel)metaData;
            if (property2.isBoolean()) {
                bBoolean = true;
            }
        } else if (metaData instanceof IQueryItemOfHierarchy && (property = (IQueryItemOfHierarchy)metaData).isBoolean()) {
            bBoolean = true;
        }
        return bBoolean;
    }

    public boolean isNumericProperty() {
        boolean bNumeric = false;
        IDataType dType = this.getPropertyDataType();
        if (dType != null && (dType.isInteger() || dType.isNumeric())) {
            bNumeric = true;
        }
        return bNumeric;
    }

    public boolean isDateTimeProperty() {
        boolean bDateTime = false;
        IDataType dType = this.getPropertyDataType();
        if (dType != null && dType.isTimestamp()) {
            bDateTime = true;
        }
        return bDateTime;
    }

    public boolean isDateProperty() {
        boolean bDate = false;
        IDataType dType = this.getPropertyDataType();
        if (dType != null && dType.isDate()) {
            bDate = true;
        }
        return bDate;
    }

    private IDataType getPropertyDataType() {
        return ((BaseProperty)this.getChild(0)).getDataType();
    }

    public boolean isContextDone() {
        return Boolean.TRUE.equals(this.getPropertyValue(PROP_BOOLEAN_CONTEXT_DONE));
    }

    public void setContextDone(boolean contextDone) {
        this.setPropertyValue(PROP_BOOLEAN_CONTEXT_DONE, contextDone);
    }
}

