/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueExpression;
import com.cognos.xqe.ast.olap.CogMDXAggregate;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.List;

public class CogMDXScalarFunction
extends AbstractMDXNumericValueExpression {
    protected static final String PROPERTY_FUNCTION_TYPE = "functionType";
    protected static final String PROPERTY_FUNCTION_NAME = "functionName";
    protected static final String PROPERTY_FUNCTION_MDX = "functionMDX";
    public static final int ABS = 1;
    public static final int ROUND = 2;
    public static final int ROUNDDOWN = 3;
    public static final int SQRT = 4;
    public static final int POWER = 5;
    public static final int ROUNDUP = 6;
    public static final int EXP = 7;
    public static final int LN = 8;
    public static final int ARCTAN = 9;
    public static final int ARCCOS = 10;
    public static final int ARCSIN = 11;
    public static final int TANHYP = 12;
    public static final int COSHYP = 13;
    public static final int SINHYP = 14;
    public static final int TAN = 15;
    public static final int COS = 16;
    public static final int SIN = 17;
    public static final int LOG10 = 18;
    public static final int FLOOR = 19;
    public static final int CEILING = 20;

    @Override
    public int getType() {
        return 1144;
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        if (this.getType() == node.getType() && this.getOperatorType() == ((CogMDXScalarFunction)node).getOperatorType()) {
            return super.isSameExpression(node, compareCalcDefiniton);
        }
        return false;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1144) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public int getOperatorType() {
        return (Integer)this.getPropertyValue(PROPERTY_FUNCTION_TYPE);
    }

    public void setOperatorType(int type) {
        this.setPropertyValue(PROPERTY_FUNCTION_TYPE, XQEIntegerPool.getInteger(type));
        switch (type) {
            case 1: {
                this.setOperatorMDX("ABS");
                break;
            }
            case 2: {
                this.setOperatorMDX("ROUND");
                break;
            }
            case 3: {
                this.setOperatorMDX("ROUNDDOWN");
                break;
            }
            case 4: {
                this.setOperatorMDX("SQRT");
                break;
            }
            case 5: {
                this.setOperatorMDX("POWER");
                break;
            }
            case 6: {
                this.setOperatorMDX("ROUNDUP");
                break;
            }
            case 7: {
                this.setOperatorMDX("EXP");
                break;
            }
            case 8: {
                this.setOperatorMDX("LN");
                break;
            }
            case 9: {
                this.setOperatorMDX("ARCTAN");
                break;
            }
            case 10: {
                this.setOperatorMDX("ARCCOS");
                break;
            }
            case 11: {
                this.setOperatorMDX("ARCSIN");
                break;
            }
            case 12: {
                this.setOperatorMDX("TANHYP");
                break;
            }
            case 13: {
                this.setOperatorMDX("COSHYP");
                break;
            }
            case 14: {
                this.setOperatorMDX("SINHYP");
                break;
            }
            case 15: {
                this.setOperatorMDX("TAN");
                break;
            }
            case 16: {
                this.setOperatorMDX("COS");
                break;
            }
            case 17: {
                this.setOperatorMDX("SIN");
                break;
            }
            case 18: {
                this.setOperatorMDX("LOG10");
                break;
            }
            case 19: {
                this.setOperatorMDX("FLOOR");
                break;
            }
            case 20: {
                this.setOperatorMDX("CEIL");
                break;
            }
        }
    }

    public void setOperatorMDX(String mdx) {
        this.setPropertyValue(PROPERTY_FUNCTION_MDX, mdx);
    }

    private String getMDXString() {
        return (String)this.getPropertyValue(PROPERTY_FUNCTION_MDX);
    }

    @Override
    public String getMDXTextName() {
        return this.getMDXString();
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        int[] categories = null;
        int operatorType = this.getOperatorType();
        switch (operatorType) {
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                if (index != 0) break;
                categories = new int[]{1062};
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                if (index != 0 && index != 1) break;
                categories = new int[]{1062};
                break;
            }
        }
        if (categories != null) {
            return categories;
        }
        return new int[0];
    }

    @Override
    public int getMinimumNumberChildren() {
        switch (this.getOperatorType()) {
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return 1;
            }
            case 2: 
            case 5: {
                return 2;
            }
        }
        return Integer.MAX_VALUE;
    }

    public String getOperatorTypeString() {
        String operatorTypeString = null;
        int operatorType = this.getOperatorType();
        switch (operatorType) {
            case 1: {
                operatorTypeString = "abs";
                break;
            }
            case 2: {
                operatorTypeString = "round";
                break;
            }
            case 3: {
                operatorTypeString = "roundDown";
                break;
            }
            case 4: {
                operatorTypeString = "sqrt";
                break;
            }
            case 5: {
                operatorTypeString = "power";
                break;
            }
            case 6: {
                operatorTypeString = "roundUp";
                break;
            }
            case 7: {
                operatorTypeString = "exp";
                break;
            }
            case 8: {
                operatorTypeString = "ln";
                break;
            }
            case 9: {
                operatorTypeString = "arctan";
                break;
            }
            case 10: {
                operatorTypeString = "arccos";
                break;
            }
            case 11: {
                operatorTypeString = "arcsin";
                break;
            }
            case 12: {
                operatorTypeString = "tanhyp";
                break;
            }
            case 13: {
                operatorTypeString = "coshyp";
                break;
            }
            case 14: {
                operatorTypeString = "sinhyp";
                break;
            }
            case 15: {
                operatorTypeString = "tan";
                break;
            }
            case 16: {
                operatorTypeString = "cos";
                break;
            }
            case 17: {
                operatorTypeString = "sin";
                break;
            }
            case 18: {
                operatorTypeString = "log10";
                break;
            }
            case 19: {
                operatorTypeString = "floor";
                break;
            }
            case 20: {
                operatorTypeString = "ceiling";
                break;
            }
        }
        return operatorTypeString;
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("apply", -1);
        trace.beginElement(this.getOperatorTypeString(), -1);
        trace.endElement();
        int numberChildren = this.getNumberChildren();
        for (int i = 0; i < numberChildren; ++i) {
            this.getChild(i).dumpFormattedXMLQuery(trace);
        }
        trace.endElement();
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        buffer.append("(");
        buffer.append(this.getMDXTextName());
        buffer.append("(");
        this.getChild(0).writeFormattedText(buffer);
        int numberChildren = this.getNumberChildren();
        for (int i = 1; i < numberChildren; ++i) {
            buffer.append(", ");
            this.getChild(i).writeFormattedText(buffer);
        }
        buffer.append(")");
        buffer.append(")");
    }

    @Override
    public AbstractMDXNumericValueExpression distributeCogMDXAggregate(CogMDXAggregate cogMDXAggregate, int aggrSolveOrder, List<AbstractMDXMember> contextMembers, IXQENodeFactory nodeFactory) {
        AbstractMDXNumericValueExpression newNumValExpr = null;
        IXQEQueryNode newOp1 = this.getChild(0);
        if (this.getChild(0).getType() != 1089) {
            newOp1 = ((AbstractMDXNumericValueExpression)this.getChild(0)).distributeCogMDXAggregate(cogMDXAggregate, aggrSolveOrder, contextMembers, nodeFactory);
        }
        IXQEQueryNode newOp2 = null;
        if (this.getMinimumNumberChildren() == 2) {
            newOp2 = this.getChild(1);
            if (this.getChild(1).getType() != 1089) {
                newOp2 = ((AbstractMDXNumericValueExpression)this.getChild(1)).distributeCogMDXAggregate(cogMDXAggregate, aggrSolveOrder, contextMembers, nodeFactory);
            }
        }
        if (newOp1 != this.getChild(0) || newOp2 != null && newOp2 != this.getChild(1)) {
            newNumValExpr = (AbstractMDXNumericValueExpression)nodeFactory.deepCopyNode(this);
            newNumValExpr.exchangeChildNode(newNumValExpr.getChild(0), newOp1);
            if (this.getMinimumNumberChildren() == 2) {
                if (newOp2.getParent() != null) {
                    newOp2 = nodeFactory.deepCopyNode(newOp2);
                }
                newNumValExpr.exchangeChildNode(newNumValExpr.getChild(1), newOp2);
            }
        } else {
            newNumValExpr = this;
        }
        return newNumValExpr;
    }
}

