/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfoCache;
import com.cognos.xqe.ast.olap.util.OLAPMDXUtils;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MDXCalculatedMemberDefinition
extends AbstractMDXNode {
    public static final String STR_FORMAT_STRING = "FORMAT_STRING";
    public static final String PROP_CUSTOM_SOLVE_ORDER = "solveOrder";
    public static final String BOOL_ABSOLUTE_SOLVE_ORDER = "isAbsoluteSolveOrder";
    public static final String PROP_CUSTOM_UNIQUE_NAME = "member";
    public static final String PROP_CUSTOM_V5_CAPTION = "v5Caption";
    public static final String PROP_CUSTOM_V5_NAME = "v5Name";
    public static final String PROP_CUSTOM_V5_PARSED_NODEID = "v5ParsedNodeId";
    public static final String PROP_BOOLEAN_NESTED_LEVEL_CALC = "nestedLevelCalc";
    public static final String PROP_CUSTOM_PREFIX = "prefix";
    protected static final String PROP_HIERARCHY = "hierarchy";
    protected static final String PROP_PLANNER_HIERARCHY = "isPlannerHierarchy";
    protected static final String PROP_USER_HIERARCHY = "isUserHierarchy";
    public static final String PROP_BOOLEAN_IS_TAG = "isTag";
    public static final String PROP_BOOLEAN_IS_FILLER_TAG = "isFillerTag";
    public static final String PROP_BOOLEAN_USE_COMMA_IN_SOLVE_ORDER = "useCommaInSolveOrder";
    private static final String PROPERTY_FILLER_TAG_CONTEXT = "fillerTagContext";
    private static final String PROPERTY_ADJUST_CONTEXT = "adjustByContext";
    public static final String PROP_CALC_MEMBER_REFS = "calcMemberRefs";
    public static final String PROP_LEVEL = "level";
    public static final String PROP_INTERSECTS_WITH_SEVERAL_CALCS = "IntersectsWithSeveralCalcs";
    public static final String PROP_IS_NONDETAIL_GROUPBODY = "isNonDetailGroupBody";

    public MDXCalculatedMemberDefinition() {
        this.setPropertyValue(PROP_CUSTOM_SOLVE_ORDER, XQEIntegerPool.getInteger(0));
        this.setPropertyValue(PROP_BOOLEAN_USE_COMMA_IN_SOLVE_ORDER, Boolean.TRUE);
        this.setPropertyValue(PROP_CALC_MEMBER_REFS, new ArrayList());
    }

    @Override
    public int getType() {
        return 1005;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1005) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public void generateUniqueName() {
        MDXQuery mdQuery = (MDXQuery)this.getAncestorOfType(1002);
        IHierarchy hierarchy = this.getHierarchy();
        if (mdQuery == null || hierarchy == null || this.getPrefix() == null) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
        }
        String uniqueName = mdQuery.createCalculatedMemberUniqueName(hierarchy, this.getPrefix());
        this.setCustomUniqueName(uniqueName);
    }

    public String getUniqueName() {
        return this.getCustomUniqueName();
    }

    public String getExternalName() {
        return (String)this.getPropertyValue("externalName");
    }

    public void setPrefix(String prefix) {
        this.setPropertyValue(PROP_CUSTOM_PREFIX, prefix);
    }

    public String getPrefix() {
        return (String)this.getPropertyValue(PROP_CUSTOM_PREFIX);
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        IDataSourceCapabilities capabilities;
        buffer.append("MEMBER");
        buffer.append(" ");
        String externalName = this.getExternalName();
        if (externalName != null) {
            buffer.append(externalName);
        } else {
            buffer.append(this.getUniqueName());
        }
        boolean bUseQuote = false;
        boolean isTMRDirect = false;
        MDXQuery mdxQuery = (MDXQuery)this.getAncestorOfType(1002);
        if (mdxQuery != null && mdxQuery.getDataSourceType().equals("TMR") && (capabilities = mdxQuery.getCapabilities()) != null && !capabilities.getBooleanValue("v5.useLocalOLAP", Boolean.FALSE)) {
            isTMRDirect = true;
        }
        if (!isTMRDirect && mdxQuery != null && !mdxQuery.isYukonProvider()) {
            bUseQuote = true;
        }
        buffer.append(" ");
        buffer.append("AS");
        buffer.append(" ");
        if (bUseQuote) {
            buffer.append("'");
        }
        StringBuilder tmpBuffer = new StringBuilder();
        int numberChildren = this.getNumberChildren();
        for (int i = 0; i < numberChildren; ++i) {
            this.getChild(i).writeFormattedText(tmpBuffer);
        }
        if (bUseQuote) {
            String tmpStr = OLAPMDXUtils.escapeQuotes(tmpBuffer);
            buffer.append(tmpStr);
            buffer.append("'");
        } else {
            buffer.append((CharSequence)tmpBuffer);
        }
        if (this.getSolveOrder() != 0) {
            if (this.isUseCommaInSolveOrder()) {
                buffer.append(", ");
            } else {
                buffer.append(" ");
            }
            buffer.append("SOLVE_ORDER =");
            buffer.append(" ");
            buffer.append(this.getSolveOrder());
        }
        if (mdxQuery != null && this.getV5Caption() != null && this.getV5Caption().length() != 0) {
            String dataSourceType = mdxQuery.getDataSourceType();
            if (DataSourceTypeEnum.isPostMSAS2005(dataSourceType) || isTMRDirect) {
                if (this.isUseCommaInSolveOrder()) {
                    buffer.append(", ");
                } else {
                    buffer.append(" ");
                }
                buffer.append("CAPTION =");
                buffer.append(" ");
                buffer.append("'");
                buffer.append(OLAPMDXUtils.escapeQuotes(new StringBuilder(this.getV5Caption())));
                buffer.append("'");
            } else if (dataSourceType.equals("PC") || dataSourceType.equals("RO") || dataSourceType.equals("TM") || dataSourceType.equals("TMR") || dataSourceType.equals("EB") || dataSourceType.equals("BW")) {
                if (this.isUseCommaInSolveOrder()) {
                    buffer.append(", ");
                } else {
                    buffer.append(" ");
                }
                buffer.append("MEMBER_CAPTION =");
                buffer.append(" ");
                buffer.append("'");
                buffer.append(OLAPMDXUtils.escapeQuotes(new StringBuilder(this.getV5Caption())));
                buffer.append("'");
            }
        }
        String formatString = (String)this.getPropertyValue(STR_FORMAT_STRING);
        if (mdxQuery != null && mdxQuery.isYukonProvider() && formatString == null) {
            formatString = (String)this.getChild(0).getPropertyValue(STR_FORMAT_STRING);
        }
        if (formatString != null) {
            if (this.isUseCommaInSolveOrder()) {
                buffer.append(", ");
            } else {
                buffer.append(" ");
            }
            buffer.append("FORMAT_STRING =");
            buffer.append(" ");
            buffer.append("\"");
            buffer.append(formatString);
            buffer.append("\"");
        }
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("calculatedMember", -1);
        if (this.getSolveOrder() != 0) {
            trace.attribute(PROP_CUSTOM_SOLVE_ORDER, this.getSolveOrder());
        }
        trace.beginElement("ci", -1);
        trace.attribute("type", "qs:member");
        String externalName = this.getExternalName();
        if (externalName != null) {
            trace.data(externalName);
        } else {
            trace.data(this.getUniqueName());
        }
        trace.endElement();
        int numberChildren = this.getNumberChildren();
        for (int i = 0; i < numberChildren; ++i) {
            this.getChild(i).dumpFormattedXMLQuery(trace);
        }
        if (this.getV5Caption() != null && this.getV5Caption().length() != 0) {
            trace.beginElement("propertyDefinition", -1);
            trace.beginElement("ci", -1);
            trace.attribute("type", "qs:property");
            trace.data("memberCaption");
            trace.endElement();
            trace.beginElement("cn", -1);
            trace.attribute("type", "xsd:string");
            trace.data(this.getV5Caption());
            trace.endElement();
            trace.endElement();
        }
        trace.endElement();
    }

    @Override
    public int getMinimumNumberChildren() {
        return 1;
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        int[] categories = index == 0 ? new int[]{1061} : new int[]{};
        return categories;
    }

    public int getSolveOrder() {
        return (Integer)this.getPropertyValue(PROP_CUSTOM_SOLVE_ORDER);
    }

    public void setSolveOrder(int so) {
        if (!this.isAbsoluteSolveOrder().booleanValue()) {
            this.setPropertyValue(PROP_CUSTOM_SOLVE_ORDER, XQEIntegerPool.getInteger(so));
        }
    }

    public Boolean isAbsoluteSolveOrder() {
        if (Boolean.TRUE.equals(this.getBooleanPropertyValue(BOOL_ABSOLUTE_SOLVE_ORDER))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setAbsoluteSolveOrder(Boolean abs) {
        this.setPropertyValue(BOOL_ABSOLUTE_SOLVE_ORDER, abs);
    }

    public void setIsTag() {
        this.setPropertyValue(PROP_BOOLEAN_IS_TAG, Boolean.TRUE);
    }

    public boolean isTag() {
        return this.getPropertyValue(PROP_BOOLEAN_IS_TAG) == Boolean.TRUE;
    }

    public void setIsFillerTag() {
        this.setPropertyValue(PROP_BOOLEAN_IS_FILLER_TAG, Boolean.TRUE);
    }

    public boolean isFillerTag() {
        return this.getPropertyValue(PROP_BOOLEAN_IS_FILLER_TAG) == Boolean.TRUE;
    }

    public boolean isANSMore() {
        String v5Caption = this.getV5Caption();
        if ("More & hidden".equals(v5Caption) && this.getChildren().length == 1 && this.getChild(0).getType() == 1089) {
            List<MDXCalculatedMemberReference> refs = this.getCalcMemberRefs();
            for (MDXCalculatedMemberReference aRef : refs) {
                IXQEQueryNode currentEdge = aRef.getAncestorOfType(1006);
                if (currentEdge == null || !((MDXEdge)currentEdge).isProjectedDescendant(aRef)) continue;
                return true;
            }
        }
        return false;
    }

    public void setPlannerHierarchy(boolean value) {
        if (value) {
            this.removeProperty(PROP_PLANNER_HIERARCHY);
        } else {
            this.setPropertyValue(PROP_PLANNER_HIERARCHY, Boolean.FALSE);
        }
    }

    public boolean isPlannerHierarchy() {
        Object propValue = this.getPropertyValue(PROP_PLANNER_HIERARCHY);
        return propValue == null || propValue.equals(Boolean.TRUE);
    }

    public void setUserHierarchy(boolean value) {
        if (!value) {
            this.removeProperty(PROP_USER_HIERARCHY);
        } else {
            this.setPropertyValue(PROP_USER_HIERARCHY, Boolean.TRUE);
        }
    }

    public boolean isUserHierarchy() {
        Object propValue = this.getPropertyValue(PROP_USER_HIERARCHY);
        return propValue != null && propValue.equals(Boolean.TRUE);
    }

    public IHierarchy getHierarchy() {
        return (IHierarchy)this.getPropertyValue(PROP_HIERARCHY);
    }

    public void setHierarchy(IHierarchy hierarchy) {
        if (this.getHierarchy() != null) {
            this.setPropertyValue(PROP_HIERARCHY, hierarchy);
            this.generateUniqueName();
        } else {
            this.setPropertyValue(PROP_HIERARCHY, hierarchy);
        }
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        IHierarchy hierarchy = this.getHierarchy();
        if (hierarchy == null) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
        }
        MDXHierInfo hierInfo = new MDXHierInfo();
        hierInfo.appendProjectedHierarchy(hierarchy);
        return hierInfo;
    }

    @Override
    protected MDXLevelInfo getLevelInfo(IHierarchy hierarchy) {
        IHierarchy calcHierarchy = this.getHierarchy();
        if (calcHierarchy == null) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
        }
        if (hierarchy != null && !calcHierarchy.equals(hierarchy)) {
            return new MDXLevelInfo();
        }
        MDXLevelInfo exprInfo = new MDXLevelInfo();
        if (!calcHierarchy.isShell()) {
            if (calcHierarchy.getLevelCount() > 0) {
                ILevel level = (ILevel)this.getPropertyValue(PROP_LEVEL);
                if (level == null) {
                    level = calcHierarchy.getLevels().get(0);
                }
                boolean isCalc = true;
                if (Boolean.TRUE.equals(this.getPropertyValue("createdFromROLAPCalcMember"))) {
                    isCalc = false;
                }
                MDXLevelInfo mDXLevelInfo = exprInfo;
                mDXLevelInfo.getClass();
                exprInfo.addProjectedHierarchy(mDXLevelInfo.new MDXLevelInfo.LevelInfo(level, !isCalc, isCalc, false));
            } else {
                exprInfo.addProjectedHierarchyNoLevels(calcHierarchy);
            }
        }
        return exprInfo;
    }

    @Override
    public void getReferencedHierarchies(Set<IHierarchy> hierarchies, Set<AbstractMDXNode> visited) {
        if (!visited.add(this)) {
            return;
        }
        hierarchies.add(this.getHierarchy());
        super.getReferencedHierarchies(hierarchies, visited);
    }

    @Override
    public String[] getSyntaxProperties() {
        return new String[]{PROP_CUSTOM_SOLVE_ORDER, STR_FORMAT_STRING};
    }

    public void setIsNestedLevelCalc(boolean bool) {
        this.setPropertyValue(PROP_BOOLEAN_NESTED_LEVEL_CALC, bool);
    }

    public boolean isNestedLevelCalc() {
        return Boolean.TRUE.equals(this.getPropertyValue(PROP_BOOLEAN_NESTED_LEVEL_CALC));
    }

    public boolean isUseCommaInSolveOrder() {
        return Boolean.TRUE.equals(this.getPropertyValue(PROP_BOOLEAN_USE_COMMA_IN_SOLVE_ORDER));
    }

    public void setUseCommaInSolveOrder(boolean useCommaInSolveOrder) {
        this.setPropertyValue(PROP_BOOLEAN_USE_COMMA_IN_SOLVE_ORDER, useCommaInSolveOrder);
    }

    @Override
    protected MDXHierInfo getContextHierarchyInfoForChild(AbstractMDXNode child, AbstractMDXNode contextBoundary) {
        MDXQuery mdxQuery;
        if (!this.validateChildCategories() || !this.isParentOf(child)) {
            this.throwInternalError("Query could not be planned.");
        }
        if (this.getParent() == null && contextBoundary != null && this != contextBoundary) {
            this.throwInternalError("Query could not be planned.");
        }
        MDXHierInfo hierInfo = null;
        if (this.getParent() != null && this != contextBoundary && this.getParent().isOfCategory(1001)) {
            hierInfo = ((AbstractMDXNode)this.getParent()).getContextHierarchyInfoForChild(this, contextBoundary);
        }
        if (hierInfo == null) {
            hierInfo = new MDXHierInfo();
        }
        if ((mdxQuery = (MDXQuery)this.getAncestorOfType(1002)) != null && this != contextBoundary) {
            List<IXQEQueryNode> references = mdxQuery.getCalcMemberRefForDefinition(this);
            for (MDXCalculatedMemberReference mDXCalculatedMemberReference : references) {
                IXQEQueryNode parent = mDXCalculatedMemberReference.getParent();
                if (parent == null || !parent.isOfCategory(1001)) {
                    this.throwInternalError("Query could not be planned.");
                }
                MDXHierInfo calcHierInfo = ((AbstractMDXNode)parent).getContextHierarchyInfoForCalculatedMemberDefinition(mDXCalculatedMemberReference, mDXCalculatedMemberReference);
                for (IHierarchy hierarchy : calcHierInfo.getProjectedHierarchies()) {
                    if (hierarchy.equals(this.getHierarchy()) || hierInfo.projectsHierarchy(hierarchy)) continue;
                    hierInfo.appendProjectedHierarchy(hierarchy);
                }
            }
        }
        return hierInfo;
    }

    @Override
    protected MDXLevelInfo getContextLevelInfoForChild(AbstractMDXNode child, AbstractMDXNode contextBoundary, IHierarchy hierarchy) {
        if (!this.validateChildCategories() || !this.isParentOf(child)) {
            this.throwInternalError("Query could not be planned.");
        }
        if (this.getParent() == null && contextBoundary != null && this != contextBoundary) {
            this.throwInternalError("Query could not be planned.");
        }
        MDXQuery mdxQuery = (MDXQuery)this.getAncestorOfType(1002);
        MDXLevelInfoCache levelInfoCache = this.getLevelInfoCache();
        MDXLevelInfo levelInfo = mdxQuery != null && this == contextBoundary ? new MDXLevelInfo() : levelInfoCache.getCalcMemContextLevelInfoCache(this, hierarchy);
        if (levelInfo != null) {
            return levelInfo;
        }
        levelInfoCache.addCalcMemContextLevelInfoCache(this, hierarchy, null);
        levelInfoCache.addNestedCalculation(this, hierarchy);
        levelInfo = new MDXLevelInfo();
        if (mdxQuery != null) {
            List<IXQEQueryNode> references = mdxQuery.getCalcMemberRefForDefinition(this);
            for (MDXCalculatedMemberReference mDXCalculatedMemberReference : references) {
                IXQEQueryNode parent = mDXCalculatedMemberReference.getParent();
                if (parent == null || !parent.isOfCategory(1001)) {
                    this.throwInternalError("Query could not be planned.");
                }
                MDXLevelInfo calcLevelInfo = ((AbstractMDXNode)parent).getContextLevelInfoForCalculatedMemberDefinition(mDXCalculatedMemberReference, mDXCalculatedMemberReference, hierarchy);
                levelInfo.unionProjectedHierarchiesExceptCurrent(calcLevelInfo, this.getHierarchy());
            }
        }
        levelInfoCache.addCalcMemContextLevelInfoCache(this, hierarchy, levelInfo);
        levelInfoCache.removeNestedCalculation(this, hierarchy);
        return levelInfo;
    }

    @Override
    public boolean validateChildCategories() {
        IXQEQueryNode parent;
        return super.validateChildCategories() && ((parent = this.getParent()) == null || parent.getType() == 1002);
    }

    public boolean isAdjustedForIncompatibleNestingContext() {
        Boolean b = (Boolean)this.getPropertyValue(PROPERTY_ADJUST_CONTEXT);
        return b != null && b.equals(Boolean.TRUE);
    }

    public void setAdjustedForIncompatibleNestingContext(Boolean flag) {
        this.setPropertyValue(PROPERTY_ADJUST_CONTEXT, flag);
    }

    public void setV5Caption(String v5Caption) {
        this.setPropertyValue(PROP_CUSTOM_V5_CAPTION, v5Caption);
    }

    public String getV5Caption() {
        return (String)this.getPropertyValue(PROP_CUSTOM_V5_CAPTION);
    }

    public void setV5Name(String v5Name) {
        this.setPropertyValue(PROP_CUSTOM_V5_NAME, v5Name);
    }

    public String getV5Name() {
        return (String)this.getPropertyValue(PROP_CUSTOM_V5_NAME);
    }

    public Integer getV5ParsedNodeId() {
        return (Integer)this.getPropertyValue(PROP_CUSTOM_V5_PARSED_NODEID);
    }

    public void setV5ParsedNodeId(Integer v5ParsedNodeId) {
        this.setPropertyValue(PROP_CUSTOM_V5_PARSED_NODEID, v5ParsedNodeId);
    }

    public void addCalcMemberRef(MDXCalculatedMemberReference calcRef) {
        ((List)this.getPropertyValue(PROP_CALC_MEMBER_REFS)).add(calcRef);
        calcRef.getPlanningEnvironment().setTreeHasBeenModified();
    }

    public List<MDXCalculatedMemberReference> getCalcMemberRefs() {
        List calcRefs = (List)this.getPropertyValue(PROP_CALC_MEMBER_REFS);
        ArrayList<MDXCalculatedMemberReference> calcRefsInTree = new ArrayList<MDXCalculatedMemberReference>();
        for (MDXCalculatedMemberReference next : calcRefs) {
            if (next.getParent() == null || next.getNodeIndex().getNodeByID(next.getId()) == null && !this.inSameMDXQuery(next)) continue;
            calcRefsInTree.add(next);
        }
        return calcRefsInTree;
    }

    private boolean inSameMDXQuery(MDXCalculatedMemberReference next) {
        IXQEQueryNode mdxQueryThis = this.getAncestorOfType(1002);
        if (mdxQueryThis == null) {
            return false;
        }
        IXQEQueryNode mdxQueryRef = next.getAncestorOfType(1002);
        return mdxQueryThis == mdxQueryRef;
    }

    @Override
    public void copyContentTo(IXQENodeFactory nodeFactory, IXQEQueryNode node) {
        this.throwOnInvalidChildCategories();
        for (String key : this.getProperties().keySet()) {
            if (key == PROP_CALC_MEMBER_REFS) continue;
            Object value = this.getPropertyValue(key);
            node.setPropertyValue(key, value);
        }
    }

    public boolean isSlicerCalcIntersectingWithSeveralProjCalc() {
        Boolean prop = this.getBooleanPropertyValue(PROP_INTERSECTS_WITH_SEVERAL_CALCS);
        return prop != null && prop != false;
    }

    public void setLevel(ILevel level) {
        this.setPropertyValue(PROP_LEVEL, level);
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        if (this.getType() != node.getType()) {
            return false;
        }
        MDXCalculatedMemberDefinition defToCompare = (MDXCalculatedMemberDefinition)node;
        if (!compareCalcDefiniton || this == null) {
            return this == defToCompare;
        }
        if (!this.getV5Caption().equals(defToCompare.getV5Caption()) || !this.getV5Name().equals(defToCompare.getV5Name()) || this.getSolveOrder() != defToCompare.getSolveOrder()) {
            return false;
        }
        return this.getChild(0).isSameExpression(defToCompare.getChild(0), compareCalcDefiniton);
    }

    public boolean isNonDetailGroupBody() {
        Boolean prop = this.getBooleanPropertyValue(PROP_IS_NONDETAIL_GROUPBODY);
        return prop == Boolean.TRUE;
    }

    public void setNonDetailGroupBody(boolean value) {
        if (!value) {
            this.removeProperty(PROP_IS_NONDETAIL_GROUPBODY);
            return;
        }
        this.setPropertyValue(PROP_IS_NONDETAIL_GROUPBODY, Boolean.TRUE);
    }

    public String getCustomUniqueName() {
        return (String)this.getPropertyValue(PROP_CUSTOM_UNIQUE_NAME);
    }

    public void setCustomUniqueName(String uniqueName) {
        if (uniqueName == null) {
            this.removeProperty(PROP_CUSTOM_UNIQUE_NAME);
            return;
        }
        this.setPropertyValue(PROP_CUSTOM_UNIQUE_NAME, uniqueName);
    }
}

