/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXHierarchy;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.olap.util.MDXOOMContext;
import com.cognos.xqe.ast.olap.util.MDXOOMInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.trace.XQETrace;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class MDXCurrentMember
extends AbstractMDXMember {
    public static final String NL_CALC_REPLACEMENT = "nlcReplacement";
    public static final String ORIGINAL_MUN = "originalMUN";

    @Override
    public int getType() {
        return 1076;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1076) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        if (this.getNumberChildren() > 0) {
            this.getChild(0).writeFormattedText(buffer);
        }
        buffer.append(".");
        buffer.append("CURRENTMEMBER");
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("apply", -1);
        trace.beginElement("currentMember", -1);
        trace.endElement();
        if (this.getNumberChildren() > 0) {
            this.getChild(0).dumpFormattedXMLQuery(trace);
        }
        trace.endElement();
    }

    @Override
    public int getMinimumNumberChildren() {
        return 1;
    }

    @Override
    protected boolean isContextDependent(AbstractMDXNode contextBoundary) {
        if (this.getParent() != null && !this.getParent().isOfCategory(1001)) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
        }
        MDXHierInfo contextInfo = null;
        if (this.getParent() != null) {
            contextInfo = ((AbstractMDXNode)this.getParent()).getContextHierarchyInfoForChild(this, contextBoundary);
        }
        if (contextInfo != null) {
            MDXHierInfo hierInfo = this.getHierarchyInfo();
            if (hierInfo.getNumProjectedHierarchies() != 1) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
            }
            IHierarchy hierarchy = hierInfo.getProjectedHierarchy(0);
            if (contextInfo.projectsHierarchy(hierarchy)) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean isContextDependent(IHierarchy hierarchy, AbstractMDXNode contextBoundary) {
        this.throwOnInvalidChildCategories();
        if (((AbstractMDXHierarchy)this.getChild(0)).isContextDependent(hierarchy, contextBoundary)) {
            return true;
        }
        MDXHierInfo hierInfo = this.getHierarchyInfo();
        if (hierInfo.getNumProjectedHierarchies() != 1) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
        }
        if (hierInfo.getProjectedHierarchy(0).equals(hierarchy)) {
            MDXHierInfo contextInfo = null;
            if (this.getParent() != null) {
                contextInfo = ((AbstractMDXNode)this.getParent()).getContextHierarchyInfoForChild(this, contextBoundary);
            }
            if (contextInfo == null || !contextInfo.projectsHierarchy(hierarchy)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        int[] categories = null;
        categories = index == 0 ? new int[]{1072} : new int[]{};
        return categories;
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXHierarchy)this.getChild(0)).getHierarchyInfo();
    }

    @Override
    protected MDXLevelInfo getLevelInfo(IHierarchy hierarchy) {
        MDXLevelInfo contextInfo;
        this.throwOnInvalidChildCategories();
        MDXLevelInfo levelInfo = this.getLevelInfoCache().getLevelInfoCache(this, hierarchy);
        if (levelInfo != null) {
            return levelInfo;
        }
        MDXHierInfo hierInfo = this.getHierarchyInfo();
        if (hierInfo.getNumProjectedHierarchies() != 1) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
        }
        IHierarchy projHierarchy = hierInfo.getProjectedHierarchy(0);
        if (hierarchy != null && !projHierarchy.equals(hierarchy)) {
            return new MDXLevelInfo();
        }
        if (this.getParent() != null && this.getParent().isOfCategory(1001) && (contextInfo = ((AbstractMDXNode)this.getParent()).getContextLevelInfoForChild(this, null, projHierarchy)).getHierarchyInfo().getNumProjectedHierarchies() > 0 && contextInfo.getHierarchyInfo().projectsHierarchy(projHierarchy)) {
            levelInfo = new MDXLevelInfo();
            levelInfo.appendProjectedHierarchy(contextInfo, projHierarchy);
        }
        if (levelInfo == null) {
            levelInfo = ((AbstractMDXHierarchy)this.getChild(0)).getLevelInfo(hierarchy);
        }
        this.getLevelInfoCache().addLevelInfoCache(this, hierarchy, levelInfo);
        return levelInfo;
    }

    @Override
    public boolean isAscendantOrDescendantOfCurrentMember() {
        return true;
    }

    @Override
    protected void addMemberToContext(IXQENodeFactory factory, IHierarchy hierarchy, AbstractMDXMember member, boolean replaceUnresolvedCurrentMemberRefs, AbstractMDXNode contextBoundary) {
        MDXHierInfo hierInfo;
        super.addMemberToContext(factory, hierarchy, member, replaceUnresolvedCurrentMemberRefs, contextBoundary);
        if (replaceUnresolvedCurrentMemberRefs && (hierInfo = this.getHierarchyInfo()).getProjectedHierarchy(0).equals(hierarchy)) {
            if (this.getParent() != null) {
                if (!this.getParent().isOfCategory(1001)) {
                    throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
                }
                MDXHierInfo contextInfo = ((AbstractMDXNode)this.getParent()).getContextHierarchyInfoForChild(this, contextBoundary);
                if (contextInfo.projectsHierarchy(hierarchy)) {
                    return;
                }
                AbstractMDXMember memberCopy = (AbstractMDXMember)factory.deepCopyNode(member);
                this.getParent().exchangeChildNode(this, memberCopy, false);
                if (memberCopy.getType() == 1013) {
                    MDXCalculatedMemberReference calc = (MDXCalculatedMemberReference)memberCopy;
                    calc.setV5Caption(calc.getDefinition().getV5Caption());
                }
            } else {
                throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
            }
        }
    }

    @Override
    public ILevel getLowestReferencedLevel(IHierarchy hierarchy) {
        return this.getLevelInfo(hierarchy).getLowestProjectedLevel(hierarchy);
    }

    @Override
    public ILevel getHighestReferencedLevel(IHierarchy hierarchy) {
        return this.getLevelInfo(hierarchy).getHighestProjectedLevel(hierarchy);
    }

    @Override
    public boolean couldResolveToEmptyMember() {
        return false;
    }

    public boolean isNLCReplacement() {
        return this.getPropertyValue(NL_CALC_REPLACEMENT) == Boolean.TRUE;
    }

    public void setNLCReplacement(boolean nlcReplacement) {
        if (nlcReplacement) {
            this.setPropertyValue(NL_CALC_REPLACEMENT, Boolean.TRUE);
            return;
        }
        this.removeProperty(NL_CALC_REPLACEMENT);
    }

    public void setIsV5CalculatedMember(boolean value) {
        if (value) {
            this.setPropertyValue("isV5CalculatedMember", Boolean.TRUE);
            return;
        }
        this.removeProperty("isV5CalculatedMember");
    }

    public boolean isV5CalculatedMember() {
        return this.getPropertyValue("isV5CalculatedMember") == Boolean.TRUE;
    }

    public void setV5Caption(String v5Caption) {
        if (v5Caption != null && v5Caption.length() > 0) {
            this.setPropertyValue("v5Caption", v5Caption);
            return;
        }
        this.removeProperty("v5Caption");
    }

    public String getV5Caption() {
        return (String)this.getPropertyValue("v5Caption");
    }

    public void setV5Name(String v5Name) {
        if (v5Name != null && v5Name.length() > 0) {
            this.setPropertyValue("v5Name", v5Name);
            return;
        }
        this.removeProperty("v5Name");
    }

    public String getV5Name() {
        return (String)this.getPropertyValue("v5Name");
    }

    public void setOriginalMUN(String originalMUN) {
        if (originalMUN != null && originalMUN.length() > 0) {
            this.setPropertyValue(ORIGINAL_MUN, originalMUN);
            return;
        }
        this.removeProperty(ORIGINAL_MUN);
    }

    public String getOriginalMUN() {
        return (String)this.getPropertyValue(ORIGINAL_MUN);
    }

    @Override
    public MDXOOMInfo computeOOM(MDXOOMContext context) {
        HashMap<ILevel, Double> mp = new HashMap<ILevel, Double>();
        Map<ILevel, Double> mpContext = context.getCurrentContext();
        if (mpContext == null) {
            mp.put(this.getHierarchy().getLevel(0), 1.0);
        } else {
            IHierarchy cHier = null;
            Iterator<ILevel> iterator = mpContext.keySet().iterator();
            if (iterator.hasNext()) {
                ILevel l = iterator.next();
                cHier = l.getHierarchy();
            }
            if (!this.getHierarchy().equals(cHier)) {
                mp.put(this.getHierarchy().getLevel(0), 1.0);
            } else {
                double sum = 0.0;
                for (Map.Entry<ILevel, Double> e : mpContext.entrySet()) {
                    sum += e.getValue().doubleValue();
                }
                for (Map.Entry<ILevel, Double> e : mpContext.entrySet()) {
                    mp.put(e.getKey(), e.getValue() / sum);
                }
            }
        }
        return MDXOOMInfo.createOOMInfo(1.0, mp);
    }
}

