/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXDimensionProperties;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.olap.util.MDXOOMContext;
import com.cognos.xqe.ast.olap.util.MDXOOMInfo;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.decoration.exceptions_and_warnings.OLAPDecorationException;
import com.cognos.xqe.runtree.olap.edgemapping.XOLAPEdgeMapping;
import com.cognos.xqe.runtree.olap.edgemapping.actions.CrosstabSpacerDescriptor;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.CollectTreeNodesForCondition;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class MDXEdge
extends AbstractMDXNode {
    private static final String MDQUERY_AXIS_EDGEID_ATTRIBUTE = "edgeID";
    public static final String PROP_STRING_V5NAME = "V5Name";
    public static final String PROP_BOOLEAN_MDX_NON_EMPTY = "nonEmpty";
    public static final String PROP_BOOLEAN_PC_ZERO_SUPPRESS = "zeroSuppress";
    public static final String PROPERTY_XOLAPEDGEMAPPING = "xOLAPEdgeMapping";
    public static final String PROP_REPORT_HIERARCHIES = "reportHierarchies";
    public static final String PROP_REPORT_MEASURE = "reportMeasure";

    public MDXEdge() {
        this.setPropertyValue("dimensionProperties", new MDXDimensionProperties());
    }

    @Override
    public int getType() {
        return 1006;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1006) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public int getEdgeID() {
        Integer edgeID = (Integer)this.getPropertyValue(MDQUERY_AXIS_EDGEID_ATTRIBUTE);
        if (edgeID == null) {
            this.throwInternalError("Edge ID not set.");
        }
        return edgeID;
    }

    public void setEdgeID(int value) {
        this.setPropertyValue(MDQUERY_AXIS_EDGEID_ATTRIBUTE, XQEIntegerPool.getInteger(value));
    }

    public void setEdgeID(String value) {
        int intValue = 0;
        if (value != null) {
            intValue = Integer.parseInt(value);
        }
        this.setEdgeID(intValue);
    }

    public void setMDXNonEmptyProperty(boolean value) {
        if (value) {
            this.setPropertyValue(PROP_BOOLEAN_MDX_NON_EMPTY, Boolean.TRUE);
        } else {
            this.removeProperty(PROP_BOOLEAN_MDX_NON_EMPTY);
        }
        if (this.getXOLAPEdgeMapping() != null) {
            this.getXOLAPEdgeMapping().setEdgeHasMDXNonEmpty(value);
        }
    }

    public boolean getMDXNonEmptyProperty() {
        return this.getPropertyValue(PROP_BOOLEAN_MDX_NON_EMPTY) == Boolean.TRUE;
    }

    public void setPowerCubeZeroSuppress(boolean value) {
        if (value) {
            this.setPropertyValue(PROP_BOOLEAN_PC_ZERO_SUPPRESS, Boolean.TRUE);
        } else {
            this.removeProperty(PROP_BOOLEAN_PC_ZERO_SUPPRESS);
        }
    }

    public boolean getPowerCubeZeroSuppress() {
        return this.getPropertyValue(PROP_BOOLEAN_PC_ZERO_SUPPRESS) == Boolean.TRUE;
    }

    public boolean applyExcludeEmptyHeadSuppression() {
        MDXQuery mdxQuery = (MDXQuery)this.getParent();
        if (!(this.getMDXNonEmptyProperty() && mdxQuery.isListReport() && mdxQuery.isDMR())) {
            return false;
        }
        ICube cube = mdxQuery.getMDXFrom().getCube();
        return ((CubeWrapper)cube).containsNonDefaultMeasure();
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        MDXQuery mdxQuery;
        trace.beginElement("edge", -1);
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            childIterator.next().dumpFormattedXMLQuery(trace);
        }
        this.getDimensionProperties().dumpFormattedXMLQuery(trace);
        if (this.getPowerCubeZeroSuppress()) {
            trace.beginElement("suppress", -1);
            trace.beginElement("suppressZeros", -1);
            trace.endElement();
            trace.endElement();
        }
        if (this.getMDXNonEmptyProperty()) {
            trace.beginElement("suppress", -1);
            trace.beginElement("suppressNulls", -1);
            trace.endElement();
            trace.endElement();
        } else if (!this.getPowerCubeZeroSuppress() && "none".equalsIgnoreCase((mdxQuery = (MDXQuery)this.getParent()).getSuppressNullsQueryHint())) {
            trace.beginElement("suppress", -1);
            trace.beginElement("suppressNone", -1);
            trace.endElement();
            trace.endElement();
        }
        trace.endElement();
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        if (this.getMDXNonEmptyProperty()) {
            buffer.append("NON EMPTY");
            buffer.append(" ");
        } else {
            MDXQuery mdxQuery = (MDXQuery)this.getParent();
            if ("none".equalsIgnoreCase(mdxQuery.getSuppressNullsQueryHint()) && (DataSourceTypeEnum.isTM1(mdxQuery.getDataSourceType()) || DataSourceTypeEnum.isPowerCube(mdxQuery.getDataSourceType()))) {
                buffer.append(" /* SUPPRESS NONE */ ");
            }
        }
        this.getChild(0).writeFormattedText(buffer);
        this.getDimensionProperties().writeFormattedText(buffer);
        buffer.append(" ");
        buffer.append("ON AXIS");
        buffer.append("(");
        buffer.append(this.getMDXAxisNumber());
        buffer.append(")");
    }

    private int getMDXAxisNumber() {
        int axisNumber = -1;
        IXQEQueryNode parent = this.getParent();
        if (parent != null) {
            IXQEQueryNode[] children = parent.getChildrenOfTypeOrdered(this.getType());
            for (int idx = 0; idx < children.length && axisNumber == -1; ++idx) {
                if (children[idx] != this) continue;
                axisNumber = idx;
            }
        }
        if (axisNumber == -1) {
            axisNumber = 0;
        }
        return axisNumber;
    }

    @Override
    public int getMinimumNumberChildren() {
        return 0;
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        int[] categories = index == 0 ? new int[]{1021} : new int[]{};
        return categories;
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        if (this.getNumberChildren() == 0) {
            return new MDXHierInfo();
        }
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXSet)this.getChild(0)).getHierarchyInfo();
    }

    @Override
    public MDXLevelInfo getLevelInfo(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXSet)this.getChild(0)).getLevelInfo(hierarchy);
    }

    public MDXDimensionProperties getDimensionProperties() {
        return (MDXDimensionProperties)this.getPropertyValue("dimensionProperties");
    }

    public void addMemberProperty(String memberProperty) {
        this.getPlanningEnvironment().setTreeHasBeenModified();
        this.getDimensionProperties().addMemberProperty(memberProperty);
    }

    public void addCustomMemberProperty(IQueryItem queryItemProperty) {
        this.getPlanningEnvironment().setTreeHasBeenModified();
        this.getDimensionProperties().addCustomMemberProperty(queryItemProperty);
    }

    public boolean hasMemberProperty(String memberProperty) {
        return this.getDimensionProperties().containsMemberProperty(memberProperty);
    }

    public void replaceMemberProperty(String oldMemberProperty, String newMemberProperty) {
        this.removeMemberProperty(oldMemberProperty);
        this.addMemberProperty(newMemberProperty);
    }

    public void removeMemberProperty(String memberProperty) {
        this.getPlanningEnvironment().setTreeHasBeenModified();
        this.getDimensionProperties().removeMemberProperty(memberProperty);
    }

    @Override
    public boolean isProjectedDescendant(AbstractMDXNode node) {
        this.throwOnInvalidChildCategories();
        if (this.getNumberChildren() == 0) {
            return false;
        }
        return ((AbstractMDXSet)this.getChild(0)).isProjectedDescendant(node);
    }

    @Override
    public void isProjectedDescendant(Collection<IXQEQueryNode> nodes, Collection<IXQEQueryNode> returnNodes) {
        this.throwOnInvalidChildCategories();
        if (this.getNumberChildren() > 0) {
            ((AbstractMDXNode)this.getChild(0)).isProjectedDescendant(nodes, returnNodes);
        }
    }

    public void getProjectedReference(Collection<IXQEQueryNode> calcRefs, MDXCalculatedMemberDefinition mdxCalculatedMemberDefinition) {
        CollectTreeNodesForCondition.getProjectedReferenceForDefinition(calcRefs, this, mdxCalculatedMemberDefinition);
    }

    @Override
    public boolean validateChildCategories() {
        IXQEQueryNode parent;
        return super.validateChildCategories() && ((parent = this.getParent()) == null || parent.getType() == 1002);
    }

    public boolean areIntersectingProjDescendants(AbstractMDXNode node1, AbstractMDXNode node2) {
        this.throwOnInvalidChildCategories();
        if (this.getNumberChildren() == 0) {
            return false;
        }
        return ((AbstractMDXSet)this.getChild(0)).areIntersectingProjDescendants(node1, node2);
    }

    @Override
    public String[] getSyntaxProperties() {
        return new String[]{"dimensionProperties", PROP_BOOLEAN_MDX_NON_EMPTY, PROP_BOOLEAN_PC_ZERO_SUPPRESS};
    }

    public boolean useNLDecorationRules(PlanningEnvironment planningEnvironment) {
        MDXQuery mdxQuery = (MDXQuery)this.getAncestorOfType(1002);
        ICube cube = mdxQuery.getMDXFrom().getCube();
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)planningEnvironment.getExecutionEnvironment();
        String aUseNLDecorationRules = executionEnvironment.applyNestedLevelDecorationRules(cube);
        boolean useNLDecorationRules = false;
        if (aUseNLDecorationRules == null) {
            useNLDecorationRules = false;
        } else if (aUseNLDecorationRules.equals("never")) {
            useNLDecorationRules = false;
        } else if (aUseNLDecorationRules.equals("always")) {
            useNLDecorationRules = true;
        } else if (aUseNLDecorationRules.equals("automatic")) {
            useNLDecorationRules = this.getMDXNonEmptyProperty() || this.isNonEmptyFriendlyMDXOn();
        } else {
            throw new OLAPDecorationException(XQEMessageKeys.DEC_InternalError_INTERNAL, "aUseNLDecorationRules = ?");
        }
        return useNLDecorationRules;
    }

    public boolean isSafeToApplyNonEmpty() {
        IXQEQueryNode[] calcRefs;
        if (!this.validateChildCategories()) {
            this.throwInternalError("!mdxEdge.validateChildCategories()");
        }
        if (this.getPropertyValue("raggedCompensationApplied") != null || this.getPropertyValue("ubCompensationApplied") != null) {
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)this.getAncestorOfType(1002);
        MDXEdge[] mdxEdges = mdxQuery.getEdges();
        if (mdxEdges.length == 1) {
            return true;
        }
        int edgeWithChildrenCount = mdxQuery.getNumberOfEdgesWithChildren();
        if (edgeWithChildrenCount == 1) {
            return true;
        }
        for (IXQEQueryNode currCalRef1 : calcRefs = this.getDescendantsOfType(1013, false)) {
            MDXCalculatedMemberReference mdxCalcRef1 = (MDXCalculatedMemberReference)currCalRef1;
            if (!mdxCalcRef1.getDefinition().isFillerTag() || !mdxCalcRef1.getHierarchy().getDimension().isMeasuresDimension() || !this.isProjectedDescendant(mdxCalcRef1)) continue;
            return false;
        }
        return true;
    }

    public boolean isNonEmptyFriendlyMDXOn() {
        MDXQuery mdxQuery = (MDXQuery)this.getParent();
        if (DataSourceTypeEnum.isTM1(mdxQuery.getDataSourceType()) && MultiRequestContext.RequestProcessing.DATABASEONLY == mdxQuery.getRequestProcessing()) {
            return false;
        }
        String value = mdxQuery.getCapabilities().getStringValue("mdx.generateNonEmptyFriendlyMDX", "forNonEmpty");
        if (value.equals("always")) {
            return true;
        }
        return value.equals("forNonEmpty") && this.getMDXNonEmptyProperty();
    }

    public XOLAPEdgeMapping getXOLAPEdgeMapping() {
        return (XOLAPEdgeMapping)this.getPropertyValue(PROPERTY_XOLAPEDGEMAPPING);
    }

    public void setXOLAPEdgeMapping(XOLAPEdgeMapping xNode) {
        if (xNode != null) {
            this.setPropertyValue(PROPERTY_XOLAPEDGEMAPPING, xNode);
        } else {
            this.removeProperty(PROPERTY_XOLAPEDGEMAPPING);
        }
    }

    public String getV5Name() {
        return (String)this.getPropertyValue(PROP_STRING_V5NAME);
    }

    public void setV5Name(String v5Name) {
        if (v5Name != null && v5Name.length() != 0) {
            this.setPropertyValue(PROP_STRING_V5NAME, v5Name);
        } else {
            this.removeProperty(PROP_STRING_V5NAME);
        }
    }

    public Set<IHierarchy> getReportHierarchies() {
        return (Set)this.getPropertyValue(PROP_REPORT_HIERARCHIES);
    }

    public List<CrosstabSpacerDescriptor> getSpacerList() {
        return (List)this.getPropertyValue("spacerList");
    }

    public void setSpacerList(List<CrosstabSpacerDescriptor> spacerList) {
        if (spacerList == null) {
            this.removeProperty("spacerList");
            return;
        }
        this.setPropertyValue("spacerList", spacerList);
    }

    @Override
    public MDXOOMInfo computeOOM(MDXOOMContext context) {
        IXQEQueryNode[] children = this.getChildren();
        if (children.length == 1 && children[0] instanceof AbstractMDXNode) {
            return ((AbstractMDXNode)children[0]).computeOOM(context);
        }
        return MDXOOMInfo.unkownOOM();
    }
}

