/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.olap.util.MDXOOMContext;
import com.cognos.xqe.ast.olap.util.MDXOOMInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPool;

public final class MDXFirstLastChild
extends AbstractMDXMember {
    public static final String PROPERTY_RELATIVE_MEMBER_FUNCTION = "mdxMemberFunction";
    public static final int FIRSTCHILD_FUNCTION = 0;
    public static final int LASTCHILD_FUNCTION = 1;

    public MDXFirstLastChild() {
        this.setRelativeMemberFunctionProperty(0);
    }

    @Override
    public int getType() {
        return 1035;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1035) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        this.getChild(0).writeFormattedText(buffer);
        buffer.append(".");
        buffer.append(this.getMDXRelativeMemberFunctionName());
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("apply", -1);
        trace.beginElement(this.getMDRelativeMemberFunctionName(), -1);
        trace.endElement();
        this.getChild(0).dumpFormattedXMLQuery(trace);
        trace.endElement();
    }

    @Override
    public int getMinimumNumberChildren() {
        return 1;
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        int[] categories = null;
        categories = index == 0 ? new int[]{1022} : new int[]{};
        return categories;
    }

    private String getMDRelativeMemberFunctionName() {
        String mdFunctionName = null;
        int operatorType = this.getRelativeMemberFunctionProperty();
        switch (operatorType) {
            case 0: {
                mdFunctionName = "firstChild";
                break;
            }
            case 1: {
                mdFunctionName = "lastChild";
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
            }
        }
        return mdFunctionName;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("functionName", this.getMDRelativeMemberFunctionName());
    }

    public int getRelativeMemberFunctionProperty() {
        return (Integer)this.getPropertyValue(PROPERTY_RELATIVE_MEMBER_FUNCTION);
    }

    public void setRelativeMemberFunctionProperty(int type) {
        this.setPropertyValue(PROPERTY_RELATIVE_MEMBER_FUNCTION, XQEIntegerPool.getInteger(type));
    }

    private String getMDXRelativeMemberFunctionName() {
        String mdxFunctionName = null;
        int operatorType = this.getRelativeMemberFunctionProperty();
        switch (operatorType) {
            case 0: {
                mdxFunctionName = "FIRSTCHILD";
                break;
            }
            case 1: {
                mdxFunctionName = "LASTCHILD";
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
            }
        }
        return mdxFunctionName;
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXMember)this.getChild(0)).getHierarchyInfo();
    }

    @Override
    protected MDXLevelInfo getLevelInfo(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        MDXLevelInfo memberInfo = ((AbstractMDXMember)this.getChild(0)).getLevelInfo(hierarchy);
        if (memberInfo.isEmpty()) {
            return memberInfo;
        }
        IHierarchy memberHierarchy = memberInfo.getHierarchyInfo().getProjectedHierarchy(0);
        memberInfo.adjustProjectedLevelsByOffset(memberHierarchy, 1);
        return memberInfo;
    }

    @Override
    public boolean isAscendantOrDescendantOfCurrentMember() {
        this.throwOnInvalidChildCategories();
        return this.getChild(0).getType() == 1076;
    }

    @Override
    public ILevel getLowestReferencedLevel(IHierarchy hierarchy) {
        ILevel lowestReferencedLevel = super.getLowestReferencedLevel(hierarchy);
        ILevel projectedLevel = this.getLevelInfo(hierarchy).getLowestProjectedLevel(hierarchy);
        if (projectedLevel != null) {
            if (lowestReferencedLevel == null) {
                lowestReferencedLevel = projectedLevel;
            } else if (projectedLevel.getIndex() > lowestReferencedLevel.getIndex()) {
                lowestReferencedLevel = projectedLevel;
            }
        }
        return lowestReferencedLevel;
    }

    @Override
    public ILevel getHighestReferencedLevel(IHierarchy hierarchy) {
        ILevel highestReferencedLevel = super.getHighestReferencedLevel(hierarchy);
        ILevel projectedLevel = this.getLevelInfo(hierarchy).getHighestProjectedLevel(hierarchy);
        if (projectedLevel != null) {
            if (highestReferencedLevel == null) {
                highestReferencedLevel = projectedLevel;
            } else if (projectedLevel.getIndex() < highestReferencedLevel.getIndex()) {
                highestReferencedLevel = projectedLevel;
            }
        }
        return highestReferencedLevel;
    }

    @Override
    public boolean couldResolveToEmptyMember() {
        this.throwOnInvalidChildCategories();
        if (((AbstractMDXMember)this.getChild(0)).couldResolveToEmptyMember()) {
            return true;
        }
        MDXLevelInfo memberLevelInfo = ((AbstractMDXMember)this.getChild(0)).getLevelInfo();
        if (memberLevelInfo.isEmpty()) {
            return true;
        }
        IHierarchy hierarchy = memberLevelInfo.getHierarchyInfo().getProjectedHierarchy(0);
        if (hierarchy.isUnbalanced()) {
            return true;
        }
        memberLevelInfo.adjustProjectedLevelsByOffset(hierarchy, 1);
        return memberLevelInfo.isEmpty();
    }

    @Override
    public MDXOOMInfo computeOOM(MDXOOMContext context) {
        MDXLevelInfo lvlInfo = this.getLevelInfo();
        if (lvlInfo.getHierarchyInfo().getNumberOfNonMeasureHierarchiesProjected() == 1 && lvlInfo.getNumProjectedLevels(lvlInfo.getHierarchyInfo().getProjectedHierarchy(0)) == 1) {
            return MDXOOMInfo.oneMemberFromLevel(lvlInfo.getProjectedLevels(lvlInfo.getHierarchyInfo().getProjectedHierarchy(0)).get(0));
        }
        return MDXOOMInfo.unkownOOM();
    }

    @Override
    public String getMDXTextName() {
        return this.getMDXRelativeMemberFunctionName();
    }
}

