/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.BaseProperty;
import com.cognos.xqe.ast.olap.CogMDXDefaultMeasure;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXCellProperties;
import com.cognos.xqe.ast.olap.MDXDimensionLine;
import com.cognos.xqe.ast.olap.MDXDimensionProperties;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.olap.MDXNamedSetDefinition;
import com.cognos.xqe.ast.olap.MDXNamedSetReference;
import com.cognos.xqe.ast.olap.MDXSAPVariables;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.olap.util.MDXOOMContext;
import com.cognos.xqe.ast.olap.util.MDXOOMInfo;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.IAliasEntry;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.shell.ShellDimension;
import com.cognos.xqe.metadata.shell.ShellManager;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.XMdxProperty;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRQueryOptimizationInfo;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.ragged_unbalanced.AbstractRaggedUnbalancedTransformation;
import com.cognos.xqe.transformation.olap.util.CollectTreeNodesForCondition;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.PrePlanUtilities;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.SetOfTables;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.StringBuilderWriter;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MDXQuery
extends AbstractMDXNode {
    public static final String PROP_STRING_REF_QUERY = "refQuery";
    public static final String PROP_STRING_V5_NAME = "v5Name";
    public static final String PROP_IS_LIST_REPORT = "isListReport";
    public static final String PROP_IS_CONSTANT_QUERY = "isConstantQuery";
    private static final String PROP_BOOLEAN_DEFAULT_MEASURE_APPLIED = "defaultMeasureApplied";
    public static final String PROP_STRING_INC_CALC_MEMBERS = "includeCalculatedMembers";
    public static final String PROP_STRING_NULL_SUPPR_QUERY_HINT = "nullSuppressionAcrossEdges";
    public static final String XQE_PREFIX = "XQE";
    public static final String PROP_BOOLEAN_SOLVE_ORDERS_NORMALIZED = "solveOrdersNormalized";
    public static final String PROP_BOOLEAN_QUERY_WITH_FILTERS = "filters";
    public static final String V5_FUNCTION_DEFAULT_NAME = "V5C";
    public static final String PROP_BOOLEAN_YUKON_HIER_RELATIONSHIP_APPLIED = "yukonHierRelationshipApplied";
    public static final int MDX_IDENTIFIER_MAXIMUM_LENGTH = 98;
    public static final String HAS_MEMBER_SET_REFERENCE = "hasMemberSetReference";
    public static final String PROP_BOOLEAN_SUPPRESS_NULLS = "suppressNulls";
    public static final String PROP_STRING_SUPPRESS_NULLS_QUERYHINT = "suppressNullsQueryHint";
    public static final String PROP_PXJ_ENABLED = "PXJEnabled";
    public static final String PROP_STRING_QUERY_PROCESSING = "queryProcessing";
    public static final String PROP_STRING_QUERY_INTENT = "queryIntent";
    public static final String PROP_BOOLEAN_USE_LOCAL_QUERY_PROCESSING = "useLocalQueryProcessing";
    public static final String PROP_STRING_SUMMARY_QUERY = "summaryQuery";
    public static final String PROP_BOOLEAN_FORCE_LOCAL_QUERY_PROCESSING = "forceLocalQueryProcessing";
    protected String stringMdx = null;
    public static final String PROP_STRING_EXECUTION_NOT_SUPPORTED = "isXQEExecutionNotSupported";
    public static final String PROP_STRING_MEMBER_TYPE_REQUESTED = "isMemberTypeRequested";
    public static final String CALC_MEMBER_NAMED_SET_ORDERED = "isCalcMemberNamedSetOrdered";
    public static final String PROP_STRING_REQUIRES_LOCAL_SUB_MDX_QUERY = "requireLocalSubMDXQuery";
    public static final String PROP_BOOLEAN_IS_RELATIONAL_STYLE_QUERY = "isRelationalStyleQuery";
    private static final String PROP_HIER_LEVEL_ORDER_IS_BROKEN_FOR_RAGGED = "hierarchyLevelOrderIsBrokenForRaggedGroups";
    private static final String PROP_HIER_LEVEL_ORDER_IS_BROKEN_FOR_UNBALANCED = "hierarchyLevelOrderIsBrokenForUnbalancedGroups";
    private static final String PROP_GROUPS_NOT_REQUIRING_RAGGED_COMP = "CogMDXGroupsNotRequiringRaggedCompensation";
    private static final String PROP_GROUPS_NOT_REQUIRING_UNBAL_COMP = "CogMDXGroupsNotRequiringUnbalCompensation";
    private static final String PROP_ALIAS_TABLE = "aliasTable";
    public static final String PROP_VARIABLE_VALUES_SET = "variableValuesSet";
    private static final String EDGE = "Edge";
    private static final String DEPTH = "Depth";
    public static final String PROP_STRING_PLANNED_PRIMING_QUERY = "plannedPrimingQuery";
    private int latestCalculatedMemberId = -1;
    private int latestNamedSetId = -1;
    private int latestSetAliasId = -1;
    private int latestCachingId = 0;
    private int latestPushdownQueryId = -1;
    public static final String NULL_EXPRESSION_BEHAVIOR = "nullExpressionBehavior";
    public static final String PROP_BOOLEAN_HAS_SUPORTED_ROLLUPAGGREGATE_ONLY = "hasSupportedRollupAggregatOnly";
    private static final String PROP_BOOLEAN_USE_NL_DECORATION = "useNLDecorationRules";
    private static final String PROPERTY_V5_QUERY_HINT_PROPAGATED = "V5QueryHintPropagated";
    private static final String PROPERTY_COUNT_MDF_AND_SLICER_BY_HIER = "countOfMDFandSlicerByHierarchy";
    private static final String PROP_MDX_PARAMETERS = "MDXParameters";
    public static final String PROP_BOOLEAN_DMR_CUBE_REUSE_ENABLED = "DMRCubeReuseEnabled";
    public static final String PROP_BOOLEAN_IS_SAP_REPLACEMENTVARIABLE_SET = "isSAPReplacementVariableSet";
    public static final String PROP_INT_DMR_AGG_SUMMARY_OPTIM_LEVEL = "DMRAggSummaryOptimLevel";
    public static final String PROP_REPORT_SUMMARY_AGGREGATION_LEVEL_INFO = "ReportSummaryAggregationLevelInfo";
    public static final String PROP_QUERY_OPTIMIZATION_INFO = "QueryOptimizationInfo";
    public static final String PROP_STRING_REQUIRED_PROPERTIES = "requiredPropertiesForLOLAP";
    public static final String PROP_EDGES_WITH_CROSSTAB_SPACERS = "edgesProjectingCrosstabSpacers";
    private static final String DMR = "DMR";
    protected ShellManager shellManager;
    private Map<String, Integer> calcToPrimingModeMap;
    private MultiRequestContext.RequestProcessing requestProcessing;

    public MDXQuery() {
        this.setHaveVariableValuesBeenSet(false);
        this.setPropertyValue("cellProperties", new MDXCellProperties());
        this.setPropertyValue("sapVariables", new MDXSAPVariables());
        this.requestProcessing = MultiRequestContext.RequestProcessing.DEFAULT;
    }

    public List<IXQEQueryNode> getMDXParameters() {
        List mdxParameters = CollectionCast.uncheckedCast((List)this.getPropertyValue(PROP_MDX_PARAMETERS));
        if (null == mdxParameters) {
            return CollectionCast.uncheckedCast(Collections.emptyList());
        }
        return CollectionCast.uncheckedCast(Collections.unmodifiableList(mdxParameters));
    }

    public void addMDXParameter(IXQEQueryNode parameter) {
        List mdxParameters = CollectionCast.uncheckedCast((List)this.getPropertyValue(PROP_MDX_PARAMETERS));
        if (null == mdxParameters) {
            mdxParameters = new ArrayList();
            this.setPropertyValue(PROP_MDX_PARAMETERS, mdxParameters);
        }
        mdxParameters.add(parameter);
    }

    public MDXCellProperties getCellProperties() {
        return (MDXCellProperties)this.getPropertyValue("cellProperties");
    }

    public void addCellProperty(String cellProperty) {
        this.getPlanningEnvironment().setTreeHasBeenModified();
        this.getCellProperties().addCellProperty(cellProperty);
    }

    public void removeCellProperty(String cellProperty) {
        this.getPlanningEnvironment().setTreeHasBeenModified();
        this.getCellProperties().removeCellProperty(cellProperty);
    }

    public void clearCellProperties() {
        this.getPlanningEnvironment().setTreeHasBeenModified();
        this.getCellProperties().clearCellProperties();
    }

    public void setAliasTable(List<IAliasEntry> aliasTable) {
        this.setPropertyValue(PROP_ALIAS_TABLE, aliasTable);
    }

    public List<IAliasEntry> getAliasTable() {
        return (List)this.getPropertyValue(PROP_ALIAS_TABLE);
    }

    public MDXSAPVariables getSAPVariables() {
        return (MDXSAPVariables)this.getPropertyValue("sapVariables");
    }

    public void addSAPVariable(String sapVariable) {
        this.getPlanningEnvironment().setTreeHasBeenModified();
        this.getSAPVariables().addSAPVariable(sapVariable);
    }

    public int getNextCalculatedMemberId() {
        return ++this.latestCalculatedMemberId;
    }

    public int getNextNamedSetId() {
        return ++this.latestNamedSetId;
    }

    public int getNextSetAliasId() {
        return ++this.latestSetAliasId;
    }

    public int getNextCachingId() {
        return ++this.latestCachingId;
    }

    public int getNextPushdownQueryId() {
        return ++this.latestPushdownQueryId;
    }

    public void setRefQueryProperty(String refQuery) {
        this.setPropertyValue(PROP_STRING_REF_QUERY, refQuery);
    }

    public String getRefQueryProperty() {
        return (String)this.getPropertyValue(PROP_STRING_REF_QUERY);
    }

    public void setV5NameProperty(String v5Name) {
        this.setPropertyValue(PROP_STRING_V5_NAME, v5Name);
    }

    public String getV5NameProperty() {
        return (String)this.getPropertyValue(PROP_STRING_V5_NAME);
    }

    public void setExecutionNotSupported() {
        this.setPropertyValue(PROP_STRING_EXECUTION_NOT_SUPPORTED, Boolean.TRUE);
    }

    public boolean isExecutionNotSupported() {
        boolean bool = false;
        Boolean propValue = (Boolean)this.getPropertyValue(PROP_STRING_EXECUTION_NOT_SUPPORTED);
        if (propValue != null) {
            bool = propValue;
        }
        return bool;
    }

    public void setMemberTypeRequested() {
        this.setPropertyValue(PROP_STRING_MEMBER_TYPE_REQUESTED, Boolean.TRUE);
    }

    public void resetMemberTypeRequested() {
        this.setPropertyValue(PROP_STRING_MEMBER_TYPE_REQUESTED, Boolean.FALSE);
    }

    public boolean isMemberTypeRequested() {
        boolean bool = false;
        Boolean propValue = (Boolean)this.getPropertyValue(PROP_STRING_MEMBER_TYPE_REQUESTED);
        if (propValue != null) {
            bool = propValue;
        }
        return bool;
    }

    public int getNumberOfEdges() {
        return this.getEdges().length;
    }

    public int getNumberOfEdgesWithChildren() {
        int edgeWithChildrenCount = 0;
        for (MDXEdge currEdge : this.getEdges()) {
            if (currEdge.getNumberChildren() == 0) continue;
            ++edgeWithChildrenCount;
        }
        return edgeWithChildrenCount;
    }

    public MDXEdge[] getEdges() {
        ArrayList<MDXEdge> edges = new ArrayList<MDXEdge>();
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            IXQEQueryNode child = childIterator.next();
            if (child.getType() != 1006) continue;
            edges.add((MDXEdge)child);
        }
        return edges.toArray(new MDXEdge[edges.size()]);
    }

    public int getEdgeOrdinal(MDXEdge edge) {
        MDXEdge[] edges = this.getEdges();
        for (int edgeIndex = 0; edgeIndex < edges.length; ++edgeIndex) {
            if (edges[edgeIndex] != edge) continue;
            return edgeIndex;
        }
        throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
    }

    public MDXCalculatedMemberDefinition[] getCalcMemberDefinitions() {
        ArrayList<MDXCalculatedMemberDefinition> calcs = new ArrayList<MDXCalculatedMemberDefinition>();
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            IXQEQueryNode child = childIterator.next();
            if (child.getType() != 1005) continue;
            calcs.add((MDXCalculatedMemberDefinition)child);
        }
        return calcs.toArray(new MDXCalculatedMemberDefinition[calcs.size()]);
    }

    public MDXDimensionLine getDimensionLine() {
        MDXDimensionLine mdxDimLine = null;
        IXQEQueryNode[] dimLineNodes = this.getDescendantsOfType(1008, false);
        if (dimLineNodes.length > 1) {
            this.throwInternalError("An MDXQuery node cannot have multiple MDXDimensionLine node descendants.");
        }
        if (dimLineNodes.length == 1) {
            mdxDimLine = (MDXDimensionLine)dimLineNodes[0];
        }
        return mdxDimLine;
    }

    public IXQEQueryNode[] getDetailFilters() {
        IXQEQueryNode[] detailFilters = this.getChildrenOfType(1010);
        if (detailFilters.length != 0) {
            CogMDXDetailFilter detailFilter = (CogMDXDetailFilter)detailFilters[0];
            return detailFilter.getChildren();
        }
        return detailFilters;
    }

    @Override
    public int getType() {
        return 1002;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1002) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public V5Query getRefV5Query() {
        String refquery = this.getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)this.getAncestorOfType(101002);
        return v5QuerySet.getV5Query(refquery);
    }

    public ICube getReferencedCube() {
        return this.getMDXFrom().getCube();
    }

    public MDXFromCube getMDXFrom() {
        MDXFromCube fromCube = (MDXFromCube)this.getFirstChildByType(1007);
        if (fromCube == null) {
            this.throwInternalError("Unable to find the child MDXFromCube node.");
        }
        return fromCube;
    }

    public String getReferencedModel() {
        return this.getMDXFrom().getModel();
    }

    public void disableLocalSubMDXQueryRequest() {
        this.setPropertyValue(PROP_STRING_REQUIRES_LOCAL_SUB_MDX_QUERY, Boolean.FALSE);
    }

    public boolean requiresLocalSubMDXQuery() {
        boolean bool = true;
        Boolean propValue = (Boolean)this.getPropertyValue(PROP_STRING_REQUIRES_LOCAL_SUB_MDX_QUERY);
        if (propValue != null) {
            bool = propValue;
        }
        return bool;
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        this.writeFormattedText(buffer, false);
    }

    public void writeFormattedText(StringBuilder buffer, boolean forMasterComparison) {
        IXQEQueryNode child;
        int idx;
        int nChildren = this.getNumberChildren();
        boolean withClauseDone = false;
        for (idx = 0; idx < nChildren; ++idx) {
            child = this.getChild(idx);
            if (child.getType() != 1003 && child.getType() != 1005 && child.getType() != 1189) continue;
            if (withClauseDone) {
                buffer.append("\n");
                buffer.append("  ");
                child.writeFormattedText(buffer);
                continue;
            }
            withClauseDone = true;
            buffer.append("WITH");
            buffer.append("\n");
            buffer.append("  ");
            child.writeFormattedText(buffer);
        }
        if (withClauseDone) {
            buffer.append("\n");
        }
        buffer.append("SELECT");
        buffer.append(" ");
        int i = 0;
        for (idx = 0; idx < nChildren; ++idx) {
            child = this.getChild(idx);
            if (child.getType() != 1006) continue;
            if (i++ > 0) {
                buffer.append(", ");
                buffer.append("\n");
                buffer.append("  ");
            } else {
                buffer.append("\n");
                buffer.append("  ");
            }
            child.writeFormattedText(buffer);
        }
        this.getMDXFrom().writeFormattedText(buffer);
        i = 0;
        for (idx = 0; idx < nChildren; ++idx) {
            child = this.getChild(idx);
            if (child.getType() != 1008) continue;
            if (i++ == 0) {
                buffer.append("\n");
            }
            child.writeFormattedText(buffer);
        }
        i = 0;
        for (idx = 0; idx < nChildren; ++idx) {
            child = this.getChild(idx);
            if (child.getType() != 1010) continue;
            if (i++ == 0) {
                buffer.append("\n");
            }
            child.writeFormattedText(buffer);
        }
        i = 0;
        for (idx = 0; idx < nChildren; ++idx) {
            child = this.getChild(idx);
            if (child.getType() != 1009) continue;
            if (i++ == 0) {
                buffer.append("\n");
            }
            child.writeFormattedText(buffer);
        }
        MDXCellProperties cellProperties = (MDXCellProperties)this.getPropertyValue("cellProperties");
        if (this.isYukonProvider()) {
            cellProperties.addCellProperty("LANGUAGE");
        }
        cellProperties.writeFormattedText(buffer);
        MDXSAPVariables sapVariables = (MDXSAPVariables)this.getPropertyValue("sapVariables");
        if (sapVariables != null) {
            sapVariables.writeFormattedText(buffer, forMasterComparison);
        }
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("md:MDQuerySpec", -1);
        trace.attribute("xmlns:md", "http://developer.cognos.com/schemas/mds/1/");
        trace.attribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            IXQEQueryNode child = childIterator.next();
            if (child.getType() == 1007) continue;
            child.dumpFormattedXMLQuery(trace);
        }
        this.getCellProperties().dumpFormattedXMLQuery(trace);
        this.getMDXFrom().dumpFormattedXMLQuery(trace);
        trace.endElement();
    }

    public boolean isDefinitionReferenced(MDXCalculatedMemberDefinition mDXCalculatedMemberDefinition) {
        return !mDXCalculatedMemberDefinition.getCalcMemberRefs().isEmpty();
    }

    public boolean isSetSpecificationReferenced(MDXNamedSetDefinition mDXNamedSetDefinition) {
        boolean setSpecificationIsReferenced = false;
        IXQEQueryNode[] calcMembersOnQuery = this.getDescendantsOfType(1014, false);
        for (int idx = 0; !setSpecificationIsReferenced && idx < calcMembersOnQuery.length; ++idx) {
            if (((MDXNamedSetReference)calcMembersOnQuery[idx]).getDefinition() != mDXNamedSetDefinition) continue;
            setSpecificationIsReferenced = true;
        }
        return setSpecificationIsReferenced;
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        MDXHierInfo hierInfo = new MDXHierInfo();
        MDXEdge[] edges = this.getEdges();
        for (int edgeIndex = 0; edgeIndex < edges.length; ++edgeIndex) {
            MDXHierInfo edgeMetadata = edges[edgeIndex].getHierarchyInfo();
            hierInfo.appendProjectedHierarchies(edgeMetadata);
        }
        return hierInfo;
    }

    @Override
    public MDXLevelInfo getLevelInfo(IHierarchy hierarchy) {
        MDXLevelInfo levelInfo = new MDXLevelInfo();
        MDXEdge[] edges = this.getEdges();
        for (int edgeIndex = 0; edgeIndex < edges.length; ++edgeIndex) {
            MDXLevelInfo edgeLevelInfo = edges[edgeIndex].getLevelInfo(hierarchy);
            levelInfo.appendProjectedHierarchies(edgeLevelInfo);
        }
        return levelInfo;
    }

    public String createMDXIdentifier(String prefix, String name, String suffix) {
        StringBuilder strBuf = new StringBuilder(prefix);
        if (prefix.length() + name.length() + suffix.length() < 98) {
            strBuf.append(name);
        } else {
            int iMaxNameLength = 98 - prefix.length() - suffix.length();
            strBuf.append(name.substring(0, iMaxNameLength - 1));
        }
        strBuf.append(suffix);
        return strBuf.toString().replace('[', '_').replace(']', '_');
    }

    public String createCalculatedMemberUniqueName(IHierarchy hierarchy, String name) {
        return hierarchy.createCalculatedMemberUniqueName(this.createMDXIdentifier(XQE_PREFIX, name, "_CM" + this.getNextCalculatedMemberId()));
    }

    public String createNamedSetUniqueName(String suffix) {
        StringBuilder strBuf = new StringBuilder(XQE_PREFIX);
        strBuf.append(suffix).append("_NS").append(this.getNextNamedSetId());
        return strBuf.toString();
    }

    public String createSetAliasUniqueName(String suffix) {
        StringBuilder strBuf = new StringBuilder("[");
        strBuf.append(XQE_PREFIX).append(suffix).append("_SA").append(this.getNextSetAliasId()).append("]");
        return strBuf.toString();
    }

    public List<BaseMember> collectBaseMeasures() {
        ArrayList<BaseMember> baseMeasures = new ArrayList<BaseMember>();
        List<IXQEQueryNode> baseMembers = this.getDescendantsOfTypeOrdered(1067, false);
        for (IXQEQueryNode baseMember : baseMembers) {
            if (!((BaseMember)baseMember).isMeasure()) continue;
            baseMeasures.add((BaseMember)baseMember);
        }
        return baseMeasures;
    }

    public List<AbstractMDXMember> collectMeasures() {
        ArrayList<AbstractMDXMember> allMeasures = new ArrayList<AbstractMDXMember>();
        List<IXQEQueryNode> baseMembers = this.getDescendantsOfTypeOrdered(1067, false);
        for (IXQEQueryNode baseMember : baseMembers) {
            if (!((BaseMember)baseMember).isMeasure()) continue;
            allMeasures.add((BaseMember)baseMember);
        }
        baseMembers = this.getDescendantsOfTypeOrdered(1013, false);
        for (IXQEQueryNode baseMember : baseMembers) {
            if (!((MDXCalculatedMemberReference)baseMember).getDefinition().getHierarchy().getDimension().isMeasuresDimension()) continue;
            allMeasures.add((AbstractMDXMember)baseMember);
        }
        return allMeasures;
    }

    public String getMDX() {
        return this.getMDX(false);
    }

    public String getMDX(boolean forMasterComparison) {
        if (this.getUseLocalQueryProcessing()) {
            if (this.stringMdx == null) {
                this.stringMdx = this.generateMDX(forMasterComparison);
            }
            return this.stringMdx;
        }
        return this.generateMDX(forMasterComparison);
    }

    public String generateMDX() {
        return this.generateMDX(false);
    }

    public String generateMDX(boolean forMasterComparison) {
        StringBuilder mdxQueryStrBuf = new StringBuilder();
        this.writeFormattedText(mdxQueryStrBuf, forMasterComparison);
        if (this.getUseLocalQueryProcessing()) {
            this.stringMdx = mdxQueryStrBuf.toString();
            return this.stringMdx;
        }
        return mdxQueryStrBuf.toString();
    }

    public String getMDQuery() {
        StringBuilderWriter aWriter = new StringBuilderWriter(new StringBuilder());
        XQETrace trace = new XQETrace();
        trace.setTraceLevelAll();
        trace.addStream(aWriter);
        this.dumpFormattedXMLQuery(trace);
        return aWriter.toString();
    }

    public Set<IHierarchy> getReferencedHierarchiesOnEdges() {
        this.throwOnInvalidChildCategories();
        LinkedHashSet<IHierarchy> referencedHierarchies = new LinkedHashSet<IHierarchy>();
        MDXEdge[] edges = this.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            referencedHierarchies.addAll(edges[i].getReferencedHierarchies());
        }
        return referencedHierarchies;
    }

    public Set<IHierarchy> getReferencedHierarchiesOnEdgesAndDimLine() {
        this.throwOnInvalidChildCategories();
        LinkedHashSet<IHierarchy> referencedHierarchies = new LinkedHashSet<IHierarchy>();
        referencedHierarchies.addAll(this.getReferencedHierarchiesOnEdges());
        MDXDimensionLine dimLine = this.getDimensionLine();
        if (dimLine != null) {
            referencedHierarchies.addAll(dimLine.getReferencedHierarchies());
        }
        return referencedHierarchies;
    }

    public Set<IDimension> getReferencedDimensionsOnEdges() {
        HashSet<IDimension> referencedDimensions = new HashSet<IDimension>();
        MDXEdge[] edges = this.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            referencedDimensions.addAll(edges[i].getReferencedDimensions());
        }
        return referencedDimensions;
    }

    public Set<IDimension> getReferencedDimensionsOnEdgesAndDimLine() {
        HashSet<IDimension> referencedDimensions = new HashSet<IDimension>();
        referencedDimensions.addAll(this.getReferencedDimensionsOnEdges());
        MDXDimensionLine dimLine = this.getDimensionLine();
        if (dimLine != null) {
            referencedDimensions.addAll(dimLine.getReferencedDimensions());
        }
        return referencedDimensions;
    }

    public IDimension getUnreferencedDimension() {
        List<BaseMember> measures = this.collectBaseMeasures();
        HashSet<String> ruleRefDimNames = new HashSet<String>();
        for (BaseMember aMeasure : measures) {
            IAggregateRule[] rules;
            for (IAggregateRule rule : rules = aMeasure.getMember().getAggregateRules()) {
                ruleRefDimNames.add(rule.getDimensionRef());
            }
        }
        Set<IDimension> referencedDimensions = this.getReferencedDimensions();
        List<IDimension> cubeDimensions = this.getReferencedCube().getDimensions();
        if (referencedDimensions.size() < cubeDimensions.size()) {
            for (int i = 0; i < cubeDimensions.size(); ++i) {
                if (referencedDimensions.contains(cubeDimensions.get(i)) || ruleRefDimNames.contains(cubeDimensions.get(i).getName())) continue;
                return cubeDimensions.get(i);
            }
        }
        return null;
    }

    public IHierarchy getUnreferencedHierarchy() {
        IDimension unreferencedDimension = this.getUnreferencedDimension();
        if (unreferencedDimension != null) {
            return unreferencedDimension.getDefaultHierarchy();
        }
        if (DataSourceTypeEnum.isPowerCube(this.getDataSourceType())) {
            Set<IHierarchy> referencedHierarchies = this.getReferencedHierarchies();
            Iterator<IHierarchy> refHierIt = referencedHierarchies.iterator();
            while (refHierIt.hasNext()) {
                IDimension dimension = refHierIt.next().getDimension();
                for (IHierarchy hierarchy : dimension.getHierarchies()) {
                    if (referencedHierarchies.contains(hierarchy)) continue;
                    return hierarchy;
                }
            }
        }
        return null;
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        return new int[]{1001};
    }

    @Override
    public int getMinimumNumberChildren() {
        return 1;
    }

    public static String getShellHierarchyName(V5Edge v5Edge, Integer iDepth) {
        return EDGE + (String)v5Edge.getPropertyValue("name") + DEPTH + iDepth.toString();
    }

    public IHierarchy getShellHierarchy(String hierarchyName, int hierarchyDepth) {
        IHierarchy shellHierarchy = null;
        if (this.shellManager == null) {
            this.shellManager = new ShellManager();
        }
        if (this.getReferencedCube() != null) {
            ShellDimension shellDimension = (ShellDimension)this.shellManager.getCube(this.getReferencedCube().getName()).getDimension(hierarchyName);
            shellHierarchy = shellDimension.getHierarchy(hierarchyName, hierarchyDepth);
        }
        return shellHierarchy;
    }

    public void setDefaultMeasureApplied() {
        this.setPropertyValue(PROP_BOOLEAN_DEFAULT_MEASURE_APPLIED, Boolean.TRUE);
    }

    public boolean isDefaultMeasureApplied() {
        return this.getPropertyValue(PROP_BOOLEAN_DEFAULT_MEASURE_APPLIED) == Boolean.TRUE;
    }

    public boolean getFiltering() {
        Boolean propValue = (Boolean)this.getPropertyValue(PROP_BOOLEAN_QUERY_WITH_FILTERS);
        if (propValue != null) {
            return propValue;
        }
        return false;
    }

    public void setFiltering() {
        this.setPropertyValue(PROP_BOOLEAN_QUERY_WITH_FILTERS, Boolean.TRUE);
    }

    public boolean isListReport() {
        return Boolean.TRUE.equals(this.getPropertyValue(PROP_IS_LIST_REPORT));
    }

    public void setSolveOrdersNormalized() {
        this.setPropertyValue(PROP_BOOLEAN_SOLVE_ORDERS_NORMALIZED, Boolean.TRUE);
    }

    public boolean isSolveOrdersNormalized() {
        return this.getPropertyValue(PROP_BOOLEAN_SOLVE_ORDERS_NORMALIZED) == Boolean.TRUE;
    }

    public String getDataSourceType() {
        return this.getMDXFrom().getDataSourceType();
    }

    public IDataSourceCapabilities getCapabilities() {
        return this.getMDXFrom().getCMDataSource().getCapabilities();
    }

    public IHierarchy getMeasuresHierarchy() {
        return this.getReferencedCube().getMeasuresHierarchy();
    }

    @Override
    public boolean isProjectedDescendant(AbstractMDXNode node) {
        this.throwOnInvalidChildCategories();
        MDXEdge[] edges = this.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            if (!edges[i].isProjectedDescendant(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void isProjectedDescendant(Collection<IXQEQueryNode> nodes, Collection<IXQEQueryNode> returnNodes) {
        this.throwOnInvalidChildCategories();
        for (MDXEdge edge : this.getEdges()) {
            if (nodes.isEmpty()) continue;
            edge.isProjectedDescendant(nodes, returnNodes);
        }
    }

    public List<IXQEQueryNode> getCalcMemberRefForDefinition(MDXCalculatedMemberDefinition cmDefinition) {
        return CollectionCast.upcast(cmDefinition.getCalcMemberRefs(), IXQEQueryNode.class);
    }

    public AbstractMDXMember getQueryDefaultMeasure() {
        CogMDXDefaultMeasure cogDefaultMeasure = (CogMDXDefaultMeasure)this.getFirstChildByType(1092);
        if (cogDefaultMeasure == null) {
            this.throwInternalError("CogMDXDefaultMeasure not found.");
        }
        cogDefaultMeasure.throwOnInvalidChildCategories();
        return (AbstractMDXMember)cogDefaultMeasure.getChild(0);
    }

    public void setYukonHierarchyRelationshipCompensationApplied() {
        this.setPropertyValue(PROP_BOOLEAN_YUKON_HIER_RELATIONSHIP_APPLIED, Boolean.TRUE);
    }

    public boolean isYukonHierarchyRelationshipCompensationApplied() {
        return this.getPropertyValue(PROP_BOOLEAN_YUKON_HIER_RELATIONSHIP_APPLIED) == Boolean.TRUE;
    }

    public Set<IXQEQueryNode> getProjectedReferences(MDXCalculatedMemberDefinition mdxCalculatedMemberDefinition) {
        MDXEdge[] edges = this.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            HashSet<IXQEQueryNode> projectedReferences = new HashSet<IXQEQueryNode>();
            edges[i].getProjectedReference(projectedReferences, mdxCalculatedMemberDefinition);
            if (projectedReferences.isEmpty()) continue;
            return projectedReferences;
        }
        return new HashSet<IXQEQueryNode>();
    }

    public void setIncludeCalculatedMembers() {
        this.setPropertyValue(PROP_STRING_INC_CALC_MEMBERS, Boolean.TRUE);
    }

    public boolean getIncludeCalculatedMembers() {
        Boolean propValue = (Boolean)this.getPropertyValue(PROP_STRING_INC_CALC_MEMBERS);
        if (propValue != null) {
            return propValue;
        }
        return false;
    }

    public Boolean getNullSuppressionQueryHint() {
        return (Boolean)this.getPropertyValue(PROP_STRING_NULL_SUPPR_QUERY_HINT);
    }

    @Override
    protected MDXHierInfo getContextHierarchyInfoForCalculatedMemberDefinition(AbstractMDXNode child, MDXCalculatedMemberReference calcRef) {
        if (!this.validateChildCategories() || !this.isParentOf(child)) {
            this.throwInternalError("Query could not be planned.");
        }
        return this.getHierarchyInfo();
    }

    @Override
    protected MDXLevelInfo getContextLevelInfoForCalculatedMemberDefinition(AbstractMDXNode child, MDXCalculatedMemberReference calcRef, IHierarchy hierarchy) {
        if (!this.validateChildCategories() || null != child && !this.isParentOf(child)) {
            this.throwInternalError("Query could not be planned.");
        }
        MDXLevelInfo levelInfo = this.getLevelInfo(hierarchy);
        MDXEdge[] edges = this.getEdges();
        for (int edgeIndex = 0; edgeIndex < edges.length; ++edgeIndex) {
            MDXEdge edge = edges[edgeIndex];
            IXQEQueryNode[] calcReferences = edge.getDescendantsOfType(1013, false);
            for (int i = 0; i < calcReferences.length; ++i) {
                Set<MDXLevelInfo> calcDefVELevelInfo;
                MDXCalculatedMemberReference descendantCalcRef = (MDXCalculatedMemberReference)calcReferences[i];
                boolean validSolveOrder = false;
                boolean giveup = false;
                if (null != calcRef) {
                    boolean bl = validSolveOrder = descendantCalcRef.getSolveOrder() > calcRef.getSolveOrder() && descendantCalcRef.getHierarchy().equals(calcRef.getHierarchy());
                    if (!validSolveOrder) {
                        Set<MDXCalculatedMemberDefinition> nestedCalcs = this.getLevelInfoCache().getNestedCalculation();
                        for (MDXCalculatedMemberDefinition nestedCalc : nestedCalcs) {
                            if (descendantCalcRef.getSolveOrder() <= nestedCalc.getSolveOrder() || nestedCalc.getHierarchy().equals(calcRef.getHierarchy()) || descendantCalcRef.getHierarchy().equals(nestedCalc.getHierarchy()) || descendantCalcRef.getHierarchy().equals(calcRef.getHierarchy())) continue;
                            validSolveOrder = true;
                            giveup = true;
                            break;
                        }
                    }
                }
                if (calcRef != null && !validSolveOrder || descendantCalcRef.isTag() || !edge.isProjectedDescendant(descendantCalcRef)) continue;
                PlanningEnvironment planEnv = (PlanningEnvironment)this.getPlanningEnvironment();
                MDXCalculatedMemberDefinition calcDef = descendantCalcRef.getDefinition();
                if (giveup) {
                    MDXLevelInfo resetLevelInfo = new MDXLevelInfo();
                    if (hierarchy != null) {
                        resetLevelInfo.addProjectedHierarchy(hierarchy);
                    }
                    calcDefVELevelInfo = new LinkedHashSet<MDXLevelInfo>();
                    calcDefVELevelInfo.add(resetLevelInfo);
                    this.getLevelInfoCache().addVELevelInfoCache(calcDef, hierarchy, calcDefVELevelInfo);
                } else {
                    calcDefVELevelInfo = this.getLevelInfoCache().getVELevelInfoCache(calcDef, hierarchy);
                }
                if (calcDefVELevelInfo == null) {
                    calcDefVELevelInfo = calcDef.getContextDependentValueExpressionLevelInfo(null, hierarchy);
                    planEnv.getLevelInfoCache().addVELevelInfoCache(calcDef, hierarchy, calcDefVELevelInfo);
                }
                for (MDXLevelInfo eachLevelInfo : calcDefVELevelInfo) {
                    levelInfo.unionProjectedHierarchies(eachLevelInfo);
                }
            }
        }
        return levelInfo;
    }

    public MDXLevelInfo getSlicerContextLevelInfo(IHierarchy hierarchy) {
        MDXLevelInfo levelInfo = this.getContextLevelInfoForCalculatedMemberDefinition(null, null, hierarchy);
        MDXEdge[] edges = this.getEdges();
        for (int edgeIndex = 0; edgeIndex < edges.length; ++edgeIndex) {
            MDXEdge edge = edges[edgeIndex];
            Set<MDXLevelInfo> veLevelInfo = edge.getContextDependentValueExpressionLevelInfo(edge, hierarchy);
            Iterator<MDXLevelInfo> it = veLevelInfo.iterator();
            while (it.hasNext()) {
                levelInfo.unionProjectedHierarchies(it.next());
            }
        }
        if (hierarchy != null && !this.getHierarchyInfo().projectsHierarchy(hierarchy) && levelInfo.getNumProjectedLevels(hierarchy) > 0) {
            MDXLevelInfo newLevelInfo = new MDXLevelInfo();
            newLevelInfo.addProjectedHierarchy(hierarchy.getDefaultMember().getLevel());
            levelInfo.unionProjectedLevels(newLevelInfo, hierarchy);
        }
        return levelInfo;
    }

    public boolean isSuppressNulls() {
        return this.getPropertyValue(PROP_BOOLEAN_SUPPRESS_NULLS) == Boolean.TRUE;
    }

    public Boolean getSuppressNulls() {
        return (Boolean)this.getPropertyValue(PROP_BOOLEAN_SUPPRESS_NULLS);
    }

    public boolean getSuppressNullsProviderDefault() {
        return this.isDMR() && this.getDMRDefaultNullSuppression() || !this.isRelationaCrosstab() && this.isRelationalStyleQuery() || this.isListReport() && "BW".equals(this.getDataSourceType()) || this.getCapabilities().isSupported("mdx.suppression.DatasourceAppliesImplicitNonEmpty");
    }

    public void setSuppressNulls(Boolean doSuppressNulls) {
        this.setPropertyValue(PROP_BOOLEAN_SUPPRESS_NULLS, doSuppressNulls);
    }

    public String getSuppressNullsQueryHint() {
        return (String)this.getPropertyValue(PROP_STRING_SUPPRESS_NULLS_QUERYHINT);
    }

    public void setSuppressNullsQueryHint(String suppressNullQueryHint) {
        this.setPropertyValue(PROP_STRING_SUPPRESS_NULLS_QUERYHINT, suppressNullQueryHint);
    }

    public boolean isDMRCubeReuseEnabled() {
        return !Boolean.FALSE.equals(this.getPropertyValue(PROP_BOOLEAN_DMR_CUBE_REUSE_ENABLED));
    }

    public void setDMRCubeReuseEnabled(boolean enabled) {
        this.setPropertyValue(PROP_BOOLEAN_DMR_CUBE_REUSE_ENABLED, enabled);
    }

    public boolean isSummaryMeasureInQuery() {
        return Boolean.TRUE.equals(this.getPropertyValue(PROP_STRING_SUMMARY_QUERY));
    }

    public void setDMRAggregateSummaryOptimizationLevel(int level) {
        this.setPropertyValue(PROP_INT_DMR_AGG_SUMMARY_OPTIM_LEVEL, level);
    }

    public int getDMRAggregateSummaryOptimizationLevel() {
        Integer value = (Integer)this.getPropertyValue(PROP_INT_DMR_AGG_SUMMARY_OPTIM_LEVEL);
        if (value == null) {
            return 2;
        }
        return value;
    }

    public void setSummaryMeasureInQuery(boolean enabled) {
        this.setPropertyValue(PROP_STRING_SUMMARY_QUERY, enabled);
    }

    public boolean isNullSuppressionOnAllEdges() {
        MDXEdge[] mdxEdges = this.getEdges();
        for (int idx = 0; idx < mdxEdges.length; ++idx) {
            MDXEdge mdxEdge = mdxEdges[idx];
            if (mdxEdge.getMDXNonEmptyProperty()) continue;
            return false;
        }
        return true;
    }

    public boolean getUseLocalQueryProcessing() {
        Boolean forceLocalProcessing = (Boolean)this.getPropertyValue(PROP_BOOLEAN_FORCE_LOCAL_QUERY_PROCESSING);
        if (null != forceLocalProcessing) {
            return forceLocalProcessing.equals(Boolean.TRUE);
        }
        Boolean useLocalProcessing = (Boolean)this.getPropertyValue(PROP_BOOLEAN_USE_LOCAL_QUERY_PROCESSING);
        boolean databaseOnly = this.getRequestProcessing() == MultiRequestContext.RequestProcessing.DATABASEONLY;
        return useLocalProcessing != null && useLocalProcessing.equals(Boolean.TRUE) && !databaseOnly;
    }

    public boolean getForceLocalQueryProcessing() {
        Boolean forceLocalProcessing = (Boolean)this.getPropertyValue(PROP_BOOLEAN_FORCE_LOCAL_QUERY_PROCESSING);
        if (null != forceLocalProcessing) {
            return forceLocalProcessing.equals(Boolean.TRUE);
        }
        return false;
    }

    public boolean getForceRemoteQueryProcessing() {
        Boolean forceLocalProcessing = (Boolean)this.getPropertyValue(PROP_BOOLEAN_FORCE_LOCAL_QUERY_PROCESSING);
        if (null != forceLocalProcessing) {
            return forceLocalProcessing.equals(Boolean.FALSE);
        }
        return false;
    }

    public void setUseLocalQueryProcessing(Boolean value) {
        this.setPropertyValue(PROP_BOOLEAN_USE_LOCAL_QUERY_PROCESSING, value);
        this.getPlanningEnvironment().setUseLocalQueryProcessing(value);
    }

    public void setforceLocalQueryProcessing(Boolean value) {
        this.setPropertyValue(PROP_BOOLEAN_FORCE_LOCAL_QUERY_PROCESSING, value);
        this.getPlanningEnvironment().setUseLocalQueryProcessing(value);
    }

    public void setUseMetadataCallOnly(Boolean value) {
        this.setPropertyValue("useMetadataCallOnly", value);
    }

    public boolean useLocalProcessForSetAlias() {
        return this.getCapabilities().isSupported("v5.useLOLAPForSetAlias");
    }

    public void setQueryIntentProperty(String queryIntent) {
        this.setPropertyValue(PROP_STRING_QUERY_INTENT, queryIntent);
    }

    public String getQueryIntentProperty() {
        return (String)this.getPropertyValue(PROP_STRING_QUERY_INTENT);
    }

    public boolean isQueryIntentMetadata() {
        boolean bool = false;
        String propValue = (String)this.getPropertyValue(PROP_STRING_QUERY_INTENT);
        if (propValue != null && propValue.equals("metadata")) {
            bool = true;
        }
        return bool;
    }

    public boolean isAtLeastOneEdgeSuppressed() {
        MDXEdge[] mdxEdges = this.getEdges();
        for (int i = 0; i < mdxEdges.length; ++i) {
            MDXEdge mdxEdge = mdxEdges[i];
            if (!mdxEdge.getMDXNonEmptyProperty()) continue;
            return true;
        }
        return false;
    }

    public boolean setAliasSupported() {
        return this.getCapabilities().isSupported("mdx.support.setalias");
    }

    public boolean olympicRankSupported() {
        return this.getCapabilities().isSupported("mdx.support.olympicRank");
    }

    public boolean olympicRankSortSupported() {
        return this.getCapabilities().isSupported("mdx.support.olympicRankSort");
    }

    public boolean isCalcMemberNamedSetOrdered() {
        boolean bool = false;
        Boolean propValue = (Boolean)this.getPropertyValue(CALC_MEMBER_NAMED_SET_ORDERED);
        if (propValue != null) {
            bool = propValue;
        }
        return bool;
    }

    public void setCalcMemberNamedSetOrdered() {
        this.setPropertyValue(CALC_MEMBER_NAMED_SET_ORDERED, Boolean.TRUE);
    }

    public List<MDXEdge> getEdgesWithTags() {
        MDXEdge[] mdxEdges = this.getEdges();
        ArrayList<MDXEdge> edgesWithTags = new ArrayList<MDXEdge>();
        for (int i = 0; i < mdxEdges.length; ++i) {
            MDXEdge mdxEdge = mdxEdges[i];
            ArrayList<IXQEQueryNode> tagCollection = new ArrayList<IXQEQueryNode>();
            CollectTreeNodesForCondition.getDescendantTags(tagCollection, mdxEdge);
            if (tagCollection.isEmpty()) continue;
            edgesWithTags.add(mdxEdge);
        }
        return edgesWithTags;
    }

    public boolean isV5SuppressionRequired() {
        return !this.getEdgesWithTags().isEmpty();
    }

    public boolean isYukonProvider() {
        return DataSourceTypeEnum.isYukon(this.getDataSourceType());
    }

    public boolean isPowerCubeProvider() {
        return DataSourceTypeEnum.isPowerCube(this.getDataSourceType());
    }

    public boolean supportFetchingDataWithQueryContext() {
        return this.getCapabilities().isSupported("mdx.pushQueryContextForDataFetching");
    }

    public V5Edge[] getV5Edges() {
        ArrayList<V5Edge> edges = new ArrayList<V5Edge>();
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            IXQEQueryNode child = childIterator.next();
            if (child.getType() != 101049) continue;
            edges.add((V5Edge)child);
        }
        return edges.toArray(new V5Edge[edges.size()]);
    }

    public void setIsRelationalStyleQuery() {
        this.setPropertyValue(PROP_BOOLEAN_IS_RELATIONAL_STYLE_QUERY, Boolean.TRUE);
    }

    public boolean isRelationalStyleQuery() {
        boolean ret = false;
        if (this.getPropertyValue(PROP_BOOLEAN_IS_RELATIONAL_STYLE_QUERY) == Boolean.TRUE) {
            ret = true;
        }
        return ret;
    }

    public boolean isRelationaCrosstab() {
        MDXFromCube fromCube = this.getMDXFrom();
        ICube cube = fromCube.getCube();
        if (!(cube instanceof CubeWrapper)) {
            return false;
        }
        return !this.isDMR() && ((CubeWrapper)cube).getTabularResultSetName() != null;
    }

    private boolean isSuppressNullsWithAutoAggregationMeasureFilter() {
        if (this.isDMR()) {
            IDataSourceCapabilities capabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities(DMR);
            return capabilities.getBooleanValue("v5.suppress.nulls.usePreAutoAggregationMeasureDetailFilter", false);
        }
        return false;
    }

    public boolean isSuppressNullsWithPreAutoAggregationMeasureDetailFiler() {
        if (this.isSuppressNullsWithAutoAggregationMeasureFilter()) {
            CubeWrapper cube = (CubeWrapper)this.getMDXFrom().getCube();
            ArrayList<BaseMember> measures = new ArrayList<BaseMember>();
            List<BaseMember> members = this.collectBaseMeasures();
            for (BaseMember aMeasure : members) {
                IAggregateRule[] aggRules = aMeasure.getMember().getAggregateRules();
                if (aggRules != null && aggRules.length > 0) {
                    return false;
                }
                boolean isDuplicate = false;
                for (IXQEQueryNode iXQEQueryNode : measures) {
                    if (!aMeasure.isSameExpression(iXQEQueryNode, false)) continue;
                    isDuplicate = true;
                    break;
                }
                if (isDuplicate) continue;
                measures.add(aMeasure);
            }
            return this.allFromSameTable(measures, cube);
        }
        return false;
    }

    public boolean isSuppressNullsWithNoMeasure() {
        return this.isSuppressNullsWithAutoAggregationMeasureFilter() && this.collectMeasures().isEmpty();
    }

    private boolean allFromSameTable(List<BaseMember> measures, CubeWrapper cube) {
        if (measures == null || measures.size() == 1 || cube.getRQPPrePlanQuery() == null) {
            return true;
        }
        SetOfTables previousSetOfTables = null;
        for (BaseMember measure : measures) {
            IMember m = measure.getMember();
            ArrayList<IMetadata> queryItems = new ArrayList<IMetadata>();
            queryItems.add(m);
            SetOfTables currentSetOfTables = PrePlanUtilities.getInvolvedTables(cube.getRQPPrePlanQuery(), queryItems, false);
            if (previousSetOfTables == null) {
                previousSetOfTables = currentSetOfTables;
                continue;
            }
            if (previousSetOfTables.equals(currentSetOfTables)) continue;
            return false;
        }
        return true;
    }

    public boolean addRUCogMDXGroupWithBrokenHierarchyLevelOrder(CogMDXGroup group, int warningType) {
        IXQEQueryNode[] ancestorGroups;
        String property;
        Set<CogMDXGroup> groups;
        if (warningType == 1) {
            groups = this.getRaggedGroupsWithBrokenHierarchyLevelOrder();
            property = PROP_HIER_LEVEL_ORDER_IS_BROKEN_FOR_RAGGED;
        } else {
            groups = this.getUnbalancedGroupsWithBrokenHierarchyLevelOrder();
            property = PROP_HIER_LEVEL_ORDER_IS_BROKEN_FOR_UNBALANCED;
        }
        if (groups.contains(group)) {
            return false;
        }
        if (warningType == 1) {
            this.addCogMDXGroupNotRequiringRaggedCompensation(group);
        } else {
            this.addCogMDXGroupNotRequiringUnbalCompensation(group);
        }
        groups.add(group);
        for (IXQEQueryNode ancestorGroup : ancestorGroups = group.getAncestorsOfType(1027)) {
            this.addRUCogMDXGroupWithBrokenHierarchyLevelOrder((CogMDXGroup)ancestorGroup, warningType);
        }
        this.setPropertyValue(property, groups);
        return group.getUnbalancedRaggedOriginalGroup() == null;
    }

    public Set<CogMDXGroup> getRaggedGroupsWithBrokenHierarchyLevelOrder() {
        HashSet groups = (HashSet)this.getPropertyValue(PROP_HIER_LEVEL_ORDER_IS_BROKEN_FOR_RAGGED);
        if (groups == null) {
            groups = new HashSet();
            this.setPropertyValue(PROP_HIER_LEVEL_ORDER_IS_BROKEN_FOR_RAGGED, groups);
        }
        return groups;
    }

    public Set<CogMDXGroup> getUnbalancedGroupsWithBrokenHierarchyLevelOrder() {
        HashSet groups = (HashSet)this.getPropertyValue(PROP_HIER_LEVEL_ORDER_IS_BROKEN_FOR_UNBALANCED);
        if (groups == null) {
            groups = new HashSet();
            this.setPropertyValue(PROP_HIER_LEVEL_ORDER_IS_BROKEN_FOR_UNBALANCED, groups);
        }
        return groups;
    }

    public boolean addCogMDXGroupNotRequiringRaggedCompensation(CogMDXGroup group) {
        Set<CogMDXGroup> groups = this.getCogMDXGroupsNotRequiringRaggedCompensation();
        if (groups.contains(group)) {
            return false;
        }
        groups.add(group);
        IXQEQueryNode[] ancestorGroups = group.getAncestorsOfType(1027);
        IHierarchy groupHierarchy = AbstractRaggedUnbalancedTransformation.getHierarchy(group);
        for (IXQEQueryNode currGroup : ancestorGroups) {
            CogMDXGroup ancestorGroup = (CogMDXGroup)currGroup;
            IHierarchy ancestorHierarchy = AbstractRaggedUnbalancedTransformation.getHierarchy(ancestorGroup);
            if (!ancestorHierarchy.equals(groupHierarchy)) continue;
            ancestorGroup.setRaggedNLevelProperty("compensationNAForRaggedNested");
            this.addCogMDXGroupNotRequiringRaggedCompensation(ancestorGroup);
        }
        this.setPropertyValue(PROP_GROUPS_NOT_REQUIRING_RAGGED_COMP, groups);
        return group.getUnbalancedRaggedOriginalGroup() == null;
    }

    public Set<CogMDXGroup> getCogMDXGroupsNotRequiringRaggedCompensation() {
        HashSet groups = (HashSet)this.getPropertyValue(PROP_GROUPS_NOT_REQUIRING_RAGGED_COMP);
        if (groups == null) {
            groups = new HashSet();
            this.setPropertyValue(PROP_GROUPS_NOT_REQUIRING_RAGGED_COMP, groups);
        }
        return groups;
    }

    public boolean addCogMDXGroupNotRequiringUnbalCompensation(CogMDXGroup group) {
        Set<CogMDXGroup> groups = this.getCogMDXGroupsNotRequiringUnbalCompensation();
        if (groups.contains(group)) {
            return false;
        }
        groups.add(group);
        IXQEQueryNode[] ancestorGroups = group.getAncestorsOfType(1027);
        IHierarchy groupHierarchy = AbstractRaggedUnbalancedTransformation.getHierarchy(group);
        for (IXQEQueryNode ancestorGroup : ancestorGroups) {
            IHierarchy ancestorHierarchy = AbstractRaggedUnbalancedTransformation.getHierarchy((CogMDXGroup)ancestorGroup);
            if (!ancestorHierarchy.equals(groupHierarchy)) continue;
            this.addCogMDXGroupNotRequiringUnbalCompensation((CogMDXGroup)ancestorGroup);
        }
        this.setPropertyValue(PROP_GROUPS_NOT_REQUIRING_UNBAL_COMP, groups);
        return group.getUnbalancedRaggedOriginalGroup() == null;
    }

    public Set<CogMDXGroup> getCogMDXGroupsNotRequiringUnbalCompensation() {
        HashSet groups = (HashSet)this.getPropertyValue(PROP_GROUPS_NOT_REQUIRING_UNBAL_COMP);
        if (groups == null) {
            groups = new HashSet();
            this.setPropertyValue(PROP_GROUPS_NOT_REQUIRING_UNBAL_COMP, groups);
        }
        return groups;
    }

    public boolean isSingleQueryMasterDetail() {
        Object obj = this.getPropertyValue("singleQueryMasterDetail");
        return obj == Boolean.TRUE;
    }

    public void setSingleQueryMasterDetail(boolean isSingleQueryMasterDetail) {
        Boolean prop = Boolean.FALSE;
        if (isSingleQueryMasterDetail) {
            prop = Boolean.TRUE;
        }
        this.setPropertyValue("singleQueryMasterDetail", prop);
    }

    public void setHaveVariableValuesBeenSet(boolean haveVariablesBeenRead) {
        this.setPropertyValue(PROP_VARIABLE_VALUES_SET, haveVariablesBeenRead);
    }

    public boolean getHaveVariableValuesBeenSet() {
        return (Boolean)this.getPropertyValue(PROP_VARIABLE_VALUES_SET);
    }

    public void setNullExpressionBehavior(NullExpressionBehavior behavior) {
        this.setPropertyValue(NULL_EXPRESSION_BEHAVIOR, (Object)behavior);
    }

    public NullExpressionBehavior getNullExpressionBehavior() {
        return (NullExpressionBehavior)((Object)this.getPropertyValue(NULL_EXPRESSION_BEHAVIOR));
    }

    public Boolean hasSupportedRollupTypeOnly() {
        return this.getBooleanPropertyValue(PROP_BOOLEAN_HAS_SUPORTED_ROLLUPAGGREGATE_ONLY);
    }

    public void setSupportedRollupTypeOnly(boolean bool) {
        this.setPropertyValue(PROP_BOOLEAN_HAS_SUPORTED_ROLLUPAGGREGATE_ONLY, bool);
    }

    public boolean isDMR() {
        if (this.getPropertyValue("isDMR") == null) {
            return false;
        }
        return this.getPropertyValue("isDMR").equals(Boolean.TRUE);
    }

    public String datasourceAppliesFilterBeforeMDX() {
        return this.getCapabilities().getStringValue("datasource.appliesFilterBeforeMDX", "never");
    }

    public void setV5QueryHintPropagated() {
        this.setPropertyValue(PROPERTY_V5_QUERY_HINT_PROPAGATED, Boolean.TRUE);
    }

    public boolean isV5QueryHintPropagated() {
        return this.getPropertyValue(PROPERTY_V5_QUERY_HINT_PROPAGATED) == Boolean.TRUE;
    }

    public void setIsConstantQuery() {
        this.setPropertyValue(PROP_IS_CONSTANT_QUERY, Boolean.TRUE);
    }

    public boolean isConstantQuery() {
        return this.getPropertyValue(PROP_IS_CONSTANT_QUERY) == Boolean.TRUE;
    }

    public Map<IXQEQueryNode, MDXLevelInfo> getReportSummaryAggregationLevelInfo() {
        Object result = this.getPropertyValue(PROP_REPORT_SUMMARY_AGGREGATION_LEVEL_INFO);
        if (result != null) {
            return (Map)result;
        }
        return Collections.EMPTY_MAP;
    }

    public void addReportSummaryAggregationLevelInfo(IXQEQueryNode tuple, MDXLevelInfo contextLevel) {
        Object result = this.getPropertyValue(PROP_REPORT_SUMMARY_AGGREGATION_LEVEL_INFO);
        HashMap<IXQEQueryNode, MDXLevelInfo> aggregationLevelInfo = result != null ? (HashMap<IXQEQueryNode, MDXLevelInfo>)result : new HashMap<IXQEQueryNode, MDXLevelInfo>();
        for (MDXLevelInfo l : aggregationLevelInfo.values()) {
            if (!l.compareProjectedLevels(contextLevel)) continue;
            return;
        }
        aggregationLevelInfo.put(tuple, contextLevel);
        this.setPropertyValue(PROP_REPORT_SUMMARY_AGGREGATION_LEVEL_INFO, aggregationLevelInfo);
    }

    public DMRQueryOptimizationInfo getOptimizationInfo() {
        Object result = this.getPropertyValue(PROP_QUERY_OPTIMIZATION_INFO);
        if (result == null) {
            result = new DMRQueryOptimizationInfo();
        }
        return (DMRQueryOptimizationInfo)result;
    }

    public void setOptimizationInfo(DMRQueryOptimizationInfo value) {
        this.setPropertyValue(PROP_QUERY_OPTIMIZATION_INFO, value);
    }

    public List<IMeasure> getInvolvedMeasures() {
        List<BaseMember> baseMembers = this.collectBaseMeasures();
        ArrayList<IMeasure> measures = new ArrayList<IMeasure>();
        for (BaseMember baseMember : baseMembers) {
            IMeasure measure = (IMeasure)baseMember.getMember();
            if (measures.indexOf(measure) != -1) continue;
            measures.add(measure);
        }
        return measures;
    }

    public List<IMeasure> getInvolvedMeasuresAndMeasuresFactDrivenCustomValue() {
        List<IMeasure> rt = this.getInvolvedMeasures();
        ICube cube = this.getReferencedCube();
        if (cube instanceof CubeWrapper) {
            rt.addAll(((CubeWrapper)cube).getMeasuresForCustomValues());
        }
        return rt;
    }

    public List<IQueryItem> getInvolvedLevelPropertyQueryItems() {
        MDXEdge[] edges;
        ArrayList<IQueryItem> rtList = new ArrayList<IQueryItem>();
        for (MDXEdge edge : edges = this.getEdges()) {
            MDXDimensionProperties props = edge.getDimensionProperties();
            List<IQueryItem> items = props.getCustomMemberProperties();
            for (IQueryItem item : items) {
                if (rtList.contains(item)) continue;
                rtList.add(item);
            }
        }
        List<IXQEQueryNode> baseProperties = this.getDescendantsOfTypeOrdered(1025, false);
        for (IXQEQueryNode baseProp : baseProperties) {
            IQueryItem propItem = ((BaseProperty)baseProp).getPropertyMetadata();
            if (propItem == null || rtList.contains(propItem)) continue;
            rtList.add(propItem);
        }
        return rtList;
    }

    public static boolean restrictMultiLevelOverlap(MDXQuery mdxQuery) {
        return mdxQuery.getCapabilities().isSupported("restrictMultiLevelOverlap");
    }

    public void logQueryProcessingType(XQELogger logger) {
        String queryName = this.getV5NameProperty();
        if (queryName == null) {
            queryName = "";
        }
        String theReportName = this.getPlanningEnvironment().getRequestEnvironment().getReportName();
        String queryAndReportNames = "In report " + theReportName + ": " + queryName;
        if (this.getUseLocalQueryProcessing()) {
            logger.log(queryAndReportNames + " executed by LOLAP.");
        } else {
            logger.log(queryAndReportNames + " executed by database.");
        }
    }

    public void addPlannedPrimingQuery(XMdxLocal primingQuery) {
        this.setPropertyValue(PROP_STRING_PLANNED_PRIMING_QUERY, primingQuery);
    }

    public XMdxLocal getPlannedPrimingQuery() {
        Object primingQuery = this.getPropertyValue(PROP_STRING_PLANNED_PRIMING_QUERY);
        if (primingQuery != null) {
            return (XMdxLocal)primingQuery;
        }
        return null;
    }

    public boolean isRemoteDatasourceOLAP() {
        ICube cube = this.getMDXFrom().getCube();
        boolean isRemoteOLAP = false;
        if (cube != null) {
            IModelDataSource modelDataSource = cube.getModelDataSource();
            isRemoteOLAP = modelDataSource.isMultidimensional() && !DataSourceTypeEnum.isROLAP(modelDataSource.getInterface());
        }
        return isRemoteOLAP;
    }

    @Override
    public String[] getSyntaxProperties() {
        return new String[]{PROP_STRING_NULL_SUPPR_QUERY_HINT};
    }

    public void setSAPReplacementVariableIsSet() {
        this.setPropertyValue(PROP_BOOLEAN_IS_SAP_REPLACEMENTVARIABLE_SET, Boolean.TRUE);
    }

    public boolean isSAPReplacementVariableSet() {
        Boolean isSAPReplacementVariableSet = (Boolean)this.getPropertyValue(PROP_BOOLEAN_IS_SAP_REPLACEMENTVARIABLE_SET);
        return isSAPReplacementVariableSet != null && isSAPReplacementVariableSet.equals(Boolean.TRUE);
    }

    public boolean dataSourceRequiresNoMemberDefaultMember() {
        return this.getCapabilities().getBooleanValue("mdx.useNoMemberDefaultMember", false);
    }

    @Override
    protected MDXHierInfo getContextHierarchyInfoForChild(AbstractMDXNode child, AbstractMDXNode contextBoundary) {
        return new MDXHierInfo();
    }

    public List<XMdxProperty> getRequiredProperties() {
        Object properties = this.getPropertyValue(PROP_STRING_REQUIRED_PROPERTIES);
        if (properties != null) {
            return (List)properties;
        }
        return null;
    }

    public void setRequiredProperties(List<XMdxProperty> propertyList) {
        this.setPropertyValue(PROP_STRING_REQUIRED_PROPERTIES, propertyList);
    }

    public boolean hasProjectedCalcsWithHigherSolveOrder(MDXCalculatedMemberReference calc) {
        MDXEdge[] edges;
        MDXCalculatedMemberDefinition definition = calc.getDefinition();
        int solveOrder = definition.getSolveOrder();
        for (MDXEdge edge : edges = this.getEdges()) {
            IXQEQueryNode[] edgeCalcs;
            for (IXQEQueryNode edgeCalcNode : edgeCalcs = edge.getDescendantsOfType(1013, false)) {
                MDXCalculatedMemberReference edgeCalc = (MDXCalculatedMemberReference)edgeCalcNode;
                if (edgeCalc.getDefinition() == definition || edgeCalc.getSolveOrder() <= solveOrder || !edge.isProjectedDescendant(edgeCalc)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public MDXOOMInfo computeOOM(MDXOOMContext context) {
        IXQEQueryNode[] edges;
        MDXOOMInfo ret = MDXOOMInfo.unkownOOM();
        for (IXQEQueryNode e : edges = this.getChildrenOfType(1006)) {
            MDXOOMInfo r = ((AbstractMDXNode)e).computeOOM(context);
            ret = MDXOOMInfo.crossjoinSet(ret, r, false);
        }
        return ret;
    }

    public Map<IHierarchy, Integer> getCountOfMDFandSlicerByHierarchy() {
        HashMap countOfMDFandSlicerByHierarchy = (HashMap)this.getPropertyValue(PROPERTY_COUNT_MDF_AND_SLICER_BY_HIER);
        if (countOfMDFandSlicerByHierarchy == null) {
            countOfMDFandSlicerByHierarchy = new HashMap();
            this.setPropertyValue(PROPERTY_COUNT_MDF_AND_SLICER_BY_HIER, countOfMDFandSlicerByHierarchy);
        }
        return countOfMDFandSlicerByHierarchy;
    }

    public void updateCountOfMDFandSlicerByHierarchy(IHierarchy hieararchy) {
        Map<IHierarchy, Integer> countOfMDFandSlicerByHierarchy = this.getCountOfMDFandSlicerByHierarchy();
        Integer count = countOfMDFandSlicerByHierarchy.get(hieararchy);
        if (count == null) {
            count = XQEIntegerPool.getInteger(0);
        }
        count = count + 1;
        countOfMDFandSlicerByHierarchy.put(hieararchy, count);
    }

    public void setCalcToPrimingModeMap(Map<String, Integer> map) {
        this.calcToPrimingModeMap = map;
    }

    public Map<String, Integer> getCalcToPrimingModeMap() {
        return this.calcToPrimingModeMap;
    }

    public void addEdgeWithCrosstabSpacers(int edgeID) {
        Integer eID;
        ArrayList<Integer> edgeIDs = (ArrayList<Integer>)this.getPropertyValue(PROP_EDGES_WITH_CROSSTAB_SPACERS);
        if (edgeIDs == null) {
            edgeIDs = new ArrayList<Integer>();
        }
        if (!edgeIDs.contains(eID = XQEIntegerPool.getInteger(edgeID))) {
            edgeIDs.add(eID);
        }
        this.setPropertyValue(PROP_EDGES_WITH_CROSSTAB_SPACERS, edgeIDs);
    }

    public boolean containsCrosstabSpacersOnEdge(int edgeID) {
        List edgeIDs = (List)this.getPropertyValue(PROP_EDGES_WITH_CROSSTAB_SPACERS);
        if (edgeIDs == null) {
            return false;
        }
        Integer eID = XQEIntegerPool.getInteger(edgeID);
        return edgeIDs.contains(eID);
    }

    public boolean getDMRDefaultNullSuppression() {
        IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities(DMR);
        return providerCapabilities.getBooleanValue("mdx.suppression.default", true);
    }

    @Override
    public void dump(XQETrace trace, boolean includeRuntimeSpecifics) {
        int i;
        Integer nodeID = -1;
        if (includeRuntimeSpecifics) {
            nodeID = this.getId();
        }
        trace.beginElement(this.getNodeTypeName(), nodeID);
        this.dumpNodeLineage(trace);
        this.dumpProperties(trace);
        this.dumpExtraInfo(trace, includeRuntimeSpecifics);
        ArrayList<String> calcMUNs = new ArrayList<String>();
        IXQEQueryNode[] calcDefs = this.getChildrenOfType(1005);
        if (calcDefs != null && calcDefs.length > 0) {
            for (IXQEQueryNode calcDef : calcDefs) {
                calcMUNs.add(((MDXCalculatedMemberDefinition)calcDef).getUniqueName());
            }
            Collections.sort(calcMUNs);
        }
        int numberChildren = this.getNumberChildren();
        for (i = 0; i < numberChildren && this.getChild(i).getType() != 1005; ++i) {
            this.getChild(i).dump(trace, includeRuntimeSpecifics);
        }
        if (calcDefs != null && calcDefs.length > 0) {
            for (String calcMUN : calcMUNs) {
                for (IXQEQueryNode calcDef : calcDefs) {
                    if (!((MDXCalculatedMemberDefinition)calcDef).getUniqueName().equals(calcMUN)) continue;
                    calcDef.dump(trace, includeRuntimeSpecifics);
                    ++i;
                }
            }
            while (i < numberChildren) {
                this.getChild(i).dump(trace, includeRuntimeSpecifics);
                ++i;
            }
        }
        trace.endElement();
    }

    public MultiRequestContext.RequestProcessing getRequestProcessing() {
        return this.requestProcessing;
    }

    public void setRequestProcessing(MultiRequestContext.RequestProcessing processing) {
        this.requestProcessing = processing;
    }

    public MultiRequestContext.RequestProcessing getQueryProcessingProperty() {
        MultiRequestContext.RequestProcessing propValue = (MultiRequestContext.RequestProcessing)((Object)this.getPropertyValue(PROP_STRING_QUERY_PROCESSING));
        if (propValue == null) {
            return MultiRequestContext.RequestProcessing.DEFAULT;
        }
        return propValue;
    }

    public void setQueryProcessingProperty(String value) {
        if (value == null) {
            this.removeProperty(PROP_STRING_QUERY_PROCESSING);
        }
        String valueUpper = value.toUpperCase();
        if (MultiRequestContext.RequestProcessing.DATABASEONLY.toString().equals(valueUpper)) {
            this.setPropertyValue(PROP_STRING_QUERY_PROCESSING, (Object)MultiRequestContext.RequestProcessing.DATABASEONLY);
        } else if (MultiRequestContext.RequestProcessing.LIMITEDLOCAL.toString().equals(valueUpper)) {
            this.setPropertyValue(PROP_STRING_QUERY_PROCESSING, (Object)MultiRequestContext.RequestProcessing.LIMITEDLOCAL);
        } else if (MultiRequestContext.RequestProcessing.MINIMIZELOCAL.toString().equals(valueUpper)) {
            this.setPropertyValue(PROP_STRING_QUERY_PROCESSING, (Object)MultiRequestContext.RequestProcessing.MINIMIZELOCAL);
        } else {
            this.removeProperty(PROP_STRING_QUERY_PROCESSING);
        }
    }

    public static enum NullExpressionBehavior {
        PPYBEHAVIOR("PPYBehavior"),
        MDXBEHAVIOR("MDXBehavior"),
        SQLBEHAVIOR("SQLBehavior"),
        UNSPECIFIED("UNSPECIFIED"),
        UNKNOWN("UNKNOWN");

        private final String behavior;

        private NullExpressionBehavior(String nullBehavior) {
            this.behavior = nullBehavior;
        }

        public String getName() {
            return this.behavior;
        }

        public static NullExpressionBehavior valueOfV5String(String name) {
            if (name == null || "".equals(name)) {
                return UNKNOWN;
            }
            for (NullExpressionBehavior e : NullExpressionBehavior.values()) {
                if (!e.getName().equals(name)) continue;
                return e;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.behavior;
        }
    }
}

