/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.olap.util.MDXOOMContext;
import com.cognos.xqe.ast.olap.util.MDXOOMInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPool;

public final class MDXRelativeMember
extends AbstractMDXMember {
    public static final String PROPERTY_RELATIVE_MEMBER_FUNCTION = "mdxMemberFunction";
    public static final int PREVMEMBER_FUNCTION = 0;
    public static final int NEXTMEMBER_FUNCTION = 1;
    public static final int FIRSTSIBLING_FUNCTION = 2;
    public static final int LASTSIBLING_FUNCTION = 3;
    public static final int LEAD_FUNCTION = 4;
    public static final int LAG_FUNCTION = 5;

    public MDXRelativeMember() {
        this.setRelativeMemberFunctionProperty(0);
    }

    @Override
    public int getType() {
        return 1034;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1034) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        this.getChild(0).writeFormattedText(buffer);
        buffer.append(".");
        buffer.append(this.getMDXRelativeMemberFunctionName());
        if (this.getNumberChildren() > 1) {
            buffer.append("(");
            this.getChild(1).writeFormattedText(buffer);
            buffer.append(")");
        }
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("apply", -1);
        trace.beginElement(this.getMDRelativeMemberFunctionName(), -1);
        trace.endElement();
        this.getChild(0).dumpFormattedXMLQuery(trace);
        if (this.getNumberChildren() > 1) {
            this.getChild(1).dumpFormattedXMLQuery(trace);
        }
        trace.endElement();
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        int[] categories = new int[]{};
        if (index == 0) {
            categories = new int[]{1022};
        } else if (index == 1 && (this.getRelativeMemberFunctionProperty() == 4 || this.getRelativeMemberFunctionProperty() == 5)) {
            categories = new int[]{1062, 1016};
        }
        return categories;
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXMember)this.getChild(0)).getHierarchyInfo();
    }

    @Override
    protected MDXLevelInfo getLevelInfo(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXMember)this.getChild(0)).getLevelInfo(hierarchy);
    }

    @Override
    public int getMinimumNumberChildren() {
        return 1;
    }

    private String getMDRelativeMemberFunctionName() {
        String mdFunctionName = null;
        int operatorType = this.getRelativeMemberFunctionProperty();
        switch (operatorType) {
            case 0: {
                mdFunctionName = "previousMember";
                break;
            }
            case 1: {
                mdFunctionName = "nextMember";
                break;
            }
            case 2: {
                mdFunctionName = "firstSibling";
                break;
            }
            case 3: {
                mdFunctionName = "lastSibling";
                break;
            }
            case 4: {
                mdFunctionName = "lead";
                break;
            }
            case 5: {
                mdFunctionName = "lag";
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
            }
        }
        return mdFunctionName;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("functionName", this.getMDRelativeMemberFunctionName());
    }

    public int getRelativeMemberFunctionProperty() {
        return (Integer)this.getPropertyValue(PROPERTY_RELATIVE_MEMBER_FUNCTION);
    }

    public void setRelativeMemberFunctionProperty(int type) {
        this.setPropertyValue(PROPERTY_RELATIVE_MEMBER_FUNCTION, XQEIntegerPool.getInteger(type));
    }

    private String getMDXRelativeMemberFunctionName() {
        String mdxFunctionName = null;
        int operatorType = this.getRelativeMemberFunctionProperty();
        switch (operatorType) {
            case 0: {
                mdxFunctionName = "PREVMEMBER";
                break;
            }
            case 1: {
                mdxFunctionName = "NEXTMEMBER";
                break;
            }
            case 2: {
                mdxFunctionName = "FIRSTSIBLING";
                break;
            }
            case 3: {
                mdxFunctionName = "LASTSIBLING";
                break;
            }
            case 4: {
                mdxFunctionName = "LEAD";
                break;
            }
            case 5: {
                mdxFunctionName = "LAG";
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
            }
        }
        return mdxFunctionName;
    }

    @Override
    public String[] getSyntaxProperties() {
        return new String[]{PROPERTY_RELATIVE_MEMBER_FUNCTION};
    }

    @Override
    public MDXOOMInfo computeOOM(MDXOOMContext context) {
        MDXLevelInfo lvlInfo = this.getLevelInfo();
        if (lvlInfo.getHierarchyInfo().getNumberOfNonMeasureHierarchiesProjected() == 1 && lvlInfo.getNumProjectedLevels(lvlInfo.getHierarchyInfo().getProjectedHierarchy(0)) == 1) {
            return MDXOOMInfo.oneMemberFromLevel(lvlInfo.getProjectedLevels(lvlInfo.getHierarchyInfo().getProjectedHierarchy(0)).get(0));
        }
        return MDXOOMInfo.unkownOOM();
    }

    @Override
    public String getMDXTextName() {
        return this.getMDXRelativeMemberFunctionName();
    }
}

