/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueFunction;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.AbstractMDXValueExpression;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.util.ASTUtil;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MDXSummaryFunction
extends AbstractMDXNumericValueFunction {
    public static final String PROP_BOOLEAN_WITHIN_DETAIL_FUNC = "withinDetailFunc";
    public static final String PROPERTY_TYPE = "type";
    public static final String PROP_INTERSECTING_MEASURES = "intersectingMeasures";

    public MDXSummaryFunction() {
        this.setSummaryType(MDXSummaryFunctionTypeEnum.AGGREGATE);
    }

    @Override
    public int getType() {
        return 1060;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1060) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("summaryName", this.getMDSummaryString());
    }

    public MDXSummaryFunctionTypeEnum getSummaryType() {
        MDXSummaryFunctionTypeEnum type = (MDXSummaryFunctionTypeEnum)this.getPropertyValue(PROPERTY_TYPE);
        if (type == null) {
            type = MDXSummaryFunctionTypeEnum.UNDEFINED_SUMMARY_TYPE;
        }
        return type;
    }

    public void setSummaryType(MDXSummaryFunctionTypeEnum type) {
        this.setPropertyValue(PROPERTY_TYPE, type);
    }

    public String getMDXSummaryString() {
        return this.getSummaryType().getMDXKeyword();
    }

    @Override
    public String getMDXTextName() {
        return this.getMDXSummaryString();
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("apply", -1);
        if (this.getCachingId() != 0) {
            trace.attribute("id", this.getCachingId());
        }
        trace.beginElement(this.getMDSummaryString(), -1);
        trace.endElement();
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            childIterator.next().dumpFormattedXMLQuery(trace);
        }
        trace.endElement();
    }

    private String getMDSummaryString() {
        String mdString = null;
        switch (this.getSummaryType()) {
            case AGGREGATE: {
                mdString = "aggregate";
                break;
            }
            case SUM: {
                mdString = "sum";
                break;
            }
            case MINIMUM: {
                mdString = "min";
                break;
            }
            case MAXIMUM: {
                mdString = "max";
                break;
            }
            case AVERAGE: {
                mdString = "avg";
                break;
            }
            case MEDIAN: {
                mdString = "median";
                break;
            }
            case STANDARD_DEVIATION: {
                mdString = "stddev";
                break;
            }
            case STANDARD_DEVIATION_POPULATION: {
                mdString = "stddevp";
                break;
            }
            case VARIANCE: {
                mdString = "var";
                break;
            }
            case VARIANCE_POPULATION: {
                mdString = "varp";
                break;
            }
        }
        return mdString;
    }

    @Override
    public int getMinimumNumberChildren() {
        return 1;
    }

    @Override
    protected void appendContextHierarchyInfoForChild(AbstractMDXNode child, MDXHierInfo parentContextInfo) {
        if (this.getPositionOfChild(child) == 1) {
            MDXHierInfo op1ExprInfo = ((AbstractMDXSet)this.getChild(0)).getHierarchyInfo();
            for (int i = 0; i < op1ExprInfo.getNumProjectedHierarchies(); ++i) {
                IHierarchy hierarchy = op1ExprInfo.getProjectedHierarchy(i);
                if (parentContextInfo.projectsHierarchy(hierarchy)) continue;
                parentContextInfo.appendProjectedHierarchy(hierarchy);
            }
        }
    }

    @Override
    protected MDXLevelInfo getContextLevelInfoForChild(AbstractMDXNode child, AbstractMDXNode contextBoundary, IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        if (!this.isParentOf(child)) {
            this.throwInternalError("!isParentOf(child)");
        }
        if (this.getParent() != null && !this.getParent().isOfCategory(1001)) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
        }
        if (this.getParent() == null && contextBoundary != null && this != contextBoundary) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
        }
        MDXLevelInfo parentContextInfo = null;
        if (this.getPositionOfChild(child) == 1) {
            MDXLevelInfo op1ExprInfo = ((AbstractMDXSet)this.getChild(0)).getLevelInfo(hierarchy);
            if (hierarchy != null && op1ExprInfo.getHierarchyInfo().projectsHierarchy(hierarchy)) {
                return op1ExprInfo;
            }
            parentContextInfo = this.getParent() != null && this != contextBoundary ? ((AbstractMDXNode)this.getParent()).getContextLevelInfoForChild(this, contextBoundary, hierarchy) : new MDXLevelInfo();
            if (hierarchy == null) {
                parentContextInfo.replaceProjectedHierarchies(op1ExprInfo);
            } else if (op1ExprInfo.getHierarchyInfo().projectsHierarchy(hierarchy)) {
                parentContextInfo.replaceProjectedHierarchy(op1ExprInfo, hierarchy);
            }
            return parentContextInfo;
        }
        parentContextInfo = this.getParent() != null && this != contextBoundary ? ((AbstractMDXNode)this.getParent()).getContextLevelInfoForChild(this, contextBoundary, hierarchy) : new MDXLevelInfo();
        return parentContextInfo;
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        int[] categories = index == 0 ? new int[]{1021} : (index == 1 ? new int[]{1061} : new int[]{});
        return categories;
    }

    @Override
    protected void addMemberToContext(IXQENodeFactory factory, IHierarchy hierarchy, AbstractMDXMember member, boolean replaceUnresolvedCurrentMemberRefs, AbstractMDXNode contextBoundary) {
        super.addMemberToContext(factory, hierarchy, member, replaceUnresolvedCurrentMemberRefs, contextBoundary);
        if (this.getNumberChildren() == 2) {
            return;
        }
        MDXHierInfo hierInfo = ((AbstractMDXSet)this.getChild(0)).getHierarchyInfo();
        if (hierInfo.projectsHierarchy(hierarchy)) {
            return;
        }
        if (this.getParent() != null && contextBoundary != this) {
            if (!this.getParent().isOfCategory(1001)) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
            }
            MDXHierInfo contextInfo = ((AbstractMDXNode)this.getParent()).getContextHierarchyInfoForChild(this, contextBoundary);
            if (contextInfo.projectsHierarchy(hierarchy)) {
                return;
            }
        }
        IXQEQueryNode mdxValue = factory.createNode(1059);
        IXQEQueryNode mdxTuple = factory.createNode(1069);
        mdxTuple.addChild(factory.deepCopyNode(member));
        mdxValue.addChild(mdxTuple);
        this.addChild(mdxValue);
    }

    @Override
    public String[] getSyntaxProperties() {
        return new String[]{PROPERTY_TYPE};
    }

    @Override
    public Set<MDXHierInfo> getContextDependentValueExpressionHierarchyInfo(AbstractMDXNode contextBoundary) {
        this.throwOnInvalidChildCategories();
        Set<MDXHierInfo> result = super.getContextDependentValueExpressionHierarchyInfo(contextBoundary);
        if (this.getNumberChildren() == 1) {
            AbstractMDXValueExpression.getContextDependentValueExprHierInfoFromChild(this, contextBoundary, (AbstractMDXNode)this.getChild(0), result);
        }
        return result;
    }

    @Override
    public void getContextDependentValueExpressionLevelInfo(AbstractMDXNode contextBoundary, Set<MDXLevelInfo> result, IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        super.getContextDependentValueExpressionLevelInfo(contextBoundary, result, hierarchy);
        if (this.getNumberChildren() == 1) {
            MDXLevelInfo childLevelInfo = ((AbstractMDXSet)this.getChild(0)).getLevelInfo(hierarchy);
            if (this.getParent() != null && (hierarchy == null || childLevelInfo.isEmpty())) {
                MDXLevelInfo contextLevelInfo = ((AbstractMDXNode)this.getParent()).getContextLevelInfoForChild(this, contextBoundary, hierarchy);
                contextLevelInfo.replaceProjectedHierarchies(childLevelInfo);
                result.add(contextLevelInfo);
            } else {
                result.add(childLevelInfo);
            }
        }
    }

    @Override
    public boolean isAssociativeSummaryFunction() {
        return MDXSummaryFunction.isAssociativeSummaryFunction(this.getSummaryType());
    }

    public static boolean isAssociativeSummaryFunction(MDXSummaryFunctionTypeEnum sType) {
        if (sType == null) {
            return false;
        }
        switch (sType) {
            case SUM: 
            case MINIMUM: 
            case MAXIMUM: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setIsWithinDetailCalc(boolean bool) {
        this.setPropertyValue(PROP_BOOLEAN_WITHIN_DETAIL_FUNC, bool);
    }

    @Override
    public boolean isWithinDetailCalc() {
        return Boolean.TRUE.equals(this.getPropertyValue(PROP_BOOLEAN_WITHIN_DETAIL_FUNC));
    }

    public void applyMeasureRollupAggregate(IXQENodeFactory nodeFactory) {
        if (this.getNumberChildren() < 2) {
            return;
        }
        AbstractMDXNode valueExpression = (AbstractMDXNode)this.getChild(1);
        V5RollupAggregateEnum rollupAggregate = valueExpression.getRollupAggregate();
        this.validateRollupAggregate(valueExpression, rollupAggregate);
        if (rollupAggregate == V5RollupAggregateEnum.COUNT) {
            IXQEQueryNode mdxIsEmpty = nodeFactory.createNode(1104);
            this.getChild(1).insertParent(mdxIsEmpty);
            IXQEQueryNode mdxIIF = nodeFactory.createNode(1085);
            this.getChild(1).insertParent(mdxIIF);
            mdxIIF.addChild(MDXBuilder.buildMDXNumericConstant(nodeFactory, 0));
            mdxIIF.addChild(MDXBuilder.buildMDXNumericConstant(nodeFactory, 1));
            this.setPropertyValue("FORMAT_STRING", "#");
            this.setSummaryType(MDXSummaryFunctionTypeEnum.SUM);
        } else {
            this.setSummaryType(MDXSummaryFunctionTypeEnum.convertRollupAggregateToMDXSummaryFunctionType(rollupAggregate));
        }
    }

    public static boolean isValidRollupAggregate(AbstractMDXNode valueExpression, V5RollupAggregateEnum rollupAggregate) {
        boolean validAggregate = true;
        if (rollupAggregate == V5RollupAggregateEnum.UNDEFINED) {
            return validAggregate;
        }
        boolean nonNumericExpression = false;
        if (rollupAggregate != V5RollupAggregateEnum.UNDEFINED) {
            boolean isMeasure = valueExpression.getType() == 1067 && ((BaseMember)valueExpression).isMeasure();
            boolean bl = nonNumericExpression = !isMeasure && !V5ToCogMDXUtilities.isCoercableToNumericValueExpression(valueExpression);
        }
        if (nonNumericExpression && rollupAggregate != V5RollupAggregateEnum.COUNT || rollupAggregate == V5RollupAggregateEnum.NONE) {
            MDXQuery mdxQuery = (MDXQuery)valueExpression.getAncestorOfType(1002);
            if (mdxQuery == null || !mdxQuery.isListReport()) {
                validAggregate = false;
            } else if (valueExpression.getNumberChildren() == 1) {
                IXQEQueryNode tuple = valueExpression.getChild(0);
                if (tuple.getType() != 1069 || tuple.getChild(0).getType() != 1013 || !((MDXCalculatedMemberReference)tuple.getChild(0)).isReportSummary()) {
                    validAggregate = false;
                }
            } else {
                validAggregate = false;
            }
        }
        return validAggregate;
    }

    private void validateRollupAggregate(AbstractMDXNode valueExpression, V5RollupAggregateEnum rollupAggregate) {
        if (!MDXSummaryFunction.isValidRollupAggregate(valueExpression, rollupAggregate)) {
            V5DataItem dataItem = (V5DataItem)ASTUtil.getFirstNodeOfTypeFromAncestorQueryLineage(valueExpression, 101003);
            String param = null;
            param = dataItem == null ? "" : dataItem.getNameProperty();
            boolean nonNumericExpression = false;
            if (rollupAggregate != V5RollupAggregateEnum.UNDEFINED) {
                boolean isMeasure = valueExpression.getType() == 1067 && ((BaseMember)valueExpression).isMeasure();
                boolean bl = nonNumericExpression = !isMeasure && !V5ToCogMDXUtilities.isCoercableToNumericValueExpression(valueExpression);
            }
            if (nonNumericExpression) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedAggregationNonMeasureDataItem, rollupAggregate.getName(), param);
            }
            throw new XQERuntimeException(XQEMessageKeys.PLN_AggregationTypeNone, rollupAggregate.getName(), param);
        }
    }

    public void setIntersectingMeasures(Set<AbstractMDXMember> intersectingMeasures) {
        this.setPropertyValue(PROP_INTERSECTING_MEASURES, intersectingMeasures);
    }

    public Set<AbstractMDXMember> getIntersectingMeasures() {
        HashSet intersectingMeasures = (HashSet)this.getPropertyValue(PROP_INTERSECTING_MEASURES);
        if (intersectingMeasures == null) {
            intersectingMeasures = new HashSet();
        }
        return intersectingMeasures;
    }

    public boolean hasExplicitMeasureContext() {
        boolean measureContext = false;
        if (this.getNumberChildren() == 2) {
            AbstractMDXValueExpression valueExpr = (AbstractMDXValueExpression)this.getChild(1);
            MDXHierInfo secondChildHierInfo = valueExpr.getResolvedHierarchyInfo(valueExpr);
            measureContext = secondChildHierInfo.projectsMeasures();
        }
        return measureContext;
    }

    @Override
    protected boolean isContextDependent(IHierarchy hierarchy, AbstractMDXNode contextBoundary) {
        MDXHierInfo hierInfo;
        this.throwOnInvalidChildCategories();
        boolean result = super.isContextDependent(hierarchy, contextBoundary);
        if (result) {
            return result;
        }
        if (this.getNumberChildren() == 1 && !(hierInfo = ((AbstractMDXSet)this.getChild(0)).getHierarchyInfo()).projectsHierarchy(hierarchy)) {
            if (contextBoundary == this) {
                return true;
            }
            if (this.getParent() != null) {
                hierInfo.unionHierInfo(((AbstractMDXNode)this.getParent()).getContextHierarchyInfoForChild(this, contextBoundary));
                if (!hierInfo.projectsHierarchy(hierarchy)) {
                    return true;
                }
            }
        }
        return result;
    }

    @Override
    protected boolean isContextDependent(AbstractMDXNode contextBoundary) {
        this.throwOnInvalidChildCategories();
        return super.isContextDependent(contextBoundary) || this.getNumberChildren() == 1;
    }

    public BaseMember getExplicitMeasureInValueExpression() {
        BaseMember foundMeasure = null;
        if (this.getNumberChildren() < 2) {
            return foundMeasure;
        }
        IXQEQueryNode[] refBaseMembers = this.getChild(1).getDescendantsOfType(1067, false);
        for (int j = 0; j < refBaseMembers.length; ++j) {
            BaseMember member = (BaseMember)refBaseMembers[j];
            if (!member.getHierarchy().getDimension().isMeasuresDimension()) continue;
            if (foundMeasure == null) {
                foundMeasure = member;
                continue;
            }
            if (foundMeasure == member) continue;
            return null;
        }
        return foundMeasure;
    }

    public boolean isSlicerCalcIntersectingWithSeveralProjCalc() {
        Boolean prop = this.getBooleanPropertyValue("IntersectsWithSeveralCalcs");
        return prop != null && prop != false;
    }

    public void setSlicerCalcIntersectingWithSeveralProjCalc(boolean prop) {
        if (prop) {
            this.setPropertyValue("IntersectsWithSeveralCalcs", true);
        } else if (this.getPropertyValue("IntersectsWithSeveralCalcs") != null) {
            this.removeProperty("IntersectsWithSeveralCalcs");
        }
    }
}

