/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueExpression;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.AbstractMDXSetOperator;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.olap.util.MDXOOMContext;
import com.cognos.xqe.ast.olap.util.MDXOOMInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.msas.msas2005.multihier.MultiHierUtil;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class MDXTopBottomFunction
extends AbstractMDXSetOperator {
    protected static final String PROPERTY_FUNCTION_TYPE = "functionType";
    protected static final String PROPERTY_FUNCTION_NAME = "functionName";
    public static final int TOPCOUNT = 1;
    public static final int TOPSUM = 2;
    public static final int TOPPERCENT = 3;
    public static final int BOTTOMCOUNT = 4;
    public static final int BOTTOMSUM = 5;
    public static final int BOTTOMPERCENT = 6;
    private static final int MIN_NUM_ARGS = 2;

    @Override
    public int getType() {
        return 1041;
    }

    public int getOperatorType() {
        return (Integer)this.getPropertyValue(PROPERTY_FUNCTION_TYPE);
    }

    public void setOperatorType(int type) {
        this.setPropertyValue(PROPERTY_FUNCTION_TYPE, XQEIntegerPool.getInteger(type));
    }

    public void setOperatorType(String mdxFunctionName) {
        int operatorType = -1;
        if (mdxFunctionName.equals("TOPCOUNT")) {
            operatorType = 1;
        } else if (mdxFunctionName.equals("TOPSUM")) {
            operatorType = 2;
        } else if (mdxFunctionName.equals("TOPPERCENT")) {
            operatorType = 3;
        } else if (mdxFunctionName.equals("BOTTOMCOUNT")) {
            operatorType = 4;
        } else if (mdxFunctionName.equals("BOTTOMSUM")) {
            operatorType = 5;
        } else if (mdxFunctionName.equals("BOTTOMPERCENT")) {
            operatorType = 6;
        } else {
            this.throwInternalError("Invalid operator type.");
        }
        this.setPropertyValue(PROPERTY_FUNCTION_TYPE, XQEIntegerPool.getInteger(operatorType));
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1041) {
            return true;
        }
        return super.isOfCategory(category);
    }

    private String getOperatorTypeString() {
        String operatorTypeString = null;
        int operatorType = this.getOperatorType();
        switch (operatorType) {
            case 1: {
                operatorTypeString = "topCountSet";
                break;
            }
            case 2: {
                operatorTypeString = "topSumSet";
                break;
            }
            case 3: {
                operatorTypeString = "topPercentSet";
                break;
            }
            case 4: {
                operatorTypeString = "bottomCountSet";
                break;
            }
            case 5: {
                operatorTypeString = "bottomSumSet";
                break;
            }
            case 6: {
                operatorTypeString = "bottomPercentSet";
                break;
            }
        }
        return operatorTypeString;
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("apply", -1);
        if (this.getCachingId() != 0) {
            trace.attribute("id", this.getCachingId());
        }
        trace.beginElement(this.getOperatorTypeString(), -1);
        trace.endElement();
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            childIterator.next().dumpFormattedXMLQuery(trace);
        }
        trace.endElement();
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(PROPERTY_FUNCTION_NAME, this.getOperatorTypeString());
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        int[] categories = null;
        categories = index == 0 ? new int[]{1021} : (index == 1 ? new int[]{1062} : (index == 2 ? new int[]{1062, 1016} : new int[]{}));
        return categories;
    }

    private String getMDXString() {
        String operatorTypeString = null;
        int operatorType = this.getOperatorType();
        switch (operatorType) {
            case 1: {
                operatorTypeString = "TOPCOUNT";
                break;
            }
            case 2: {
                operatorTypeString = "TOPSUM";
                break;
            }
            case 3: {
                operatorTypeString = "TOPPERCENT";
                break;
            }
            case 4: {
                operatorTypeString = "BOTTOMCOUNT";
                break;
            }
            case 5: {
                operatorTypeString = "BOTTOMSUM";
                break;
            }
            case 6: {
                operatorTypeString = "BOTTOMPERCENT";
                break;
            }
        }
        return operatorTypeString;
    }

    @Override
    public String getMDXTextName() {
        return this.getMDXString();
    }

    @Override
    public int getMinimumNumberChildren() {
        return 2;
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXSet)this.getChild(0)).getHierarchyInfo();
    }

    @Override
    protected MDXLevelInfo getLevelInfo(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXSet)this.getChild(0)).getLevelInfo(hierarchy);
    }

    @Override
    protected void appendContextHierarchyInfoForChild(AbstractMDXNode child, MDXHierInfo parentContextInfo) {
        if (this.getPositionOfChild(child) != 0) {
            MDXHierInfo op1HierInfo = ((AbstractMDXSet)this.getChild(0)).getHierarchyInfo();
            for (int i = 0; i < op1HierInfo.getNumProjectedHierarchies(); ++i) {
                IHierarchy hierarchy = op1HierInfo.getProjectedHierarchy(i);
                if (parentContextInfo.projectsHierarchy(hierarchy)) continue;
                parentContextInfo.appendProjectedHierarchy(hierarchy);
            }
        }
    }

    @Override
    protected MDXLevelInfo getContextLevelInfoForChild(AbstractMDXNode child, AbstractMDXNode contextBoundary, IHierarchy hierarchy) {
        if (!this.validateChildCategories() || !this.isParentOf(child)) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
        }
        if (this.getParent() != null && !this.getParent().isOfCategory(1001)) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
        }
        if (this.getParent() == null && contextBoundary != null && this != contextBoundary) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
        }
        MDXLevelInfo parentContextInfo = null;
        if (this.getPositionOfChild(child) != 0) {
            MDXLevelInfo op1ExprInfo = ((AbstractMDXSet)this.getChild(0)).getLevelInfo(hierarchy);
            if (hierarchy != null && op1ExprInfo.getHierarchyInfo().projectsHierarchy(hierarchy)) {
                return op1ExprInfo;
            }
            parentContextInfo = this.getParent() != null && this != contextBoundary ? ((AbstractMDXNode)this.getParent()).getContextLevelInfoForChild(this, contextBoundary, hierarchy) : new MDXLevelInfo();
            if (hierarchy == null) {
                parentContextInfo.replaceProjectedHierarchies(op1ExprInfo);
            } else if (op1ExprInfo.getHierarchyInfo().projectsHierarchy(hierarchy)) {
                parentContextInfo.replaceProjectedHierarchy(op1ExprInfo, hierarchy);
            }
            return parentContextInfo;
        }
        parentContextInfo = this.getParent() != null && this != contextBoundary ? ((AbstractMDXNode)this.getParent()).getContextLevelInfoForChild(this, contextBoundary, hierarchy) : new MDXLevelInfo();
        return parentContextInfo;
    }

    @Override
    public boolean isFilteringOperator(boolean includeMDXIntersectAndMDXExcept) {
        return true;
    }

    @Override
    public boolean isNotReplaceableWithHierarchize() {
        return true;
    }

    @Override
    public boolean projectsDuplicates() {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXSet)this.getChild(0)).projectsDuplicates();
    }

    @Override
    public boolean isHierarchized() {
        return this.projectsAtMostOneTuple();
    }

    @Override
    public boolean projectsAtMostOneTuple() {
        this.throwOnInvalidChildCategories();
        if (((AbstractMDXSet)this.getChild(0)).projectsAtMostOneTuple()) {
            return true;
        }
        return this.getChild(1).getType() == 1064 && ((MDXNumericConstant)this.getChild(1)).getConstantValue() instanceof Integer && (Integer)((MDXNumericConstant)this.getChild(1)).getConstantValue() <= 1;
    }

    @Override
    public String[] getSyntaxProperties() {
        return new String[]{PROPERTY_FUNCTION_TYPE};
    }

    @Override
    public boolean couldResolveToEmptySet(boolean ignoreTags, boolean ignoreRaggedUnbalanced, boolean ignoreNonEmpty) {
        this.throwOnInvalidChildCategories();
        if (((AbstractMDXSet)this.getChild(0)).couldResolveToEmptySet(ignoreTags, ignoreRaggedUnbalanced, ignoreNonEmpty)) {
            return true;
        }
        if (!((AbstractMDXNumericValueExpression)this.getChild(1)).couldResolveToZero()) {
            return this.couldResolveToEmptySetForProvider(ignoreNonEmpty);
        }
        return true;
    }

    @Override
    public boolean projectsOnlyAscendantsOrDescendantsOfCurrentMember(boolean ignoreCalculatedMembers) {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXSet)this.getChild(0)).projectsOnlyAscendantsOrDescendantsOfCurrentMember(true);
    }

    @Override
    public boolean areIntersectingProjDescendants(AbstractMDXNode node1, AbstractMDXNode node2) {
        return this.areIntersectingProjDescendantsOfFirstChild(node1, node2);
    }

    @Override
    protected void addMemberToContext(IXQENodeFactory factory, IHierarchy hierarchy, AbstractMDXMember member, boolean replaceUnresolvedCurrentMemberRefs, AbstractMDXNode contextBoundary) {
        this.throwOnInvalidChildCategories();
        MultiHierUtil.addMemberToContext(this, factory, hierarchy, member, replaceUnresolvedCurrentMemberRefs, contextBoundary);
        super.addMemberToContext(factory, hierarchy, member, replaceUnresolvedCurrentMemberRefs, contextBoundary);
    }

    @Override
    protected void appendProjectedCalculatedMembers(List<MDXCalculatedMemberReference> calcMembers) {
        ((AbstractMDXSet)this.getChild(0)).appendProjectedCalculatedMembers(calcMembers);
    }

    @Override
    public MDXOOMInfo computeOOM(MDXOOMContext context) {
        MDXOOMInfo ret = MDXOOMInfo.unkownOOM();
        IXQEQueryNode[] children = this.getChildrenOfCategory(1001);
        if (children[0] instanceof AbstractMDXNode) {
            int t;
            if (!context.getProviderType().equalsIgnoreCase("dmr") && ((t = this.getOperatorType()) == 1 || t == 4) && children[1] instanceof MDXNumericConstant && ((MDXNumericConstant)children[1]).getConstantValue() instanceof Integer) {
                Integer n = (Integer)((MDXNumericConstant)children[1]).getConstantValue();
                MDXLevelInfo lvls = ((AbstractMDXNode)children[0]).getLevelInfo();
                HashMap<ILevel, Double> mp = null;
                if (lvls.getHierarchyInfo().getNumProjectedHierarchies() == 1) {
                    IHierarchy h = lvls.getHierarchyInfo().getProjectedHierarchy(0);
                    List<ILevel> ls = lvls.getProjectedLevels(h);
                    mp = new HashMap<ILevel, Double>();
                    for (ILevel l : ls) {
                        mp.put(l, Double.valueOf(n / ls.size()));
                    }
                }
                ret = MDXOOMInfo.createOOMInfo(n.intValue(), mp);
                return ret;
            }
            ret = ((AbstractMDXNode)children[0]).computeOOM(context);
        }
        return ret;
    }
}

