/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap.util;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.transformation.v5tocogmdx.hierarchynormalization.NormalizeEdgeHierarchies;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class MDXHierInfo {
    protected List<IHierarchy> projectedHierarchies = new ArrayList<IHierarchy>();

    public int getNumProjectedHierarchies() {
        return this.projectedHierarchies.size();
    }

    public IHierarchy getProjectedHierarchy(int index) {
        if (index > this.projectedHierarchies.size() - 1) {
            return null;
        }
        return this.projectedHierarchies.get(index);
    }

    public int getProjectedHierarchyIndex(IHierarchy hierarchy) {
        int index;
        if (!this.projectsHierarchy(hierarchy)) {
            throw new XQERuntimeException(XQEMessageKeys.MDX_InvalidHierArgument);
        }
        for (index = 0; index < this.projectedHierarchies.size() && !this.projectedHierarchies.get(index).equals(hierarchy); ++index) {
        }
        return index;
    }

    public List<IHierarchy> getProjectedHierarchies() {
        return Collections.unmodifiableList(this.projectedHierarchies);
    }

    public void clearProjectedHierarchies() {
        this.projectedHierarchies.clear();
    }

    public void removeProjectedHierarchy(IHierarchy hierarchy) {
        if (hierarchy == null) {
            throw new XQERuntimeException(XQEMessageKeys.MDX_InvalidHierArgument);
        }
        if (!this.projectedHierarchies.contains(hierarchy)) {
            throw new XQERuntimeException(XQEMessageKeys.MDX_HierNotProjected);
        }
        this.projectedHierarchies.remove(hierarchy);
    }

    public void appendProjectedHierarchies(MDXHierInfo mdxHierInfo) {
        for (int i = 0; i < mdxHierInfo.getNumProjectedHierarchies(); ++i) {
            IHierarchy hierarchy = mdxHierInfo.getProjectedHierarchy(i);
            if (this.projectsHierarchy(hierarchy)) {
                throw new XQERuntimeException(XQEMessageKeys.MDX_HierAlreadyProjected);
            }
            this.projectedHierarchies.add(hierarchy);
        }
    }

    public void appendNewProjectedHierarchies(MDXHierInfo mdxHierInfo) {
        for (IHierarchy hierarchy : mdxHierInfo.getProjectedHierarchies()) {
            if (this.projectsHierarchy(hierarchy)) continue;
            this.projectedHierarchies.add(hierarchy);
        }
    }

    public void appendProjectedHierarchy(IHierarchy hierarchy) {
        if (hierarchy == null) {
            throw new XQERuntimeException(XQEMessageKeys.MDX_InvalidHierArgument);
        }
        if (this.projectsHierarchy(hierarchy)) {
            throw new XQERuntimeException(XQEMessageKeys.MDX_HierAlreadyProjected);
        }
        this.projectedHierarchies.add(hierarchy);
    }

    public boolean compareProjectedHierarchies(MDXHierInfo mdxHierInfo) {
        return this.projectedHierarchies.equals(mdxHierInfo.projectedHierarchies);
    }

    public boolean projectsHierarchy(IHierarchy hierarchy) {
        if (hierarchy == null) {
            throw new XQERuntimeException(XQEMessageKeys.MDX_InvalidHierArgument);
        }
        return this.projectedHierarchies.contains(hierarchy);
    }

    public boolean projectsHierarchies(MDXHierInfo mdxHierInfo) {
        for (IHierarchy hierarchy : mdxHierInfo.getProjectedHierarchies()) {
            if (this.projectedHierarchies.contains(hierarchy)) continue;
            return false;
        }
        return true;
    }

    public boolean projectedHierarchiesOverlap(MDXHierInfo mdxHierInfo) {
        for (IHierarchy hierarchy : this.projectedHierarchies) {
            if (!mdxHierInfo.projectedHierarchies.contains(hierarchy)) continue;
            return true;
        }
        return false;
    }

    public boolean isBalancedAndEquivalentHierarchies(MDXHierInfo siblingHierInfo, boolean tolerateShellLeaf) {
        if (this.equals(siblingHierInfo)) {
            return true;
        }
        if (!this.projectsShellHierarchy() && !siblingHierInfo.projectsShellHierarchy()) {
            return false;
        }
        boolean status = NormalizeEdgeHierarchies.compareHierInfoWithDummyHierarchies(this, siblingHierInfo, tolerateShellLeaf);
        return status;
    }

    public boolean hasSingleValidShell(MDXHierInfo siblingHierInfo) {
        boolean status = false;
        if (this.projectedHierarchies.size() == 1 && this.projectedHierarchies.get(0).isShell()) {
            List<IHierarchy> siblingProjHierarchies = siblingHierInfo.getProjectedHierarchies();
            IHierarchy shellHierarchy = this.projectedHierarchies.get(0);
            IHierarchy hierarchy = siblingProjHierarchies.get(0);
            if (hierarchy.isShell() && hierarchy.equals(shellHierarchy)) {
                status = true;
            } else if (!hierarchy.isShell()) {
                int i;
                for (i = 1; i < siblingProjHierarchies.size() && !(hierarchy = siblingProjHierarchies.get(i)).isShell(); ++i) {
                }
                if (i == siblingProjHierarchies.size()) {
                    status = true;
                }
            }
        }
        return status;
    }

    public MDXHierInfo intersectHierInfo(MDXHierInfo mdxHierInfo) {
        MDXHierInfo intersectingHierInfo = new MDXHierInfo();
        for (IHierarchy hierarchy : this.projectedHierarchies) {
            if (!mdxHierInfo.projectsHierarchy(hierarchy)) continue;
            intersectingHierInfo.appendProjectedHierarchy(hierarchy);
        }
        return intersectingHierInfo;
    }

    public void unionHierInfo(MDXHierInfo mdxHierInfo) {
        for (int i = 0; i < mdxHierInfo.getNumProjectedHierarchies(); ++i) {
            IHierarchy hierarchy = mdxHierInfo.getProjectedHierarchy(i);
            if (this.projectsHierarchy(hierarchy)) continue;
            this.appendProjectedHierarchy(hierarchy);
        }
    }

    public MDXHierInfo extractHierInfo(MDXHierInfo mdxHierInfo) {
        MDXHierInfo extracted = new MDXHierInfo();
        for (int i = 0; i < mdxHierInfo.getNumProjectedHierarchies(); ++i) {
            IHierarchy hierarchy = mdxHierInfo.getProjectedHierarchy(i);
            if (!this.projectsHierarchy(hierarchy)) continue;
            this.removeProjectedHierarchy(hierarchy);
            extracted.appendProjectedHierarchy(hierarchy);
        }
        return extracted;
    }

    public int hashCode() {
        int hashCode = 0;
        Iterator<IHierarchy> hierarchyIterator = this.projectedHierarchies.iterator();
        int shift = 1;
        int increment = 10;
        while (hierarchyIterator.hasNext()) {
            IHierarchy hierarchy = hierarchyIterator.next();
            hashCode += hierarchy.hashCode() * shift;
            shift += 10;
        }
        return hashCode;
    }

    public boolean equals(MDXHierInfo mdxHierInfo) {
        return mdxHierInfo != null ? this.hashCode() == mdxHierInfo.hashCode() : false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MDXHierInfo) {
            return this.equals((MDXHierInfo)obj);
        }
        return super.equals(obj);
    }

    public boolean projectsShellHierarchy() {
        IHierarchy hierarchy;
        int i = 0;
        for (i = 0; i < this.getNumProjectedHierarchies() && !(hierarchy = this.getProjectedHierarchy(i)).isShell(); ++i) {
        }
        return i != this.getNumProjectedHierarchies();
    }

    public boolean replaceProjectedHierarchy(IHierarchy oldHierarchy, IHierarchy newHierarchy) {
        boolean success = false;
        for (int i = 0; i < this.getNumProjectedHierarchies(); ++i) {
            IHierarchy hierarchy = this.getProjectedHierarchy(i);
            if (!hierarchy.equals(oldHierarchy)) continue;
            this.projectedHierarchies.remove(i);
            this.projectedHierarchies.add(i, newHierarchy);
            success = true;
            break;
        }
        return success;
    }

    public String toString() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(".") + 1);
        StringBuilder buffer = new StringBuilder();
        buffer.append(className);
        buffer.append(" : {");
        for (int i = 0; i < this.getNumProjectedHierarchies(); ++i) {
            IHierarchy currHierarchy = this.getProjectedHierarchy(i);
            buffer.append(currHierarchy.getName());
            if (i < this.getNumProjectedHierarchies() - 1) {
                buffer.append(", ");
                continue;
            }
            buffer.append("}");
        }
        return buffer.toString();
    }

    public boolean projectsMeasures() {
        for (IHierarchy hierarchy : this.projectedHierarchies) {
            if (!hierarchy.getDimension().isMeasuresDimension()) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfNonMeasureHierarchiesProjected() {
        int result = 0;
        for (IHierarchy hierarchy : this.projectedHierarchies) {
            if (hierarchy.getDimension().isMeasuresDimension()) continue;
            ++result;
        }
        return result;
    }

    public boolean projectsSameDimensionDiffHierarchy(IHierarchy hierarchy) {
        if (hierarchy == null) {
            throw new XQERuntimeException(XQEMessageKeys.MDX_InvalidHierArgument);
        }
        for (IHierarchy nextHier : this.projectedHierarchies) {
            if (nextHier.equals(hierarchy) || !nextHier.getDimension().equals(hierarchy.getDimension())) continue;
            return true;
        }
        return false;
    }

    public void removeHierarchiesFromOtherDimensions(IDimension dimension) {
        int i = 0;
        while (i < this.projectedHierarchies.size()) {
            IHierarchy compareHier = this.projectedHierarchies.get(i);
            if (compareHier.getDimension() != dimension) {
                this.projectedHierarchies.remove(i);
                continue;
            }
            ++i;
        }
    }

    public boolean projectsTimeDimension() {
        for (int i = 0; i < this.projectedHierarchies.size(); ++i) {
            IHierarchy projectedHier = this.projectedHierarchies.get(i);
            if (!projectedHier.getDimension().isTimeDimension()) continue;
            return true;
        }
        return false;
    }

    public MDXHierInfo mergeHierInfo(MDXHierInfo otherHierInfo) {
        MDXHierInfo resultHierInfo = new MDXHierInfo();
        if (this.compareProjectedHierarchies(otherHierInfo)) {
            resultHierInfo.appendProjectedHierarchies(this);
            return resultHierInfo;
        }
        List<IHierarchy> otherHiers = otherHierInfo.getProjectedHierarchies();
        List<IHierarchy> thisHiers = this.getProjectedHierarchies();
        ArrayList<IHierarchy> newPatternHiers = new ArrayList<IHierarchy>();
        newPatternHiers.addAll(thisHiers);
        ArrayList<IHierarchy> toInsert = new ArrayList<IHierarchy>();
        for (IHierarchy currHier : otherHiers) {
            int pos = thisHiers.indexOf(currHier);
            if (pos == -1) {
                toInsert.add(currHier);
                continue;
            }
            if (toInsert.isEmpty()) continue;
            newPatternHiers.addAll(pos, toInsert);
            toInsert.clear();
        }
        if (!toInsert.isEmpty()) {
            newPatternHiers.addAll(toInsert);
        }
        for (IHierarchy hier : newPatternHiers) {
            resultHierInfo.appendProjectedHierarchy(hier);
        }
        return resultHierInfo;
    }
}

