/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.rqp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryItem;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.IDbMeasureDimension;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.OData.ODataUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPNameGenerator;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.SummaryQuerySubjectUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserQueryItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class RMQueryItemList
extends RQPNode {
    private static final String PROP_SEARCH_BY_ID = "searchByID";
    private Map<String, RMQueryItem> mItemMap;

    RMQueryItemList() {
    }

    @Override
    public int getType() {
        return 801034;
    }

    public void deployRMQueryItemList(IQuerySubject querySubject, PlanningEnvironment environment) {
        if (!this.hasChildOfType(801033)) {
            this.createRMQueryItems(querySubject, environment);
        }
    }

    public RMQueryItem getRMQueryItem(V5BoundModelIdentifier v5Identifier) {
        IAccessedViaShortcut ascParent;
        boolean bSearchByID = Boolean.TRUE == this.getPropertyValue(PROP_SEARCH_BY_ID);
        IMetadata metadataObj = v5Identifier.getMetadata();
        String srcUniqueId = null;
        srcUniqueId = bSearchByID ? metadataObj.getID() : metadataObj.getV5UniqueName();
        IMetadata parent = metadataObj.getParentObject();
        if (!bSearchByID && parent instanceof IDbMeasureDimension && parent instanceof IAccessedViaShortcut && (ascParent = (IAccessedViaShortcut)parent).isAccessedViaShortcut()) {
            IShortcut shortcut = ascParent.getShortcut();
            parent = shortcut.getTarget();
            srcUniqueId = UniqueNameGenerator.appendUniqueName(parent.getV5UniqueName(), metadataObj.getName());
        }
        return this.mItemMap.get(srcUniqueId);
    }

    private void createNameToItemMap(boolean bSearchByID) {
        this.mItemMap = new HashMap<String, RMQueryItem>(this.getNumberChildren());
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            IXQEQueryNode child = this.getChild(i);
            if (child.getNodeType() != 801033) continue;
            RMQueryItem rmQueryItem = (RMQueryItem)child;
            String uniqueId = null;
            uniqueId = bSearchByID ? rmQueryItem.getID() : rmQueryItem.getV5UniqueName();
            this.mItemMap.put(uniqueId, rmQueryItem);
        }
    }

    private void createRMQueryItems(IQuerySubject querySubject, PlanningEnvironment environment) {
        int pos = 1;
        HashSet<String> seenAlias = new HashSet<String>();
        for (IMetadata qi : querySubject.getQueryItemsAndMeasures()) {
            RMQueryItem rmQueryItem = (RMQueryItem)environment.getNodeFactory().createNode(801033);
            this.addChild(rmQueryItem);
            rmQueryItem.setQueryItem(qi);
            String preferredAlias = "C" + pos++;
            String itmName = RQPNameGenerator.generateUniqueAliasQueryItem(rmQueryItem.getQueryItem());
            for (int i = 1; i < 10000 && seenAlias.contains(preferredAlias); ++i) {
                preferredAlias = preferredAlias + "_" + i;
            }
            seenAlias.add(itmName);
            seenAlias.add(preferredAlias);
            rmQueryItem.setPropertyValue("preferredAlias", preferredAlias);
            if (!(qi instanceof IQueryItem)) continue;
            IQueryItem queryItem = (IQueryItem)qi;
            IXQEQueryNode v5ValueExpression = RQPUtilities.getV5ValueExpression(queryItem, environment);
            if (v5ValueExpression != null) {
                rmQueryItem.addChild(v5ValueExpression);
                RQPUtilities.updateModelIDsToReferenceCurrentAlias((RMQuery)this.getParent(), v5ValueExpression);
                MetadataContext.flagMetadataObjectIfRequired(querySubject, v5ValueExpression);
            } else {
                MetadataConnection mdConn = environment.getMetadataConnection();
                if (mdConn instanceof MoserMetadataConnection) {
                    ((MoserMetadataConnection)mdConn).throwQueryItemNoExpr(queryItem);
                }
            }
            if (!this.isJoinKeyForDynamicSQS(qi, querySubject)) continue;
            rmQueryItem.incrementCount();
        }
        boolean searchByID = false;
        if (ODataUtilities.isUsingOData(environment) || ODataUtilities.isUsingJSON(environment)) {
            this.setPropertyValue(PROP_SEARCH_BY_ID, Boolean.TRUE);
            searchByID = true;
        }
        this.createNameToItemMap(searchByID);
    }

    private boolean isJoinKeyForDynamicSQS(IMetadata qi, IQuerySubject qs) {
        return SummaryQuerySubjectUtilities.isSummaryQuerySubject(qs) && qi instanceof MoserQueryItem && ((MoserQueryItem)qi).getIsUsedAsJoinKey();
    }

    public IXQEQueryNode getRelatedSQLASTNode() {
        IXQEQueryNode queryType = this.getParent();
        IXQEQueryNode sqlAST = queryType.getFirstChildByType(301007);
        return sqlAST;
    }
}

