/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.rqp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL.ReplaceV5SummaryFunction;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DetectNoOpAggregates;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ProcessDataItemRefInValueSet;
import java.util.ArrayList;
import java.util.List;

public class RQPDataItem
extends RQPNode {
    public static final String PROP_OBJECT_QUERYITEM = "queryItem";
    public static final String PROP_REF_SUMMARYFILTER = "RefSummaryFilter";
    public static final String PROP_BOOL_GROUPINGITEM = "groupingItem";
    public static final String PROP_BOOL_ISHEADERITEM = "isHeaderItem";
    public static final String PROP_AUTOMATIC_ROLLUP = "automaticRollup";
    public static final String PROP_BOOL_ISFOOTERITEM = "isFooterItem";
    public static final String PROP_BOOL_ISBRIDGEKEY = "isBridgeKey";
    public static final String PROP_STRING_BRIDGESTREAM = "bridgeStream";
    public static final String PROP_VALUESET = "valueSet";
    public static final String PROP_NESTED_VALUESET = "nestedValueSet";
    public static final String PROP_BOOL_VALUESET_REFDATAITEM = "valueSetRefDataItem";
    public static final String PROP_BOOL_FORMAT_RESOLVED = "formatResolved";
    public static final String PROP_AGGREGATE_ONLY_ON_FIRST_ROW = "aggregateOnlyOnFirstRow";
    public static final String PROP_AGGR_ONSHAREDDIM = "aggrOnSharedDim";
    public static final String PROP_ORIGINAL_V5NAME = "originalV5Name";
    public static final String PROP_BOOL_BELONG_TO_LASTVALUESET = "belongsToLastValueSet";
    public static final String PROP_BOOL_IS_DESCENDING = "isDescending";
    public static final String PROP_BOOL_EXPLICIT_SORT = "explicitSort";
    public static final String PROP_SAME_EXPS = "sameExps";
    private static final String PROP_IS_CASE_ROWNUMBER_EXPR = "isCaseRowNumberExpr";
    private static final String PROP_IS_CASE_ROWNUMBER_EXPR_FORDISTINCT = "isCaseRowNumberExprForDistinct";
    private static final String PROP_BOOL_IS_NON_PROJECTED_SORTITEM = "isNonProjectedSortItem";
    private static final String PROP_BOOL_IS_NULLABLE = "isNullable";
    public static final String PROP_BOOL_DO_NOT_REMOVE = "doNotRemoveProjection";

    RQPDataItem() {
    }

    @Override
    public int getType() {
        return 801008;
    }

    public boolean isGroupingItem() {
        return this.isBooleanPropertySet(PROP_BOOL_GROUPINGITEM) && this.getBooleanPropertyValue(PROP_BOOL_GROUPINGITEM) != false;
    }

    public void setGroupingItem(boolean value) {
        this.setPropertyValue(PROP_BOOL_GROUPINGITEM, value);
    }

    public boolean belongsToLastValueSet() {
        return this.isBooleanPropertySet(PROP_BOOL_BELONG_TO_LASTVALUESET);
    }

    private boolean isBooleanPropertySet(String propertyName) {
        Boolean value = this.getBooleanPropertyValue(propertyName);
        return value != null;
    }

    public void setBelongsToLastValueSet(boolean value) {
        this.setPropertyValue(PROP_BOOL_BELONG_TO_LASTVALUESET, value);
    }

    public boolean isAscending() {
        return !this.isBooleanPropertySet(PROP_BOOL_IS_DESCENDING);
    }

    public void setDescending() {
        this.setPropertyValue(PROP_BOOL_IS_DESCENDING, Boolean.TRUE);
    }

    public void setExplicitSort() {
        this.setPropertyValue(PROP_BOOL_EXPLICIT_SORT, Boolean.TRUE);
    }

    public boolean hasExplicitSort() {
        Boolean value = this.getBooleanPropertyValue(PROP_BOOL_EXPLICIT_SORT);
        if (value == null) {
            return false;
        }
        return value;
    }

    public boolean isFooterHeaderItem() {
        return this.isFooterItem() || this.isHeaderItem();
    }

    public boolean isFooterItem() {
        return this.isBooleanPropertySet(PROP_BOOL_ISFOOTERITEM);
    }

    public boolean isHeaderItem() {
        return this.isBooleanPropertySet(PROP_BOOL_ISHEADERITEM);
    }

    public boolean isBridgeKey() {
        return this.isBooleanPropertySet(PROP_BOOL_ISBRIDGEKEY);
    }

    public String getBridgeStream() {
        return (String)this.getPropertyValue(PROP_STRING_BRIDGESTREAM);
    }

    public V5ValueSet getFooterLevel() {
        if (!this.isFooterHeaderItem()) {
            return null;
        }
        return (V5ValueSet)this.getPropertyValue(PROP_VALUESET);
    }

    public V5ValueSet getValueSet() {
        return (V5ValueSet)this.getPropertyValue(PROP_VALUESET);
    }

    public void setValueSet(V5ValueSet valueSet) {
        this.setPropertyValue(PROP_VALUESET, valueSet);
    }

    public V5ValueSet getNestedValueSet() {
        return (V5ValueSet)this.getPropertyValue(PROP_NESTED_VALUESET);
    }

    public void setNestedValueSet(V5ValueSet valueSet) {
        this.setPropertyValue(PROP_NESTED_VALUESET, valueSet);
    }

    public boolean isValueSetRefDataItem() {
        return this.getPropertyValue(PROP_BOOL_VALUESET_REFDATAITEM) != null;
    }

    public void setValueSetRefDataItem(boolean value) {
        this.setPropertyValue(PROP_BOOL_VALUESET_REFDATAITEM, value);
    }

    public void setFooterLevel(V5ValueSet valueSet) {
        this.setValueSet(valueSet);
    }

    public V5ValueSet getRollupScope() {
        if (this.isFooterHeaderItem()) {
            return this.getFooterLevel();
        }
        if (this.isGroupBodyItemOfNonLastValueSet()) {
            return this.getNestedValueSet();
        }
        return null;
    }

    public static RQPDataItem create(PlanningEnvironment environment, String refDataItemName) {
        RQPDataItem rqpDataItem = (RQPDataItem)environment.getNodeFactory().createNode(801008);
        rqpDataItem.setName(refDataItemName);
        return rqpDataItem;
    }

    public static RQPDataItem create(PlanningEnvironment environment, String name, V5DataItem v5DataItem) {
        RQPDataItem rqpDataItem = RQPDataItem.create(environment, name);
        rqpDataItem.addChild(environment.getNodeFactory().deepCopyNode(v5DataItem.getDetailExpression()));
        String sortAttribute = (String)v5DataItem.getPropertyValue("sort");
        if (sortAttribute != null) {
            rqpDataItem.setPropertyValue("sort", sortAttribute);
        }
        return rqpDataItem;
    }

    public IXQEQueryNode getExpression() {
        return this.getChild(0);
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        if (this == node) {
            return true;
        }
        if (node.getType() == this.getType()) {
            RQPDataItem di = (RQPDataItem)node;
            if (di.getExpression().isSameExpression(this.getExpression(), compareCalcDefiniton)) {
                return true;
            }
            return this.getExpression().isSameExpression(di.getExpression(), false);
        }
        return this.getExpression().isSameExpression(node, false);
    }

    public void moveToQuery(PlanningEnvironment environment, RQPQuery targetQuery) {
        RQPQuery sourceQuery = RQPNode.getRQPQuery(this);
        RQPProjectionList targetProjList = targetQuery.getOrCreateProjectionList(environment);
        this.move(targetProjList);
        this.updateDataItemRefsToThis(sourceQuery.getName(), targetQuery.getName());
    }

    private void updateDataItemRefsToThis(String prevQueryName, String newQueryName) {
        RQPQuery rootQuery = RQPNode.getRQPQuery(this).getParentRQPQuery();
        IXQEQueryNode[] dataItemRefs = rootQuery.getDescendantsOfType(801009, false);
        String thisName = this.getName();
        for (int i = 0; i < dataItemRefs.length; ++i) {
            RQPDataItemRef dataItemRef = (RQPDataItemRef)dataItemRefs[i];
            if (!thisName.equals(dataItemRef.getName()) || !prevQueryName.equals(dataItemRef.getQueryName())) continue;
            dataItemRef.setQueryName(newQueryName);
        }
    }

    public static String getRQPDataItemNameForAggregateType(int aggregateType) {
        StringBuilder newNameBuf = new StringBuilder(SQLAggregate.getAggregateFunctionName(ReplaceV5SummaryFunction.convertV5AggregateFunctionSubTypeToSqlAggregateSubtype(aggregateType, false)));
        newNameBuf.append(1);
        return newNameBuf.toString();
    }

    public void copyPropertiesFrom(IXQEQueryNode expression) {
        Object loc;
        V5ValueSet valueSet;
        RQPDataItem rqpDataItemOfInputExpr = null;
        if (expression.getType() == 801008) {
            rqpDataItemOfInputExpr = (RQPDataItem)expression;
        } else {
            rqpDataItemOfInputExpr = (RQPDataItem)expression.getAncestorOfType(801008);
            if (rqpDataItemOfInputExpr == null) {
                return;
            }
        }
        if (rqpDataItemOfInputExpr.isGroupingItem()) {
            this.setGroupingItem(true);
        }
        if (rqpDataItemOfInputExpr.isFooterItem()) {
            this.setIsFooterItem(true);
        }
        if (rqpDataItemOfInputExpr.isHeaderItem()) {
            this.setIsHeaderItem(true);
        }
        if ((valueSet = rqpDataItemOfInputExpr.getValueSet()) != null) {
            this.setValueSet(valueSet);
        }
        if (rqpDataItemOfInputExpr.belongsToLastValueSet()) {
            this.setBelongsToLastValueSet(true);
        }
        if (rqpDataItemOfInputExpr.isValueSetRefDataItem()) {
            this.setValueSetRefDataItem(true);
        }
        if ((valueSet = rqpDataItemOfInputExpr.getNestedValueSet()) != null) {
            this.setNestedValueSet(valueSet);
        }
        if (rqpDataItemOfInputExpr.getPropertyValue("forSummaryFilter") != null) {
            this.setPropertyValue("forSummaryFilter", true);
        }
        if (rqpDataItemOfInputExpr.isBridgeKey()) {
            this.setIsBridgeKey(true);
        }
        String bridgeStream = rqpDataItemOfInputExpr.getBridgeStream();
        if (rqpDataItemOfInputExpr.getBridgeStream() != null) {
            this.setBridgeStream(bridgeStream);
        }
        if ((loc = rqpDataItemOfInputExpr.getPropertyValue("moduleLocation")) != null) {
            this.setPropertyValue("moduleLocation", loc);
        }
    }

    public void updateReferencesWithExpression(PlanningEnvironment environment, IXQEQueryNode newExpr) {
        RQPDataItemRef[] refsToThisDataItem;
        RQPQuery rqpQuery = this.getParentRQPQuery();
        for (RQPDataItemRef ref : refsToThisDataItem = rqpQuery.getDataItemRefsTo(this)) {
            ref.exchange(environment.getNodeFactory().deepCopyNode(newExpr));
        }
    }

    public boolean hasHigherScopeThanValueSetOfReferenceDataItemInParentQuery() {
        RQPQuery rqpQuery = RQPNode.getRQPQuery(this);
        RQPQuery parentQuery = rqpQuery.getParentRQPQuery();
        RQPDataItemRef[] refsToThisDataItem = parentQuery.getDataItemRefsTo(this);
        if (refsToThisDataItem == null) {
            return false;
        }
        for (RQPDataItemRef ref : refsToThisDataItem) {
            RQPDataItem rqpDataItem = (RQPDataItem)ref.getAncestorOfType(801008);
            if (rqpDataItem == null || rqpDataItem.getValueSet() == null) continue;
            List<V5DataItem> v5GroupingList = ProcessDataItemRefInValueSet.getGroupingItems(rqpDataItem.getValueSet(), parentQuery, rqpDataItem.isFooterHeaderItem());
            IXQEQueryNode[] parentQueryGroupingItems = DetectNoOpAggregates.convertListV5DataItemToIXQEQueryNodeArray(parentQuery, v5GroupingList);
            IXQEQueryNode[] summaryGroupingItems = rqpQuery.getGroupingItems();
            if (!(summaryGroupingItems != null && summaryGroupingItems.length != 0 || parentQueryGroupingItems != null && parentQueryGroupingItems.length != 0)) {
                return false;
            }
            if (summaryGroupingItems == null || summaryGroupingItems.length == 0) {
                return true;
            }
            if (parentQueryGroupingItems == null || parentQueryGroupingItems.length == 0) {
                return false;
            }
            if (summaryGroupingItems.length >= parentQueryGroupingItems.length || !RQPSummaryQuery.groupingItemsAreSubsetOf(parentQueryGroupingItems, summaryGroupingItems)) continue;
            return true;
        }
        return false;
    }

    public String getOriginalName() {
        String name = (String)this.getPropertyValue(PROP_ORIGINAL_V5NAME);
        if (name != null) {
            return name;
        }
        return "";
    }

    public void setOriginalName(String v5DataItemName) {
        this.setPropertyValue(PROP_ORIGINAL_V5NAME, v5DataItemName);
    }

    public IXQEQueryNode[] getAllReferencesToMe() {
        IXQEQueryNode[] allRefs;
        RQPQuery parentRQPQuery = RQPNode.getRQPQuery(this).getParentRQPQuery();
        ArrayList<IXQEQueryNode> refList = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode r : allRefs = parentRQPQuery.getDescendantsOfType(801009, false, 801017)) {
            if (!((RQPDataItemRef)r).isReferenceTo(this)) continue;
            refList.add(r);
        }
        IXQEQueryNode[] returnArray = new IXQEQueryNode[refList.size()];
        refList.toArray(returnArray);
        return returnArray;
    }

    public boolean isGroupBodyItemOfNonLastValueSet() {
        return this.getNestedValueSet() != null;
    }

    public boolean isCaseRowNumberExpr() {
        return this.isBooleanPropertySet(PROP_IS_CASE_ROWNUMBER_EXPR);
    }

    public void setIsRowNumberExpr() {
        this.setPropertyValue(PROP_IS_CASE_ROWNUMBER_EXPR, true);
    }

    public boolean isNonProjectedSortItem() {
        return this.isBooleanPropertySet(PROP_BOOL_IS_NON_PROJECTED_SORTITEM);
    }

    public void setIsNonProjectedSortItem() {
        this.setPropertyValue(PROP_BOOL_IS_NON_PROJECTED_SORTITEM, true);
    }

    public void moveToQuery(PlanningEnvironment environment, RQPSummaryQuery targetQuery) {
        IXQEQueryNode[] allRefs;
        String newSumQueryName = targetQuery.getName();
        for (IXQEQueryNode itemRef : allRefs = this.getAllReferencesToMe()) {
            ((RQPDataItemRef)itemRef).setQueryName(newSumQueryName);
        }
        this.detach();
        targetQuery.addToProjectionList(environment, this);
    }

    public void setIsHeaderItem(boolean b) {
        this.setPropertyValue(PROP_BOOL_ISHEADERITEM, b);
    }

    public void setIsFooterItem(boolean b) {
        this.setPropertyValue(PROP_BOOL_ISFOOTERITEM, b);
    }

    public void setIsBridgeKey(boolean b) {
        this.setPropertyValue(PROP_BOOL_ISBRIDGEKEY, b);
    }

    public void setBridgeStream(String s) {
        this.setPropertyValue(PROP_STRING_BRIDGESTREAM, s);
    }

    public void setPropIsRollupExpression(Boolean value) {
        this.setPropertyValue("isRollupExpression", value);
    }

    public boolean getPropIsRollupExpression() {
        Boolean bool = this.getBooleanPropertyValue("isRollupExpression");
        if (bool == null) {
            return false;
        }
        return bool;
    }

    public void setAutomaticRollup(Boolean value) {
        this.setPropertyValue(PROP_AUTOMATIC_ROLLUP, value);
    }

    public boolean getAutomaticRollup() {
        Boolean bool = this.getBooleanPropertyValue(PROP_AUTOMATIC_ROLLUP);
        if (bool == null) {
            return false;
        }
        return bool;
    }

    public Boolean getIsNullableProperty() {
        return (Boolean)this.getPropertyValue(PROP_BOOL_IS_NULLABLE);
    }

    public void setIsNullableProperty(Boolean b) {
        this.setPropertyValue(PROP_BOOL_IS_NULLABLE, b);
    }

    public IDataType getCastDataType() {
        return (IDataType)this.getPropertyValue("castDataType");
    }

    public void setCastDataType(IDataType dataType) {
        this.setPropertyValue("castDataType", dataType);
    }

    public String getFormat() {
        IXQEQueryNode child;
        String formatString = null;
        if (1 == this.getNumberChildren() && (child = this.getChild(0)) instanceof V5QueryNode) {
            formatString = ((V5QueryNode)child).getFormat();
        }
        return formatString;
    }

    public void setDoNotRemove() {
        this.setPropertyValue(PROP_BOOL_DO_NOT_REMOVE, Boolean.TRUE);
    }

    public boolean getDoNotRemove() {
        return Boolean.TRUE == this.getPropertyValue(PROP_BOOL_DO_NOT_REMOVE);
    }

    public void setIsRowNumberForDistinct() {
        this.setPropertyValue(PROP_IS_CASE_ROWNUMBER_EXPR_FORDISTINCT, Boolean.TRUE);
    }

    public boolean getIsRowNumberForDistinct() {
        Boolean b = (Boolean)this.getPropertyValue(PROP_IS_CASE_ROWNUMBER_EXPR_FORDISTINCT);
        return b != null && b != false;
    }
}

