/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.rqp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPGroupByList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.ArrayList;
import java.util.List;

public class RQPFooterQuery
extends RQPSummaryQuery {
    public static final String PROP_LEVEL = "aggregateLevel";
    public static final String PROP_OBJ_V5VALUESET = "v5ValueSetObject";
    public static final String PROP_ROLLUPS_HAVING_ONLY_REFITEMS = "rollupsHavingOnlyRefItems";

    RQPFooterQuery() {
    }

    @Override
    public int getType() {
        return 801012;
    }

    public List<IXQEQueryNode> getRollupsHavingOnlyRefItems() {
        ArrayList<IXQEQueryNode> refItems = new ArrayList<IXQEQueryNode>();
        IXQEQueryNode projectionList = this.getFirstChildByType(801016);
        if (projectionList != null) {
            for (IXQEQueryNode footerProjection : projectionList.getChildren()) {
                RQPDataItem projection = (RQPDataItem)footerProjection;
                if (RQPUtilities.hasAggregateInExpression(projection.getChild(0)) || this.isAGroupingItem(projection)) continue;
                refItems.add(footerProjection);
            }
        }
        return refItems;
    }

    public List<IXQEQueryNode> getRollupsHavingOnlyRefItemsProperty() {
        return (List)this.getPropertyValue(PROP_ROLLUPS_HAVING_ONLY_REFITEMS);
    }

    public void setRollupsHavingOnlyRefItemsProperty(List<IXQEQueryNode> refItems) {
        this.setPropertyValue(PROP_ROLLUPS_HAVING_ONLY_REFITEMS, refItems);
    }

    private boolean isAGroupingItem(RQPDataItem projection) {
        String projectionName = projection.getName();
        RQPGroupByList groupByList = (RQPGroupByList)this.getFirstChildByType(801013);
        if (groupByList == null || groupByList.getNumberChildren() == 0) {
            return false;
        }
        for (int j = 0; j < groupByList.getNumberChildren(); ++j) {
            RQPDataItemSelfRef groupingItem = (RQPDataItemSelfRef)groupByList.getChild(j);
            if (!groupingItem.getName().equals(projectionName)) continue;
            return true;
        }
        return false;
    }

    public static RQPFooterQuery create(PlanningEnvironment environment, RQPQuery rootQuery, List<V5DataItem> groupingItems, V5ValueSet v5ValueSet) {
        RQPFooterQuery footerQuery = rootQuery.createFooterQuery(environment);
        if (groupingItems != null) {
            for (V5DataItem groupingItem : groupingItems) {
                IXQEQueryNode groupingItemExpr = groupingItem.isAggregate() && rootQuery.isAutoSummaryTRUE() && (RQPUtilities.containsAnalyticOrMovingRunningOnDetailExpr(groupingItem) || groupingItem.isAggregate("calculated")) ? groupingItem.getAggregateExpression() : groupingItem.getDetailExpression();
                footerQuery.createGroupingColumn(environment, groupingItem.getNameProperty(), environment.getNodeFactory().deepCopyNode(groupingItemExpr));
            }
            if (groupingItems.size() > 0) {
                footerQuery.setPropertyValue(PROP_LEVEL, groupingItems.get(groupingItems.size() - 1).getNameProperty());
            }
        }
        footerQuery.setV5ValueSet(v5ValueSet);
        return footerQuery;
    }

    public String getFooterLevel() {
        return (String)this.getPropertyValue(PROP_LEVEL);
    }

    public void setFooterLevel(String footerV5ValueSetName) {
        this.setPropertyValue(PROP_LEVEL, footerV5ValueSetName);
    }

    public V5ValueSet getV5ValueSet() {
        return (V5ValueSet)this.getPropertyValue(PROP_OBJ_V5VALUESET);
    }

    public void setV5ValueSet(V5ValueSet v5ValueSet) {
        this.setPropertyValue(PROP_OBJ_V5VALUESET, v5ValueSet);
    }
}

