/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.rqp;

import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.dynamic.DMRelationship;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.RepositoryInfoFinder;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;
import com.cognos.xqe.util.Governors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RQPJoinInfo
extends RQPNode {
    HashMap<IMetadata, List<IMetadata>> mQuerySubjectToJoinsMap = new HashMap();
    RepositoryInfoFinder mRepositoryInfo = null;

    RQPJoinInfo() {
    }

    public void createRepositoryInfo(MetadataConnection mc) {
        this.mRepositoryInfo = new RepositoryInfoFinder(mc, this.getGovernors());
    }

    public void createRepositoryInfo(MetadataConnection mc, Governors gov) {
        this.mRepositoryInfo = new RepositoryInfoFinder(mc, gov);
    }

    @Override
    public int getType() {
        return 801046;
    }

    public List<IMetadata> getJoinsForQuerySubject(IMetadata querySubject) {
        if (this.mQuerySubjectToJoinsMap.containsKey(querySubject)) {
            return this.mQuerySubjectToJoinsMap.get(querySubject);
        }
        List<IMetadata> joinsForQS = null;
        joinsForQS = this.getJoinsForQS(this.mRepositoryInfo.getRelationships(), querySubject, joinsForQS);
        joinsForQS = this.getJoinsForQS(this.mRepositoryInfo.getDummyRelationships(), querySubject, joinsForQS);
        joinsForQS = this.getJoinsForQS(MetadataContext.getRelationships(querySubject), querySubject, joinsForQS);
        this.mQuerySubjectToJoinsMap.put(querySubject, joinsForQS);
        return joinsForQS;
    }

    private List<IMetadata> getJoinsForQS(List<IMetadata> joins, IMetadata querySubject, List<IMetadata> joinsForQS) {
        for (IMetadata j : joins) {
            IRelationship join;
            if (!(j instanceof IRelationship) || !(join = (IRelationship)j).getLeftRefObjectId().equals(querySubject.getID()) && !join.getRightRefObjectId().equals(querySubject.getID())) continue;
            if (joinsForQS == null) {
                joinsForQS = new ArrayList<IMetadata>();
            }
            joinsForQS.add(j);
        }
        return joinsForQS;
    }

    public boolean otherShortcutsToSameTargetHaveJoins(IMetadata shortcutOrQuerySubject) {
        List<IShortcut> allShortcuts = this.mRepositoryInfo.getAllShortcuts(shortcutOrQuerySubject);
        if (allShortcuts == null) {
            return false;
        }
        for (IShortcut s : allShortcuts) {
            List<IMetadata> allJoins = this.getJoinsForQuerySubject(s);
            if (allJoins == null) continue;
            for (IMetadata m : allJoins) {
                if (m instanceof DMRelationship) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasRepositoryInfo() {
        return this.mRepositoryInfo != null;
    }
}

