/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.rqp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEQueryNode;
import com.cognos.xqe.ast.rqp.RMEmbeddedFilterList;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.sql.IOutputList;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.metadata.IEmbeddedFilter;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.ArrayList;
import java.util.List;

public class RQPNode
extends XQEQueryNode
implements Comparable<RQPNode>,
IOutputList {
    public static String UNWINDCONTEXT_PREFERREDQS = "PREFERRED_QS";
    private static String PROP_UNWIND_CONTEXT = "unwindContext";

    RQPNode() {
    }

    @Override
    public int getType() {
        return 801015;
    }

    public RQPQuery getParentRQPQuery() {
        if (this.getType() == 801017) {
            return (RQPQuery)this;
        }
        return (RQPQuery)this.getAncestorOfType(801017);
    }

    public RQPQuery getRootRQPQuery() {
        RQPQuery rootRQPQuery = null;
        for (RQPQuery tmpRQPQuery = this.getParentRQPQuery(); tmpRQPQuery != null; tmpRQPQuery = (RQPQuery)tmpRQPQuery.getAncestorOfType(801017)) {
            rootRQPQuery = tmpRQPQuery;
        }
        return rootRQPQuery;
    }

    public void setName(String nameProperty) {
        this.setPropertyValue("name", nameProperty);
    }

    public String getName() {
        return (String)this.getPropertyValue("name");
    }

    public static RQPQuery getRQPQuery(IXQEQueryNode node) {
        for (IXQEQueryNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!RQPNode.isRQPQuery(parent.getType())) continue;
            return (RQPQuery)parent;
        }
        return null;
    }

    public static V5Query getV5Query(IXQEQueryNode node) {
        IXQEQueryNode q = node.getAncestorOfType(101006);
        if (q != null) {
            return (V5Query)q;
        }
        for (IXQEQueryNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
            RQPQuery rqpQuery;
            V5Query query;
            if (!RQPNode.isRQPQuery(parent.getType()) || (query = (rqpQuery = (RQPQuery)parent).getRefV5Query()) == null) continue;
            return query;
        }
        return null;
    }

    private static boolean isRQPQuery(int type) {
        return type == 801017 || type == 801025 || type == 801024 || type == 801012 || type == 801044 || type == 801051;
    }

    public static boolean isUnderRMQuery(IXQEQueryNode node) {
        for (IXQEQueryNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getType() == 801032) {
                return true;
            }
            if (RQPNode.isRQPQuery(parent.getType())) break;
        }
        return false;
    }

    @Override
    public int compareTo(RQPNode rqpNode) {
        return this.getName().compareTo(rqpNode.getName());
    }

    public List<RQPDataItemRef> getReferencesMatchingName(String queryName, String itemName) {
        ArrayList<RQPDataItemRef> referencesMatchingName = new ArrayList<RQPDataItemRef>();
        List<RQPDataItemRef> dataItemRefs = this.getAllReferences();
        for (RQPDataItemRef node : dataItemRefs) {
            RQPDataItemRef dataItemRef = node;
            if (!dataItemRef.getQueryName().equals(queryName)) continue;
            if (itemName == null) {
                referencesMatchingName.add(dataItemRef);
                continue;
            }
            if (!dataItemRef.getName().equals(itemName)) continue;
            referencesMatchingName.add(dataItemRef);
        }
        return referencesMatchingName;
    }

    public List<RQPDataItemRef> getAllReferences() {
        IXQEQueryNode[] dataItemRefs = this.getDescendantsOfType(801009, false);
        ArrayList<RQPDataItemRef> itemRefs = new ArrayList<RQPDataItemRef>();
        for (IXQEQueryNode ref : dataItemRefs) {
            itemRefs.add((RQPDataItemRef)ref);
        }
        return itemRefs;
    }

    public void addEmbeddedFiltersForQS(PlanningEnvironment environment, IQuerySubject qs, IXQEQueryNode node) {
        List<IEmbeddedFilter> embeddedFilters = qs.getFilters();
        List<IEmbeddedFilter> previewFilters = null;
        if (node.getGovernors() != null) {
            if (node.getGovernors().getDesignMode().booleanValue()) {
                previewFilters = qs.getPreviewFilters();
            }
        } else {
            previewFilters = qs.getPreviewFilters();
        }
        List<IEmbeddedFilter> securityFilters = qs.getSecurityFilters();
        if (!(embeddedFilters != null && embeddedFilters.size() != 0 || previewFilters != null && previewFilters.size() != 0 || securityFilters != null && securityFilters.size() != 0)) {
            return;
        }
        RMEmbeddedFilterList embeddedFilterListForQS = this.getOrCreateEmbeddedFilterList(environment, qs);
        embeddedFilterListForQS.deployRMEmbeddedFilterList(qs, environment);
    }

    public RMEmbeddedFilterList getOrCreateEmbeddedFilterList(PlanningEnvironment environment, IQuerySubject querySubject) {
        IXQEQueryNode[] embeddedFilterLists;
        for (IXQEQueryNode embeddedFilterListForQS : embeddedFilterLists = this.getChildrenOfType(801036)) {
            if (((RMEmbeddedFilterList)embeddedFilterListForQS).getQuerySubject() != querySubject) continue;
            return (RMEmbeddedFilterList)embeddedFilterListForQS;
        }
        RMEmbeddedFilterList embeddedFilterList = (RMEmbeddedFilterList)environment.getNodeFactory().createNode(801036);
        embeddedFilterList.setQuerySubject(querySubject);
        this.addChild(embeddedFilterList);
        return embeddedFilterList;
    }

    @Override
    public SQLValueList getOutputList() {
        return null;
    }

    public String getUnwindContext() {
        return (String)this.getPropertyValue(PROP_UNWIND_CONTEXT);
    }

    public void setUnwindContext(String unwindContext) {
        this.setPropertyValue(PROP_UNWIND_CONTEXT, unwindContext);
    }

    public void clearUnwindContext() {
        this.removeProperty(PROP_UNWIND_CONTEXT);
    }
}

