/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.rqp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPFooterQuery;
import com.cognos.xqe.ast.rqp.RQPGroupByList;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSubqueryList;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ProcessDataItemRefInValueSet;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPNameGenerator;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.List;

public class RQPSummaryQuery
extends RQPQuery {
    public static final String PROP_BOOL_BEING_SPLIT = "beingSplit";

    RQPSummaryQuery() {
    }

    @Override
    public int getType() {
        return 801024;
    }

    public static RQPQuery getSummaryQueryMatchingAggregateForClause(PlanningEnvironment environment, V5AggregateFunction aggregateNode, int[] queryTypes) {
        RQPQuery rqpQuery = RQPNode.getRQPQuery(aggregateNode);
        if (null == rqpQuery) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "getSummaryQueryMatchingAggregateForClause requires rqpQuery");
        }
        RQPQuery rootRQPQuery = rqpQuery.getParentRQPQuery();
        return RQPSummaryQuery.getSummaryQueryMatchingAggregateForClause(environment, aggregateNode, rootRQPQuery, queryTypes);
    }

    public static RQPQuery getSummaryQueryMatchingAggregateForClause(PlanningEnvironment environment, V5AggregateFunction aggregateNode, RQPQuery rootRQPQuery, int[] queryTypes) {
        RQPQuery subquery = RQPSummaryQuery.getExistingSummaryQueryMatchingAggregateForClause(rootRQPQuery, aggregateNode, queryTypes, environment);
        if (subquery != null) {
            return subquery;
        }
        return RQPSummaryQuery.createSummaryQueryWithAggregateForClause(environment, rootRQPQuery, aggregateNode);
    }

    private static RQPQuery createSummaryQueryWithAggregateForClause(PlanningEnvironment environment, RQPQuery rootRQPQuery, V5AggregateFunction aggregateNode) {
        V5AggregateBreakClause forClause = aggregateNode.getForClause();
        if (forClause == null || forClause.getNumberChildren() == 0) {
            return RQPSummaryQuery.getOrCreateForReportSummaryQuery(environment, rootRQPQuery);
        }
        RQPSummaryQuery summaryQuery = rootRQPQuery.createSummaryQuery(environment);
        for (int i = 0; i < forClause.getNumberChildren(); ++i) {
            summaryQuery.createGroupingColumn(environment, environment.getNodeFactory().deepCopyNode(forClause.getChild(i)));
        }
        return summaryQuery;
    }

    public static RQPQuery getSummaryQueryWithScope(String levelRef, IXQEQueryNode summaryFilter, PlanningEnvironment environment) {
        RQPQuery rqpQuery = RQPNode.getRQPQuery(summaryFilter).getParentRQPQuery();
        V5ValueSet valueSet = RQPSummaryQuery.getValueSetOfRefDataItem(levelRef, rqpQuery, summaryFilter);
        List<V5DataItem> groupingItems = ProcessDataItemRefInValueSet.getGroupingItems(valueSet, rqpQuery.getRootRQPQuery(), false);
        RQPQuery summaryQuery = RQPSummaryQuery.getSummaryQueryMatchingGroupingItems(rqpQuery, groupingItems, new int[]{801024, 801012}, environment);
        if (summaryQuery == null) {
            return RQPFooterQuery.create(environment, rqpQuery, groupingItems, valueSet);
        }
        return (RQPSummaryQuery)summaryQuery;
    }

    public static V5ValueSet getValueSetOfRefDataItem(String refDataItem, RQPQuery rqpQuery, IXQEQueryNode summaryFilter) {
        IXQEQueryNode parent = summaryFilter.getParent();
        int position = parent.getPositionOfChild(summaryFilter);
        if (refDataItem == null) {
            throw new XQERuntimeException(XQEMessageKeys.EXE_InvalidSummaryFilterLevel, refDataItem, Integer.toString(position + 1));
        }
        List<IXQEQueryNode> v5VS = rqpQuery.getRootRQPQuery().getDescendantsOfTypeOrdered(101057, false);
        for (IXQEQueryNode vs : v5VS) {
            V5ValueSet valueSet = (V5ValueSet)vs;
            if (!refDataItem.equals(valueSet.getRefDataItemProperty())) continue;
            return valueSet;
        }
        throw new XQERuntimeException(XQEMessageKeys.EXE_InvalidSummaryFilterLevel, refDataItem, Integer.toString(position + 1));
    }

    public static String getDataItemName(RQPQuery rqpQuery, IXQEQueryNode expressionNode) {
        String name;
        switch (expressionNode.getType()) {
            case 201116: {
                name = ((V5BoundModelIdentifier)expressionNode).getColumnName();
                break;
            }
            case 201060: {
                name = ((V5BoundDataItemReference)expressionNode).getRefDataItem().getNameProperty();
                break;
            }
            case 101003: {
                name = ((V5DataItem)expressionNode).getNameProperty();
                break;
            }
            case 101015: {
                name = ((V5DataItemRef)expressionNode).getDataItemRefProperty();
                break;
            }
            case 801008: 
            case 801009: 
            case 801010: {
                name = ((RQPNode)expressionNode).getName();
                break;
            }
            default: {
                name = "C";
            }
        }
        if (name == null) {
            name = "C";
        }
        return RQPNameGenerator.generateUniqueRQPDataItemName(rqpQuery, name);
    }

    private static RQPQuery getExistingSummaryQueryMatchingAggregateForClause(RQPQuery rootRQPQuery, V5AggregateFunction aggregateNode, int[] queryTypes, PlanningEnvironment environment) {
        V5AggregateBreakClause forClause = aggregateNode.getForClause();
        if (forClause == null) {
            return RQPSummaryQuery.determineScopeOfAutoForClause(environment, aggregateNode, rootRQPQuery, queryTypes);
        }
        return RQPSummaryQuery.getSummaryQueryMatchingGroupingItems(rootRQPQuery, forClause.getChildren(), queryTypes, environment);
    }

    public static RQPQuery getSummaryQueryMatchingGroupingItems(RQPQuery rootRQPQuery, IXQEQueryNode[] groupingItems, int[] queryTypes, PlanningEnvironment environment) {
        RQPSubqueryList subqueries = (RQPSubqueryList)rootRQPQuery.getFirstChildByType(801022);
        for (int i = 0; i < subqueries.getNumberChildren(); ++i) {
            RQPQuery subquery = (RQPQuery)subqueries.getChild(i);
            if (!RQPSummaryQuery.queryTypeIsMatched(subquery.getType(), queryTypes)) continue;
            RQPGroupByList groupByList = (RQPGroupByList)subquery.getFirstChildByType(801013);
            if (!(groupByList != null && groupByList.getNumberChildren() != 0 || groupingItems != null && groupingItems.length != 0)) {
                return subquery;
            }
            if (groupByList == null || groupingItems == null || !RQPSummaryQuery.groupingItemsAndGroupByListAreSubsetsOfEachOther(groupingItems, groupByList)) continue;
            return subquery;
        }
        return null;
    }

    private static boolean groupingItemsAndGroupByListAreSubsetsOfEachOther(IXQEQueryNode[] groupingItems, RQPGroupByList groupByList) {
        boolean found = false;
        boolean[] gbListFlags = new boolean[groupByList.getNumberChildren()];
        for (int i = 0; i < groupingItems.length; ++i) {
            if (RQPUtilities.isConstantGroupingItem(groupingItems[i])) continue;
            found = false;
            for (int j = 0; j < groupByList.getNumberChildren(); ++j) {
                RQPDataItemSelfRef selfRef = (RQPDataItemSelfRef)groupByList.getChild(j);
                IXQEQueryNode gpItem = groupingItems[i];
                if (gpItem.getType() == 101003) {
                    gpItem = gpItem.getChild(0);
                }
                if (!selfRef.isSameExpression(gpItem, false)) continue;
                gbListFlags[j] = true;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        for (int j = 0; j < gbListFlags.length; ++j) {
            RQPDataItemSelfRef selfRef;
            RQPDataItem proj;
            if (gbListFlags[j] || RQPUtilities.isConstantGroupingItem(proj = (selfRef = (RQPDataItemSelfRef)groupByList.getChild(j)).getRefProjection())) continue;
            found = false;
            for (int i = 0; i < groupingItems.length; ++i) {
                IXQEQueryNode gpItem = groupingItems[i];
                if (gpItem.getType() == 101003) {
                    gpItem = gpItem.getChild(0);
                }
                if (!selfRef.isSameExpression(gpItem, false)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static RQPQuery getSummaryQueryMatchingGroupingItems(RQPQuery rootRQPQuery, List<V5DataItem> groupingItems, int[] queryTypes, PlanningEnvironment environment) {
        IXQEQueryNode[] gpItems = new IXQEQueryNode[groupingItems.size()];
        for (int i = 0; i < groupingItems.size(); ++i) {
            gpItems[i] = groupingItems.get(i).getChild(0);
        }
        return RQPSummaryQuery.getSummaryQueryMatchingGroupingItems(rootRQPQuery, gpItems, queryTypes, environment);
    }

    public static V5AggregateBreakClause expandForClause(PlanningEnvironment environment, RQPQuery rootRQPQuery, V5ValueSet valueSet, boolean isForFooter) {
        V5AggregateBreakClause forClause = (V5AggregateBreakClause)environment.getNodeFactory().createNode(201037);
        List<V5DataItem> groupingItems = ProcessDataItemRefInValueSet.getGroupingItems(valueSet, rootRQPQuery, isForFooter);
        for (int k = 0; k < groupingItems.size(); ++k) {
            IXQEQueryNode forClauseItem = groupingItems.get(k);
            if (forClauseItem.getType() == 101003) {
                forClause.addChild(environment.getNodeFactory().deepCopyNode(forClauseItem.getChild(0)));
                continue;
            }
            forClause.addChild(environment.getNodeFactory().deepCopyNode(forClauseItem));
        }
        return forClause;
    }

    private static boolean queryTypeIsMatched(int subQueryType, int[] expectedQueryTypes) {
        for (int i : expectedQueryTypes) {
            if (subQueryType != i) continue;
            return true;
        }
        return false;
    }

    public boolean groupingColumnsAreSubsetOf(RQPSummaryQuery summaryQuery) {
        RQPGroupByList groupByListThis = (RQPGroupByList)this.getFirstChildByType(801013);
        if (groupByListThis == null || groupByListThis.getNumberChildren() == 0) {
            return true;
        }
        IXQEQueryNode groupByListSQ = summaryQuery.getFirstChildByType(801013);
        if (groupByListSQ == null || groupByListSQ.getNumberChildren() == 0) {
            return false;
        }
        boolean found = false;
        for (int j = 0; j < groupByListThis.getNumberChildren(); ++j) {
            RQPDataItemSelfRef groupingItemThis = (RQPDataItemSelfRef)groupByListThis.getChild(j);
            IXQEQueryNode groupingItemThisExpr = groupingItemThis.getExpression();
            found = false;
            for (int k = 0; k < groupByListSQ.getNumberChildren(); ++k) {
                RQPDataItemSelfRef groupingItemThat = (RQPDataItemSelfRef)groupByListSQ.getChild(k);
                IXQEQueryNode groupingItemThatExpr = groupingItemThat.getExpression();
                if (!RQPSummaryQuery.isSameGroupingColumnExpression(groupingItemThisExpr, groupingItemThatExpr)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static boolean isSameGroupingColumnExpression(IXQEQueryNode expr1, IXQEQueryNode expr2) {
        boolean recursiveCall = false;
        if (expr1.getType() == 801010) {
            expr1 = ((RQPDataItemSelfRef)expr1).getRefProjection();
            recursiveCall = true;
        }
        if (expr2.getType() == 801010) {
            expr2 = ((RQPDataItemSelfRef)expr2).getRefProjection();
            recursiveCall = true;
        }
        if (expr1.getType() == 801008) {
            expr1 = ((RQPDataItem)expr1).getExpression();
            recursiveCall = true;
        }
        if (expr2.getType() == 801008) {
            expr2 = ((RQPDataItem)expr2).getExpression();
            recursiveCall = true;
        }
        if (recursiveCall) {
            return RQPSummaryQuery.isSameGroupingColumnExpression(expr1, expr2);
        }
        if (expr1.isSameExpression(expr2, false)) {
            return true;
        }
        if (expr1.getType() == 801009 && expr2.getType() == 801009) {
            RQPDataItemRef di1 = (RQPDataItemRef)expr1;
            RQPDataItemRef di2 = (RQPDataItemRef)expr2;
            RQPDataItem di1RefLastExpr = di1.getReferencedItem();
            RQPDataItem di2RefLastExpr = di2.getReferencedItem();
            return di1RefLastExpr != null && di2RefLastExpr != null && di1RefLastExpr.isSameExpression(di2RefLastExpr, false);
        }
        if (expr2.getType() == 801009) {
            return ((RQPDataItemRef)expr2).getReferencedItem().isSameExpression(expr1, false);
        }
        return false;
    }

    public void createGroupingColumn(PlanningEnvironment environment, String preferredName, IXQEQueryNode groupingColumnExpr) {
        RQPDataItem projection = this.createProjection(environment, preferredName, groupingColumnExpr);
        projection.setGroupingItem(true);
        RQPDataItemSelfRef selfRef = RQPDataItemSelfRef.create(environment, preferredName);
        this.addToGroupByList(environment, selfRef);
    }

    public void createGroupingColumn(PlanningEnvironment environment, IXQEQueryNode groupingColumnExpr) {
        String preferredName = RQPSummaryQuery.getDataItemName(this, groupingColumnExpr);
        this.createGroupingColumn(environment, preferredName, groupingColumnExpr);
    }

    public boolean hasGroupBy() {
        IXQEQueryNode groupByList = this.getFirstChildByType(801013);
        return groupByList != null && groupByList.getNumberChildren() > 0;
    }

    public boolean groupColumnsArePresentInProjections(RQPQuery rqpQuery) {
        RQPGroupByList groupByListThis = (RQPGroupByList)this.getFirstChildByType(801013);
        if (groupByListThis == null || groupByListThis.getNumberChildren() == 0) {
            return true;
        }
        IXQEQueryNode projectionListSQ = rqpQuery.getFirstChildByType(801016);
        if (projectionListSQ == null || projectionListSQ.getNumberChildren() == 0) {
            return false;
        }
        boolean found = false;
        for (int j = 0; j < groupByListThis.getNumberChildren(); ++j) {
            RQPDataItem groupingProjectionThis = ((RQPDataItemSelfRef)groupByListThis.getChild(j)).getRefProjection();
            found = false;
            for (int k = 0; k < projectionListSQ.getNumberChildren(); ++k) {
                if (!RQPSummaryQuery.isSameGroupingColumnExpression(groupingProjectionThis, projectionListSQ.getChild(k))) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public RQPDataItemSelfRef getGroupingItem(String itemName) {
        RQPGroupByList groupByList = (RQPGroupByList)this.getFirstChildByType(801013);
        if (groupByList == null || groupByList.getNumberChildren() == 0) {
            return null;
        }
        RQPDataItemSelfRef groupingItem = null;
        for (int j = 0; j < groupByList.getNumberChildren(); ++j) {
            IXQEQueryNode child = groupByList.getChild(j);
            if (child.getType() != 801010 || !(groupingItem = (RQPDataItemSelfRef)child).getName().equals(itemName)) continue;
            return groupingItem;
        }
        return null;
    }

    public static RQPQuery getOrCreateForReportSummaryQuery(PlanningEnvironment environment, RQPQuery parentRQPQuery) {
        RQPSubqueryList subqueryList = (RQPSubqueryList)parentRQPQuery.getSubqueryList();
        if (subqueryList != null) {
            for (int i = 0; i < subqueryList.getNumberChildren(); ++i) {
                RQPQuery subquery = (RQPQuery)subqueryList.getChild(i);
                if (!RQPSummaryQuery.isForReportSubquery(subquery)) continue;
                return subquery;
            }
        }
        RQPQuery summaryQuery = (RQPQuery)environment.getNodeFactory().createNode(801024);
        String name = parentRQPQuery.generateQueryName(801024);
        summaryQuery.setName(name);
        parentRQPQuery.addToSubqueryList(environment, summaryQuery, false);
        return summaryQuery;
    }

    public static boolean isForReportSubquery(RQPQuery subquery) {
        if (!subquery.isSummarizedQuery()) {
            return false;
        }
        IXQEQueryNode groupByList = subquery.getFirstChildByType(801013);
        return groupByList == null || groupByList.getNumberChildren() == 0;
    }

    public static boolean groupingItemsAreSubsetOf(IXQEQueryNode[] groupinItems1, IXQEQueryNode[] groupingItems2) {
        for (IXQEQueryNode groupingItem1 : groupinItems1) {
            boolean found = false;
            for (IXQEQueryNode groupingItem2 : groupingItems2) {
                if (!RQPSummaryQuery.isSameGroupingColumnExpression(groupingItem2, groupingItem1)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static RQPQuery determineScopeOfAutoForClause(PlanningEnvironment environment, V5AggregateFunction aggregateNode, RQPQuery rqpQuery, int[] queryTypes) {
        RQPDataItem projection = (RQPDataItem)aggregateNode.getAncestorOfType(801008);
        if (rqpQuery.getRootRQPQuery().isAutoSummaryTRUE()) {
            return rqpQuery.getDefaultSummaryQuery();
        }
        if (projection.isValueSetRefDataItem()) {
            V5AggregateFunction tempAggr = (V5AggregateFunction)environment.getNodeFactory().deepCopyNode(aggregateNode);
            tempAggr.addChild(RQPSummaryQuery.expandForClause(environment, rqpQuery, projection.getValueSet(), false));
            return RQPSummaryQuery.getExistingSummaryQueryMatchingAggregateForClause(rqpQuery, tempAggr, queryTypes, environment);
        }
        if (RQPUtilities.isAggregateToBeAdjustedForDetailContext(aggregateNode)) {
            return RQPSummaryQuery.getOrCreateForReportSummaryQuery(environment, rqpQuery);
        }
        if (RQPSummaryQuery.innerAggregateOfFooter(aggregateNode)) {
            V5AggregateFunction tempAggr = (V5AggregateFunction)environment.getNodeFactory().deepCopyNode(aggregateNode);
            RQPFooterQuery footerQuery = (RQPFooterQuery)aggregateNode.getAncestorOfType(801012);
            tempAggr.addChild(RQPSummaryQuery.expandForClause(environment, rqpQuery, footerQuery.getV5ValueSet(), true));
            return RQPSummaryQuery.getExistingSummaryQueryMatchingAggregateForClause(rqpQuery, tempAggr, queryTypes, environment);
        }
        return rqpQuery.getDefaultSummaryQuery();
    }

    public static boolean innerAggregateOfFooter(V5AggregateFunction aggregateNode) {
        return aggregateNode.getAncestorOfType(801012) != null && aggregateNode.getAncestorOfType(201031) != null;
    }

    public boolean isDefaultSummaryQuery() {
        RQPQuery parentRQPQuery = this.getParentRQPQuery();
        return parentRQPQuery.getDefaultSummaryQuery() == this;
    }
}

