/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IValueExpression;
import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLSearchedCase;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.SQLWindow;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.IFunction;
import com.cognos.xqe.runtree.relational.vectorization.VectorType;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorAggregateApproxCountDistinctDouble;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorAggregateApproxCountDistinctLong;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorAggregateAvgDouble;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorAggregateAvgLong;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorAggregateFirstValueDouble;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorAggregateFirstValueLong;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorAggregateLastValueDouble;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorAggregateLastValueLong;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorAggregateMaxDouble;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorAggregateMaxLong;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorAggregateMinDouble;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorAggregateMinLong;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorAggregateStdDevPopDouble;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorAggregateStdDevPopLong;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorAggregateStdDevSampDouble;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorAggregateStdDevSampLong;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorAggregateSumDouble;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorAggregateSumLong;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorAggregateVarPopDouble;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorAggregateVarPopLong;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorAggregateVarSampDouble;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorAggregateVarSampLong;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateApproxCountDistinctDecimal;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateApproxCountDistinctInterval;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateApproxCountDistinctString;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateApproxCountDistinctTimestamp;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateAvgDecimal;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateAvgInterval;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateCount;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateCountStar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateFirstValueDecimal;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateLastValueDecimal;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateMaxDecimal;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateMaxInterval;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateMaxString;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateMaxTimestamp;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateMinDecimal;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateMinInterval;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateMinString;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateMinTimestamp;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateStdDevPopDecimal;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateStdDevSampDecimal;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateSumDecimal;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateSumInterval;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateVarPopDecimal;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateVarSampDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class SQLAggregate
extends SQLAbstractFunction {
    private static final String MULTIPLE_DISTINCT = "supports.multipleDistinctAggregates";
    private static final String SQLSERVER_WINDOW_BEHAVIOUR = "supports.sqlserverWindowBehaviour";
    private static final String PROP_BOOLEAN_DISTINCT = "distinct";
    private static final String PROP_ENUM_SUBTYPE = "subType";
    public static final String OLAP = "olap.";
    private static final String AGGREGATES = "aggregates.";
    private static final String COMMA = ",";
    private static final String OPEN_SQUARE_BRACKET = "[";
    private static final String CLOSED_SQUARE_BRACKET = "]";
    private static final String ANY_TYPE = "any";
    private static final Map<String, Class<?>> VECTOR_CLASS_MAP = new HashMap();
    private static final String UNKNOWN = "unknown";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLAggregate.create(p, jjtid, 301034);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301034;
    }

    public SubType getSubType() {
        return (SubType)((Object)this.getPropertyValue(PROP_ENUM_SUBTYPE));
    }

    public void setSubType(SubType subType) {
        this.setPropertyValue(PROP_ENUM_SUBTYPE, (Object)subType);
    }

    @Override
    public String getFunctionName() {
        SubType subType = this.getSubType();
        if (subType == SubType.UDF) {
            return super.getFunctionName();
        }
        return subType.key();
    }

    @Override
    public int getNumberParameters() {
        int nParameters = this.getNumberChildren();
        IXQEQueryNode window = this.getFirstChildByType(301041);
        if (window != null) {
            --nParameters;
        }
        return nParameters;
    }

    public void setDistinct(boolean distinct) {
        this.setPropertyValue(PROP_BOOLEAN_DISTINCT, distinct);
    }

    @Override
    public boolean isUdf() {
        return this.getSubType() == SubType.UDF;
    }

    public boolean isDistinct() {
        return this.getBooleanPropertyValue(PROP_BOOLEAN_DISTINCT, false);
    }

    @Override
    protected String getCapabilityPrefix() {
        IXQEQueryNode window = this.getFirstChildByType(301041);
        StringBuilder key = new StringBuilder();
        if (window != null) {
            key.append(OLAP);
        } else {
            key.append(AGGREGATES);
        }
        key.append(this.getSQLFunctionName());
        return key.toString();
    }

    @Override
    protected String getCapabilitySuffix() {
        if (this.isDistinct()) {
            return ".distinct";
        }
        return "";
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        if (this == node) {
            return true;
        }
        if (node instanceof SQLAggregate) {
            SQLAggregate aggNode = (SQLAggregate)node;
            if (this.isDistinct() == aggNode.isDistinct() && this.getSubType() == aggNode.getSubType()) {
                if (this.getSubType() == SubType.UDF && !this.getFunctionName().equals(aggNode.getFunctionName())) {
                    return false;
                }
                if (this.getNumberChildren() != aggNode.getNumberChildren()) {
                    return false;
                }
                for (int i = 0; i < this.getNumberChildren(); ++i) {
                    if (this.getChild(i).isSameExpression(aggNode.getChild(i), compareCalcDefiniton)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public SQLWindow createOrGetWindow(IXQENodeFactory nodeFactory) {
        IXQEQueryNode[] windows = this.getChildrenOfType(301041);
        if (windows.length > 0) {
            return (SQLWindow)windows[0];
        }
        SQLWindow window = (SQLWindow)nodeFactory.createNode(301041);
        this.addChild(window);
        return window;
    }

    public SQLSortKey addSortKey(IXQEQueryNode sortKeyItem, boolean sortOrder, IXQENodeFactory nodeFactory) {
        SQLWindow window = this.createOrGetWindow(nodeFactory);
        SQLSortKeyList sortKeyList = window.createOrGetSortKeyList(nodeFactory);
        SQLSortKey sortKey = (SQLSortKey)nodeFactory.createNode(301020);
        sortKey.setAscending(sortOrder);
        sortKey.addChild(sortKeyItem);
        sortKeyList.addChild(sortKey);
        return sortKey;
    }

    public SQLSortKeyList getSortKeyList(IXQENodeFactory nodeFactory) {
        SQLWindow window = this.createOrGetWindow(nodeFactory);
        return window.createOrGetSortKeyList(nodeFactory);
    }

    public void addSortKey(IXQEQueryNode sortKeyItem, boolean sortOrder, SQLSortKey.NullOrdering nullOrdering, IXQENodeFactory nodeFactory) {
        SQLSortKey sortKey = this.addSortKey(sortKeyItem, sortOrder, nodeFactory);
        sortKey.setNullOrder(nullOrdering);
    }

    public boolean isWindowedAggregate() {
        return this.getFirstChildByType(301041) != null;
    }

    public boolean isStandardAggregate() {
        return this.getFirstChildByType(301041) == null;
    }

    @Override
    public boolean isProjectable() {
        return true;
    }

    @Override
    public boolean isProjectableForGroupBy() {
        return !this.isWindowedAggregate();
    }

    @Override
    public boolean hasWindowedAggregates() {
        return this.isWindowedAggregate();
    }

    public static boolean isAggregateFeatureSupported(IDataSourceCapabilities capabilities, SubType subType) {
        String pattern = capabilities.getStringValue(AGGREGATES + subType.key(), null);
        if (pattern == null || pattern.length() == 0) {
            pattern = null;
        }
        return pattern != null;
    }

    public static boolean isOlapFeatureSupported(IDataSourceCapabilities capabilities, SubType subType, int nParams) {
        String key = OLAP + subType.key() + OPEN_SQUARE_BRACKET;
        for (int i = 0; i < nParams; ++i) {
            if (i != 0) {
                key = key + COMMA;
            }
            key = key + ANY_TYPE;
        }
        String pattern = capabilities.getStringValue(key = key + CLOSED_SQUARE_BRACKET, null);
        if (pattern == null || pattern.length() == 0) {
            pattern = null;
        }
        return pattern != null;
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        boolean result = false;
        if (this.getSubType() == SubType.UDF) {
            IFunction function = FunctionManager.getUserDefinedFunction(this.getFunctionName(), this.getParameterTypes());
            if (function == null || function.isDbFunction()) {
                result = true;
            }
        } else {
            result = super.isSupportedImpl(dataSource, ul);
            if (result && this.getSubType() == SubType.COUNT && ((SQLExpression)this.getChild(0)).isConstantExpression() && !dataSource.getCapabilities().isSupported("supports.constantsInCount")) {
                result = false;
            }
            if (result && this.getFirstDescendantOfTypeOrdered(301034, false) != null) {
                List<IXQEQueryNode> aggregates = this.getDescendantsOfTypeOrdered(301034, false);
                boolean nestedOlap = false;
                for (int i = 0; i < aggregates.size() && !nestedOlap; ++i) {
                    nestedOlap = ((SQLAggregate)aggregates.get(i)).isWindowedAggregate();
                }
                if (nestedOlap && !(result = dataSource.getCapabilities().isSupported("supports.nestedOlap"))) {
                    SQLAggregate.addUnsupportedReason(ul, "Nested olap aggregates.", this);
                }
            }
            if (result && this.getFirstDescendantOfTypeOrdered(301059, false) != null && !(result = dataSource.getCapabilities().isSupported("supports.subqueriesInAggregate"))) {
                SQLAggregate.addUnsupportedReason(ul, "Subquery in Aggregate.", this);
            }
            boolean bl = result = result && (!this.isDistinct() || !this.hasOrderBy());
        }
        if (result && !dataSource.getCapabilities().getBooleanValue(MULTIPLE_DISTINCT)) {
            IXQEQueryNode ancestor = this.getAncestorOfType(new int[]{301015, 301010});
            SQLValueList vList = (SQLValueList)ancestor.getChild(1);
            IXQEQueryNode[] aggregates = vList.getChildrenOfType(301034);
            ArrayList<IXQEQueryNode> distinctAggregates = new ArrayList<IXQEQueryNode>();
            for (IXQEQueryNode agg : aggregates) {
                if (!((SQLAggregate)agg).isDistinct()) continue;
                distinctAggregates.add(agg);
            }
            for (int i = 1; i < distinctAggregates.size(); ++i) {
                if (((IXQEQueryNode)distinctAggregates.get(i - 1)).isSameExpression((IXQEQueryNode)distinctAggregates.get(i), false)) continue;
                SQLAggregate.addUnsupportedReason(ul, "Cannot support multiple distinct aggregates in a projection.", this);
                result = false;
                break;
            }
        }
        if (this.getSubType() == SubType.ROW_NUMBER && !this.hasOrderBy()) {
            result = dataSource.getCapabilities().isSupported("supports.rowNumberNoOrderBy");
            SQLWindow window = (SQLWindow)this.getFirstChildByType(301041);
            if (!result && null != window && window.isSamplingScope()) {
                result = true;
            }
        }
        return result;
    }

    private boolean hasOrderBy() {
        SQLWindow window = (SQLWindow)this.getFirstChildByType(301041);
        if (window == null) {
            return false;
        }
        return null != window.getOrderBy();
    }

    public static String getAggregateFunctionName(SubType subType) {
        return subType.key();
    }

    @Override
    public String getPattern(IDataSourceCapabilities capabilities) {
        if (this.getSubType() != SubType.UDF) {
            return super.getOverloadedPattern(capabilities);
        }
        int nChildren = this.getNumberChildren();
        IXQEQueryNode window = this.getFirstChildByType(301041);
        if (window != null) {
            --nChildren;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getFunctionName());
        buffer.append("(");
        for (int i = 0; i < nChildren; ++i) {
            if (i > 0) {
                buffer.append(COMMA);
            }
            buffer.append("%");
            buffer.append(i + 1);
            buffer.append("$s");
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public boolean isConvertible(IDataSourceCapabilities capabilities) {
        boolean status;
        switch (this.getSubType()) {
            case DIFFERENCE: {
                status = SQLAggregate.isOlapFeatureSupported(capabilities, SubType.LAG, this.getNumberParameters());
                if (status || !(status = SQLAggregate.isOlapFeatureSupported(capabilities, SubType.MAX, this.getNumberParameters()))) break;
                SQLQueryBlock pQueryBlock = (SQLQueryBlock)this.getAncestorOfType(301004);
                if (pQueryBlock.getDataSource().getCapabilities().getBooleanValue(SQLSERVER_WINDOW_BEHAVIOUR)) {
                    status = false;
                    break;
                }
                status = this.checkWindowSpecificationSupport(capabilities);
                break;
            }
            case RATIO_TO_REPORT: {
                status = SQLAggregate.isOlapFeatureSupported(capabilities, SubType.SUM, 1);
                if (!status) break;
                IDataType dt = ((SQLQueryNode)this.getChild(0)).getDataType();
                IDataType[] dta = new IDataType[]{dt, dt};
                IDataType[] dtb = new IDataType[]{dt, DataTypeFactory.getDoubleType()};
                status = SQLAbstractFunction.isFeatureSupported(capabilities, "operators.arithmetic.Divide", dta) && !dt.isExactNumeric() || !capabilities.getBooleanValue("supports.integerDivision") || SQLAbstractFunction.isFeatureSupported(capabilities, "expressions.Cast", dtb);
                break;
            }
            case ROW_NUMBER: {
                status = SQLAggregate.isOlapFeatureSupported(capabilities, SubType.SUM, 1) && this.checkWindowSpecificationSupport(capabilities);
                break;
            }
            case TERTILE: {
                status = SQLAggregate.isOlapFeatureSupported(capabilities, SubType.NTILE, 1) && SQLSearchedCase.isFeatureSupported(capabilities);
                break;
            }
            default: {
                status = false;
            }
        }
        return status;
    }

    public boolean checkWindowSpecificationSupport(IDataSourceCapabilities capabilities) {
        IXQEQueryNode[] windows = this.getChildrenOfType(301041);
        SQLWindow window = (SQLWindow)windows[0];
        String wSpec = "olap.Window.Specification[";
        if (window.getPartitionBy() != null) {
            wSpec = wSpec + "P";
        }
        if (window.getOrderBy() != null) {
            wSpec = wSpec + "O";
        }
        wSpec = wSpec + "F]";
        return capabilities.getBooleanValue(wSpec);
    }

    @Override
    public boolean isConstantValue() {
        SQLWindow window = (SQLWindow)this.getFirstChildByType(301041);
        if (window == null) {
            return false;
        }
        return window.isReportAggregate() && window.getPartitionBy() == null && window.getOrderBy() == null;
    }

    public boolean isExecutable() {
        return false;
    }

    @Override
    public boolean isXMLFunction() {
        return this.getSubType() == SubType.XMLAGG;
    }

    @Override
    protected boolean isSimpleType(XQEPersistContext ctx, Object value) {
        return super.isSimpleType(ctx, value) || value instanceof SubType;
    }

    @Override
    protected void persistAttributeProperty(XQEPersistContext ctx, String key, Object value) {
        if (value instanceof SubType) {
            ctx.property(key, ((SubType)((Object)value)).name(), "sub:");
        } else {
            super.persistAttributeProperty(ctx, key, value);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        Namespace ns = att.getNamespace();
        if (ns.getURI().equals("http://developer.cognos.com/Types/SubType")) {
            for (SubType val : SubType.values()) {
                if (!val.name().equals(att.getValue())) continue;
                this.setPropertyValue(att.getName(), (Object)val);
                break;
            }
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    public Class<?> getVectorClass(IDataType resultType) {
        SubType subType = this.getSubType();
        String className = null;
        String typeName = null;
        String argumentName = null;
        IValueExpression exprNode = null;
        if (subType == SubType.COUNT || subType == SubType.COUNT_STAR) {
            className = String.format("XVectorAggregate%s", this.getFunctionName());
        } else {
            exprNode = (IValueExpression)this.getChild(0);
            if (XVectorRowBatchUtil.getVectorTypeFromDataType(resultType) == VectorType.DECIMAL) {
                className = String.format("XVectorAggregate%sDecimal", this.getFunctionName());
            } else {
                typeName = this.getTypeName(exprNode);
                className = String.format("XVectorAggregate%s%s", this.getFunctionName(), typeName);
            }
        }
        Class<?> theClassName = VECTOR_CLASS_MAP.get(className);
        if (theClassName == null) {
            if (exprNode != null) {
                try {
                    argumentName = (String)exprNode.getPropertyValue("name");
                }
                catch (Exception e) {
                    argumentName = UNKNOWN;
                }
            } else {
                argumentName = UNKNOWN;
            }
            if (typeName == null) {
                typeName = UNKNOWN;
            }
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidArgumentType, (Object)typeName, (Object)argumentName, (Object)this.getFunctionName());
        }
        return theClassName;
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        boolean vectorizable;
        SubType subType = this.getSubType();
        boolean bl = vectorizable = this.isWindowedAggregate() || !this.isDistinct() && (subType == SubType.MIN || subType == SubType.MAX || subType == SubType.SUM || subType == SubType.AVG || subType == SubType.VAR_POP || subType == SubType.VAR_SAMP || subType == SubType.STDDEV_POP || subType == SubType.STDDEV_SAMP || subType == SubType.COUNT || subType == SubType.COUNT_STAR || subType == SubType.FIRST_VALUE || subType == SubType.LAST_VALUE || subType == SubType.APPROX_COUNT_DISTINCT);
        if (!vectorizable) {
            if (this.isDistinct()) {
                SQLAggregate.addUnsupportedReasonForVQE(ul, "Unsupported distinct aggregate");
            } else {
                SQLAggregate.addUnsupportedReasonForVQE(ul, "Unsupported aggregate: " + subType.key());
            }
        }
        for (int i = 0; i < this.getNumberChildren() && vectorizable; ++i) {
            vectorizable = ((ISQLQueryNode)this.getChild(i)).isVectorizable(ul);
        }
        return vectorizable;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 301034) {
            return true;
        }
        return super.isOfCategory(category);
    }

    static {
        VECTOR_CLASS_MAP.put("XVectorAggregateCount", XVectorAggregateCount.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateCountStar", XVectorAggregateCountStar.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateAvgLong", XVectorAggregateAvgLong.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateAvgDouble", XVectorAggregateAvgDouble.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateAvgDecimal", XVectorAggregateAvgDecimal.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateAvgInterval", XVectorAggregateAvgInterval.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateFirstValueLong", XVectorAggregateFirstValueLong.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateFirstValueDouble", XVectorAggregateFirstValueDouble.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateFirstValueDecimal", XVectorAggregateFirstValueDecimal.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateLastValueLong", XVectorAggregateLastValueLong.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateLastValueDouble", XVectorAggregateLastValueDouble.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateLastValueDecimal", XVectorAggregateLastValueDecimal.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateMaxLong", XVectorAggregateMaxLong.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateMaxDouble", XVectorAggregateMaxDouble.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateMaxDecimal", XVectorAggregateMaxDecimal.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateMaxInterval", XVectorAggregateMaxInterval.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateMaxTimestamp", XVectorAggregateMaxTimestamp.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateMinLong", XVectorAggregateMinLong.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateMinDouble", XVectorAggregateMinDouble.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateMinDecimal", XVectorAggregateMinDecimal.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateMinInterval", XVectorAggregateMinInterval.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateMinTimestamp", XVectorAggregateMinTimestamp.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateStdDevPopLong", XVectorAggregateStdDevPopLong.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateStdDevPopDouble", XVectorAggregateStdDevPopDouble.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateStdDevPopDecimal", XVectorAggregateStdDevPopDecimal.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateStdDevSampLong", XVectorAggregateStdDevSampLong.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateStdDevSampDouble", XVectorAggregateStdDevSampDouble.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateStdDevSampDecimal", XVectorAggregateStdDevSampDecimal.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateVarPopLong", XVectorAggregateVarPopLong.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateVarPopDouble", XVectorAggregateVarPopDouble.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateVarPopDecimal", XVectorAggregateVarPopDecimal.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateVarSampLong", XVectorAggregateVarSampLong.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateVarSampDouble", XVectorAggregateVarSampDouble.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateVarSampDecimal", XVectorAggregateVarSampDecimal.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateMinString", XVectorAggregateMinString.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateMaxString", XVectorAggregateMaxString.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateSumLong", XVectorAggregateSumLong.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateSumDouble", XVectorAggregateSumDouble.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateSumDecimal", XVectorAggregateSumDecimal.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateSumInterval", XVectorAggregateSumInterval.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateApproxCountDistinctLong", XVectorAggregateApproxCountDistinctLong.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateApproxCountDistinctDouble", XVectorAggregateApproxCountDistinctDouble.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateApproxCountDistinctString", XVectorAggregateApproxCountDistinctString.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateApproxCountDistinctDecimal", XVectorAggregateApproxCountDistinctDecimal.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateApproxCountDistinctTimestamp", XVectorAggregateApproxCountDistinctTimestamp.class);
        VECTOR_CLASS_MAP.put("XVectorAggregateApproxCountDistinctInterval", XVectorAggregateApproxCountDistinctInterval.class);
    }

    public static enum SubType {
        UDF("udaf"),
        MAX("Max"),
        MIN("Min"),
        SUM("Sum"),
        AVG("Avg"),
        COUNT("Count"),
        COUNT_STAR("CountStar"),
        APPROX_COUNT_DISTINCT("ApproxCountDistinct"),
        STDDEV_POP("StdDevPop"),
        STDDEV_SAMP("StdDevSamp"),
        VAR_POP("VarPop"),
        VAR_SAMP("VarSamp"),
        FIRST_VALUE("FirstValue"),
        LAG("Lag"),
        LAST_VALUE("LastValue"),
        LEAD("Lead"),
        EVERY("Every"),
        ANY("Any"),
        PERCENTILE_CONT("PercentileCont"),
        PERCENTILE_DISC("PercentileDisc"),
        COVAR_POP("CovarPop"),
        COVAR_SAMP("CovarSamp"),
        CORR("Corr"),
        REGR_SLOPE("RegrSlope"),
        REGR_INTERCEPT("RegrIntercept"),
        REGR_COUNT("RegrCount"),
        REGR_R2("RegrR2"),
        REGR_AVGX("RegrAvgX"),
        REGR_AVGY("RegrAvgY"),
        REGR_SXX("RegrSXX"),
        REGR_SYY("RegrSYY"),
        REGR_SXY("RegrSXY"),
        XMLAGG("XMLAgg"),
        ROW_NUMBER("RowNumber"),
        RANK("Rank"),
        DENSE_RANK("DenseRank"),
        PERCENT_RANK("PercentRank"),
        CUME_DIST("CumeDist"),
        CUME_DIST_H("CumeDistH"),
        NTILE("NTile"),
        TERTILE("Tertile"),
        RATIO_TO_REPORT("RatioToReport"),
        DIFFERENCE("Difference"),
        GROUPING("Grouping"),
        NTH_VALUE("NthValue"),
        ARRAY_AGG("ArrayAgg"),
        COLLECT("Collect"),
        MEDIAN("Median"),
        JSON_ARRAYAGG("JSONArrayAgg"),
        JSON_OBJECTAGG("JSONObjectAgg");

        private String key;

        private SubType(String theKey) {
            this.key = theKey;
        }

        String key() {
            return this.key;
        }
    }
}

