/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IValueExpression;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLDataType;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.IScalarFunction;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastDateToString;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastDateToTimestamp;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastDecimalToDecimal;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastDecimalToDouble;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastDecimalToLong;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastDecimalToString;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastDoubleToDecimal;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastDoubleToDouble;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastDoubleToLong;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastDoubleToString;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastLongToDecimal;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastLongToDouble;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastLongToLong;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastLongToString;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastStringToDate;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastStringToDateWithFormat;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastStringToDecimal;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastStringToDouble;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastStringToLong;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastStringToTime;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastStringToTimeWithFormat;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastStringToTimeWithTZ;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastStringToTimeWithTZWithFormat;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastStringToTimestamp;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastStringToTimestampWithFormat;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastStringToTimestampWithTZ;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastStringToTimestampWithTZWithFormat;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastTimeToString;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastTimestampToDate;
import com.cognos.xqe.runtree.relational.vectorization.expressions.cast.XVectorCastTimestampToString;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLCast
extends SQLAbstractFunction {
    private static final String DATE = "Date";
    private static final String TIME = "Time";
    private static final String TIME_WITH_TZ = "TimeWithTZ";
    private static final String TIMESTAMP = "Timestamp";
    private static final String TIMESTAMP_WITH_TZ = "TimestampWithTZ";
    private static final String FUNCTION_NAME = "Cast";
    private static final String CAPABILITY_KEY = "expressions.Cast";
    public static final int NUM_FORMAT_ARGS = 5;
    public static final int SOURCE_ARG_INDEX = 0;
    public static final int TARGET_TYPE_INDEX = 1;
    public static final int TARGET_PRECISION_INDEX = 2;
    public static final int TARGET_SCALE_INDEX = 3;
    public static final int FORMAT_INDEX = 4;
    public static final String PROP_STRING_OPTIONAL = "optional";
    public static final String FALSE = "false";
    public static final String TRUE = "true";
    public static final int THREE_NUM = 3;
    public static final String PROP_ON_ERROR_POLICY = "onErrorPolicy";
    private static final Map<String, Class<?>> VECTOR_CLASS_MAP = new HashMap();

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLCast.create(p, jjtid, 301047);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301047;
    }

    @Override
    public IDataType getDataType() {
        return ((SQLDataType)this.getChild(1)).getDataType();
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    public boolean isProjectable() {
        return !this.isOptional();
    }

    @Override
    public String getPattern(IDataSourceCapabilities capabilities) {
        return super.getOverloadedPattern(capabilities);
    }

    @Override
    protected String getCapabilityPrefix() {
        return CAPABILITY_KEY;
    }

    @Override
    protected String getKey() {
        return CAPABILITY_KEY;
    }

    public void setOptional(Boolean value) {
        this.setPropertyValue(PROP_STRING_OPTIONAL, value);
    }

    public boolean isOptional() {
        Boolean value = this.getBooleanPropertyValue(PROP_STRING_OPTIONAL);
        if (value == null) {
            return false;
        }
        return value;
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        boolean result = super.isSupportedImpl(dataSource, ul);
        if (!result && this.isOptional()) {
            IDataSourceCapabilities capabilities = dataSource.getCapabilities();
            result = capabilities.getStringValue("supports.integerDivision", FALSE).equals(FALSE);
            if (!result) {
                SQLCast.addUnsupportedReason(ul, "Optional CAST is needed, but not supported.", this);
            } else {
                result = this.getChild(0).isSupported(dataSource);
            }
        }
        if (this.getOnErrorPolicy() == SQLAbstractFunction.OnErrorPolicy.NULL) {
            result = false;
        }
        return result;
    }

    public static boolean isFeatureSupported(IDataSourceCapabilities capabilities, IDataType[] fArguments) {
        return SQLAbstractFunction.isFeatureSupported(capabilities, CAPABILITY_KEY, fArguments);
    }

    @Override
    public IValue execute(XDataContext context) {
        IDataType[] argTypes = this.getParameterTypes();
        IScalarFunction function = (IScalarFunction)FunctionManager.getBuiltinFunction(FUNCTION_NAME);
        IValue value = function.getResultDataType(argTypes).createValue();
        function.execute(context, (IParameterEvaluator)this, value);
        this.setPropertyValue("foldingApplied", Boolean.TRUE);
        return value;
    }

    @Override
    public boolean isExecutable(boolean localProcessing) {
        return localProcessing && this.getChild(0) instanceof SQLExpression && ((SQLExpression)this.getChild(0)).isExecutable(localProcessing);
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        boolean vectorizable;
        boolean bl = vectorizable = this.getVectorClass() != null;
        if (vectorizable) {
            for (int i = 0; i < this.getNumberChildren() && vectorizable; ++i) {
                vectorizable = ((ISQLQueryNode)this.getChild(i)).isVectorizable(ul);
            }
        } else {
            SQLCast.addUnsupportedReasonForVQE(ul, "Unsupported function: cast " + ((IValueExpression)this.getChild(0)).getDataType() + " to " + ((IValueExpression)this.getChild(1)).getDataType());
        }
        return vectorizable;
    }

    @Override
    public Class<?> getVectorClass() {
        return VECTOR_CLASS_MAP.get(this.getVectorClassName());
    }

    public static Class<?> getVectorClass(IDataType inputDataType, IDataType castDataType) {
        return VECTOR_CLASS_MAP.get(SQLCast.getVectorClassName(inputDataType, castDataType));
    }

    public String getVectorClassName() {
        StringBuilder sb = new StringBuilder();
        sb.append(SQLCast.getVectorClassName(((IValueExpression)this.getChild(0)).getDataType(), ((IValueExpression)this.getChild(1)).getDataType()));
        if (this.getNumberChildren() == 3) {
            sb.append("WithFormat");
        }
        return sb.toString();
    }

    public static String getVectorClassName(IDataType inputDataType, IDataType castDataType) {
        return String.format("XVectorCast%sTo%s", SQLCast.getTypeName(inputDataType), SQLCast.getTypeName(castDataType));
    }

    protected static String getTypeName(IDataType dataType) {
        String typeName = dataType.getCCLTypeCode() == 57 ? DATE : (dataType.getCCLTypeCode() == 58 ? TIME : (dataType.getCCLTypeCode() == 52 ? TIME_WITH_TZ : (dataType.getCCLTypeCode() == 59 ? TIMESTAMP : (dataType.getCCLTypeCode() == 53 ? TIMESTAMP_WITH_TZ : SQLAbstractFunction.getTypeName(dataType)))));
        return typeName;
    }

    @Override
    public boolean needAdjustDataType() {
        return false;
    }

    @Override
    public SQLAbstractFunction.OnErrorPolicy getOnErrorPolicy() {
        Object oep = this.getPropertyValue(PROP_ON_ERROR_POLICY);
        if (oep != null) {
            return (SQLAbstractFunction.OnErrorPolicy)((Object)oep);
        }
        return SQLAbstractFunction.OnErrorPolicy.ERROR;
    }

    @Override
    public void setOnErrorPolicy(SQLAbstractFunction.OnErrorPolicy oep) {
        this.setPropertyValue(PROP_ON_ERROR_POLICY, (Object)oep);
    }

    @Override
    public boolean hasOnErrorPolicyBeenSet() {
        return this.getPropertyValue(PROP_ON_ERROR_POLICY) != null;
    }

    static {
        VECTOR_CLASS_MAP.put("XVectorCastDateToString", XVectorCastDateToString.class);
        VECTOR_CLASS_MAP.put("XVectorCastDateToTimestamp", XVectorCastDateToTimestamp.class);
        VECTOR_CLASS_MAP.put("XVectorCastDoubleToLong", XVectorCastDoubleToLong.class);
        VECTOR_CLASS_MAP.put("XVectorCastDoubleToDouble", XVectorCastDoubleToDouble.class);
        VECTOR_CLASS_MAP.put("XVectorCastDoubleToDecimal", XVectorCastDoubleToDecimal.class);
        VECTOR_CLASS_MAP.put("XVectorCastDoubleToString", XVectorCastDoubleToString.class);
        VECTOR_CLASS_MAP.put("XVectorCastDecimalToLong", XVectorCastDecimalToLong.class);
        VECTOR_CLASS_MAP.put("XVectorCastDecimalToDouble", XVectorCastDecimalToDouble.class);
        VECTOR_CLASS_MAP.put("XVectorCastDecimalToDecimal", XVectorCastDecimalToDecimal.class);
        VECTOR_CLASS_MAP.put("XVectorCastDecimalToString", XVectorCastDecimalToString.class);
        VECTOR_CLASS_MAP.put("XVectorCastLongToLong", XVectorCastLongToLong.class);
        VECTOR_CLASS_MAP.put("XVectorCastLongToDouble", XVectorCastLongToDouble.class);
        VECTOR_CLASS_MAP.put("XVectorCastLongToDecimal", XVectorCastLongToDecimal.class);
        VECTOR_CLASS_MAP.put("XVectorCastLongToString", XVectorCastLongToString.class);
        VECTOR_CLASS_MAP.put("XVectorCastStringToLong", XVectorCastStringToLong.class);
        VECTOR_CLASS_MAP.put("XVectorCastStringToDouble", XVectorCastStringToDouble.class);
        VECTOR_CLASS_MAP.put("XVectorCastStringToDecimal", XVectorCastStringToDecimal.class);
        VECTOR_CLASS_MAP.put("XVectorCastStringToDate", XVectorCastStringToDate.class);
        VECTOR_CLASS_MAP.put("XVectorCastStringToTime", XVectorCastStringToTime.class);
        VECTOR_CLASS_MAP.put("XVectorCastStringToTimeWithTZ", XVectorCastStringToTimeWithTZ.class);
        VECTOR_CLASS_MAP.put("XVectorCastStringToTimestamp", XVectorCastStringToTimestamp.class);
        VECTOR_CLASS_MAP.put("XVectorCastStringToTimestampWithTZ", XVectorCastStringToTimestampWithTZ.class);
        VECTOR_CLASS_MAP.put("XVectorCastTimeToString", XVectorCastTimeToString.class);
        VECTOR_CLASS_MAP.put("XVectorCastTimestampToDate", XVectorCastTimestampToDate.class);
        VECTOR_CLASS_MAP.put("XVectorCastTimestampToString", XVectorCastTimestampToString.class);
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String localFormattingOnCastOperator = config.getStringProperty("queryPlanning.localFormattingOnCastOperator[@enabled]", FALSE);
        if (localFormattingOnCastOperator.equalsIgnoreCase(TRUE)) {
            VECTOR_CLASS_MAP.put("XVectorCastStringToDateWithFormat", XVectorCastStringToDateWithFormat.class);
            VECTOR_CLASS_MAP.put("XVectorCastStringToTimeWithFormat", XVectorCastStringToTimeWithFormat.class);
            VECTOR_CLASS_MAP.put("XVectorCastStringToTimeWithTZWithFormat", XVectorCastStringToTimeWithTZWithFormat.class);
            VECTOR_CLASS_MAP.put("XVectorCastStringToTimestampWithFormat", XVectorCastStringToTimestampWithFormat.class);
            VECTOR_CLASS_MAP.put("XVectorCastStringToTimestampWithTZWithFormat", XVectorCastStringToTimestampWithTZWithFormat.class);
        }
    }
}

