/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLIdentifier;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.IDataType;

public class SQLColumn
extends SQLIdentifier {
    public static final String PROP_OBJECT_DATATYPE = "dataType";
    public static final String PROP_ORIGINAL_TABLE_NAME = "orginalTableName";
    public static final String PROP_BOOLEAN_ISPSEUDOCOLUMN = "isPseudoColumn";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLColumn.create(p, jjtid, 301005);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301005;
    }

    @Override
    public IDataType getDataType() {
        return (IDataType)this.getPropertyValue(PROP_OBJECT_DATATYPE);
    }

    public void setDataType(IDataType dataType) {
        this.setPropertyValue(PROP_OBJECT_DATATYPE, dataType);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        super.setIdentifierChain(new String[]{name});
    }

    public boolean isPseudoColumn() {
        return (Boolean)this.getPropertyValue(PROP_BOOLEAN_ISPSEUDOCOLUMN) == Boolean.TRUE;
    }

    public void setIsPseudoColumn(boolean isPseudoColumn) {
        this.setPropertyValue(PROP_BOOLEAN_ISPSEUDOCOLUMN, isPseudoColumn);
    }

    @Override
    public int isValidPlannedQuery() {
        return -1;
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        if (this == node) {
            return true;
        }
        if (node instanceof SQLColumn) {
            SQLColumn column = (SQLColumn)node;
            if (this.getName().equals(column.getName())) {
                String thisTableName = this.getTableName();
                String columnTableName = column.getTableName();
                if (thisTableName == null && columnTableName == null) {
                    return true;
                }
                if (thisTableName != null && columnTableName != null && thisTableName.equals(columnTableName)) {
                    return true;
                }
            }
        }
        return false;
    }

    public String getOriginalTableName() {
        String origName = (String)this.getPropertyValue(PROP_ORIGINAL_TABLE_NAME);
        if (origName != null) {
            return origName;
        }
        return this.getTableName();
    }
}

