/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.QueryFormatter;
import com.cognos.xqe.ast.sql.SQLDataFlowNode;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import com.cognos.xqe.transformation.relational.optimization.util.FactorAnalyzer;
import com.cognos.xqe.transformation.relational.optimization.util.SelectivityEstimator;
import java.util.List;

public class SQLFilter
extends SQLDataFlowNode {
    private static final String CAPABILITIES_KEY = "clauses.Where";
    public static final String PROP_OBJECT_INCIDENCE = "incidence";
    public static final String PROP_DOUBLE_SELECTIVITY = "selectivity";
    public static final String PROP_ENUM_FACTORTYPE = "factorType";
    public static final String PROP_INTEGER_LSOURCENO = "lSourceNo";
    public static final String PROP_INTEGER_RSOURCENO = "rSourceNo";
    public static final String PROP_INTEGER_SUBTYPE = "subType";
    public static final String PROP_INTEGER_NCONJUNCTS = "nConjuncts";
    public static final String PROP_BOOLEAN_ISCORRELATED = "isCorrelated";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLFilter.create(p, jjtid, 301009);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301009;
    }

    public SQLExpression getPredicate() {
        return (SQLExpression)this.getChild(1);
    }

    @Override
    public IXQEQueryNode getFilterNode() {
        return this;
    }

    @Override
    public BitMask incidence(BitMask mask) {
        this.getPredicate().incidence(mask);
        return mask;
    }

    public BitMask getIncidence() {
        return (BitMask)this.getPropertyValue(PROP_OBJECT_INCIDENCE);
    }

    public void setIncidence(BitMask incidence) {
        this.setPropertyValue(PROP_OBJECT_INCIDENCE, incidence);
    }

    public FactorAnalyzer.FactorType getFactorType() {
        return (FactorAnalyzer.FactorType)((Object)this.getPropertyValue(PROP_ENUM_FACTORTYPE));
    }

    public void setFactorType(FactorAnalyzer.FactorType factorType) {
        this.setPropertyValue(PROP_ENUM_FACTORTYPE, (Object)factorType);
    }

    public boolean isCorrelated() {
        return (Boolean)this.getPropertyValue(PROP_BOOLEAN_ISCORRELATED);
    }

    public void setCorrelated(Boolean isCorrelated) {
        this.setPropertyValue(PROP_BOOLEAN_ISCORRELATED, isCorrelated);
    }

    public double getSelectivity() {
        Double selectivity = (Double)this.getPropertyValue(PROP_DOUBLE_SELECTIVITY);
        if (selectivity != null) {
            return selectivity;
        }
        return SelectivityEstimator.getSelectivity(this.getPredicate());
    }

    public void setSelectivity(double selectivity) {
        this.setPropertyValue(PROP_DOUBLE_SELECTIVITY, selectivity);
    }

    @Override
    public double getCardinality() {
        return ((ISQLQueryNode)this.getChild(0)).getCardinality() * this.getSelectivity();
    }

    public int getLeftSourceNo() {
        return (Integer)this.getPropertyValue(PROP_INTEGER_LSOURCENO);
    }

    public void setLeftSourceNo(int lSourceNo) {
        this.setPropertyValue(PROP_INTEGER_LSOURCENO, lSourceNo);
    }

    public int getRightSourceNo() {
        return (Integer)this.getPropertyValue(PROP_INTEGER_RSOURCENO);
    }

    public void setRightSourceNo(int rSourceNo) {
        this.setPropertyValue(PROP_INTEGER_RSOURCENO, rSourceNo);
    }

    public int getSubType() {
        Integer property = (Integer)this.getPropertyValue(PROP_INTEGER_SUBTYPE);
        if (property != null) {
            return property;
        }
        return 301009;
    }

    public void setSubType(int subType) {
        this.setPropertyValue(PROP_INTEGER_SUBTYPE, subType);
    }

    public int getNumberOfConjuncts() {
        Integer nConjuncts = (Integer)this.getPropertyValue(PROP_INTEGER_NCONJUNCTS);
        if (nConjuncts != null) {
            return nConjuncts;
        }
        return 0;
    }

    public void incrementNumberOfConjuncts() {
        this.setPropertyValue(PROP_INTEGER_NCONJUNCTS, this.getNumberOfConjuncts() + 1);
    }

    @Override
    public void getCognosSQL(IDataSourceCapabilities capabilities, QueryFormatter formatter) {
        formatter.setCurrentNodeIndentationLevel(0);
        formatter.addNewLineAndIndentation();
        formatter.addText(this.getPattern(capabilities));
        formatter.addSpace();
        formatter.increaseCurrentNodeIndentationLevel();
        formatter.addNewLineAndIndentation();
        ((SQLQueryNode)this.getChild(1)).accept(formatter, capabilities);
        formatter.decreaseCurrentNodeIndentationLevel();
    }

    @Override
    protected String getKey() {
        return CAPABILITIES_KEY;
    }

    @Override
    public void getProjectableExpressions(IDataSource dataSource, SQLJoin.SubType jType, int sourceNo, List<IXQEQueryNode> exprNodeList, List<IXQEQueryNode> excludeList, IXQEQueryNode anchorNode, BitMask mask) {
        BitMask eMask = this.incidence(new BitMask());
        if (!(eMask.isEmpty() || mask.isEmpty() || eMask.intersects(mask))) {
            SQLQueryNode dataFlow = (SQLQueryNode)this.getChild(0);
            if (dataFlow != anchorNode && dataFlow.getType() != 301004) {
                dataFlow.getProjectableExpressions(dataSource, jType, sourceNo, exprNodeList, excludeList, anchorNode, mask);
            }
        } else {
            super.getProjectableExpressions(dataSource, jType, sourceNo, exprNodeList, excludeList, anchorNode, mask);
        }
    }

    public static boolean isFeatureSupported(IDataSourceCapabilities capabilities) {
        String pattern = capabilities.getStringValue(CAPABILITIES_KEY, null);
        if (pattern == null || pattern.length() == 0) {
            pattern = null;
        }
        return pattern != null;
    }

    @Override
    public int getNumberColumns() {
        IXQEQueryNode child = this.getChild(0);
        return ((ISQLQueryNode)child).getNumberColumns();
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 301089) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        boolean vectorizable = true;
        for (int i = 0; i < this.getNumberChildren() && vectorizable; ++i) {
            vectorizable = ((ISQLQueryNode)this.getChild(i)).isVectorizable(ul);
        }
        return vectorizable;
    }
}

