/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IValueExpression;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.IFunction;
import com.cognos.xqe.runtree.relational.vectorization.VectorType;
import com.cognos.xqe.runtree.relational.vectorization.expressions.character.XVectorBitLength;
import com.cognos.xqe.runtree.relational.vectorization.expressions.character.XVectorCharLength;
import com.cognos.xqe.runtree.relational.vectorization.expressions.character.XVectorLower;
import com.cognos.xqe.runtree.relational.vectorization.expressions.character.XVectorOctetLength;
import com.cognos.xqe.runtree.relational.vectorization.expressions.character.XVectorReverse;
import com.cognos.xqe.runtree.relational.vectorization.expressions.character.XVectorStringScalarIndexStringColumn;
import com.cognos.xqe.runtree.relational.vectorization.expressions.character.XVectorStringScalarPositionStringColumn;
import com.cognos.xqe.runtree.relational.vectorization.expressions.character.XVectorSubstring;
import com.cognos.xqe.runtree.relational.vectorization.expressions.character.XVectorSubstring2Args;
import com.cognos.xqe.runtree.relational.vectorization.expressions.character.XVectorUpper;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorAddDaysScalar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorAddFractionalSecondsScalar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorAddHoursScalar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorAddMinutesScalar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorAddMonthsScalar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorAddQuartersScalar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorAddSecondsScalar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorAddWeeksScalar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorAddYearsScalar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorAge;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorCurrentDate;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorCurrentTime;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorCurrentTimestamp;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorDayOfWeek;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorDayOfYear;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorDaysBetween;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorDaysToEndOfMonth;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorFirstOfMonth;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorFractionalSecondsBetween;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorHoursBetween;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorLastOfMonth;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorLocalTime;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorLocalTimestamp;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorMinutesBetween;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorMonthsBetween;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorQuartersBetween;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorSecondsBetween;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorWeekOfYear;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorWeeksBetween;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorYMDIntBetween;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorYearsBetween;
import com.cognos.xqe.runtree.relational.vectorization.expressions.regex.XVectorOccurrencesRegex;
import com.cognos.xqe.runtree.relational.vectorization.expressions.regex.XVectorPositionRegex;
import com.cognos.xqe.runtree.relational.vectorization.expressions.regex.XVectorSubstringRegex;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class SQLFunction
extends SQLAbstractFunction {
    private static final String COM_COGNOS_XQE_RUNTREE_RELATIONAL_VECTORIZATION_EXPRESSIONS_NUMERIC = "com.cognos.xqe.runtree.relational.vectorization.expressions.numeric.";
    private static final String PROP_OBJECT_DATATYPE = "dataType";
    private static final String PROP_ENUM_SUBTYPE = "subType";
    public static final String PROP_BOOLEAN_IS_PUSHED_FAR_ENOUGH = "IsPushedFarEnough";
    private static final String CAPABILITY_PREFIX = "functions.";
    public static final String PROP_ON_ERROR_POLICY = "onErrorPolicy";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLFunction.create(p, jjtid, 301033);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301033;
    }

    public SubType getSubType() {
        return (SubType)((Object)this.getPropertyValue(PROP_ENUM_SUBTYPE));
    }

    public void setSubType(SubType subType) {
        this.setPropertyValue(PROP_ENUM_SUBTYPE, (Object)subType);
    }

    public void setSubType(SubType subType, String name) {
        this.setSubType(subType);
        this.setFunctionName(name);
    }

    @Override
    public String getFunctionName() {
        SubType subType = this.getSubType();
        if (subType == SubType.UDF || subType == SubType.MACRO) {
            return super.getFunctionName();
        }
        return subType.key();
    }

    @Override
    public IDataType getDataType() {
        IDataType dType = (IDataType)this.getPropertyValue(PROP_OBJECT_DATATYPE);
        if (dType == null) {
            return super.getDataType();
        }
        return dType;
    }

    public void setDataType(IDataType dType) {
        this.setPropertyValue(PROP_OBJECT_DATATYPE, dType);
    }

    @Override
    public IDataType[] getParameterTypes() {
        int nParameters = this.getNumberParameters();
        ArrayList<IDataType> parameterTypes = new ArrayList<IDataType>();
        IXQEQueryNode[] children = this.getChildren();
        for (int i = 0; i < nParameters; ++i) {
            IXQEQueryNode child = children[i];
            if (child.getType() == 301030 && (this.isXMLFunction() || this.isJSONFunction())) {
                IDataType[] pTypes;
                for (IDataType pType : pTypes = ((SQLValueList)child).getParameterTypes()) {
                    parameterTypes.add(pType);
                }
                continue;
            }
            parameterTypes.add(((IValueExpression)child).getDataType());
        }
        return parameterTypes.toArray(new IDataType[parameterTypes.size()]);
    }

    @Override
    public String getPattern(IDataSourceCapabilities capabilities) {
        return super.getOverloadedPattern(capabilities);
    }

    @Override
    public boolean isUdf() {
        return this.getSubType() == SubType.UDF;
    }

    @Override
    public boolean isXMLFunction() {
        SubType subType = this.getSubType();
        return subType != SubType.UDF && subType.key().startsWith("XML");
    }

    @Override
    public boolean isJSONFunction() {
        SubType subType = this.getSubType();
        return subType != SubType.UDF && subType.key().startsWith("JSON");
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        boolean result;
        if (this.getSubType() == SubType.MACRO) {
            result = true;
        } else {
            IFunction function;
            result = super.isSupportedImpl(dataSource, ul);
            if (!result && this.getSubType() == SubType.UDF && ((function = FunctionManager.getUserDefinedFunction(this.getFunctionName(), this.getParameterTypes())) == null || function.isDbFunction())) {
                this.setDBOnly(true);
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean isExecutable(boolean localProcessing) {
        SubType subType = this.getSubType();
        if (subType == SubType.JSON_DOCUMENT || subType == SubType.CURRENT_DATE || subType == SubType.CURRENT_TIME || subType == SubType.CURRENT_TIMESTAMP || subType == SubType.LOCALTIME || subType == SubType.LOCALTIMESTAMP || subType == SubType.RANDOM) {
            return false;
        }
        return super.isExecutable(localProcessing);
    }

    public static boolean isFeatureSupported(IDataSourceCapabilities capabilities, String functionName, IDataType[] fArguments) {
        boolean status = true;
        String baseKey = CAPABILITY_PREFIX + functionName;
        String pattern = capabilities.getFunctionPattern(baseKey, fArguments);
        if (pattern == null || pattern.length() == 0) {
            status = false;
        }
        return status;
    }

    @Override
    public boolean isProjectable() {
        return true;
    }

    @Override
    protected String getCapabilityPrefix() {
        if (this.isUdf()) {
            return CAPABILITY_PREFIX + this.getFunctionName().toLowerCase();
        }
        return CAPABILITY_PREFIX + this.getFunctionName();
    }

    public void delimitName(IDataSourceCapabilities capabilities, StringBuilder buffer, String name) {
        String pattern = capabilities.getIdentifierQuoteString();
        if (pattern != null && pattern.length() != 0) {
            buffer.append(pattern);
            buffer.append(name);
            buffer.append(pattern);
        } else {
            buffer.append(name);
        }
    }

    public String[] parseFunctionName(String functionName) {
        String dlimitCharacter = "\\.";
        String[] parts = functionName.split("\"\\.|\\.\"");
        if (parts.length == 0) {
            parts = functionName.split(dlimitCharacter);
        }
        ArrayList<String> nameParts = new ArrayList<String>();
        for (int i = 0; i < parts.length; ++i) {
            String s = parts[i];
            if (s.length() == 0) {
                nameParts.add(null);
                continue;
            }
            if (s.charAt(0) != '\"' && s.charAt(s.length() - 1) != '\"') {
                String[] tmpParts = s.split(dlimitCharacter);
                for (int j = 0; j < tmpParts.length; ++j) {
                    nameParts.add(tmpParts[j]);
                }
                continue;
            }
            int start = 0;
            int end = s.length();
            if (s.charAt(0) == '\"') {
                ++start;
            }
            if (s.charAt(s.length() - 1) == '\"') {
                --end;
            }
            nameParts.add(s.substring(start, end));
        }
        return nameParts.toArray(new String[nameParts.size()]);
    }

    public static SubType getSubTypeFromFunctionName(String functionName) {
        for (SubType s : SubType.values()) {
            if (s.key() == null || !s.key().equals(functionName)) continue;
            return s;
        }
        return SubType.UDF;
    }

    public String generateKey(IDataSourceCapabilities capabilities) {
        String funtionName = this.getCapabilityPrefix() + this.getCapabilitySuffix();
        return capabilities.generateKey(funtionName, this.getParameterTypes());
    }

    @Override
    public boolean isRandomFunction() {
        return SubType.RANDOM == this.getSubType();
    }

    @Override
    public boolean isBusinessDateFunction() {
        SubType subType = this.getSubType();
        boolean result = subType == SubType.ADD_SECONDS || subType == SubType.ADD_MINUTES || subType == SubType.ADD_HOURS || subType == SubType.ADD_DAYS || subType == SubType.ADD_MONTHS || subType == SubType.ADD_YEARS || subType == SubType.AGE || subType == SubType.SECONDS_BETWEEN || subType == SubType.MINUTES_BETWEEN || subType == SubType.HOURS_BETWEEN || subType == SubType.DAY_OF_WEEK || subType == SubType.DAY_OF_YEAR || subType == SubType.DAYS_BETWEEN || subType == SubType.DAYS_TO_END_OF_MONTH || subType == SubType.FIRST_OF_MONTH || subType == SubType.LAST_OF_MONTH || subType == SubType.MAKE_TIMESTAMP || subType == SubType.MONTHS_BETWEEN || subType == SubType.WEEK_OF_YEAR || subType == SubType.YEARS_BETWEEN;
        return result;
    }

    public boolean isDurationFunction() {
        SubType subType = this.getSubType();
        boolean result = subType == SubType.FRACTIONAL_SECONDS_BETWEEN || subType == SubType.SECONDS_BETWEEN || subType == SubType.MINUTES_BETWEEN || subType == SubType.HOURS_BETWEEN || subType == SubType.DAYS_BETWEEN || subType == SubType.WEEKS_BETWEEN || subType == SubType.MONTHS_BETWEEN || subType == SubType.QUARTERS_BETWEEN || subType == SubType.YEARS_BETWEEN || subType == SubType.YMDINT_BETWEEN;
        return result;
    }

    @Override
    public boolean needAdjustDataType() {
        return this.isUdf() && this.getFunction() == null;
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        int i;
        SubType subType = this.getSubType();
        boolean vectorizable = true;
        int nChildren = this.getNumberChildren();
        if (subType == SubType.UDF) {
            SQLFunction.addUnsupportedReasonForVQE(ul, "Unsupported UDF function: " + this.getFunctionName());
            vectorizable = false;
        } else if (subType == SubType.ADD_DAYS || subType == SubType.ADD_HOURS || subType == SubType.ADD_MINUTES || subType == SubType.ADD_SECONDS || subType == SubType.ADD_FRACTIONAL_SECONDS || subType == SubType.ADD_MONTHS || subType == SubType.ADD_YEARS || subType == SubType.ADD_QUARTERS || subType == SubType.ADD_WEEKS || subType == SubType.POWER || subType == SubType.SUBSTRING || subType == SubType.WIDTH_BUCKET) {
            for (i = 1; i < nChildren && vectorizable; ++i) {
                vectorizable = this.getChild(i).getType() == 301031;
            }
            if (!vectorizable) {
                SQLFunction.addUnsupportedReasonForVQE(ul, "Argument of " + subType.key() + " must be literals");
            }
        } else if (subType == SubType.POSITION || subType == SubType.INDEX) {
            boolean bl = vectorizable = this.getChild(0).getType() == 301031;
            if (!vectorizable) {
                SQLFunction.addUnsupportedReasonForVQE(ul, "First argument of " + subType.key() + " must be literal");
            }
        } else if (subType == SubType.ROUND) {
            boolean bl = vectorizable = nChildren == 1 && ((ISQLQueryNode)this.getChild(0)).isVectorizable(ul);
            if (!vectorizable) {
                SQLFunction.addUnsupportedReasonForVQE(ul, "Round function with more than one argument is not supported");
            }
        } else if (SubType.RANDOM == subType && 1 == nChildren) {
            boolean bl = vectorizable = this.getChild(0).getType() == 301031;
            if (!vectorizable) {
                SQLFunction.addUnsupportedReasonForVQE(ul, "Seed for " + subType.key() + " must be literal");
            }
        } else {
            boolean bl = vectorizable = subType == SubType.YEARS_BETWEEN || subType == SubType.QUARTERS_BETWEEN || subType == SubType.MONTHS_BETWEEN || subType == SubType.WEEKS_BETWEEN || subType == SubType.DAYS_BETWEEN || subType == SubType.HOURS_BETWEEN || subType == SubType.MINUTES_BETWEEN || subType == SubType.SECONDS_BETWEEN || subType == SubType.FRACTIONAL_SECONDS_BETWEEN || subType == SubType.YMDINT_BETWEEN || subType == SubType.AGE || subType == SubType.CEILING || subType == SubType.CHAR_LENGTH || subType == SubType.BIT_LENGTH || subType == SubType.OCTET_LENGTH || subType == SubType.DAY_OF_WEEK || subType == SubType.DAY_OF_YEAR || subType == SubType.WEEK_OF_YEAR || subType == SubType.EXP || subType == SubType.FIRST_OF_MONTH || subType == SubType.FLOOR || subType == SubType.LAST_OF_MONTH || subType == SubType.DAYS_TO_END_OF_MONTH || subType == SubType.LN || subType == SubType.LOG10 || subType == SubType.LOWER || subType == SubType.MOD || subType == SubType.SAFE_MOD || subType == SubType.REVERSE || subType == SubType.SIGN || subType == SubType.SQRT || subType == SubType.SUBSTRING_REGEX || subType == SubType.POSITION_REGEX || subType == SubType.OCCURRENCES_REGEX || subType == SubType.UPPER || subType == SubType.CURRENT_DATE || subType == SubType.CURRENT_TIME || subType == SubType.CURRENT_TIMESTAMP || subType == SubType.LOCALTIME || subType == SubType.LOCALTIMESTAMP || subType == SubType.RANDOM;
            if (!vectorizable) {
                SQLFunction.addUnsupportedReasonForVQE(ul, "Unsupported function: " + subType.key());
            }
        }
        for (i = 0; i < nChildren && vectorizable; ++i) {
            vectorizable = ((ISQLQueryNode)this.getChild(i)).isVectorizable(ul);
            if (vectorizable) continue;
            SQLFunction.addUnsupportedReasonForVQE(ul, "Unsupported argument of Function " + subType.key());
        }
        return vectorizable;
    }

    @Override
    public Class<?> getVectorClass() {
        String className;
        SubType subType = this.getSubType();
        switch (subType) {
            case UPPER: {
                return XVectorUpper.class;
            }
            case LOWER: {
                return XVectorLower.class;
            }
            case REVERSE: {
                return XVectorReverse.class;
            }
            case CHAR_LENGTH: {
                return XVectorCharLength.class;
            }
            case BIT_LENGTH: {
                return XVectorBitLength.class;
            }
            case OCTET_LENGTH: {
                return XVectorOctetLength.class;
            }
            case SUBSTRING: {
                if (this.getNumberChildren() == 2) {
                    return XVectorSubstring2Args.class;
                }
                return XVectorSubstring.class;
            }
            case SUBSTRING_REGEX: {
                return XVectorSubstringRegex.class;
            }
            case POSITION: {
                return XVectorStringScalarPositionStringColumn.class;
            }
            case INDEX: {
                return XVectorStringScalarIndexStringColumn.class;
            }
            case POSITION_REGEX: {
                return XVectorPositionRegex.class;
            }
            case OCCURRENCES_REGEX: {
                return XVectorOccurrencesRegex.class;
            }
            case ADD_DAYS: {
                return XVectorAddDaysScalar.class;
            }
            case ADD_HOURS: {
                return XVectorAddHoursScalar.class;
            }
            case ADD_MINUTES: {
                return XVectorAddMinutesScalar.class;
            }
            case ADD_SECONDS: {
                return XVectorAddSecondsScalar.class;
            }
            case ADD_FRACTIONAL_SECONDS: {
                return XVectorAddFractionalSecondsScalar.class;
            }
            case ADD_MONTHS: {
                return XVectorAddMonthsScalar.class;
            }
            case ADD_YEARS: {
                return XVectorAddYearsScalar.class;
            }
            case ADD_QUARTERS: {
                return XVectorAddQuartersScalar.class;
            }
            case ADD_WEEKS: {
                return XVectorAddWeeksScalar.class;
            }
            case YEARS_BETWEEN: {
                return XVectorYearsBetween.class;
            }
            case QUARTERS_BETWEEN: {
                return XVectorQuartersBetween.class;
            }
            case MONTHS_BETWEEN: {
                return XVectorMonthsBetween.class;
            }
            case WEEKS_BETWEEN: {
                return XVectorWeeksBetween.class;
            }
            case DAYS_BETWEEN: {
                return XVectorDaysBetween.class;
            }
            case HOURS_BETWEEN: {
                return XVectorHoursBetween.class;
            }
            case MINUTES_BETWEEN: {
                return XVectorMinutesBetween.class;
            }
            case SECONDS_BETWEEN: {
                return XVectorSecondsBetween.class;
            }
            case FRACTIONAL_SECONDS_BETWEEN: {
                return XVectorFractionalSecondsBetween.class;
            }
            case YMDINT_BETWEEN: {
                return XVectorYMDIntBetween.class;
            }
            case FIRST_OF_MONTH: {
                return XVectorFirstOfMonth.class;
            }
            case LAST_OF_MONTH: {
                return XVectorLastOfMonth.class;
            }
            case DAYS_TO_END_OF_MONTH: {
                return XVectorDaysToEndOfMonth.class;
            }
            case DAY_OF_WEEK: {
                return XVectorDayOfWeek.class;
            }
            case DAY_OF_YEAR: {
                return XVectorDayOfYear.class;
            }
            case WEEK_OF_YEAR: {
                return XVectorWeekOfYear.class;
            }
            case AGE: {
                return XVectorAge.class;
            }
            case MOD: 
            case SAFE_MOD: {
                IValueExpression child2 = (IValueExpression)this.getChild(1);
                String lTypeName = this.getTypeName((IValueExpression)this.getChild(0));
                String rTypeName = this.getTypeName(child2);
                String operatorName = this.getFunctionName();
                if (lTypeName.equals(VectorType.DECIMAL.toString())) {
                    rTypeName = lTypeName;
                    operatorName = SubType.SAFE_MOD.key();
                }
                String template = child2.getType() == 301031 ? "%sXVector%sColumn%s%sScalar" : "%sXVector%sColumn%s%sColumn";
                className = String.format(template, "com.cognos.xqe.runtree.relational.vectorization.expressions.generated.", lTypeName, operatorName, rTypeName);
                break;
            }
            case CURRENT_DATE: {
                return XVectorCurrentDate.class;
            }
            case CURRENT_TIME: {
                return XVectorCurrentTime.class;
            }
            case CURRENT_TIMESTAMP: {
                return XVectorCurrentTimestamp.class;
            }
            case LOCALTIME: {
                return XVectorLocalTime.class;
            }
            case LOCALTIMESTAMP: {
                return XVectorLocalTimestamp.class;
            }
            case POWER: {
                className = String.format("%sXVectorPower%s", COM_COGNOS_XQE_RUNTREE_RELATIONAL_VECTORIZATION_EXPRESSIONS_NUMERIC, this.getTypeName((IValueExpression)this.getChild(0)));
                break;
            }
            case RANDOM: {
                IXQEQueryNode[] children = this.getChildren();
                if (null == children || children.length == 0) {
                    className = String.format("%sXVectorRandom", COM_COGNOS_XQE_RUNTREE_RELATIONAL_VECTORIZATION_EXPRESSIONS_NUMERIC);
                    break;
                }
                className = String.format("%sXVectorRandom%s", COM_COGNOS_XQE_RUNTREE_RELATIONAL_VECTORIZATION_EXPRESSIONS_NUMERIC, this.getTypeName((IValueExpression)children[0]));
                break;
            }
            case WIDTH_BUCKET: {
                className = String.format("%sXVectorWidthBucket%s", COM_COGNOS_XQE_RUNTREE_RELATIONAL_VECTORIZATION_EXPRESSIONS_NUMERIC, this.getTypeName((IValueExpression)this.getChild(0)));
                break;
            }
            default: {
                className = String.format("%sXVectorFunction%s%s", "com.cognos.xqe.runtree.relational.vectorization.expressions.generated.", this.getFunctionName(), this.getTypeName((IValueExpression)this.getChild(0)));
            }
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    protected boolean isSimpleType(XQEPersistContext ctx, Object value) {
        return super.isSimpleType(ctx, value) || value instanceof SubType;
    }

    @Override
    protected void persistAttributeProperty(XQEPersistContext ctx, String key, Object value) {
        if (value instanceof SubType) {
            ctx.property(key, ((SubType)((Object)value)).name(), "sub:");
        } else {
            super.persistAttributeProperty(ctx, key, value);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        Namespace ns = att.getNamespace();
        if (ns.getURI().equals("http://developer.cognos.com/Types/SubType")) {
            for (SubType val : SubType.values()) {
                if (!val.name().equals(att.getValue())) continue;
                this.setPropertyValue(att.getName(), (Object)val);
                break;
            }
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    @Override
    public SQLAbstractFunction.OnErrorPolicy getOnErrorPolicy() {
        Object oep = this.getPropertyValue(PROP_ON_ERROR_POLICY);
        if (oep != null) {
            return (SQLAbstractFunction.OnErrorPolicy)((Object)oep);
        }
        return SQLAbstractFunction.OnErrorPolicy.ERROR;
    }

    @Override
    public void setOnErrorPolicy(SQLAbstractFunction.OnErrorPolicy oep) {
        this.setPropertyValue(PROP_ON_ERROR_POLICY, (Object)oep);
    }

    @Override
    public boolean hasOnErrorPolicyBeenSet() {
        return this.getPropertyValue(PROP_ON_ERROR_POLICY) != null;
    }

    public static enum SubType {
        UDF(null),
        MACRO(null),
        UPPER("Upper"),
        LOWER("Lower"),
        SUBSTRING("Substring"),
        SUBSTRINGR("SubstringR"),
        SUBSTRING_REGEX("SubstringRegex"),
        REVERSE("Reverse"),
        TRANSLATE("Translate"),
        NORMALIZE("Normalize"),
        POSITION("Position"),
        POSITION_REGEX("PositionRegex"),
        OCCURRENCES_REGEX("OccurrencesRegex"),
        INDEX("Index"),
        CHAR_LENGTH("CharLength"),
        OCTET_LENGTH("OctetLength"),
        BIT_LENGTH("BitLength"),
        ROUND("Round"),
        ASCII("Ascii"),
        ABS("Abs"),
        MOD("Mod"),
        SAFE_MOD("SafeMod"),
        LN("Ln"),
        LOG10("Log10"),
        EXP("Exp"),
        POWER("Power"),
        SQRT("Sqrt"),
        FLOOR("Floor"),
        CEILING("Ceiling"),
        WIDTH_BUCKET("WidthBucket"),
        CURRENT_DATE("CurrentDate"),
        CURRENT_TIME("CurrentTime"),
        CURRENT_TIMESTAMP("CurrentTimestamp"),
        LOCALTIME("LocalTime"),
        LOCALTIMESTAMP("LocalTimestamp"),
        ADD_FRACTIONAL_SECONDS("AddFractionalSeconds"),
        ADD_SECONDS("AddSeconds"),
        ADD_MINUTES("AddMinutes"),
        ADD_HOURS("AddHours"),
        ADD_DAYS("AddDays"),
        ADD_WEEKS("AddWeeks"),
        ADD_MONTHS("AddMonths"),
        SHIFT_TIMEZONE("ShiftTimeZone"),
        ADD_QUARTERS("AddQuarters"),
        ADD_YEARS("AddYears"),
        AGE("Age"),
        FRACTIONAL_SECONDS_BETWEEN("FractionalSecondsBetween"),
        SECONDS_BETWEEN("SecondsBetween"),
        MINUTES_BETWEEN("MinutesBetween"),
        HOURS_BETWEEN("HoursBetween"),
        DAYS_BETWEEN("DaysBetween"),
        WEEKS_BETWEEN("WeeksBetween"),
        MONTHS_BETWEEN("MonthsBetween"),
        QUARTERS_BETWEEN("QuartersBetween"),
        YEARS_BETWEEN("YearsBetween"),
        DAY_OF_WEEK("DayOfWeek"),
        DAY_OF_YEAR("DayOfYear"),
        DAYS_TO_END_OF_MONTH("DaysToEndOfMonth"),
        FIRST_OF_MONTH("FirstOfMonth"),
        LAST_OF_MONTH("LastOfMonth"),
        MAKE_TIMESTAMP("MakeTimestamp"),
        WEEK_OF_YEAR("WeekOfYear"),
        YMDINT_BETWEEN("YMDIntBetween"),
        XMLATTRIBUTES("XMLAttributes"),
        XMLCOMMENT("XMLComment"),
        XMLCONCAT("XMLConcat"),
        XMLDOCUMENT("XMLDocument"),
        XMLELEMENT("XMLElement"),
        XMLEXISTS("XMLExists"),
        XMLFOREST("XMLForest"),
        XMLNAMESPACES("XMLNamespaces"),
        XMLPARSE("XMLParse"),
        XMLPI("XMLPI"),
        XMLQUERY("XMLQuery"),
        XMLSERIALIZE("XMLSerialize"),
        XMLTABLE("XMLTable"),
        XMLTEXT("XMLText"),
        XMLTRANSFORM("XMLTransform"),
        XMLVALIDATE("XMLValidate"),
        JSON_ARRAY("JSONArray"),
        JSON_DOCUMENT("JSONDocument"),
        JSON_EXISTS("JSONExists"),
        JSON_OBJECT("JSONObject"),
        JSON_QUERY("JSONQuery"),
        JSON_VALUE("JSONValue"),
        TO_JSON("ToJSON"),
        ACOS("Arccos"),
        ASIN("Arcsin"),
        ATAN("Arctan"),
        COS("Cos"),
        COSH("Coshyp"),
        SIN("Sin"),
        SINH("Sinhyp"),
        TAN("Tan"),
        TANH("Tanhyp"),
        CARDINALITY("Cardinality"),
        SIGN("Sign"),
        TRIM_ARRAY("TrimArray"),
        MAP("Map"),
        RANDOM("Random");

        private String key;

        private SubType(String theKey) {
            this.key = theKey;
        }

        public String key() {
            return this.key;
        }
    }
}

