/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLHaving;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import java.util.List;

public class SQLGroupBy
extends SQLProject {
    private static final String CAPABILITIES_KEY = "clauses.GroupBy";
    public static final String PROP_ENUM_HINT = "hint";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLGroupBy.create(p, jjtid, 301010);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301010;
    }

    public SQLValueList getValueList() {
        return (SQLValueList)this.getFirstChildByType(301030);
    }

    public SQLGroupByList getGroupByList() {
        return (SQLGroupByList)this.getFirstChildByType(301029);
    }

    public SQLHaving getHavingClause() {
        return (SQLHaving)this.getFirstChildByType(301049);
    }

    @Override
    public int getNumberColumns() {
        return this.getOutputList().getNumberChildren();
    }

    public void setHint(Hint groupByHint) {
        this.setPropertyValue(PROP_ENUM_HINT, (Object)groupByHint);
    }

    public Hint getHint() {
        Hint hint = (Hint)((Object)this.getPropertyValue(PROP_ENUM_HINT));
        if (hint == null) {
            hint = Hint.DEFAULT;
        }
        return hint;
    }

    public static boolean isFeatureSupported(IDataSourceCapabilities capabilities) {
        String pattern = capabilities.getStringValue(CAPABILITIES_KEY, null);
        if (pattern == null || pattern.length() == 0) {
            pattern = null;
        }
        return pattern != null;
    }

    public boolean isReductionGroupBy() {
        SQLValueList projectList = this.getOutputList();
        SQLGroupByList groupByList = this.getGroupByList();
        if (groupByList == null || projectList.getNumberChildren() != groupByList.getNumberChildren()) {
            return false;
        }
        for (int i = 0; i < projectList.getNumberChildren(); ++i) {
            if (projectList.getChild(i).isSameExpression(groupByList.getChild(i), false)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        boolean vectorizable = true;
        for (int i = 0; i < this.getNumberChildren() && vectorizable; ++i) {
            vectorizable = ((ISQLQueryNode)this.getChild(i)).isVectorizable(ul);
        }
        return vectorizable;
    }

    public static enum Hint {
        DEFAULT,
        ORDER,
        HASH;

    }
}

