/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLAbstractBooleanFunction;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.ast.util.ASTUtil;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.XVectorFilterLogicalAnd;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.XVectorFilterLogicalOr;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.XVectorLogicalAnd;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.XVectorLogicalOr;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class SQLLogical
extends SQLAbstractBooleanFunction {
    public static final String PROP_ENUM_SUBTYPE = "subType";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLLogical.create(p, jjtid, 301027);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301027;
    }

    public SubType getSubType() {
        return (SubType)((Object)this.getPropertyValue(PROP_ENUM_SUBTYPE));
    }

    public void setSubType(SubType subType) {
        this.setPropertyValue(PROP_ENUM_SUBTYPE, (Object)subType);
    }

    @Override
    public String getFunctionName() {
        return this.getSubType().key();
    }

    @Override
    protected String getKey() {
        return "operators.logical." + this.getFunctionName();
    }

    @Override
    public boolean needAdjustDataType() {
        return false;
    }

    @Override
    protected void analyzeJoinCondition(BitMask bitMask) {
        if (this.getSubType() == SubType.OR) {
            bitMask.set(2);
            if (this.getChild(0) instanceof SQLAbstractFunction) {
                ((SQLAbstractFunction)this.getChild(0)).analyzeJoinCondition(bitMask);
            }
            if (this.getChild(1) instanceof SQLAbstractFunction) {
                ((SQLAbstractFunction)this.getChild(1)).analyzeJoinCondition(bitMask);
            }
        } else if (this.getSubType() == SubType.AND) {
            bitMask.set(1);
            if (this.getChild(0) instanceof SQLAbstractFunction) {
                ((SQLAbstractFunction)this.getChild(0)).analyzeJoinCondition(bitMask);
            }
            if (this.getChild(1) instanceof SQLAbstractFunction) {
                ((SQLAbstractFunction)this.getChild(1)).analyzeJoinCondition(bitMask);
            }
        } else if (this.getSubType() == SubType.NOT) {
            bitMask.set(3);
            if (this.getChild(0) instanceof SQLAbstractFunction) {
                ((SQLAbstractFunction)this.getChild(0)).analyzeJoinCondition(bitMask);
            }
        }
    }

    @Override
    public boolean isExecutable(boolean localProcessing) {
        SubType subType = this.getSubType();
        if (subType != SubType.AND && subType != SubType.OR && subType != SubType.NOT) {
            return false;
        }
        boolean isExecutable = false;
        for (IXQEQueryNode child : this.getChildren()) {
            isExecutable |= ((SQLExpression)child).isExecutable(localProcessing);
        }
        return isExecutable;
    }

    @Override
    public IValue execute(XDataContext context) {
        XQENodeFactory nodeFactory = this.environment.getNodeFactory();
        if (this.getSubType() == SubType.NOT) {
            BooleanValue value = (BooleanValue)((SQLExpression)this.getChild(0)).execute(context);
            value = value.isNull() ? BooleanValue.UNKNOWN : (value.getBoolean() ? BooleanValue.FALSE : BooleanValue.TRUE);
            return value;
        }
        IXQEQueryNode[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            BooleanValue value;
            SQLExpression child = (SQLExpression)children[i];
            if (!child.isExecutable(false) || child.getType() == 301031 || (value = (BooleanValue)child.execute(context)) == null) continue;
            SQLLiteral literal = (SQLLiteral)nodeFactory.createNode(301031);
            literal.setValue(value);
            child.exchange(literal);
            this.setPropertyValue("foldingApplied", Boolean.TRUE);
        }
        children = this.getChildren();
        if (children[0].getType() == 301031 && children[1].getType() == 301031) {
            SQLLiteral literal1 = (SQLLiteral)children[0];
            SQLLiteral literal2 = (SQLLiteral)children[1];
            if (this.getSubType() == SubType.AND) {
                if (literal1.getValue().getBoolean() && literal2.getValue().getBoolean()) {
                    return BooleanValue.TRUE;
                }
                return BooleanValue.FALSE;
            }
            if (literal1.getValue().getBoolean() || literal2.getValue().getBoolean()) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
        return null;
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        boolean vectorizable;
        SubType subType = this.getSubType();
        boolean bl = vectorizable = subType != SubType.IS_JSON && subType != SubType.IS;
        if (!vectorizable) {
            SQLLogical.addUnsupportedReasonForVQE(ul, "Unsupported logical operator: " + subType.key());
        }
        for (int i = 0; i < this.getNumberChildren() && vectorizable; ++i) {
            vectorizable = ((ISQLQueryNode)this.getChild(i)).isVectorizable(ul);
        }
        return vectorizable;
    }

    @Override
    public Class<?> getVectorClass() {
        if (ASTUtil.isInFilterContext(this)) {
            return this.getSubType().vectorFilterClass;
        }
        return this.getSubType().vectorClass;
    }

    @Override
    protected boolean isSimpleType(XQEPersistContext ctx, Object value) {
        return super.isSimpleType(ctx, value) || value instanceof SubType;
    }

    @Override
    protected void persistAttributeProperty(XQEPersistContext ctx, String key, Object value) {
        if (value instanceof SubType) {
            ctx.property(key, ((SubType)((Object)value)).name(), "sub:");
        } else {
            super.persistAttributeProperty(ctx, key, value);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        Namespace ns = att.getNamespace();
        if (ns.getURI().equals("http://developer.cognos.com/Types/SubType")) {
            for (SubType val : SubType.values()) {
                if (!val.name().equals(att.getValue())) continue;
                this.setPropertyValue(att.getName(), (Object)val);
                break;
            }
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    public static enum SubType {
        AND("And", XVectorFilterLogicalAnd.class, XVectorLogicalAnd.class),
        OR("Or", XVectorFilterLogicalOr.class, XVectorLogicalOr.class),
        NOT("Not", null, null),
        IS("Is", null, null),
        IS_JSON("IsJson", null, null);

        private String key;
        private Class<?> vectorFilterClass;
        private Class<?> vectorClass;

        private SubType(String theKey, Class<?> theVectorFilterClass, Class<?> theVectorClass) {
            this.key = theKey;
            this.vectorClass = theVectorClass;
            this.vectorFilterClass = theVectorFilterClass;
        }

        String key() {
            return this.key;
        }

        Class<?> vectorClass() {
            return this.vectorClass;
        }
    }
}

