/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import com.cognos.xqe.transformation.relational.preoptimization.SQLPreoptimizerUtil;
import java.util.Collection;
import java.util.List;

public class SQLProduct
extends SQLQueryNode {
    private static final String PROP_OBJECT_DATASOURCES = "dataSources";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLProduct.create(p, jjtid, 301014);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301014;
    }

    public void setDataSourceList(Collection<IDataSource> dsList) {
        this.setPropertyValue(PROP_OBJECT_DATASOURCES, dsList);
    }

    public Collection<IDataSource> getDataSourceList() {
        return (Collection)this.getPropertyValue(PROP_OBJECT_DATASOURCES);
    }

    @Override
    public SQLQueryItemList getQueryItemList() {
        SQLQueryItemList result = new SQLQueryItemList();
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            SQLQueryItemList queryItems = ((SQLQueryNode)this.getChild(i)).getQueryItemList();
            if (queryItems == null) continue;
            for (int j = 0; j < queryItems.size(); ++j) {
                SQLQueryItem queryItem = (SQLQueryItem)queryItems.get(j);
                queryItem.setSourceNo(i);
            }
            result.addAll(queryItems);
        }
        return result;
    }

    @Override
    public int getNumberColumns() {
        int nColumns = 0;
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            nColumns += ((SQLQueryNode)this.getChild(i)).getNumberColumns();
        }
        return nColumns;
    }

    @Override
    public int getNumberOfLeafNodes() {
        int nLeafNodes = 0;
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            nLeafNodes += ((SQLQueryNode)this.getChild(i)).getNumberOfLeafNodes();
        }
        return nLeafNodes;
    }

    @Override
    public IXQEQueryNode getLeafNodeForPredicatePushdown(IXQEQueryNode predicate) {
        IXQEQueryNode leafNode = null;
        List<IXQEQueryNode> leafNodes = SQLPreoptimizerUtil.getLeafNodes(this);
        SQLFid fid = (SQLFid)predicate.getFirstDescendantOfTypeOrdered(301032, false);
        int nColumns = 0;
        for (int i = 0; i < leafNodes.size(); ++i) {
            SQLQueryNode child = (SQLQueryNode)leafNodes.get(i);
            if (fid.getVirtualColumnNo() >= (nColumns += child.getNumberColumns())) continue;
            leafNode = child;
            break;
        }
        if (leafNode != null && leafNode.getParent().getType() == 301011 && !SQLJoin.canPushPredicateThroughJoin(this, leafNode)) {
            leafNode = null;
        }
        return leafNode;
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        if (!super.isSupportedImpl(dataSource, ul)) {
            return false;
        }
        if (this.supportsCrossProduct(dataSource) && this.supportsEquiJoin(dataSource) && this.supportsThetaJoin(dataSource)) {
            return true;
        }
        boolean validJoin = false;
        IXQEQueryNode parent = this.getParent();
        while (parent.getType() == 301009) {
            if (this.validFilterNode((SQLFilter)parent)) {
                for (IXQEQueryNode predicate : ((SQLFilter)parent).getPredicate().getDescendantsOfType(301026, true)) {
                    if (((SQLQueryNode)predicate).incidence().cardinality() <= 1) continue;
                    if (!predicate.isSupported(dataSource)) {
                        return false;
                    }
                    validJoin = true;
                }
            }
            parent = parent.getParent();
        }
        if (validJoin) {
            return true;
        }
        return this.supportsCrossProduct(dataSource);
    }

    public boolean validFilterNode(SQLFilter factor) {
        BitMask fIncidence = factor.incidence();
        fIncidence.and(this.incidence());
        return fIncidence.equals(this.incidence());
    }

    private boolean supportsCrossProduct(IDataSource dataSource) {
        return dataSource.getCapabilities().getBooleanValue("supports.crossProducts");
    }

    private boolean supportsEquiJoin(IDataSource dataSource) {
        return dataSource.getCapabilities().getBooleanValue("supports.equiJoins");
    }

    private boolean supportsThetaJoin(IDataSource dataSource) {
        return dataSource.getCapabilities().getBooleanValue("supports.thetaJoins");
    }
}

