/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.function.IFunction;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.util.IQueryReuseManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class SQLTableFunction
extends SQLAbstractFunction {
    public static final String PROP_OBJECT_QUERYITEMS = "queryItems";
    public static final String PROP_OBJECT_DATASOURCE = "dataSource";
    public static final String PROP_ENUM_SUBTYPE = "subType";
    public static final String PROP_OBJECT_DATATYPE = "dataType";
    public static final String PROP_BOOLEAN_ISNESTED = "isNested";
    public static final String PROP_PROJECTION_LIST = "projectionList";
    public static final String PROP_IDENTIFIER_CHAIN = "identifierChain";
    public static final String PROP_ON_ERROR_POLICY = "onErrorPolicy";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLTableFunction.create(p, jjtid, 301038);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301038;
    }

    public SubType getSubType() {
        return (SubType)((Object)this.getPropertyValue(PROP_ENUM_SUBTYPE));
    }

    public void setSubType(SubType subType) {
        this.setPropertyValue(PROP_ENUM_SUBTYPE, (Object)subType);
        this.setFunctionName(subType.key());
    }

    @Override
    public IDataType getDataType() {
        return (IDataType)this.getPropertyValue(PROP_OBJECT_DATATYPE);
    }

    public void setDataType(IDataType dataType) {
        this.setPropertyValue(PROP_OBJECT_DATATYPE, dataType);
    }

    public boolean isNested() {
        Boolean isNested = (Boolean)this.getPropertyValue(PROP_BOOLEAN_ISNESTED);
        return isNested != null && isNested != false;
    }

    public void setIsNested(boolean value) {
        this.setPropertyValue(PROP_BOOLEAN_ISNESTED, value);
    }

    public List<String> getProjectionList() {
        return (List)this.getPropertyValue(PROP_PROJECTION_LIST);
    }

    public void addToProjectionList(String identifierChain) {
        ArrayList<String> projectionList = (ArrayList<String>)this.getProjectionList();
        if (projectionList == null) {
            projectionList = new ArrayList<String>();
            projectionList.add(identifierChain);
            this.setPropertyValue(PROP_PROJECTION_LIST, projectionList);
        } else {
            projectionList.add(identifierChain);
        }
    }

    public void setIdentifierChain1(String idChain) {
        this.setPropertyValue(PROP_IDENTIFIER_CHAIN, idChain);
    }

    public String getIdentifierChain1() {
        return (String)this.getPropertyValue(PROP_IDENTIFIER_CHAIN);
    }

    @Override
    public int getNumberColumns() {
        RowType rowType = (RowType)this.getDataType();
        if (rowType == null) {
            return super.getNumberColumns();
        }
        return rowType.getNumberColumns();
    }

    @Override
    protected String getKey() {
        return "functions." + this.getSubType().key();
    }

    @Override
    public void setQueryItemList(SQLQueryItemList qItems) {
        this.setPropertyValue(PROP_OBJECT_QUERYITEMS, qItems);
    }

    @Override
    public SQLQueryItemList getQueryItemList() {
        return (SQLQueryItemList)this.getPropertyValue(PROP_OBJECT_QUERYITEMS);
    }

    public void addQueryItems(SQLQueryItemList qItems) {
        if (qItems == null) {
            return;
        }
        Object qiList = this.getPropertyValue(PROP_OBJECT_QUERYITEMS);
        if (qiList == null) {
            this.setPropertyValue(PROP_OBJECT_QUERYITEMS, qItems);
            return;
        }
        SQLQueryItemList existingList = (SQLQueryItemList)qiList;
        existingList.addAll(qItems);
    }

    public void setDataSource(IDataSource dataSource) {
        this.setPropertyValue(PROP_OBJECT_DATASOURCE, dataSource);
    }

    @Override
    public IDataSource getDataSource() {
        return (IDataSource)this.getPropertyValue(PROP_OBJECT_DATASOURCE);
    }

    @Override
    public boolean isUdf() {
        return this.getSubType() == SubType.UDF;
    }

    @Override
    public boolean isXMLFunction() {
        return this.getSubType() == SubType.XMLTABLE;
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        IFunction function = this.getFunction();
        if (function != null && function.isDbFunction()) {
            return true;
        }
        if (!super.isSupportedImpl(dataSource, ul)) {
            return false;
        }
        if (DataSourceTypeEnum.isOData(dataSource.getType()) && this.getSubType() == SubType.UNNEST) {
            XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            return configuration.getBooleanProperty("queryExecution.OData.lazyLoading[@value]", true);
        }
        return true;
    }

    @Override
    public double getCardinality() {
        return 1000.0;
    }

    public boolean isExecutable() {
        return false;
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        IQueryReuseManager.CursorInfo ci;
        XNode ep;
        SQLLiteral sqlLiteral;
        boolean vectorizable;
        SubType subType = this.getSubType();
        boolean bl = vectorizable = subType == SubType.UDF || subType == SubType.XMLEXTERNALDATA || subType == SubType.CURSOR || subType == SubType.JSON_TABLE;
        if (subType == SubType.JSON_TABLE && this.getChildrenOfType(301033).length != 0) {
            vectorizable = false;
        }
        if (!vectorizable) {
            SQLTableFunction.addUnsupportedReasonForVQE(ul, "Unsupported table function: " + subType.key());
        }
        if (vectorizable && this.getChildren().length > 0 && null != this.getChild(0) && this.getChild(0).getType() == 301031 && (sqlLiteral = (SQLLiteral)this.getChild(0)).getValue().getObject() instanceof IQueryReuseManager.CursorInfo && null != (ep = (ci = (IQueryReuseManager.CursorInfo)sqlLiteral.getValue().getObject()).getExecutionPlan()) && null == ep.getVectorizationContext()) {
            vectorizable = false;
            String msg = "Table function based on " + ci.getName() + " has no vectorization context set for execution plan.";
            SQLTableFunction.addUnsupportedReasonForVQE(ul, msg);
        }
        return vectorizable;
    }

    @Override
    public Object getPropertyValue(String key) {
        return this.mProperties.get(key);
    }

    @Override
    protected boolean isSimpleType(XQEPersistContext ctx, Object value) {
        return super.isSimpleType(ctx, value) || value instanceof SubType;
    }

    @Override
    protected void persistAttributeProperty(XQEPersistContext ctx, String key, Object value) {
        if (value instanceof SubType) {
            ctx.property(key, ((SubType)((Object)value)).name(), "sub:");
        } else {
            super.persistAttributeProperty(ctx, key, value);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        Namespace ns = att.getNamespace();
        if (ns.getURI().equals("http://developer.cognos.com/Types/SubType")) {
            for (SubType val : SubType.values()) {
                if (!val.name().equals(att.getValue())) continue;
                this.setPropertyValue(att.getName(), (Object)val);
                break;
            }
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    @Override
    public SQLAbstractFunction.OnErrorPolicy getOnErrorPolicy() {
        Object oep = this.getPropertyValue(PROP_ON_ERROR_POLICY);
        if (oep != null) {
            return (SQLAbstractFunction.OnErrorPolicy)((Object)oep);
        }
        return SQLAbstractFunction.OnErrorPolicy.NULL;
    }

    @Override
    public void setOnErrorPolicy(SQLAbstractFunction.OnErrorPolicy oep) {
        SQLAbstractFunction.OnErrorPolicy onerrorPolicy = SQLAbstractFunction.OnErrorPolicy.ERROR;
        onerrorPolicy.setOnErrorPolicyValue(oep.getOnErrorPolicyValue());
        this.setPropertyValue(PROP_ON_ERROR_POLICY, (Object)oep);
    }

    @Override
    public boolean hasOnErrorPolicyBeenSet() {
        return this.getPropertyValue(PROP_ON_ERROR_POLICY) != null;
    }

    @Override
    public void getDataSourceList(Collection<IDataSource> dataSourcesFromContext, ArrayList<IDataSource> dataSources) {
        IDataSource dataSource = this.getDataSource();
        if (dataSource != null) {
            SQLTableFunction.addDatasource(dataSources, dataSource);
        }
    }

    public static enum SubType {
        UDF(null),
        XMLTABLE("XMLTable"),
        XMLEXTERNALDATA("XMLExternalData"),
        CURSOR("Cursor"),
        UNNEST("Unnest"),
        EMPTY("Empty"),
        JSON_TABLE("JSONTable"),
        DATASET("Dataset");

        private String key;

        private SubType(String theKey) {
            this.key = theKey;
        }

        String key() {
            return this.key;
        }
    }
}

