/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.runtree.relational.vectorization.expressions.character.XVectorTrim;
import java.util.List;

public class SQLTrim
extends SQLAbstractFunction {
    public static final String DEFAULT_TRIM_CHAR = " ";
    public static final String PROP_OBJECT_TRIM_SPEC = "trimSpec";
    private static final String FUNCTION_NAME = "Trim";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLTrim.create(p, jjtid, 301064);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301064;
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    public void setTrimSpec(TrimSpec trimSpec) {
        this.setPropertyValue(PROP_OBJECT_TRIM_SPEC, (Object)trimSpec);
    }

    public TrimSpec getTrimSpec() {
        return (TrimSpec)((Object)this.getPropertyValue(PROP_OBJECT_TRIM_SPEC));
    }

    @Override
    public boolean isProjectable() {
        return true;
    }

    @Override
    protected String getCapabilityPrefix() {
        return "expressions.Trim." + this.getTrimSpec().key();
    }

    @Override
    public String getPattern(IDataSourceCapabilities capabilities) {
        return super.getOverloadedPattern(capabilities);
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        boolean result = super.isSameExpression(node, compareCalcDefiniton);
        if (result) {
            result = this.getTrimSpec() == ((SQLTrim)node).getTrimSpec();
        }
        return result;
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        boolean vectorizable = true;
        for (int i = 0; i < this.getNumberChildren() && vectorizable; ++i) {
            vectorizable = ((ISQLQueryNode)this.getChild(i)).isVectorizable(ul);
        }
        return vectorizable;
    }

    @Override
    public Class<?> getVectorClass() {
        return XVectorTrim.class;
    }

    public static enum TrimSpec {
        TRAILING("TRAILING", 1),
        LEADING("LEADING", 2),
        BOTH("BOTH", 3);

        private String key;
        private int value;

        private TrimSpec(String theKey, int theValue) {
            this.key = theKey;
            this.value = theValue;
        }

        String key() {
            return this.key;
        }

        public int value() {
            return this.value;
        }
    }
}

