/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql.ddl;

import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.ddl.DDLNode;
import com.cognos.xqe.ast.sql.ddl.SQLArgument;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.data.types.IDataType;

public class SQLCreateFunction
extends DDLNode {
    private String functionName;
    private String externalName;
    private IDataType dataType;
    private IDataType castFromDataType;
    private boolean callOnNullInput;
    private SubType subType;
    private String language;
    private SQLQueryNode ast;
    private int maxResultSets;
    private String syntax;
    private String tip;
    private boolean isVariadic;

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return new SQLCreateFunction();
    }

    public String[] getArgumentNames() {
        int nArgs = this.jjtGetNumChildren();
        String[] argumentNames = new String[nArgs];
        for (int i = 0; i < nArgs; ++i) {
            SQLArgument arg = (SQLArgument)this.jjtGetChild(i);
            argumentNames[i] = arg.getName();
        }
        return argumentNames;
    }

    public IDataType[] getArgumentTypes() {
        int nArgs = this.jjtGetNumChildren();
        IDataType[] argumentTypes = new IDataType[nArgs];
        for (int i = 0; i < nArgs; ++i) {
            SQLArgument arg = (SQLArgument)this.jjtGetChild(i);
            argumentTypes[i] = arg.getDataType();
        }
        return argumentTypes;
    }

    public boolean isVariadic() {
        return this.isVariadic;
    }

    public void setIsVariadic(boolean variadic) {
        this.isVariadic = variadic;
    }

    public int getVariableStartIdx() {
        if (!this.isVariadic) {
            return -1;
        }
        return this.jjtGetNumChildren() - 1;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String name) {
        this.functionName = name;
    }

    public void setFunctionName(String[] nameParts) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nameParts.length; ++i) {
            if (i > 0) {
                sb.append(".");
            }
            sb.append(nameParts[i]);
        }
        this.functionName = sb.toString();
    }

    public String getExternalName() {
        return this.externalName;
    }

    public final void setExternalName(String name) {
        this.externalName = name;
    }

    public IDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(IDataType theDataType) {
        this.dataType = theDataType;
    }

    public SubType getSubType() {
        return this.subType;
    }

    public void setSubType(SubType theSubType) {
        this.subType = theSubType;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String theLanguage) {
        this.language = theLanguage;
    }

    public SQLQueryNode getSQLAst() {
        return this.ast;
    }

    public void setSQLAst(SQLQueryNode tree) {
        this.ast = tree;
    }

    public IDataType getCastFromDataType() {
        return this.castFromDataType;
    }

    public void setCastFromDataType(IDataType theCastFromDataType) {
        this.castFromDataType = theCastFromDataType;
    }

    public boolean callOnNullInput() {
        return this.callOnNullInput;
    }

    public void setCallOnNullInput(boolean indicator) {
        this.callOnNullInput = indicator;
    }

    public int getMaxResultSets() {
        return this.maxResultSets;
    }

    public void setMaxResultSets(int theMaxResultSets) {
        this.maxResultSets = theMaxResultSets;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void setSyntax(String theSyntax) {
        this.syntax = theSyntax;
    }

    public String getTip() {
        return this.tip;
    }

    public void setTip(String aTip) {
        this.tip = aTip;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        IDataType resultType = this.getDataType();
        if (resultType == null) {
            builder.append("void");
        } else {
            builder.append(this.getDataType().getSQLText());
        }
        builder.append(" ");
        builder.append(this.getFunctionName());
        builder.append("(");
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.jjtGetChild(i).toString());
        }
        builder.append(")");
        builder.append(" [");
        builder.append(this.getExternalName());
        builder.append("]");
        return builder.toString();
    }

    public static enum SubType {
        AGGREGATE,
        FUNCTION,
        PROCEDURE;

    }
}

