/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql.parser;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEIDGenerator;
import com.cognos.xqe.ast.XQEUberNodeFactory;
import com.cognos.xqe.ast.sql.SQLNativeSql;
import com.cognos.xqe.ast.sql.SQLNodeFactory;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.ddl.SQLCreateFunction;
import com.cognos.xqe.ast.sql.parser.ParseException;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.parser.SQLParserPool;
import com.cognos.xqe.ast.util.BoundedStringReader;
import com.cognos.xqe.data.DataType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.BasePlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import java.io.InputStream;
import java.util.List;

public class SQLProcessor {
    private IXQENodeFactory factory;

    public SQLProcessor() {
    }

    public SQLProcessor(IXQENodeFactory nodeFactory) {
        this.factory = nodeFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IXQEQueryNode parseQuery(String sqlText) throws ParseException {
        SQLQueryNode node = null;
        try {
            SQLParser parser = SQLParserPool.getInstance().borrowParser();
            try {
                parser.setNodeFactory(this.factory);
                parser.ReInit(new BoundedStringReader(sqlText));
                node = parser.statement();
            }
            finally {
                parser.setNodeFactory(null);
                SQLParserPool.getInstance().returnParser(parser);
            }
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(ex);
        }
        return node;
    }

    public IXQEQueryNode parseQuery(String sqlText, boolean isPassThru) throws ParseException {
        if (!isPassThru) {
            return this.parseQuery(sqlText);
        }
        SQLNativeSql node = (SQLNativeSql)this.factory.createNode(301012);
        node.setSqlString(sqlText);
        return node;
    }

    public IXQEQueryNode parseExpression(String sqlText) throws ParseException {
        return SQLProcessor.parseExpression(sqlText, this.factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IXQEQueryNode parseExpression(String sqlText, IXQENodeFactory nodeFactory) throws ParseException {
        SQLQueryNode node = null;
        try {
            SQLParser parser = SQLParserPool.getInstance().borrowParser();
            try {
                parser.setNodeFactory(nodeFactory);
                parser.ReInit(new BoundedStringReader(sqlText));
                node = parser.expression();
            }
            finally {
                parser.setNodeFactory(null);
                SQLParserPool.getInstance().returnParser(parser);
            }
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(ex);
        }
        return node;
    }

    public static IDataType parseDataType(String sqlText) throws ParseException {
        DataType dataType = null;
        try {
            SQLParser parser = SQLParserPool.getInstance().borrowParser();
            try {
                parser.ReInit(new BoundedStringReader(sqlText));
                dataType = parser.dataType();
            }
            finally {
                SQLParserPool.getInstance().returnParser(parser);
            }
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(ex);
        }
        return dataType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SQLCreateFunction> parseDeploymentDescriptor(InputStream is) throws ParseException {
        List<SQLCreateFunction> list = null;
        try {
            XQEUberNodeFactory nodeFactory = new XQEUberNodeFactory();
            nodeFactory.addNodeFactory(new SQLNodeFactory());
            BasePlanningEnvironment env = new BasePlanningEnvironment();
            env.setPlanningActive(null);
            env.setTrace(new XQETrace());
            nodeFactory.setPlanningEnvironment(env);
            SQLParser parser = SQLParserPool.getInstance().borrowParser();
            try {
                parser.setNodeFactory(nodeFactory);
                nodeFactory.setNodeIDGenerator(new XQEIDGenerator());
                parser.ReInit(is);
                list = parser.deploymentDescriptor();
            }
            finally {
                parser.setNodeFactory(null);
                SQLParserPool.getInstance().returnParser(parser);
            }
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(ex);
        }
        return list;
    }

    public static List<SQLCreateFunction> parseActionGroup(String actionGroup) throws ParseException {
        List<SQLCreateFunction> list = null;
        try {
            SQLParser parser = SQLParserPool.getInstance().borrowParser();
            try {
                parser.ReInit(new BoundedStringReader(actionGroup));
                list = parser.actionGroup();
            }
            finally {
                parser.setNodeFactory(null);
                SQLParserPool.getInstance().returnParser(parser);
            }
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(ex);
        }
        return list;
    }
}

