/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql.util;

import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.util.SQLAbstractUnformattedQueryFormatter;
import java.util.Properties;

public abstract class SQLAbstractFormattedQueryFormatter
extends SQLAbstractUnformattedQueryFormatter {
    public static final String NEWLINE = "\r\n";
    public static final String SLASH_N_NEWLINE = "\n";
    public static final String SELECT = "SELECT";
    public static final String SPACE_CLOSE_PARENTHESIS_SPACE = " ) ";
    public static final String SPACE_FROM_SPACE = " FROM ";
    public static final String KEYWORD_ON = "ON ";
    public static final String SPACES_IN_ONE_BLOCK_INDENTATION = "    ";
    private static final String SPACES_IN_ONE_NODE_INDENTATION = "    ";
    private static final String FIRST_ARGUMENT = "%1$s";
    private static final String SECOND_ARGUMENT = "%2$s";
    private static final String THIRD_ARGUMENT = "%3$s";
    private int currentBlockIndentationLevel;
    private int currentNodeIndentationLevel;

    public SQLAbstractFormattedQueryFormatter() {
        this.setCurrentBlockIndentationLevel(0);
        this.setCurrentNodeIndentationLevel(0);
    }

    public SQLAbstractFormattedQueryFormatter(Properties props) {
        super(props);
        this.setCurrentBlockIndentationLevel(0);
        this.setCurrentNodeIndentationLevel(0);
    }

    public int getCurrentBlockIndentationLevel() {
        return this.currentBlockIndentationLevel;
    }

    public void setCurrentBlockIndentationLevel(int indentationLevel) {
        this.currentBlockIndentationLevel = indentationLevel;
    }

    public int getCurrentNodeIndentationLevel() {
        return this.currentNodeIndentationLevel;
    }

    @Override
    public void setCurrentNodeIndentationLevel(int indentationLevel) {
        this.currentNodeIndentationLevel = indentationLevel;
    }

    @Override
    public void addNewLineAndIndentation() {
        this.addText(NEWLINE);
        this.computeAndAddIndentation();
    }

    @Override
    public void increaseCurrentBlockIndentationLevel() {
        ++this.currentBlockIndentationLevel;
    }

    @Override
    public void decreaseCurrentBlockIndentationLevel() {
        --this.currentBlockIndentationLevel;
    }

    @Override
    public void increaseCurrentNodeIndentationLevel() {
        ++this.currentNodeIndentationLevel;
    }

    @Override
    public void decreaseCurrentNodeIndentationLevel() {
        --this.currentNodeIndentationLevel;
    }

    @Override
    public void addFromKeyword() {
        this.setCurrentNodeIndentationLevel(0);
        this.addNewLineAndIndentation();
        this.addText("FROM");
    }

    @Override
    public void addOverKeyword() {
        this.addNewLineAndIndentation();
        this.addText("OVER");
    }

    @Override
    public void addOrderByKeyword() {
        this.addNewLineAndIndentation();
        this.addText("ORDER BY");
    }

    @Override
    public void addATKeyword() {
        this.addNewLineAndIndentation();
        this.addText("AT");
    }

    @Override
    public void addPartitionByKeyword() {
        this.addNewLineAndIndentation();
        this.addText("PARTITION BY");
    }

    @Override
    public void addWhenKeyword() {
        this.addNewLineAndIndentation();
        this.addText("WHEN");
        this.addSpace();
    }

    @Override
    public void addElseKeyword() {
        this.addNewLineAndIndentation();
        this.addText("ELSE");
        this.addSpace();
    }

    @Override
    public void addEndKeyword() {
        this.addNewLineAndIndentation();
        this.addText("END");
    }

    @Override
    public void addFilterKeyword() {
        this.setCurrentNodeIndentationLevel(0);
        this.addNewLineAndIndentation();
        this.addText("FILTER");
    }

    @Override
    public void addOpenParenthesis() {
        this.addNewLineAndIndentation();
        this.addText("(");
    }

    @Override
    public void addCloseParenthesis() {
        this.addNewLineAndIndentation();
        this.addText(")");
    }

    @Override
    public String buildFormattedPatternForJoin(String pattern, String joinTypeName, int indentation) {
        SQLAbstractFormattedQueryFormatter tmpFormatter = (SQLAbstractFormattedQueryFormatter)this.copyFormatter();
        if (indentation == 0) {
            tmpFormatter.addNewLineAndIndentation();
        }
        tmpFormatter.addText(FIRST_ARGUMENT);
        tmpFormatter.setCurrentNodeIndentationLevel(this.getCurrentNodeIndentationLevel() + 1 + indentation);
        tmpFormatter.addNewLineAndIndentation();
        tmpFormatter.addText(joinTypeName);
        tmpFormatter.addSpace();
        tmpFormatter.addText(SECOND_ARGUMENT);
        if (!joinTypeName.equalsIgnoreCase(SQLJoin.SubType.CROSS.joinName())) {
            tmpFormatter.addNewLineAndIndentation();
            tmpFormatter.addText(KEYWORD_ON);
            tmpFormatter.addText(THIRD_ARGUMENT);
        }
        return tmpFormatter.bufferToString();
    }

    @Override
    public String buildFormattedPatternForSetOperator(String pattern, String setOperatorName, int indentation) {
        SQLAbstractFormattedQueryFormatter tmpFormatter = (SQLAbstractFormattedQueryFormatter)this.copyFormatter();
        tmpFormatter.addText(FIRST_ARGUMENT);
        tmpFormatter.addNewLineAndIndentation();
        tmpFormatter.setCurrentNodeIndentationLevel(this.getCurrentNodeIndentationLevel() + indentation);
        tmpFormatter.addNewLineAndIndentation();
        tmpFormatter.addText(setOperatorName);
        tmpFormatter.addNewLineAndIndentation();
        tmpFormatter.addText(SECOND_ARGUMENT);
        return tmpFormatter.bufferToString();
    }

    @Override
    public String buildFormattedPatternForLogicalOperator(String pattern, String logicalOperatorName) {
        SQLAbstractFormattedQueryFormatter tmpFormatter = (SQLAbstractFormattedQueryFormatter)this.copyFormatter();
        tmpFormatter.addText(FIRST_ARGUMENT);
        tmpFormatter.addSpace();
        tmpFormatter.addText(logicalOperatorName.toUpperCase());
        tmpFormatter.addNewLineAndIndentation();
        tmpFormatter.addText(SECOND_ARGUMENT);
        return tmpFormatter.bufferToString();
    }

    @Override
    public String buildFormattedPatternPercentile(String pattern, String percentileTypeName) {
        SQLAbstractFormattedQueryFormatter tmpFormatter = (SQLAbstractFormattedQueryFormatter)this.copyFormatter();
        tmpFormatter.addText(percentileTypeName);
        tmpFormatter.addText("(");
        tmpFormatter.addText(FIRST_ARGUMENT);
        tmpFormatter.addText(")");
        tmpFormatter.increaseCurrentNodeIndentationLevel();
        tmpFormatter.addNewLineAndIndentation();
        tmpFormatter.addText("WITHIN GROUP");
        tmpFormatter.addText("(");
        tmpFormatter.increaseCurrentNodeIndentationLevel();
        tmpFormatter.addNewLineAndIndentation();
        tmpFormatter.addText("ORDER BY");
        tmpFormatter.addText(SECOND_ARGUMENT);
        tmpFormatter.decreaseCurrentNodeIndentationLevel();
        tmpFormatter.addNewLineAndIndentation();
        tmpFormatter.addText(")");
        return tmpFormatter.bufferToString();
    }

    public String toString() {
        return this.replaceAllLFWithCRLF(this.getBuffer());
    }

    public String replaceAllLFWithCRLF(StringBuilder buffer) {
        return buffer.toString().replaceAll("(?<!\r)\n", NEWLINE);
    }

    private void computeAndAddIndentation() {
        int i;
        for (i = 0; i < this.getCurrentBlockIndentationLevel(); ++i) {
            this.addText("    ");
        }
        for (i = 0; i < this.getCurrentNodeIndentationLevel(); ++i) {
            this.addText("    ");
        }
    }
}

