/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql.util;

import com.cognos.xqe.ast.sql.util.SQLQueryLine;
import java.util.ArrayList;
import java.util.List;

public abstract class SQLQueryText {
    protected List<SQLQueryLine> lines = new ArrayList<SQLQueryLine>();
    protected SQLQueryLine lastLine = null;

    public List<SQLQueryLine> getLines() {
        return this.lines;
    }

    public SQLQueryLine getLastLine() {
        return this.lastLine;
    }

    public abstract String toString();

    public int getNumberOfLines() {
        return this.lines.size();
    }

    public void addLine() {
        this.lastLine = new SQLQueryLine();
        this.lines.add(this.lastLine);
    }

    public void addLine(int indent, boolean isPartOfNativeSQL, String text) {
        SQLQueryLine line = new SQLQueryLine(indent, isPartOfNativeSQL, text);
        this.lines.add(line);
        this.lastLine = line;
    }

    public void addLine(SQLQueryLine line) {
        this.lines.add(line);
        this.lastLine = line;
    }

    public void addText(SQLQueryText text) {
        for (int i = 0; i < text.getNumberOfLines(); ++i) {
            SQLQueryLine line = text.getLines().get(i);
            this.addLine(line);
        }
    }

    public void addText(int indentAmount, SQLQueryText text) {
        for (int i = 0; i < text.getNumberOfLines(); ++i) {
            SQLQueryLine line = text.getLines().get(i);
            int total = line.getIndentLevel() + indentAmount;
            line.setIndentLevelLine(total);
            this.addLine(line);
        }
    }

    public void addTextButAppendFirstLine(int indentAmount, SQLQueryText text) {
        for (int i = 0; i < text.getNumberOfLines(); ++i) {
            SQLQueryLine line = text.getLines().get(i);
            if (i == 0) {
                this.appendString(line.getLine());
                continue;
            }
            int total = line.getIndentLevel() + indentAmount;
            line.setIndentLevelLine(total);
            this.addLine(line);
        }
    }

    @Deprecated
    public void addText(String text, int indentLevel, String delimiter) {
        String[] substrings = text.split(delimiter);
        for (int i = 0; i < substrings.length; ++i) {
            String substring = substrings[i];
            if (i == 0) {
                this.appendString(substring);
                continue;
            }
            this.addLine(indentLevel, false, substring);
        }
    }

    public void indent(int amount) {
        for (int i = 0; i < this.getNumberOfLines(); ++i) {
            SQLQueryLine line = this.lines.get(i);
            int total = line.getIndentLevel() + amount;
            line.setIndentLevelLine(total);
        }
    }

    public void appendString(String string) {
        if (this.getNumberOfLines() == 0) {
            this.addLine();
        }
        this.lastLine.appendLine(string);
    }

    public void prependString(String string) {
        if (this.getNumberOfLines() == 0) {
            this.addLine();
        }
        this.lines.get(0).prependLine(string);
    }

    public String flatten() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.getNumberOfLines(); ++i) {
            builder.append(this.lines.get(i).getLine());
        }
        return builder.toString().trim();
    }

    public abstract SQLQueryText flatten(int var1);

    public abstract SQLQueryText copy();
}

