/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEQueryNode;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5InvalidPropertyValueException;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.V5SyntaxException;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.utils.V5NodeFormatResolver;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IDbDimension;
import com.cognos.xqe.metadata.IDbMeasureDimension;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQueryItemOfDimension;
import com.cognos.xqe.metadata.IQueryItemOfHierarchy;
import com.cognos.xqe.metadata.IQueryItemOfLevel;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import org.dom4j.Element;

public abstract class V5QueryNode
extends XQEQueryNode {
    public static final String PROP_STRING_NAME = "name";
    protected static final char COLON = ':';
    protected static final char SPACE = ' ';
    public static final String PROP_STRING_ORIGINALEXPRESSION = "originalExpression";

    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException, V5SyntaxException {
    }

    @Override
    public abstract String getNodeTypeName();

    @Override
    public boolean isOfCategory(int category) {
        if (category == 101064) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public int getType() {
        return 101064;
    }

    @Override
    public int isValidPlannedQuery() {
        int status = this.getId();
        return status;
    }

    public void setStringPropertyValue(String name, String value) throws V5InvalidPropertyValueException {
        if (value == null) {
            if (!this.isValueOptionalForProperty(name)) {
                throw new V5InvalidPropertyValueException(XQEMessageKeys.V5_InvalidPropertyValue, name);
            }
        } else {
            this.setPropertyValue(name, value);
        }
    }

    public void setBooleanPropertyValue(String name, String value) throws V5InvalidPropertyValueException {
        if (value == null || value.length() == 0) {
            if (!this.isValueOptionalForProperty(name)) {
                throw new V5InvalidPropertyValueException(XQEMessageKeys.V5_InvalidPropertyValue, name);
            }
        } else {
            this.setPropertyValue(name, Boolean.valueOf(value));
        }
    }

    public void setIntegerPropertyValue(String name, String value) throws V5InvalidPropertyValueException {
        if (value == null || value.length() == 0) {
            if (!this.isValueOptionalForProperty(name)) {
                throw new V5InvalidPropertyValueException(XQEMessageKeys.V5_InvalidPropertyValue, name);
            }
        } else {
            this.setPropertyValue(name, new Integer(value));
        }
    }

    public void setIntegerPropertyValueWithRules(String name, String value) throws V5InvalidPropertyValueException {
        if (value == null || value.length() == 0) {
            if (!this.isValueOptionalForProperty(name)) {
                throw new V5InvalidPropertyValueException(XQEMessageKeys.V5_InvalidPropertyValue, name);
            }
        } else {
            Integer iValue;
            try {
                iValue = new Integer(value);
            }
            catch (NumberFormatException ex) {
                String v = value.trim();
                if (v.matches("(\\+)?([0-9]+)")) {
                    iValue = Integer.MAX_VALUE;
                }
                if (v.matches("(-)?([0-9]+)")) {
                    iValue = 0;
                }
                throw new V5InvalidPropertyValueException(XQEMessageKeys.V5_InvalidPropertyValue, name);
            }
            this.setPropertyValue(name, iValue);
        }
    }

    public String getFormat() {
        int subType;
        int nodeType;
        V5NodeFormatResolver formatResolver = V5NodeFormatResolver.getV5NodeFormatResolver();
        String formatString = formatResolver.resolveFormat(nodeType = this.getType(), subType = 0);
        if (formatString != null && formatString.startsWith("@")) {
            int argu = Integer.valueOf(formatString.substring(1)) - 1;
            if (this.getNumberChildren() <= argu) {
                return null;
            }
            IXQEQueryNode child = this.getChild(argu);
            if (!(child instanceof V5QueryNode)) {
                return null;
            }
            V5QueryNode childNode = (V5QueryNode)child;
            formatString = childNode.getFormat();
        }
        return formatString;
    }

    public boolean isOLAPConstruct() {
        IXQEQueryNode[] identifiers = this.getChildrenOfCategory(101064);
        if (identifiers.length == 0) {
            V5SimpleNode v5SimpleNodeChild;
            IMetadata metadata;
            if (this instanceof V5SimpleNode && (metadata = (v5SimpleNodeChild = (V5SimpleNode)this).getMetadata()) != null && (MetadataType.isOLAP(metadata) && this.isDMRInQueryContext(metadata) || V5QueryNode.queryItemIsOLAP(metadata))) {
                return true;
            }
        } else {
            for (IXQEQueryNode anIdentifier : identifiers) {
                V5QueryNode aV5QueryNode = (V5QueryNode)anIdentifier;
                if (!aV5QueryNode.isOLAPConstruct()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean queryItemIsOLAP(IMetadata metadata) {
        IQuerySubject querySubject;
        if (metadata instanceof IQueryItem && ((querySubject = ((IQueryItem)metadata).getQuerySubject()) instanceof IDbDimension || querySubject instanceof IDbMeasureDimension)) {
            return false;
        }
        return metadata instanceof IQueryItemOfLevel || metadata instanceof IQueryItemOfDimension || metadata instanceof IQueryItemOfHierarchy;
    }

    public boolean isDMRInQueryContext(IMetadata metadata) {
        IQuerySubject querySubject;
        IXQEQueryNode v5Query = null;
        v5Query = this.getType() == 101006 ? this : this.getAncestorOfType(101006);
        return !(metadata instanceof IMeasure) || (querySubject = ((IMeasure)metadata).getQuerySubject()) == null || !(querySubject instanceof IDbMeasureDimension) || ((V5Query)v5Query).getV5Source().getPropertyValue("relational") == null;
    }

    public MDXLevelInfo getHierarchyLevelInfo(MDXLevelInfo forHierarchy, List<V5SimpleNode> fncs) {
        MDXLevelInfo levelInfo = new MDXLevelInfo();
        return levelInfo;
    }

    public MDXLevelInfo getChildByIndexHierarchyLevelInfo(int idx, MDXLevelInfo forHierarchy, List<V5SimpleNode> fncs) {
        IXQEQueryNode childNode;
        MDXLevelInfo levelInfo = null;
        if (this.getNumberChildren() >= idx && (childNode = this.getChild(idx)).isOfCategory(101064)) {
            levelInfo = ((V5QueryNode)childNode).getHierarchyLevelInfo(forHierarchy, fncs);
        }
        if (levelInfo == null) {
            levelInfo = new MDXLevelInfo();
        }
        return levelInfo;
    }

    public V5DataItem getDataItemByName(String name) {
        V5Query v5Query = null;
        if (this.getType() == 101006) {
            v5Query = (V5Query)this;
        } else {
            V5QuerySet v5QuerySet = (V5QuerySet)this.getAncestorOfType(101002);
            V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)this.getAncestorOfType(101055);
            v5Query = v5QuerySet.getV5Query(v5QRD.getRefQueryProperty());
        }
        V5Selection v5Selection = v5Query.getV5Selection();
        V5DataItem v5DataItem = v5Selection.getDataItemByRefName(name);
        return v5DataItem;
    }

    public MDXHierInfo getHierarchyInfo() {
        return null;
    }

    public boolean isOLAPFunctionNotRelational() {
        return false;
    }

    public boolean isValueOptionalForProperty(String propName) {
        return false;
    }

    public void formatForMessage(StringBuilder sb) {
        throw new RuntimeException("XQE Internal Error: formatForMessage not implemented for class \"" + this.getClass().getName() + "\"");
    }

    protected void formatForMessage(StringBuilder sb, String v5ElementName, String name) {
        sb.append(v5ElementName);
        if (name != null) {
            sb.append(':');
            XQEMessage.appendQuotedItem(sb, name);
        }
    }

    public V5QueryNode getEffectiveNodeForMessage() {
        return null;
    }

    public String getOriginalExpression() {
        String originalExpression = (String)this.getPropertyValue(PROP_STRING_ORIGINALEXPRESSION);
        if (originalExpression == null) {
            StringBuilder buffer = new StringBuilder();
            this.writeFormattedText(buffer);
            originalExpression = buffer.toString();
            this.setOriginalExpression(originalExpression);
        }
        return originalExpression;
    }

    public void setOriginalExpression(String expression) {
        if (expression != null) {
            this.setPropertyValue(PROP_STRING_ORIGINALEXPRESSION, expression);
        } else {
            this.removeProperty(PROP_STRING_ORIGINALEXPRESSION);
        }
    }
}

